/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.game.diplomacy.NegotiationActionEntry;
import game.sengoku.main.KessenMain;
import game.sengoku.window.SliderSprite;
import game.sengoku.window.WindowBase;

public class WindowNegotiationResource
extends WindowBase {
    private Font font;
    private int fontColor = -319753729;
    private Texture texMoney;
    private Texture texGun;
    private Texture texHorse;
    private Texture texIron;
    private Texture texGunpowder;
    private Texture texSaltpeter;
    private SliderSprite moneySlider;
    private SliderSprite gunSlider;
    private SliderSprite horseSlider;
    private SliderSprite ironSlider;
    private SliderSprite gunpowderSlider;
    private SliderSprite saltpeterSlider;
    private int daimyoId;
    private GameDataV datav;

    public WindowNegotiationResource(int n, int n2, int n3, int n4, int n5, int n6, GameDataV gameDataV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.font = GameFontUtil.FONT22;
        this.fontColor = -319753729;
        this.daimyoId = n6;
        this.datav = gameDataV;
        this.load();
    }

    private void load() {
        this.children.clear();
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.texMoney = (Texture)graphicPool.getResource("koban.png");
        this.texGun = (Texture)graphicPool.getResource("gun.png");
        this.texHorse = (Texture)graphicPool.getResource("horse.png");
        this.texIron = (Texture)graphicPool.getResource("iron.png");
        this.texGunpowder = (Texture)graphicPool.getResource("gunpowder.png");
        this.texSaltpeter = (Texture)graphicPool.getResource("saltpeter.png");
        this.moneySlider = new SliderSprite(170, 32, 100, 250, 25, true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.moneySlider.setParent(this);
        this.children.add(this.moneySlider);
        this.gunSlider = new SliderSprite(170, 96, 100, 250, 25, true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.gunSlider.setParent(this);
        this.children.add(this.gunSlider);
        this.horseSlider = new SliderSprite(170, 160, 100, 250, 25, true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.horseSlider.setParent(this);
        this.children.add(this.horseSlider);
        this.ironSlider = new SliderSprite(170, 224, 100, 250, 25, true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.ironSlider.setParent(this);
        this.children.add(this.ironSlider);
        this.gunpowderSlider = new SliderSprite(170, 288, 100, 250, 25, true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.gunpowderSlider.setParent(this);
        this.children.add(this.gunpowderSlider);
        this.saltpeterSlider = new SliderSprite(170, 352, 100, 250, 25, true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.saltpeterSlider.setParent(this);
        this.children.add(this.saltpeterSlider);
    }

    public void reset(NegotiationActionEntry negotiationActionEntry) {
        this.setDaimyoId(negotiationActionEntry.getDaimyoId());
        this.moneySlider.setValue(negotiationActionEntry.getMoney());
        this.gunSlider.setValue(negotiationActionEntry.getGun());
        this.horseSlider.setValue(negotiationActionEntry.getHorse());
        this.ironSlider.setValue(negotiationActionEntry.getIron());
        this.gunpowderSlider.setValue(negotiationActionEntry.getGunpowder());
        this.saltpeterSlider.setValue(negotiationActionEntry.getSaltpeter());
    }

    private void updateMax() {
        DaimyoV daimyoV = (DaimyoV)this.datav.getDaimyos().get(this.daimyoId);
        if (daimyoV != null) {
            this.moneySlider.setValueMax(daimyoV.getMoney());
            this.gunSlider.setValueMax(daimyoV.getGun());
            this.horseSlider.setValueMax(daimyoV.getHorse());
            this.ironSlider.setValueMax(daimyoV.getIron());
            this.gunpowderSlider.setValueMax(daimyoV.getGunpowder());
            this.saltpeterSlider.setValueMax(daimyoV.getSaltpeter());
            this.needUpdate();
        }
    }

    public void setDaimyoId(int n) {
        this.daimyoId = n;
        this.updateMax();
    }

    public int getMoney() {
        return this.moneySlider.getValue();
    }

    public int getGun() {
        return this.gunSlider.getValue();
    }

    public int getHorse() {
        return this.horseSlider.getValue();
    }

    public int getIron() {
        return this.ironSlider.getValue();
    }

    public int getGunpowder() {
        return this.gunpowderSlider.getValue();
    }

    public int getSaltpeter() {
        return this.saltpeterSlider.getValue();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        boolean bl = false;
        this.content.drawImage(this.texMoney, 0, 0, this.texMoney.getWidth(), this.texMoney.getHeight(), 10, 32, 25, 25);
        this.content.drawText("\u91d1\u92ad", this.font, this.fontColor, 42, 57);
        this.content.drawText("" + this.getMoney(), this.font, this.fontColor, 92, 57);
        this.content.drawImage(this.texGun, 0, 0, this.texGun.getWidth(), this.texGun.getHeight(), 10, 96, 25, 25);
        this.content.drawText("\u9244\u7832", this.font, this.fontColor, 42, 121);
        this.content.drawText("" + this.getGun(), this.font, this.fontColor, 92, 121);
        this.content.drawImage(this.texHorse, 0, 0, this.texHorse.getWidth(), this.texHorse.getHeight(), 10, 160, 25, 25);
        this.content.drawText("\u99ac", this.font, this.fontColor, 42, 185);
        this.content.drawText("" + this.getHorse(), this.font, this.fontColor, 92, 185);
        this.content.drawImage(this.texIron, 0, 0, this.texIron.getWidth(), this.texIron.getHeight(), 10, 224, 25, 25);
        this.content.drawText("\u9244", this.font, this.fontColor, 42, 249);
        this.content.drawText("" + this.getIron(), this.font, this.fontColor, 92, 249);
        this.content.drawImage(this.texGunpowder, 0, 0, this.texGunpowder.getWidth(), this.texGunpowder.getHeight(), 10, 288, 25, 25);
        this.content.drawText("\u706b\u85ac", this.font, this.fontColor, 42, 313);
        this.content.drawText("" + this.getGunpowder(), this.font, this.fontColor, 92, 313);
        this.content.drawImage(this.texSaltpeter, 0, 0, this.texSaltpeter.getWidth(), this.texSaltpeter.getHeight(), 10, 352, 25, 25);
        this.content.drawText("\u785d\u77f3", this.font, this.fontColor, 42, 377);
        this.content.drawText("" + this.getSaltpeter(), this.font, this.fontColor, 92, 377);
    }
}

