/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.base.sprite.Sprite;
import game.sengoku.common.GameFontUtil;
import game.sengoku.data.CultureV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.KnightV;
import game.sengoku.data.RoleV;
import game.sengoku.data.TechnologyV;
import game.sengoku.game.diplomacy.NegotiationAction;
import game.sengoku.game.diplomacy.NegotiationActionEntry;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ImageButtonSprite;
import game.sengoku.window.WindowBase;
import game.sengoku.window.WindowClickable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WindowNegotiationEntry
extends WindowBase {
    private Font font;
    private int fontColor = -319753729;
    private int daimyoId;
    private GameDataV datav;
    private NegotiationAction negotiationAction;
    protected List<ImageButtonSprite> deletes;
    protected Texture texDelete;
    protected Texture texDelete2;
    private boolean changeEntry = false;

    public WindowNegotiationEntry(int n, int n2, int n3, int n4, int n5, int n6, GameDataV gameDataV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.font = GameFontUtil.FONT16;
        this.fontColor = -319753729;
        this.daimyoId = n6;
        this.datav = gameDataV;
        this.deletes = new ArrayList<ImageButtonSprite>();
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.texDelete = (Texture)graphicPool.getResource("batsu.png");
        this.texDelete2 = (Texture)graphicPool.getResource("batsu2.png");
    }

    public int getDaimyoId() {
        return this.daimyoId;
    }

    public void setDaimyoId(int n) {
        this.daimyoId = n;
    }

    public NegotiationAction getNegotiationAction() {
        return this.negotiationAction;
    }

    public void setNegotiationAction(NegotiationAction negotiationAction) {
        this.negotiationAction = negotiationAction;
    }

    private int receiveDaimyoId() {
        NegotiationActionEntry negotiationActionEntry = this.negotiationAction.getSelfEntry();
        if (this.daimyoId != negotiationActionEntry.getDaimyoId()) {
            return negotiationActionEntry.getDaimyoId();
        }
        negotiationActionEntry = this.negotiationAction.getTargetEntry();
        if (this.daimyoId != negotiationActionEntry.getDaimyoId()) {
            return negotiationActionEntry.getDaimyoId();
        }
        return 0;
    }

    private NegotiationActionEntry getEntry() {
        NegotiationActionEntry negotiationActionEntry = this.negotiationAction.getSelfEntry();
        if (this.daimyoId == negotiationActionEntry.getDaimyoId()) {
            return negotiationActionEntry;
        }
        negotiationActionEntry = this.negotiationAction.getTargetEntry();
        if (this.daimyoId == negotiationActionEntry.getDaimyoId()) {
            return negotiationActionEntry;
        }
        return null;
    }

    public void forceUpdate() {
        super.needUpdate();
        this.changeEntry = false;
    }

    @Override
    protected void updateContent() {
        ImageButtonSprite imageButtonSprite2;
        TechnologyV technologyV;
        int n3;
        Iterator<Integer> iterator;
        super.updateContent();
        if (this.negotiationAction == null) {
            return;
        }
        this.deletes.clear();
        DaimyoV daimyoV = (DaimyoV)this.datav.getDaimyos().get(this.daimyoId);
        NegotiationActionEntry negotiationActionEntry = this.getEntry();
        int n2 = 1;
        this.content.drawText(daimyoV.getName(), this.font, this.fontColor, 6, 6 + 20 * n2);
        ++n2;
        if (negotiationActionEntry.isAlliance()) {
            this.content.drawText("\u540c\u76df", this.font, this.fontColor, 6, 6 + 20 * n2);
            iterator = new ImageButtonSprite(150, 6 + 20 * (n2 - 1), this.z + 10, 20, 20, this.texDelete, this.texDelete2);
            ((WindowClickable)((Object)iterator)).setPrimaryClicked(windowClickable -> {
                this.negotiationAction.getSelfEntry().setAlliance(false);
                this.negotiationAction.getTargetEntry().setAlliance(false);
                this.changeEntry = true;
            });
            ((Sprite)((Object)iterator)).setParent(this);
            this.deletes.add((ImageButtonSprite)((Object)iterator));
            ++n2;
        }
        if (negotiationActionEntry.isNonAggression()) {
            this.content.drawText("\u505c\u6226", this.font, this.fontColor, 6, 6 + 20 * n2);
            iterator = new ImageButtonSprite(150, 6 + 20 * (n2 - 1), this.z + 10, 20, 20, this.texDelete, this.texDelete2);
            ((WindowClickable)((Object)iterator)).setPrimaryClicked(windowClickable -> {
                this.negotiationAction.getSelfEntry().setNonAggression(false);
                this.negotiationAction.getTargetEntry().setNonAggression(false);
                this.changeEntry = true;
            });
            ((Sprite)((Object)iterator)).setParent(this);
            this.deletes.add((ImageButtonSprite)((Object)iterator));
            ++n2;
        }
        if (negotiationActionEntry.isSurrender()) {
            this.content.drawText("\u964d\u4f0f", this.font, this.fontColor, 6, 6 + 20 * n2);
            iterator = new ImageButtonSprite(150, 6 + 20 * (n2 - 1), this.z + 10, 20, 20, this.texDelete, this.texDelete2);
            ((WindowClickable)((Object)iterator)).setPrimaryClicked(windowClickable -> {
                this.negotiationAction.getSelfEntry().setSurrender(false);
                this.negotiationAction.getTargetEntry().setSurrender(false);
                this.negotiationAction.getSelfEntry().setThreat(false);
                this.negotiationAction.getTargetEntry().setThreat(false);
                this.changeEntry = true;
            });
            ((Sprite)((Object)iterator)).setParent(this);
            this.deletes.add((ImageButtonSprite)((Object)iterator));
            ++n2;
        }
        if (negotiationActionEntry.isBreakWith()) {
            this.content.drawText("\u624b\u5207\u308a", this.font, this.fontColor, 6, 6 + 20 * n2);
            iterator = new ImageButtonSprite(150, 6 + 20 * (n2 - 1), this.z + 10, 20, 20, this.texDelete, this.texDelete2);
            ((WindowClickable)((Object)iterator)).setPrimaryClicked(windowClickable -> {
                this.negotiationAction.getSelfEntry().setBreakWith(false);
                this.negotiationAction.getTargetEntry().setBreakWith(false);
                this.changeEntry = true;
            });
            ((Sprite)((Object)iterator)).setParent(this);
            this.deletes.add((ImageButtonSprite)((Object)iterator));
            ++n2;
        }
        if (negotiationActionEntry.isBorder()) {
            this.content.drawText("\u56fd\u5883\u7d1b\u4e89\u89e3\u6c7a", this.font, this.fontColor, 6, 6 + 20 * n2);
            iterator = new ImageButtonSprite(150, 6 + 20 * (n2 - 1), this.z + 10, 20, 20, this.texDelete, this.texDelete2);
            ((WindowClickable)((Object)iterator)).setPrimaryClicked(windowClickable -> {
                this.negotiationAction.getSelfEntry().setBorder(false);
                this.negotiationAction.getTargetEntry().setBorder(false);
                this.changeEntry = true;
            });
            ((Sprite)((Object)iterator)).setParent(this);
            this.deletes.add((ImageButtonSprite)((Object)iterator));
            ++n2;
        }
        if (negotiationActionEntry.isDetente()) {
            this.content.drawText("\u548c\u89e3", this.font, this.fontColor, 6, 6 + 20 * n2);
            iterator = new ImageButtonSprite(150, 6 + 20 * (n2 - 1), this.z + 10, 20, 20, this.texDelete, this.texDelete2);
            ((WindowClickable)((Object)iterator)).setPrimaryClicked(windowClickable -> {
                this.negotiationAction.getSelfEntry().setDetente(false);
                this.negotiationAction.getTargetEntry().setDetente(false);
                this.changeEntry = true;
            });
            ((Sprite)((Object)iterator)).setParent(this);
            this.deletes.add((ImageButtonSprite)((Object)iterator));
            ++n2;
        }
        if (0 < negotiationActionEntry.getMoney()) {
            this.content.drawText("\u91d1 " + negotiationActionEntry.getMoney(), this.font, this.fontColor, 6, 6 + 20 * n2);
            iterator = new ImageButtonSprite(150, 6 + 20 * (n2 - 1), this.z + 10, 20, 20, this.texDelete, this.texDelete2);
            ((WindowClickable)((Object)iterator)).setPrimaryClicked(windowClickable -> {
                negotiationActionEntry.setMoney(0);
                this.changeEntry = true;
            });
            ((Sprite)((Object)iterator)).setParent(this);
            this.deletes.add((ImageButtonSprite)((Object)iterator));
            ++n2;
        }
        if (0 < negotiationActionEntry.getGun()) {
            this.content.drawText("\u9244\u7832 " + negotiationActionEntry.getGun(), this.font, this.fontColor, 6, 6 + 20 * n2);
            iterator = new ImageButtonSprite(150, 6 + 20 * (n2 - 1), this.z + 10, 20, 20, this.texDelete, this.texDelete2);
            ((WindowClickable)((Object)iterator)).setPrimaryClicked(windowClickable -> {
                negotiationActionEntry.setGun(0);
                this.changeEntry = true;
            });
            ((Sprite)((Object)iterator)).setParent(this);
            this.deletes.add((ImageButtonSprite)((Object)iterator));
            ++n2;
        }
        if (0 < negotiationActionEntry.getHorse()) {
            this.content.drawText("\u99ac " + negotiationActionEntry.getHorse(), this.font, this.fontColor, 6, 6 + 20 * n2);
            iterator = new ImageButtonSprite(150, 6 + 20 * (n2 - 1), this.z + 10, 20, 20, this.texDelete, this.texDelete2);
            ((WindowClickable)((Object)iterator)).setPrimaryClicked(windowClickable -> {
                negotiationActionEntry.setHorse(0);
                this.changeEntry = true;
            });
            ((Sprite)((Object)iterator)).setParent(this);
            this.deletes.add((ImageButtonSprite)((Object)iterator));
            ++n2;
        }
        if (0 < negotiationActionEntry.getIron()) {
            this.content.drawText("\u9244 " + negotiationActionEntry.getIron(), this.font, this.fontColor, 6, 6 + 20 * n2);
            iterator = new ImageButtonSprite(150, 6 + 20 * (n2 - 1), this.z + 10, 20, 20, this.texDelete, this.texDelete2);
            ((WindowClickable)((Object)iterator)).setPrimaryClicked(windowClickable -> {
                negotiationActionEntry.setIron(0);
                this.changeEntry = true;
            });
            ((Sprite)((Object)iterator)).setParent(this);
            this.deletes.add((ImageButtonSprite)((Object)iterator));
            ++n2;
        }
        if (0 < negotiationActionEntry.getSaltpeter()) {
            this.content.drawText("\u785d\u77f3 " + negotiationActionEntry.getSaltpeter(), this.font, this.fontColor, 6, 6 + 20 * n2);
            iterator = new ImageButtonSprite(150, 6 + 20 * (n2 - 1), this.z + 10, 20, 20, this.texDelete, this.texDelete2);
            ((WindowClickable)((Object)iterator)).setPrimaryClicked(windowClickable -> {
                negotiationActionEntry.setSaltpeter(0);
                this.changeEntry = true;
            });
            ((Sprite)((Object)iterator)).setParent(this);
            this.deletes.add((ImageButtonSprite)((Object)iterator));
            ++n2;
        }
        if (0 < negotiationActionEntry.getGunpowder()) {
            this.content.drawText("\u706b\u85ac " + negotiationActionEntry.getGunpowder(), this.font, this.fontColor, 6, 6 + 20 * n2);
            iterator = new ImageButtonSprite(150, 6 + 20 * (n2 - 1), this.z + 10, 20, 20, this.texDelete, this.texDelete2);
            ((WindowClickable)((Object)iterator)).setPrimaryClicked(windowClickable -> {
                negotiationActionEntry.setGunpowder(0);
                this.changeEntry = true;
            });
            ((Sprite)((Object)iterator)).setParent(this);
            this.deletes.add((ImageButtonSprite)((Object)iterator));
            ++n2;
        }
        iterator = negotiationActionEntry.getTechnologyIds().iterator();
        while (iterator.hasNext()) {
            n3 = (Integer)iterator.next();
            technologyV = (TechnologyV)this.datav.getTechnologies().get(n3);
            this.content.drawText(technologyV.getName(), this.font, this.fontColor, 6, 6 + 20 * n2);
            imageButtonSprite2 = new ImageButtonSprite(150, 6 + 20 * (n2 - 1), this.z + 10, 20, 20, this.texDelete, this.texDelete2);
            imageButtonSprite2.setPrimaryClicked(windowClickable -> {
                negotiationActionEntry.getTechnologyIds().remove((Object)n3);
                this.changeEntry = true;
            });
            imageButtonSprite2.setParent(this);
            this.deletes.add(imageButtonSprite2);
            ++n2;
        }
        iterator = negotiationActionEntry.getCultureIds().iterator();
        while (iterator.hasNext()) {
            n3 = (Integer)iterator.next();
            technologyV = (CultureV)this.datav.getCultures().get(n3);
            this.content.drawText(technologyV.getName(), this.font, this.fontColor, 6, 6 + 20 * n2);
            imageButtonSprite2 = new ImageButtonSprite(150, 6 + 20 * (n2 - 1), this.z + 10, 20, 20, this.texDelete, this.texDelete2);
            imageButtonSprite2.setPrimaryClicked(windowClickable -> {
                negotiationActionEntry.getCultureIds().remove((Object)n3);
                this.changeEntry = true;
            });
            imageButtonSprite2.setParent(this);
            this.deletes.add(imageButtonSprite2);
            ++n2;
        }
        for (int n3 : negotiationActionEntry.getRoleIds()) {
            technologyV = (RoleV)this.datav.getRoles().get(n3);
            this.content.drawText(technologyV.getName(), this.font, this.fontColor, 6, 6 + 20 * n2);
            imageButtonSprite2 = new ImageButtonSprite(150, 6 + 20 * (n2 - 1), this.z + 10, 20, 20, this.texDelete, this.texDelete2);
            imageButtonSprite2.setPrimaryClicked(windowClickable -> {
                negotiationActionEntry.getRoleIds().remove((Object)n3);
                this.changeEntry = true;
            });
            imageButtonSprite2.setParent(this);
            this.deletes.add(imageButtonSprite2);
            ++n2;
        }
        iterator = negotiationActionEntry.getRentalKnightIds().iterator();
        while (iterator.hasNext()) {
            n3 = (Integer)iterator.next();
            technologyV = (KnightV)this.datav.getKnights().get(n3);
            this.content.drawText("\u4eba\u8cea(" + technologyV.getFullName() + ")", this.font, this.fontColor, 6, 6 + 20 * n2);
            imageButtonSprite2 = new ImageButtonSprite(150, 6 + 20 * (n2 - 1), this.z + 10, 20, 20, this.texDelete, this.texDelete2);
            imageButtonSprite2.setPrimaryClicked(windowClickable -> {
                negotiationActionEntry.getRentalKnightIds().remove((Object)n3);
                this.changeEntry = true;
            });
            imageButtonSprite2.setParent(this);
            this.deletes.add(imageButtonSprite2);
            ++n2;
        }
        iterator = negotiationActionEntry.getRentalReturnKnightIds().iterator();
        while (iterator.hasNext()) {
            n3 = (Integer)iterator.next();
            technologyV = (KnightV)this.datav.getKnights().get(n3);
            this.content.drawText("\u4eba\u8cea\u8fd4\u9084(" + technologyV.getFullName() + ")", this.font, this.fontColor, 6, 6 + 20 * n2);
            imageButtonSprite2 = new ImageButtonSprite(150, 6 + 20 * (n2 - 1), this.z + 10, 20, 20, this.texDelete, this.texDelete2);
            imageButtonSprite2.setPrimaryClicked(windowClickable -> {
                negotiationActionEntry.getRentalReturnKnightIds().remove((Object)n3);
                this.changeEntry = true;
            });
            imageButtonSprite2.setParent(this);
            this.deletes.add(imageButtonSprite2);
            ++n2;
        }
        iterator = negotiationActionEntry.getBreakIds().iterator();
        while (iterator.hasNext()) {
            n3 = (Integer)iterator.next();
            technologyV = (DaimyoV)this.datav.getDaimyos().get(n3);
            this.content.drawText("\u624b\u5207\u308a(" + technologyV.getName() + ")", this.font, this.fontColor, 6, 6 + 20 * n2);
            imageButtonSprite2 = new ImageButtonSprite(150, 6 + 20 * (n2 - 1), this.z + 10, 20, 20, this.texDelete, this.texDelete2);
            imageButtonSprite2.setPrimaryClicked(windowClickable -> {
                negotiationActionEntry.getBreakIds().remove((Object)n3);
                this.changeEntry = true;
            });
            imageButtonSprite2.setParent(this);
            this.deletes.add(imageButtonSprite2);
            ++n2;
        }
        for (int n3 : negotiationActionEntry.getEnemyToIds()) {
            technologyV = (DaimyoV)this.datav.getDaimyos().get(n3);
            this.content.drawText("\u6575\u5bfe(" + technologyV.getName() + ")", this.font, this.fontColor, 6, 6 + 20 * n2);
            imageButtonSprite2 = new ImageButtonSprite(150, 6 + 20 * (n2 - 1), this.z + 10, 20, 20, this.texDelete, this.texDelete2);
            imageButtonSprite2.setPrimaryClicked(windowClickable -> {
                negotiationActionEntry.getEnemyToIds().remove((Object)n3);
                this.changeEntry = true;
            });
            imageButtonSprite2.setParent(this);
            this.deletes.add(imageButtonSprite2);
            ++n2;
        }
        for (int n3 : negotiationActionEntry.getToubatsuToIds()) {
            technologyV = (DaimyoV)this.datav.getDaimyos().get(n3);
            this.content.drawText("\u8a0e\u4f10\u4ee4(" + technologyV.getName() + ")", this.font, this.fontColor, 6, 6 + 20 * n2);
            imageButtonSprite2 = new ImageButtonSprite(150, 6 + 20 * (n2 - 1), this.z + 10, 20, 20, this.texDelete, this.texDelete2);
            imageButtonSprite2.setPrimaryClicked(windowClickable -> {
                negotiationActionEntry.getToubatsuToIds().remove((Object)n3);
                this.changeEntry = true;
            });
            imageButtonSprite2.setParent(this);
            this.deletes.add(imageButtonSprite2);
            ++n2;
        }
        for (int n3 : negotiationActionEntry.getToubatsuRemoveIds()) {
            technologyV = (DaimyoV)this.datav.getDaimyos().get(n3);
            this.content.drawText("\u8a0e\u4f10\u4ee4\u89e3\u9664(" + technologyV.getName() + ")", this.font, this.fontColor, 6, 6 + 20 * n2);
            imageButtonSprite2 = new ImageButtonSprite(150, 6 + 20 * (n2 - 1), this.z + 10, 20, 20, this.texDelete, this.texDelete2);
            imageButtonSprite2.setPrimaryClicked(windowClickable -> {
                negotiationActionEntry.getToubatsuRemoveIds().remove((Object)n3);
                this.changeEntry = true;
            });
            imageButtonSprite2.setParent(this);
            this.deletes.add(imageButtonSprite2);
            ++n2;
        }
        this.deletes.forEach(imageButtonSprite -> imageButtonSprite.draw(this.content));
    }

    @Override
    public void update() {
        super.update();
        this.deletes.forEach(imageButtonSprite -> imageButtonSprite.update());
    }

    public boolean isChangeEntry() {
        return this.changeEntry;
    }
}

