/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.data.BattleReport;
import game.sengoku.data.CultureV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.KnightV;
import game.sengoku.data.PlayerV;
import game.sengoku.data.RoleV;
import game.sengoku.data.TechnologyV;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.ImageButtonSprite;
import game.sengoku.window.WindowBase;
import game.sengoku.window.WindowClickable;
import java.util.function.Consumer;

public class WindowDaimyoDetailInfo
extends WindowBase {
    private static final int BUTTON_WIDTH = 32;
    private static final int BUTTON_HEIGHT = 20;
    private static final int INTERVAL = 25;
    private static final int INTERVAL_X = 240;
    private static final int VALUE_X = 120;
    private static final int CLUMN_MAX = 4;
    private static final int ROW_MAX = 15;
    private Font font = GameFontUtil.FONT20;
    private int fontColor = -269422081;
    private int daimyoId;
    private GameDataV datav;
    private PlayerV player;
    private int pageIndex = 0;
    private int subPageIndex = 0;
    private int subPageMax = 0;
    protected ButtonSprite nextButton;
    protected ButtonSprite prevButton;
    protected ButtonSprite subNextButton;
    protected ButtonSprite subPrevButton;
    private ImageButtonSprite close;

    public WindowDaimyoDetailInfo(int n, int n2, int n3, int n4, int n5, GameDataV gameDataV, PlayerV playerV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.daimyoId = -1;
        this.datav = gameDataV;
        this.player = playerV;
        this.initButtons();
    }

    public int getDaimyoId() {
        return this.daimyoId;
    }

    public void setDaimyoId(int n) {
        if (this.daimyoId != n) {
            this.daimyoId = n;
            this.pageIndex = 0;
            this.subPageIndex = 0;
            this.needUpdate();
        }
    }

    public PlayerV getPlayer() {
        return this.player;
    }

    public void setPlayer(PlayerV playerV) {
        this.player = playerV;
    }

    private String sgn(int n) {
        return 0 < n ? "+" : " ";
    }

    @Override
    public void update() {
        if (this.nextButton != null) {
            if (this.isLast()) {
                this.nextButton.setNormalColor(-1380583425);
            } else {
                this.nextButton.setNormalColor(388883421);
            }
        }
        if (this.prevButton != null) {
            if (this.isFirst()) {
                this.prevButton.setNormalColor(-1380583425);
            } else {
                this.prevButton.setNormalColor(388883421);
            }
        }
        if (this.subNextButton != null) {
            if (this.isSubLast()) {
                this.subNextButton.setNormalColor(-1380583425);
            } else {
                this.subNextButton.setNormalColor(388883421);
            }
        }
        if (this.subPrevButton != null) {
            if (this.isSubFirst()) {
                this.subPrevButton.setNormalColor(-1380583425);
            } else {
                this.subPrevButton.setNormalColor(388883421);
            }
        }
        super.update();
    }

    private void pageChanged() {
        if (this.subNextButton != null) {
            this.subNextButton.setVisible(this.pageIndex != 0);
        }
        if (this.subPrevButton != null) {
            this.subPrevButton.setVisible(this.pageIndex != 0);
        }
        this.subPageIndex = 0;
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        switch (this.pageIndex) {
            case 0: {
                this.updateContentBase();
                break;
            }
            case 1: {
                this.updateContentKnight();
                break;
            }
            case 2: {
                this.updateContentTechnology();
                break;
            }
            case 3: {
                this.updateContentCulture();
                break;
            }
            case 4: {
                this.updateContentReport();
            }
        }
    }

    private void updateContentBase() {
        DaimyoV daimyoV = (DaimyoV)this.datav.getDaimyos().get(this.daimyoId);
        if (daimyoV == null) {
            return;
        }
        int n = 1;
        this.content.drawText(daimyoV.getName(), this.font, this.fontColor, 6, 6 + 25 * n);
        this.content.drawText(daimyoV.getKnight().getFullName(), this.font, this.fontColor, 120, 6 + 25 * n);
        ++n;
        if (daimyoV.getRank() == null) {
            this.content.drawText("\u7121\u4f4d\u7121\u5b98", this.font, this.fontColor, 6, 6 + 25 * n);
        } else {
            this.content.drawText(daimyoV.getRank().getName() + " " + daimyoV.getRank().getRoleName(), this.font, this.fontColor, 6, 6 + 25 * n);
        }
        ++n;
        int n2 = 0;
        for (RoleV roleV : daimyoV.getRoles()) {
            this.content.drawText(roleV.getName(), this.font, this.fontColor, 6 + 100 * n2, 6 + 25 * n);
            ++n2;
        }
        this.content.drawText("\u540d\u58f0", this.font, this.fontColor, 6, 6 + 25 * ++n);
        this.content.drawText("" + daimyoV.getFame() + "/" + daimyoV.getMaxFame(), this.font, this.fontColor, 120, 6 + 25 * n);
        this.content.drawText("\u6b66\u5a01", this.font, this.fontColor, 306, 6 + 25 * n);
        this.content.drawText("" + daimyoV.getImpact() + "/" + daimyoV.getMaxImpact(), this.font, this.fontColor, 420, 6 + 25 * n);
        this.content.drawText("\u56fd\u6570", this.font, this.fontColor, 6, 6 + 25 * ++n);
        this.content.drawText("" + daimyoV.getCountries().size(), this.font, this.fontColor, 120, 6 + 25 * n);
        this.content.drawText("\u7dcf\u4eba\u53e3", this.font, this.fontColor, 246, 6 + 25 * n);
        this.content.drawText("" + daimyoV.getPopulationAmount(), this.font, this.fontColor, 360, 6 + 25 * n);
        this.content.drawText("\u7dcf\u77f3\u9ad8", this.font, this.fontColor, 486, 6 + 25 * n);
        this.content.drawText("" + daimyoV.getFoodAmount(), this.font, this.fontColor, 600, 6 + 25 * n);
        this.content.drawText("\u5546\u696d", this.font, this.fontColor, 6, 6 + 25 * ++n);
        this.content.drawText("" + daimyoV.getCommerce(), this.font, this.fontColor, 120, 6 + 25 * n);
        this.content.drawText("\u6587\u5316\u5e73\u5747", this.font, this.fontColor, 246, 6 + 25 * n);
        this.content.drawText("" + daimyoV.getCultureArv(), this.font, this.fontColor, 360, 6 + 25 * n);
        this.content.drawText("\u7dcf\u5175\u6570", this.font, this.fontColor, 486, 6 + 25 * n);
        this.content.drawText("" + daimyoV.getArmyAmount(), this.font, this.fontColor, 600, 6 + 25 * n);
        this.content.drawText("\u91d1\u92ad", this.font, this.fontColor, 6, 6 + 25 * ++n);
        this.content.drawText("" + daimyoV.getMoney(), this.font, this.fontColor, 120, 6 + 25 * n);
        this.content.drawText("\u9244\u7832", this.font, this.fontColor, 246, 6 + 25 * n);
        this.content.drawText("" + daimyoV.getGun(), this.font, this.fontColor, 360, 6 + 25 * n);
        this.content.drawText("\u9a0e\u99ac", this.font, this.fontColor, 486, 6 + 25 * n);
        this.content.drawText("" + daimyoV.getHorse(), this.font, this.fontColor, 600, 6 + 25 * n);
        this.content.drawText("\u9244", this.font, this.fontColor, 6, 6 + 25 * ++n);
        this.content.drawText("" + daimyoV.getIron(), this.font, this.fontColor, 120, 6 + 25 * n);
        this.content.drawText("\u786b\u9ec4", this.font, this.fontColor, 246, 6 + 25 * n);
        this.content.drawText("" + daimyoV.getSaltpeter(), this.font, this.fontColor, 360, 6 + 25 * n);
        this.content.drawText("\u706b\u85ac", this.font, this.fontColor, 486, 6 + 25 * n);
        this.content.drawText("" + daimyoV.getGunpowder(), this.font, this.fontColor, 600, 6 + 25 * n);
        this.content.drawText("\u57fa\u7763\u6559\u614b\u5ea6", this.font, this.fontColor, 6, 6 + 25 * ++n);
        this.content.drawText("" + this.getChristTreatName(daimyoV.getChristTreat()), this.font, this.fontColor, 120, 6 + 25 * n);
    }

    private String getChristTreatName(int n) {
        switch (n) {
            case 1: {
                return "\u5968\u52b1";
            }
            case 0: {
                return "\u901a\u5e38";
            }
            case -1: {
                return "\u5f3e\u5727";
            }
        }
        return "\u901a\u5e38";
    }

    private void updateContentTechnology() {
        DaimyoV daimyoV = (DaimyoV)this.datav.getDaimyos().get(this.daimyoId);
        if (daimyoV == null) {
            return;
        }
        int n = 1;
        this.content.drawText("\u6240\u6709\u6280\u8853 (" + daimyoV.getTechnologyIds().size() + ")", this.font, this.fontColor, 6, 6 + 25 * n);
        ++n;
        int n2 = 0;
        int n3 = 6 + 25 * ++n;
        for (TechnologyV technologyV : daimyoV.getTechnologies()) {
            if (this.subPageIndex * 60 > n2 || n2 >= (this.subPageIndex + 1) * 60) continue;
            this.content.drawText(technologyV.getName(), this.font, this.fontColor, 6 + 150 * (n2 / 15), n3 + 25 * (n2 % 15));
            ++n2;
        }
        this.subPageMax = Math.max(0, daimyoV.getTechnologyIds().size() - 1) / 60;
    }

    private void updateContentCulture() {
        DaimyoV daimyoV = (DaimyoV)this.datav.getDaimyos().get(this.daimyoId);
        if (daimyoV == null) {
            return;
        }
        int n = 1;
        this.content.drawText("\u6240\u6709\u6587\u5316 (" + daimyoV.getCultureIds().size() + ")", this.font, this.fontColor, 6, 6 + 25 * n);
        ++n;
        int n2 = 0;
        int n3 = 6 + 25 * ++n;
        for (CultureV cultureV : daimyoV.getCultures()) {
            if (this.subPageIndex * 60 > n2 || n2 >= (this.subPageIndex + 1) * 60) continue;
            this.content.drawText(cultureV.getName(), this.font, this.fontColor, 6 + 150 * (n2 / 15), n3 + 25 * (n2 % 15));
            ++n2;
        }
        this.subPageMax = Math.max(0, daimyoV.getCultureIds().size() - 1) / 60;
    }

    private void updateContentKnight() {
        DaimyoV daimyoV = (DaimyoV)this.datav.getDaimyos().get(this.daimyoId);
        if (daimyoV == null) {
            return;
        }
        int n = 1;
        this.content.drawText("\u6240\u5c5e\u6b66\u5c06 (" + daimyoV.getKnightsWithTop().size() + ")", this.font, this.fontColor, 6, 6 + 25 * n);
        ++n;
        int n2 = 0;
        int n3 = 6 + 25 * ++n;
        for (KnightV knightV : daimyoV.getKnightsWithTop()) {
            if (this.subPageIndex * 60 > n2 || n2 >= (this.subPageIndex + 1) * 60) continue;
            this.content.drawText(knightV.getFullName() + "(" + knightV.getStatus() + ")", this.font, this.fontColor, 6 + 150 * (n2 / 15), n3 + 25 * (n2 % 15));
            ++n2;
        }
        this.subPageMax = Math.max(0, daimyoV.getKnightsWithTop().size() - 1) / 60;
    }

    private void updateContentReport() {
        DaimyoV daimyoV = (DaimyoV)this.datav.getDaimyos().get(this.daimyoId);
        if (daimyoV == null) {
            return;
        }
        BattleReport battleReport = daimyoV.getReport();
        int n = 1;
        this.content.drawText("\u6226\u95d8\u30ec\u30dd\u30fc\u30c8", this.font, this.fontColor, 6, 6 + 25 * n);
        this.content.drawText("\u52dd\u6570", this.font, this.fontColor, 6, 6 + 25 * (n += 2));
        this.content.drawText("" + battleReport.getWin(), this.font, this.fontColor, 150, 6 + 25 * n);
        this.content.drawText("\u52dd\u6570(\u5e73\u5730)", this.font, this.fontColor, 6, 6 + 25 * ++n);
        this.content.drawText("" + battleReport.getWinPlane(), this.font, this.fontColor, 150, 6 + 25 * n);
        this.content.drawText("\u52dd\u6570(\u5c71\u5730)", this.font, this.fontColor, 306, 6 + 25 * n);
        this.content.drawText("" + battleReport.getWinMountain(), this.font, this.fontColor, 450, 6 + 25 * n);
        this.content.drawText("\u52dd\u6570(\u6d77\u6226)", this.font, this.fontColor, 6, 6 + 25 * ++n);
        this.content.drawText("" + battleReport.getWinSea(), this.font, this.fontColor, 150, 6 + 25 * n);
        this.content.drawText("\u52dd\u6570(\u653b\u57ce\u6226)", this.font, this.fontColor, 306, 6 + 25 * n);
        this.content.drawText("" + battleReport.getWinCastle(), this.font, this.fontColor, 450, 6 + 25 * n);
        this.content.drawText("\u52dd\u6570(\u9632\u885b\u6226)", this.font, this.fontColor, 6, 6 + 25 * ++n);
        this.content.drawText("" + battleReport.getWinDefense(), this.font, this.fontColor, 150, 6 + 25 * n);
        this.content.drawText("\u52dd\u6570(\u9244\u7832)", this.font, this.fontColor, 6, 6 + 25 * ++n);
        this.content.drawText("" + battleReport.getWinGun(), this.font, this.fontColor, 150, 6 + 25 * n);
        this.content.drawText("\u52dd\u6570(\u9a0e\u99ac)", this.font, this.fontColor, 306, 6 + 25 * n);
        this.content.drawText("" + battleReport.getWinHorse(), this.font, this.fontColor, 450, 6 + 25 * n);
    }

    protected void initButtons() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        Texture texture = (Texture)graphicPool.getResource("batsu.png");
        Texture texture2 = (Texture)graphicPool.getResource("batsu2.png");
        this.children.clear();
        this.nextButton = new ButtonSprite(this.width / 2 + 15, this.height - 6 - 22, 100, 37, 25, 388883421, -1380583425, this.font, "\u6b21", true, MouseSymbolLayerManager.LAYER_MIDDLE);
        this.nextButton.setPrimaryClicked(windowClickable -> this.onNextClicked());
        this.nextButton.setFontColor(-319753729);
        this.nextButton.setParent(this);
        this.children.add(this.nextButton);
        this.prevButton = new ButtonSprite(this.width / 2 - 32 - 20, this.height - 6 - 22, 100, 37, 25, 388883421, -1380583425, this.font, "\u623b", true, MouseSymbolLayerManager.LAYER_MIDDLE);
        this.prevButton.setPrimaryClicked(windowClickable -> this.onPrevClicked());
        this.prevButton.setFontColor(-319753729);
        this.prevButton.setParent(this);
        this.children.add(this.prevButton);
        this.subNextButton = new ButtonSprite(this.width / 2 + 5, this.height - 60, 100, 32, 20, 388883421, -1380583425, this.font, "\u6b21", true, MouseSymbolLayerManager.LAYER_MIDDLE);
        this.subNextButton.setPrimaryClicked(windowClickable -> this.onSubNextClicked());
        this.subNextButton.setFontColor(-319753729);
        this.subNextButton.setParent(this);
        this.children.add(this.subNextButton);
        this.subPrevButton = new ButtonSprite(this.width / 2 + 5 - 32 - 5, this.height - 60, 100, 32, 20, 388883421, -1380583425, this.font, "\u623b", true, MouseSymbolLayerManager.LAYER_MIDDLE);
        this.subPrevButton.setPrimaryClicked(windowClickable -> this.onSubPrevClicked());
        this.subPrevButton.setFontColor(-319753729);
        this.subPrevButton.setParent(this);
        this.children.add(this.subPrevButton);
        this.close = new ImageButtonSprite(this.width - 32 - 6, 6, this.z + 10, 20, 20, texture, texture2, MouseSymbolLayerManager.LAYER_MIDDLE);
        this.close.setParent(this);
        this.children.add(this.close);
        this.pageChanged();
    }

    public void onClose(Consumer<WindowClickable> consumer) {
        this.close.setPrimaryClicked(consumer);
    }

    private void onNextClicked() {
        if (!this.isLast()) {
            ++this.pageIndex;
            this.pageChanged();
            this.needUpdate();
        }
    }

    private void onPrevClicked() {
        if (!this.isFirst()) {
            --this.pageIndex;
            this.pageChanged();
            this.needUpdate();
        }
    }

    private boolean isFirst() {
        return this.pageIndex == 0;
    }

    private boolean isLast() {
        return this.pageIndex >= 4;
    }

    private void onSubNextClicked() {
        if (!this.isSubLast()) {
            ++this.subPageIndex;
            this.needUpdate();
        }
    }

    private void onSubPrevClicked() {
        if (!this.isSubFirst()) {
            --this.subPageIndex;
            this.needUpdate();
        }
    }

    private boolean isSubFirst() {
        return this.subPageIndex == 0;
    }

    private boolean isSubLast() {
        return this.subPageIndex >= this.subPageMax;
    }
}

