/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.data.Build;
import game.sengoku.data.BuildPlan;
import game.sengoku.data.CommandV;
import game.sengoku.data.CountryV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.PlayerV;
import game.sengoku.game.GameCommandUtil;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.ImageButtonSprite;
import game.sengoku.window.WindowBase;
import game.sengoku.window.WindowClickable;
import java.util.function.Consumer;

public class WindowCountryDetailInfo
extends WindowBase {
    private static final int BUTTON_WIDTH = 32;
    private static final int BUTTON_HEIGHT = 20;
    private static final int CLUMN_MAX = 4;
    private static final int ROW_MAX = 15;
    private static final int INTERVAL = 25;
    private static final int INTERVAL_X = 300;
    private static final int VALUE_X = 160;
    private Font font = GameFontUtil.FONT20;
    private int fontColor = -269422081;
    private int countryId;
    private GameDataV datav;
    private PlayerV player;
    private int pageIndex = 0;
    protected ButtonSprite nextButton;
    protected ButtonSprite prevButton;
    private ImageButtonSprite close;

    public WindowCountryDetailInfo(int n, int n2, int n3, int n4, int n5, GameDataV gameDataV, PlayerV playerV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.countryId = -1;
        this.datav = gameDataV;
        this.player = playerV;
        this.initButtons();
    }

    public int getCountryId() {
        return this.countryId;
    }

    public void setCountryId(int n) {
        if (this.countryId != n) {
            this.countryId = n;
            this.needUpdate();
        }
    }

    public PlayerV getPlayer() {
        return this.player;
    }

    public void setPlayer(PlayerV playerV) {
        this.player = playerV;
    }

    private String sgn(int n) {
        return 0 < n ? "+" : " ";
    }

    @Override
    public void update() {
        if (this.nextButton != null) {
            if (this.isLast()) {
                this.nextButton.setNormalColor(-1380583425);
            } else {
                this.nextButton.setNormalColor(388883421);
            }
        }
        if (this.prevButton != null) {
            if (this.isFirst()) {
                this.prevButton.setNormalColor(-1380583425);
            } else {
                this.prevButton.setNormalColor(388883421);
            }
        }
        super.update();
    }

    private void pageChanged() {
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        switch (this.pageIndex) {
            case 0: {
                this.updateContentBase();
            }
        }
    }

    protected void updateContentBase() {
        Object object;
        super.updateContent();
        CountryV countryV = (CountryV)this.datav.getCountries().get(this.countryId);
        if (countryV == null) {
            return;
        }
        int n = 1;
        this.content.drawText(countryV.getName() + "\u56fd", this.font, this.fontColor, 6, 6 + 25 * n);
        this.content.drawText(countryV.getDaimyo().getName(), this.font, this.fontColor, 156, 6 + 25 * n);
        ++n;
        this.content.drawText("\u77f3\u9ad8", this.font, this.fontColor, 6, 6 + 25 * ++n);
        this.content.drawText("" + countryV.getFood() + "/" + countryV.getMaxFood(), this.font, this.fontColor, 160, 6 + 25 * n);
        this.content.drawText("\u77f3\u9ad8/\u6708", this.font, this.fontColor, 306, 6 + 25 * n);
        this.content.drawText(this.sgn(countryV.getFoodPlus()) + countryV.getFoodPlus(), this.font, this.fontColor, 460, 6 + 25 * n);
        this.content.drawText("\u4eba\u53e3", this.font, this.fontColor, 6, 6 + 25 * ++n);
        this.content.drawText("" + countryV.getPopulation() + "/" + countryV.getMaxPopulation(), this.font, this.fontColor, 160, 6 + 25 * n);
        this.content.drawText("\u4eba\u53e3/\u6708", this.font, this.fontColor, 306, 6 + 25 * n);
        this.content.drawText(this.sgn(countryV.getPopulationPlus()) + countryV.getPopulationPlus(), this.font, this.fontColor, 460, 6 + 25 * n);
        this.content.drawText("\u5546\u696d", this.font, this.fontColor, 6, 6 + 25 * ++n);
        this.content.drawText("" + countryV.getCommerce() + "/" + countryV.getMaxCommerce(), this.font, this.fontColor, 160, 6 + 25 * n);
        this.content.drawText("\u5546\u696d/\u6708", this.font, this.fontColor, 306, 6 + 25 * n);
        this.content.drawText(this.sgn(countryV.getCommercePlus()) + countryV.getCommercePlus(), this.font, this.fontColor, 460, 6 + 25 * n);
        int n2 = countryV.getDaimyo().getFame() < 0 && !countryV.getDaimyo().isDark() ? 882433023 : this.fontColor;
        this.content.drawText("\u6587\u5316", this.font, this.fontColor, 6, 6 + 25 * ++n);
        this.content.drawText("" + countryV.getCulture(), this.font, this.fontColor, 160, 6 + 25 * n);
        this.content.drawText("\u6587\u5316/\u6708", this.font, n2, 306, 6 + 25 * n);
        this.content.drawText(this.sgn(countryV.getCulturePlus()) + countryV.getCulturePlus(), this.font, n2, 460, 6 + 25 * n);
        this.content.drawText("\u6c11\u5fe0", this.font, this.fontColor, 6, 6 + 25 * ++n);
        this.content.drawText("" + countryV.getTamichu() + "/" + countryV.getMaxTamichu(), this.font, this.fontColor, 160, 6 + 25 * n);
        this.content.drawText("\u6c11\u5fe0/\u6708", this.font, n2, 306, 6 + 25 * n);
        this.content.drawText(this.sgn(countryV.getTamichuPlus()) + countryV.getTamichuPlus(), this.font, n2, 460, 6 + 25 * n);
        this.content.drawText("\u751f\u7523\u529b", this.font, this.fontColor, 6, 6 + 25 * ++n);
        this.content.drawText("" + countryV.getPower(), this.font, this.fontColor, 160, 6 + 25 * n);
        this.content.drawText("\u57fa\u7763\u6559\u666e\u53ca\u7387", this.font, this.fontColor, 6, 6 + 25 * ++n);
        this.content.drawText("" + countryV.getChrist() + "/" + countryV.getMaxChrist(), this.font, this.fontColor, 160, 6 + 25 * n);
        this.content.drawText("\u57fa\u7763\u6559\u666e\u53ca\u7387/\u6708", this.font, this.fontColor, 306, 6 + 25 * n);
        this.content.drawText(this.sgn(countryV.getChristPlus()) + countryV.getChristPlus(), this.font, this.fontColor, 460, 6 + 25 * n);
        ++n;
        String string = "????";
        if (this.player != null && this.player.getDaimyoId() == countryV.getDaimyoId()) {
            string = "" + countryV.getUsableArmy();
        }
        this.content.drawText("\u5175\u6570", this.font, this.fontColor, 6, 6 + 25 * n);
        this.content.drawText(string + "/" + countryV.getMaxArmy(), this.font, this.fontColor, 160, 6 + 25 * n);
        this.content.drawText("\u5175\u58eb\u30ec\u30d9\u30eb", this.font, this.fontColor, 6, 6 + 25 * ++n);
        this.content.drawText("" + countryV.getArmyLevel(), this.font, this.fontColor, 160, 6 + 25 * n);
        this.content.drawText("\u5175\u7d4c\u9a13\u5024", this.font, this.fontColor, 6, 6 + 25 * ++n);
        this.content.drawText("" + countryV.getArmyExp(), this.font, this.fontColor, 160, 6 + 25 * n);
        this.content.drawText("\u5175\u7d4c\u9a13\u5024/\u6708", this.font, this.fontColor, 306, 6 + 25 * n);
        this.content.drawText(this.sgn(countryV.getArmyExpPlus()) + countryV.getArmyExpPlus(), this.font, this.fontColor, 460, 6 + 25 * n);
        ++n;
        if (this.player != null && this.player.getDaimyo().isCanHongan()) {
            object = GameCommandUtil.calcMission(countryV);
            int n3 = object[0];
            int n4 = object[1];
            this.content.drawText("\u672c\u9858\u5bfa\u4fe1\u8005\u6570", this.font, this.fontColor, 6, 6 + 25 * n);
            this.content.drawText("" + n3, this.font, this.fontColor, 160, 6 + 25 * n);
            this.content.drawText("\u5e03\u6559\u7387", this.font, this.fontColor, 306, 6 + 25 * n);
            this.content.drawText("" + n4 + " \uff05", this.font, this.fontColor, 460, 6 + 25 * n);
            ++n;
        }
        if (this.player != null && this.player.getDaimyoId() == countryV.getDaimyoId()) {
            object = countryV.getBuildPlans();
            CommandV commandV2 = this.getPlayer().getCommands().stream().filter(commandV -> commandV.getKind() == 2).filter(commandV -> this.countryId == (Integer)commandV.getArgs().get(0)).findFirst().orElse(null);
            if (!object.isEmpty()) {
                BuildPlan buildPlan = (BuildPlan)object.get(0);
                this.content.drawText(buildPlan.getBuild().getName() + "\u3092\u5efa\u8a2d\u4e2d", this.font, this.fontColor, 6, 6 + 25 * ++n);
                int n5 = (buildPlan.getBuild().getPower() - buildPlan.getAmountPower()) / countryV.getPower() + 1;
                this.content.drawText("\u6b8b\u308a" + n5 + "\u30f6\u6708", this.font, this.fontColor, 6, 6 + 25 * ++n);
            } else if (commandV2 != null) {
                Build build = (Build)this.datav.getGameData().getBuilds().get(commandV2.getArgs().get(1));
                this.content.drawText(build.getName() + "\u3092\u5efa\u8a2d\u4e2d", this.font, this.fontColor, 6, 6 + 25 * ++n);
                int n6 = build.getPower() / countryV.getPower() + 1;
                this.content.drawText("\u6b8b\u308a" + n6 + "\u30f6\u6708", this.font, this.fontColor, 6, 6 + 25 * ++n);
            }
        }
    }

    protected void initButtons() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        Texture texture = (Texture)graphicPool.getResource("batsu.png");
        Texture texture2 = (Texture)graphicPool.getResource("batsu2.png");
        this.children.clear();
        this.nextButton = new ButtonSprite(this.width / 2 + 15, this.height - 6 - 22, 100, 37, 25, 388883421, -1380583425, this.font, "\u6b21", true, MouseSymbolLayerManager.LAYER_MIDDLE);
        this.nextButton.setPrimaryClicked(windowClickable -> this.onNextClicked());
        this.nextButton.setFontColor(-319753729);
        this.nextButton.setParent(this);
        this.children.add(this.nextButton);
        this.prevButton = new ButtonSprite(this.width / 2 - 32 - 20, this.height - 6 - 22, 100, 37, 25, 388883421, -1380583425, this.font, "\u623b", true, MouseSymbolLayerManager.LAYER_MIDDLE);
        this.prevButton.setPrimaryClicked(windowClickable -> this.onPrevClicked());
        this.prevButton.setFontColor(-319753729);
        this.prevButton.setParent(this);
        this.children.add(this.prevButton);
        this.close = new ImageButtonSprite(this.width - 32 - 6, 6, this.z + 10, 20, 20, texture, texture2, MouseSymbolLayerManager.LAYER_MIDDLE);
        this.close.setParent(this);
        this.children.add(this.close);
        this.pageChanged();
    }

    public void onClose(Consumer<WindowClickable> consumer) {
        this.close.setPrimaryClicked(consumer);
    }

    private void onNextClicked() {
        if (!this.isLast()) {
            ++this.pageIndex;
            this.pageChanged();
            this.needUpdate();
        }
    }

    private void onPrevClicked() {
        if (!this.isFirst()) {
            --this.pageIndex;
            this.pageChanged();
            this.needUpdate();
        }
    }

    private boolean isFirst() {
        return this.pageIndex == 0;
    }

    private boolean isLast() {
        return this.pageIndex >= 0;
    }
}

