/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.common.HasAbsoluteXY;
import game.base.symbol.MouseSymbol;
import game.base.symbol.MouseSymbolLayer;
import game.base.symbol.SymbolRect;
import game.sengoku.common.AudioUtil;
import game.sengoku.main.KessenMain;
import game.sengoku.window.WindowBase;
import java.util.function.Consumer;

public class WindowClickable
extends WindowBase {
    protected MouseSymbol mouseSymbol;
    protected Consumer<WindowClickable> mouseEnter;
    protected Consumer<WindowClickable> mouseExit;
    protected Consumer<WindowClickable> primaryClicked;
    protected Consumer<WindowClickable> secondaryClicked;
    protected MouseSymbolLayer layer;
    protected HasAbsoluteXY origine;
    protected int normalColor = 0;
    protected int overColor = 0;
    protected int soundId = 7;

    public WindowClickable(int n, int n2) {
        super(n, n2);
    }

    public WindowClickable(int n, int n2, int n3, int n4, int n5, int n6, int n7, MouseSymbolLayer mouseSymbolLayer) {
        this(n, n2, n3, n4, n5, n6, n7, mouseSymbolLayer, null);
    }

    public WindowClickable(int n, int n2, int n3, int n4, int n5, int n6, int n7, MouseSymbolLayer mouseSymbolLayer, HasAbsoluteXY hasAbsoluteXY) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.normalColor = n6;
        this.overColor = n7;
        this.layer = mouseSymbolLayer;
        this.origine = hasAbsoluteXY;
        this.setBgColor(n6);
    }

    @Override
    protected void init() {
        if (this.origine == null) {
            this.origine = this;
        }
        this.mouseSymbol = new MouseSymbol(KessenMain.getInstance(), this.layer);
        this.mouseSymbol.setOrigin(this.origine);
        this.mouseSymbol.setActive(true);
        this.mouseSymbol.getAreas().add(new SymbolRect(0, 0, this.width, this.height));
    }

    public int getSoundId() {
        return this.soundId;
    }

    public void setSoundId(int n) {
        this.soundId = n;
    }

    public int getNormalColor() {
        return this.normalColor;
    }

    public void setNormalColor(int n) {
        if (this.normalColor != n) {
            this.normalColor = n;
            this.needUpdate();
        }
    }

    public int getOverColor() {
        return this.overColor;
    }

    public void setOverColor(int n) {
        if (this.overColor != n) {
            this.overColor = n;
            this.needUpdate();
        }
    }

    public void setPrimaryClicked(Consumer<WindowClickable> consumer) {
        this.primaryClicked = consumer;
    }

    public void setSecondaryClicked(Consumer<WindowClickable> consumer) {
        this.secondaryClicked = consumer;
    }

    public void setMouseEnter(Consumer<WindowClickable> consumer) {
        this.mouseEnter = consumer;
    }

    public void setMouseExit(Consumer<WindowClickable> consumer) {
        this.mouseExit = consumer;
    }

    @Override
    public void update() {
        super.update();
        this.mouseSymbol.setActive(this.isVisible());
        this.mouseSymbol.update();
        int n = this.mouseSymbol.isMouseOver() ? this.overColor : this.normalColor;
        this.setBgColor(n);
        if (this.mouseSymbol.isMouseEnter()) {
            if (this.mouseEnter != null) {
                this.mouseEnter.accept(this);
            }
            this.needUpdate();
        }
        if (this.mouseSymbol.isMouseExit()) {
            if (this.mouseExit != null) {
                this.mouseExit.accept(this);
            }
            this.needUpdate();
        }
        if (this.mouseSymbol.isMousePrimaryClicked()) {
            if (this.primaryClicked != null) {
                AudioUtil.sePlay(this.soundId);
                this.primaryClicked.accept(this);
            }
        } else if (this.mouseSymbol.isMouseSecondaryClicked() && this.secondaryClicked != null) {
            this.secondaryClicked.accept(this);
        }
    }
}

