/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.graphic.DrawableTexture;
import game.base.graphic.TextureFactory;
import game.base.sprite.Sprite;

public class WindowBase
extends Sprite {
    protected static final int MARGIN = 6;
    protected int width = 0;
    protected int height = 0;
    protected int bgColor = 0;
    protected DrawableTexture background;
    private boolean initialized = false;

    public WindowBase(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.content = new TextureFactory().create(n, n2);
        this.background = new TextureFactory().create(n, n2);
    }

    public void initialize() {
        this.initialized = true;
        this.init();
        this.updateContent();
    }

    protected void init() {
    }

    protected void updateBackGround() {
        if (this.content == null) {
            this.content = new TextureFactory().create(this.width, this.height);
        }
        if (this.background == null) {
            this.background = new TextureFactory().create(this.width, this.height);
        }
        this.background.clear(this.bgColor);
        this.background.commit();
        this.needUpdate();
    }

    @Override
    protected void updateContent() {
        if (!this.initialized) {
            this.initialize();
        }
        this.updateBackGround();
        this.content.clear(0);
        this.content.drawImage(this.background, 0, 0);
        this.children.forEach(sprite -> {
            if (sprite != null) {
                sprite.draw(this.content);
            }
        });
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(int n) {
        if (this.bgColor != n) {
            this.bgColor = n;
            this.updateBackGround();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int n) {
        if (this.width != n) {
            this.width = n;
            this.initialized = false;
            this.content = null;
            this.background = null;
        }
    }

    public void setHeight(int n) {
        if (this.height != n) {
            this.height = n;
            this.initialized = false;
            this.content = null;
            this.background = null;
        }
    }

    @Override
    public void update() {
        if (!this.initialized) {
            this.initialize();
        }
        this.children.forEach(sprite -> {
            if (sprite != null) {
                sprite.update();
            }
        });
    }

    public void centering() {
        this.setX((800 - this.getWidth()) / 2);
        this.setY((600 - this.getHeight()) / 2);
    }
}

