/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.base.symbol.MouseSymbolLayer;
import game.sengoku.common.AudioUtil;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.GameUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.data.SystemData;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.ImageButtonSprite;
import game.sengoku.window.SliderSprite;
import game.sengoku.window.WindowBase;
import java.util.function.Consumer;

public class SoundOptionWindow
extends WindowBase {
    private Font font;
    private int fontColor = -319753729;
    private ImageButtonSprite music;
    private ImageButtonSprite se;
    private Texture texMusic;
    private Texture texSe;
    private Texture texMusicMute;
    private Texture texSeMute;
    private SliderSprite musicSlider;
    private SliderSprite seSlider;
    private boolean seMute = false;
    private boolean musicMute = false;
    protected ButtonSprite commit;
    protected Consumer<SoundOptionWindow> commitClicked;
    private MouseSymbolLayer layer = MouseSymbolLayerManager.LAYER_NORMAL;

    public SoundOptionWindow(int n, int n2, int n3, int n4, int n5, MouseSymbolLayer mouseSymbolLayer) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.font = GameFontUtil.FONT16;
        this.fontColor = -319753729;
        this.layer = mouseSymbolLayer;
        this.load();
    }

    private void load() {
        this.children.clear();
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        SystemData systemData = this.getSystemData();
        this.musicMute = systemData.isMusicMute();
        this.seMute = systemData.isSeMute();
        this.texMusic = (Texture)graphicPool.getResource("speaker01.png");
        this.texSe = (Texture)graphicPool.getResource("speaker02.png");
        this.texMusicMute = (Texture)graphicPool.getResource("mute01.png");
        this.texSeMute = (Texture)graphicPool.getResource("mute02.png");
        this.music = new ImageButtonSprite(80, 37, this.z + 10, 25, 25, this.texMusic, this.texMusicMute, this.layer);
        this.music.setPrimaryClicked(windowClickable -> {
            this.musicMute = !this.musicMute;
            AudioUtil.setMusicMute(this.musicMute);
        });
        this.music.setParent(this);
        this.children.add(this.music);
        this.se = new ImageButtonSprite(80, 79, this.z + 10, 25, 25, this.texSe, this.texSeMute, this.layer);
        this.se.setPrimaryClicked(windowClickable -> {
            this.seMute = !this.seMute;
            this.getSystemData().setSeMute(this.seMute);
        });
        this.se.setParent(this);
        this.children.add(this.se);
        this.musicSlider = new SliderSprite(120, 37, this.z + 10, 170, 25, false, this.layer);
        this.musicSlider.setValueChanged(() -> {
            double d = (double)this.musicSlider.getValue() * 0.1;
            AudioUtil.volumeChange(d);
        });
        this.musicSlider.setParent(this);
        this.children.add(this.musicSlider);
        this.seSlider = new SliderSprite(120, 79, this.z + 10, 170, 25, false, this.layer);
        this.seSlider.setValueChanged(() -> {
            double d = (double)this.seSlider.getValue() * 0.1;
            AudioUtil.sePlay(7, d);
        });
        this.seSlider.setParent(this);
        this.children.add(this.seSlider);
        this.musicSlider.setValueMax(20);
        this.seSlider.setValueMax(20);
        this.musicSlider.setValue((int)(systemData.getMusicVolume() * 10.0));
        this.seSlider.setValue((int)(systemData.getSeVolume() * 10.0));
        this.commit = new ButtonSprite(240, 121, this.z + 10, 48, 20, 388883421, -1380583425, this.font, "\u8a2d\u5b9a", true, MouseSymbolLayerManager.LAYER_MIDDLE);
        this.commit.setPrimaryClicked(windowClickable -> this.commit());
        this.commit.setFontColor(-319753729);
        this.commit.setParent(this);
        this.children.add(this.commit);
    }

    public void reset() {
    }

    public void commit() {
        SystemData systemData = this.getSystemData();
        systemData.setMusicMute(this.musicMute);
        systemData.setSeMute(this.seMute);
        systemData.setMusicVolume((double)this.musicSlider.getValue() * 0.1);
        systemData.setSeVolume((double)this.seSlider.getValue() * 0.1);
        GameUtil.saveSystemData(systemData);
        if (this.commitClicked != null) {
            this.commitClicked.accept(this);
        }
    }

    @Override
    public void update() {
        super.update();
        this.se.setReverse(this.seMute);
        this.music.setReverse(this.musicMute);
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.content.drawText("\u30b5\u30a6\u30f3\u30c9\u30aa\u30d7\u30b7\u30e7\u30f3", this.font, this.fontColor, 5, 21);
        this.content.drawText("\u97f3\u697d", this.font, this.fontColor, 5, 53);
        this.content.drawText("" + this.musicSlider.getValue(), this.font, this.fontColor, 300, 53);
        this.content.drawText("\u52b9\u679c\u97f3", this.font, this.fontColor, 5, 95);
        this.content.drawText("" + this.seSlider.getValue(), this.font, this.fontColor, 300, 95);
    }

    private SystemData getSystemData() {
        return KessenMain.getInstance().getSystemData();
    }

    public void setCommitClicked(Consumer<SoundOptionWindow> consumer) {
        this.commitClicked = consumer;
    }
}

