/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.data.SaveDataInterface;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.WindowBase;

public class SaveDataWindow
extends WindowBase {
    private SaveDataInterface saveData;
    private String defaultMessage;
    private ButtonSprite latest;

    public SaveDataInterface getSaveData() {
        return this.saveData;
    }

    public void setSaveData(SaveDataInterface saveDataInterface) {
        this.saveData = saveDataInterface;
        this.needUpdate();
    }

    public SaveDataWindow(int n, int n2, String string) {
        super(700, 140);
        this.setX(n);
        this.setY(n2);
        this.setZ(100);
        this.setBgColor(877223628);
        this.saveData = null;
        this.defaultMessage = string;
        this.latest = new ButtonSprite(this.width - 165, 6, this.z + 100, 50, 20, -16776961, -16776961, GameFontUtil.FONT16, "\u6700\u65b0", true, MouseSymbolLayerManager.LAYER_MESSAGE);
        this.latest.setFontColor(-319753729);
        this.latest.setVisible(false);
        this.latest.setParent(this);
        this.children.add(this.latest);
    }

    @Override
    public void update() {
        super.update();
        if (this.saveData != null) {
            this.latest.setVisible(this.saveData.isLatest());
        } else {
            this.latest.setVisible(false);
        }
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        if (this.saveData != null) {
            int n = 1;
            this.content.drawText(this.saveData.getName(), GameFontUtil.FONT16, -1, 6, 6 + 16 * n);
            this.content.drawText(this.saveData.getExplain(), GameFontUtil.FONT16, -1, 6, 6 + 16 * ++n);
            this.content.drawText(this.saveData.getTimestamp(), GameFontUtil.FONT16, -1, 6, 6 + 16 * ++n);
            ++n;
            String string = this.saveData.getScenario();
            int n2 = 0;
            for (int i = 0; i < string.length(); i += 24) {
                String string2 = string.substring(i, Math.min(i + 24, string.length()));
                this.content.drawText(string2, GameFontUtil.FONT16, -1, 6, 6 + 16 * n + 8 + 16 * n2);
                ++n2;
            }
            this.content.drawText(this.saveData.getFileName(), GameFontUtil.FONT16, -1, this.width - 6 - 200, this.height - 22);
        } else {
            this.content.drawText(this.defaultMessage, GameFontUtil.FONT16, -1, 6, 22);
        }
    }
}

