/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.data.GameDataV;
import game.sengoku.data.Present;
import game.sengoku.data.TechnologyV;
import game.sengoku.window.ButtonSprite;

public class PresentButton
extends ButtonSprite {
    private GameDataV datav;
    private Present present;

    public PresentButton(int n, int n2, int n3, int n4, GameDataV gameDataV) {
        super(n, n2, n3, n4, 55, -235801635, 1768520959, GameFontUtil.FONT20, "", false, MouseSymbolLayerManager.LAYER_NORMAL);
        this.datav = gameDataV;
    }

    public Present getPresent() {
        return this.present;
    }

    public void setPresent(Present present) {
        this.present = present;
        this.needUpdate();
    }

    public TechnologyV getTechnology() {
        TechnologyV technologyV = (TechnologyV)this.datav.getTechnologies().get(this.present.getTechnologyId());
        return technologyV;
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        if (this.present == null) {
            return;
        }
        TechnologyV technologyV = (TechnologyV)this.datav.getTechnologies().get(this.present.getTechnologyId());
        if (technologyV == null) {
            return;
        }
        int n = (this.width - (int)this.font.getFontSize() * technologyV.getName().length()) / 2;
        this.content.drawText(technologyV.getName(), this.font, this.fontColor, n, (int)this.font.getFontSize() + 5);
        String string = "\u53cb\u597d\u5ea6\uff1a" + this.present.getFriendship();
        n = (this.width - (int)this.font.getFontSize() * string.length()) / 2;
        this.content.drawText(string, this.font, this.fontColor, n, (int)this.font.getFontSize() * 2 + 5);
    }
}

