/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.title;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.AudioUtil;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.common.Scene;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.WindowCreditlInfo;

public class SceneTitle
extends Scene {
    private Texture bgtitle;
    private ButtonSprite newGame;
    private ButtonSprite loadGame;
    private ButtonSprite exit;
    private ButtonSprite creditb;
    private WindowCreditlInfo credit;
    private boolean creditView = false;

    public SceneTitle() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.bgtitle = (Texture)graphicPool.getResource("title2.jpg");
        this.newGame = new ButtonSprite(350, 350, 100, 120, 50, -235801635, 1768520959, GameFontUtil.FONT30, "\u65b0\u898f", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.newGame.setPrimaryClicked(windowClickable -> this.getPlayerClient().gameJoinRequest(false));
        this.newGame.setSoundId(1);
        this.loadGame = new ButtonSprite(350, 425, 100, 120, 50, -235801635, 1768520959, GameFontUtil.FONT30, "\u7d99\u7d9a", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.loadGame.setPrimaryClicked(windowClickable -> this.getPlayerClient().gameJoinRequest(true));
        this.exit = new ButtonSprite(350, 500, 100, 120, 50, -235801635, 1768520959, GameFontUtil.FONT30, "\u7d42\u4e86", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.exit.setPrimaryClicked(windowClickable -> this.getPlayerClient().gameEnd());
        this.creditb = new ButtonSprite(50, 500, 100, 220, 30, 0, 1768520959, GameFontUtil.FONT20, "\u3053\u306e\u30b2\u30fc\u30e0\u306b\u3064\u3044\u3066", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.creditb.setFontColor(-319753729);
        this.creditb.setPrimaryClicked(windowClickable -> {
            this.creditView = true;
        });
        this.credit = new WindowCreditlInfo(50, 10, 100, 700, 580, KessenMain.getInstance().getSystemData());
        this.credit.onClose(windowClickable -> {
            this.creditView = false;
        });
    }

    @Override
    public void load() {
        super.load();
        this.creditView = false;
        AudioUtil.musicPlay(1);
    }

    @Override
    public void update() {
        super.update();
        this.credit.setVisible(this.creditView);
        this.newGame.setVisible(!this.creditView);
        this.loadGame.setVisible(!this.creditView);
        this.exit.setVisible(!this.creditView);
        this.creditb.setVisible(!this.creditView);
        this.newGame.update();
        this.loadGame.update();
        this.exit.update();
        this.creditb.update();
        this.credit.update();
    }

    @Override
    protected void updateContent() {
        this.bcontext.drawImage(this.bgtitle, 0, 0, -100);
        this.newGame.draw(this.bcontext);
        this.loadGame.draw(this.bcontext);
        this.exit.draw(this.bcontext);
        this.creditb.draw(this.bcontext);
        this.credit.draw(this.bcontext);
    }

    @Override
    public boolean withHolding() {
        return false;
    }
}

