/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.server;

import game.sengoku.common.GameTemp;
import game.sengoku.common.GameUtil;
import game.sengoku.data.AIUseObject;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameAIData;
import game.sengoku.data.GameData;
import game.sengoku.data.GameDataV;
import game.sengoku.data.GameHistory;
import game.sengoku.data.PlayerV;
import game.sengoku.data.SaveData;
import game.sengoku.data.SaveDataInterface;
import game.sengoku.data.Scenario;
import game.sengoku.game.GameCommandUtil;
import game.sengoku.game.GameDebugUtil;
import game.sengoku.game.GameTacticsUtil;
import game.sengoku.game.diplomacy.NegotiationAction;
import game.sengoku.game.diplomacy.StoreAction;
import game.sengoku.game.domestic.DomesticAction;
import game.sengoku.game.domestic.DomesticEventResult;
import game.sengoku.game.tactics.TacticsAction;
import game.sengoku.server.GameMessage;
import game.sengoku.server.PostBox;
import game.sengoku.server.entity.DiplomacyActionRequest;
import game.sengoku.server.entity.DiplomacyActionResponse;
import game.sengoku.server.entity.DiplomacyPhaseResponse;
import game.sengoku.server.entity.DomesticActionResponse;
import game.sengoku.server.entity.DomesticEventRequest;
import game.sengoku.server.entity.DomesticEventResponse;
import game.sengoku.server.entity.DomesticPhaseResponse;
import game.sengoku.server.entity.GameFinalRequest;
import game.sengoku.server.entity.GameFinalResponse;
import game.sengoku.server.entity.GameJoinRequest;
import game.sengoku.server.entity.GameJoinRequestAi;
import game.sengoku.server.entity.GameJoinResponse;
import game.sengoku.server.entity.GameSaveDataResponse;
import game.sengoku.server.entity.GameSaveRequest;
import game.sengoku.server.entity.GameSaveResponse;
import game.sengoku.server.entity.GameStartResponse;
import game.sengoku.server.entity.MessageNotice;
import game.sengoku.server.entity.MessageResponse;
import game.sengoku.server.entity.NegotiationActionRequest;
import game.sengoku.server.entity.NegotiationActionResponse;
import game.sengoku.server.entity.NegotiationResultRequest;
import game.sengoku.server.entity.NegotiationResultResponse;
import game.sengoku.server.entity.NegotiationStartRequest;
import game.sengoku.server.entity.NegotiationStartResponse;
import game.sengoku.server.entity.SelectDaimyoResponse;
import game.sengoku.server.entity.SelectLoadRequest;
import game.sengoku.server.entity.SelectLoadResponse;
import game.sengoku.server.entity.SelectScenarioRequest;
import game.sengoku.server.entity.SelectScenarioResponse;
import game.sengoku.server.entity.StoreActionRequest;
import game.sengoku.server.entity.StoreActionResponse;
import game.sengoku.server.entity.TacticsActionResponse;
import game.sengoku.server.entity.TacticsPhaseResponse;
import game.sengoku.server.entity.TacticsResultRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class GameClient {
    public static final int GAME_JOIN_DOING = 0;
    public static final int GAME_JOIN_RESPONSE_WAIT = 1;
    public static final int SELECT_SCENARIO_DOING = 21;
    public static final int SELECT_DAIMYO_REQUEST_WAIT = 24;
    public static final int SELECT_DAIMYO_DOING = 22;
    public static final int SELECT_LOAD_DOING = 23;
    public static final int GAME_START_WAIT = 2;
    public static final int DOMESTIC_START_DOING = 3;
    public static final int DOMESTIC_ACTION_REQUEST_WAIT = 4;
    public static final int DOMESTIC_EVENT_DOING = 41;
    public static final int DOMESTIC_ACTION_DOING = 5;
    public static final int DOMESTIC_RESULT_DOING = 36;
    public static final int DIPLOMACY_START_DOING = 37;
    public static final int DIPLOMACY_ACTION_REQUEST_WAIT = 17;
    public static final int DIPLOMACY_ACTION_DOING = 18;
    public static final int NEGOTIATION_START_DOING = 8;
    public static final int NEGOTIATION_ACTION_REQUEST_WAIT = 9;
    public static final int NEGOTIATION_ACTION_DOING = 10;
    public static final int STORE_ACTION_DOING = 44;
    public static final int NEGOTIATION_RESULT_DOING = 11;
    public static final int TACTICS_START_DOING = 12;
    public static final int TACTICS_ACTION_REQUEST_WAIT = 13;
    public static final int TACTICS_ACTION_DOING = 14;
    public static final int TACTICS_RESULT_REQUEST_WAIT = 15;
    public static final int TACTICS_RESULT_DOING = 16;
    public static final int TACTICS_END_DOING = 52;
    public static final int INTERVAL_ACTION_DOING = 38;
    public static final int INTERVAL_ACTION_REQUEST_WAIT = 39;
    public static final int GAME_FINAL_DOING = 42;
    public static final int GAME_FINAL_REQUEST_WAIT = 43;
    public static final int GAME_SAVE_DATA_RESPONSE_WAIT = 32;
    public static final int GAME_SAVE_RESPONSE_WAIT = 33;
    public static final int GAME_SAVE_DOING = 34;
    public static final int GAME_SAVE_RESULT_DOING = 35;
    public static final int GAME_END = 30;
    private int id = 0;
    private int status = 0;
    private int connectedServer = 0;
    private PostBox post = null;
    private PlayerV player = null;
    private List<Scenario> scenarios;
    private List<SaveDataInterface> saveDatas;
    private GameTemp gameTemp;
    private GameData gameData;
    private GameDataV gameDataV;
    private GameAIData gameAiData;
    private String savedFileName;

    public GameClient(int n, PostBox postBox, PlayerV playerV) {
        this.id = n;
        this.post = postBox;
        this.player = playerV;
        this.connectedServer = 2;
        this.gameTemp = new GameTemp();
    }

    public int getId() {
        return this.id;
    }

    public PlayerV getPlayer() {
        return this.player;
    }

    protected void setPlayer(PlayerV playerV) {
        this.player = playerV;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void init() {
        this.referencePlayer();
        this.status = 0;
    }

    public void init(GameDataV gameDataV) {
        this.gameDataV = gameDataV;
        this.gameData = gameDataV.getGameData();
        this.gameAiData = gameDataV.getGameAIData();
        this.referencePlayer();
        this.status = 0;
    }

    private void referencePlayer() {
        this.player.setGameData(this.gameData);
        this.player.setGameAIData(this.gameAiData);
        this.player.setGameDataV(this.gameDataV);
    }

    public void update() {
        GameDebugUtil.printClientStatus(this.id, this.status);
        switch (this.status) {
            case 0: {
                break;
            }
            case 1: {
                this.receive();
                break;
            }
            case 21: {
                break;
            }
            case 24: {
                this.receive();
                break;
            }
            case 22: {
                break;
            }
            case 23: {
                break;
            }
            case 2: {
                this.receive();
                break;
            }
            case 4: {
                this.receive();
                break;
            }
            case 3: {
                this.createDomesticStart();
                break;
            }
            case 41: {
                this.createDomesticEvent();
                break;
            }
            case 5: {
                this.createDomesticAction();
                break;
            }
            case 36: {
                this.createDomesticResult();
                break;
            }
            case 37: {
                this.createDiplomacyStart();
                break;
            }
            case 18: {
                this.createDiplomacyAction();
                break;
            }
            case 17: {
                this.receive();
                break;
            }
            case 8: {
                this.createNegotiationStart();
                break;
            }
            case 9: {
                this.receive();
                break;
            }
            case 10: {
                this.createNegotiationAction();
                break;
            }
            case 44: {
                this.createStoreAction();
                break;
            }
            case 11: {
                this.createNegotiationResult();
                break;
            }
            case 12: {
                this.createTacticsStart();
            }
            case 13: {
                this.receive();
                break;
            }
            case 14: {
                this.createTacticsAction();
                break;
            }
            case 38: {
                this.createIntervalAction();
                break;
            }
            case 42: {
                this.createGameFinal();
                break;
            }
            case 15: {
                this.receive();
                break;
            }
            case 39: {
                this.receive();
                break;
            }
            case 16: {
                this.createTacticsResult();
                break;
            }
            case 52: {
                this.createTacticsEnd();
                break;
            }
            case 33: {
                this.receive();
                break;
            }
            case 32: {
                this.receive();
                break;
            }
            case 34: 
            case 35: {
                break;
            }
            case 30: {
                break;
            }
            default: {
                throw new RuntimeException("invalid status = " + this.status);
            }
        }
    }

    private void receive() {
        this.receiveMessages();
        GameMessage gameMessage = this.post.receive(this.id);
        if (gameMessage == null) {
            return;
        }
        switch (gameMessage.getMessageId()) {
            case 3: {
                this.gameJoinResponseReceive(gameMessage);
                break;
            }
            case 4: {
                this.gameJoinResponseReceive(gameMessage);
                break;
            }
            case 5: {
                this.selectScenarioStart(gameMessage);
                break;
            }
            case 7: {
                this.selectDaimyoStart(gameMessage);
                break;
            }
            case 9: {
                this.selectLoadStart(gameMessage);
                break;
            }
            case 11: {
                this.gameStartResponse(gameMessage);
                break;
            }
            case 13: {
                this.domesticStart(gameMessage);
                break;
            }
            case 15: {
                this.domesticEventStart(gameMessage);
                break;
            }
            case 17: {
                this.domesticActionStart(gameMessage);
                break;
            }
            case 19: {
                this.domesticResultStart(gameMessage);
                break;
            }
            case 21: {
                this.diplomacyStart(gameMessage);
                break;
            }
            case 23: {
                this.diplomacyActionStart(gameMessage);
                break;
            }
            case 27: {
                this.negotiationStart(gameMessage);
                break;
            }
            case 29: {
                this.negotiationActionStart(gameMessage);
                break;
            }
            case 25: {
                this.storeActionStart(gameMessage);
                break;
            }
            case 31: {
                this.negotiationResultStart(gameMessage);
                break;
            }
            case 33: {
                this.tacticsStartRequestReceive(gameMessage);
                break;
            }
            case 35: {
                this.tacticsActionStart(gameMessage);
                break;
            }
            case 37: {
                this.tacticsResultStart(gameMessage);
                break;
            }
            case 39: {
                this.tacticsEndRequestReceive(gameMessage);
                break;
            }
            case 49: {
                this.intervalActionRequestReceive(gameMessage);
                break;
            }
            case 51: {
                this.gameFinalRequestReceive(gameMessage);
                break;
            }
            case 46: {
                this.gameSaveResponseReceive(gameMessage);
                break;
            }
            case 44: {
                this.gameSaveDataResponseReceive(gameMessage);
                break;
            }
            case 41: {
                break;
            }
            default: {
                throw new RuntimeException("invalid message id = " + gameMessage.getMessageId());
            }
        }
    }

    private void receiveMessages() {
        GameMessage gameMessage;
        while ((gameMessage = this.post.receive(this.id, 98)) != null) {
            this.receiveMessage(gameMessage);
        }
    }

    public void gameJoinRequest(boolean bl) {
        this.post.send(new GameMessage(1, this.id, 1, 3, new GameJoinRequest(bl, this.player)));
        this.status = 1;
    }

    public void gameJoinRequestAI() {
        this.post.send(new GameMessage(2, this.id, 1, 3, new GameJoinRequestAi(this.player)));
        this.status = 1;
    }

    protected void gameJoinResponseReceive(GameMessage gameMessage) {
        GameJoinResponse gameJoinResponse = (GameJoinResponse)gameMessage.getPayload();
        this.gameData = gameJoinResponse.getGameData();
        this.gameAiData = gameJoinResponse.getGameAiData();
        this.referencePlayer();
    }

    public void gameSaveDataRequest() {
        this.post.send(new GameMessage(43, this.id, 1, 3, new GameSaveRequest()));
        this.status = 33;
    }

    private void gameSaveDataResponseReceive(GameMessage gameMessage) {
        GameSaveDataResponse gameSaveDataResponse = (GameSaveDataResponse)gameMessage.getPayload();
        this.saveDatas = gameSaveDataResponse.getSaveDatas();
        this.status = 34;
    }

    public void gameSaveRequest(boolean bl, boolean bl2, SaveDataInterface saveDataInterface) {
        String string = saveDataInterface == null ? "" : saveDataInterface.getFileName();
        this.post.send(new GameMessage(45, this.id, 1, 3, new GameSaveRequest(bl, bl2, string)));
        this.status = 33;
    }

    private void gameSaveResponseReceive(GameMessage gameMessage) {
        GameSaveResponse gameSaveResponse = (GameSaveResponse)gameMessage.getPayload();
        this.savedFileName = gameSaveResponse.getFileName();
        this.status = 35;
    }

    public String getSavedFileName() {
        return this.savedFileName;
    }

    public void gameSaveEnd() {
        this.savedFileName = null;
        this.intervalActionResponse();
    }

    protected void selectScenarioStart(GameMessage gameMessage) {
        SelectScenarioRequest selectScenarioRequest = (SelectScenarioRequest)gameMessage.getPayload();
        this.scenarios = selectScenarioRequest.getScenarios();
        this.status = 21;
    }

    public void selectScenarioResponse(boolean bl, Scenario scenario) {
        this.post.send(new GameMessage(6, this.id, 1, 3, new SelectScenarioResponse(bl, scenario)));
        if (bl) {
            this.status = 0;
        } else {
            this.gameDataV = scenario.getData();
            this.referencePlayer();
            this.status = 24;
        }
    }

    protected void selectDaimyoStart(GameMessage gameMessage) {
        this.status = 22;
    }

    public void selectDaimyoResponse(boolean bl, int n) {
        this.post.send(new GameMessage(8, this.id, 1, 3, new SelectDaimyoResponse(bl, n)));
        this.player.setDaimyoId(n);
        this.status = 2;
    }

    protected void selectLoadStart(GameMessage gameMessage) {
        SelectLoadRequest selectLoadRequest = (SelectLoadRequest)gameMessage.getPayload();
        this.saveDatas = selectLoadRequest.getSaveDatas();
        this.status = 23;
    }

    public void selectLoadResponse(boolean bl, SaveDataInterface saveDataInterface) {
        SaveData saveData = null;
        if (saveDataInterface != null) {
            File file = new File(saveDataInterface.getFileName());
            saveData = GameUtil.loadSave(file);
        }
        this.post.send(new GameMessage(10, this.id, 1, 3, new SelectLoadResponse(bl, saveData)));
        if (bl) {
            this.status = 0;
        } else {
            this.gameDataV = saveData.getData();
            this.referencePlayer();
            this.status = 2;
        }
    }

    protected void gameStartResponse(GameMessage gameMessage) {
        this.connectedServer = gameMessage.getFromId();
        this.post.send(new GameMessage(12, this.id, this.connectedServer, 3, new GameStartResponse()));
        this.status = 2;
    }

    protected void domesticStart(GameMessage gameMessage) {
        this.getGameTemp().setTacticsAction(null);
        this.getGameTemp().setForceShift(true);
        this.status = 3;
    }

    protected abstract void createDomesticStart();

    public void domesticStartResponse() {
        this.post.send(new GameMessage(14, this.id, this.connectedServer, 3, new DomesticPhaseResponse()));
        this.status = 4;
    }

    protected void domesticEventStart(GameMessage gameMessage) {
        DomesticEventRequest domesticEventRequest = (DomesticEventRequest)gameMessage.getPayload();
        if (domesticEventRequest.getDomesticEvent() == null) {
            this.domesticEventResponse(null);
        } else {
            this.getGameTemp().setDomesticEvent(domesticEventRequest.getDomesticEvent());
            this.status = 41;
        }
    }

    protected abstract void createDomesticEvent();

    public void domesticEventResponse(DomesticEventResult domesticEventResult) {
        this.post.send(new GameMessage(16, this.id, this.connectedServer, 3, new DomesticEventResponse(domesticEventResult)));
        this.status = 4;
    }

    protected void domesticActionStart(GameMessage gameMessage) {
        this.player.getCommands().clear();
        this.status = 5;
    }

    protected abstract void createDomesticAction();

    public void domesticActionResponse(DomesticAction domesticAction) {
        this.post.send(new GameMessage(18, this.id, this.connectedServer, 3, new DomesticActionResponse(domesticAction)));
        this.status = 4;
    }

    protected void domesticResultStart(GameMessage gameMessage) {
        this.player.getCommands().clear();
        this.status = 36;
    }

    protected abstract void createDomesticResult();

    public void domesticResultResponse() {
        this.post.send(new GameMessage(20, this.id, this.connectedServer, 3, null));
        this.status = 4;
    }

    protected void diplomacyStart(GameMessage gameMessage) {
        this.getGameTemp().setForceShift(true);
        this.status = 37;
    }

    protected abstract void createDiplomacyStart();

    public void diplomacyStartResponse() {
        this.post.send(new GameMessage(22, this.id, this.connectedServer, 3, new DiplomacyPhaseResponse()));
        this.status = 17;
    }

    protected void diplomacyActionStart(GameMessage gameMessage) {
        DiplomacyActionRequest diplomacyActionRequest = (DiplomacyActionRequest)gameMessage.getPayload();
        this.getGameTemp().getNegotiationDaimyoIds().clear();
        this.getGameTemp().getNegotiationDaimyoIds().addAll(diplomacyActionRequest.getNegotiationDaimyoIds());
        this.getGameTemp().getNegotiationStoreIds().clear();
        this.getGameTemp().getNegotiationStoreIds().addAll(diplomacyActionRequest.getNegotiationStoreIds());
        this.getGameTemp().setNegotiationDaimyoIdChange(true);
        this.player.getCommands().clear();
        this.status = 18;
    }

    protected abstract void createDiplomacyAction();

    public void diplomacyActionResponse(int n, int n2) {
        this.post.send(new GameMessage(24, this.id, this.connectedServer, 3, new DiplomacyActionResponse(n, n2)));
        this.status = 17;
    }

    protected void negotiationStart(GameMessage gameMessage) {
        NegotiationStartRequest negotiationStartRequest = (NegotiationStartRequest)gameMessage.getPayload();
        this.getGameTemp().setNegotiationDaimyoId(negotiationStartRequest.getTargetDaimyoId());
        this.status = 8;
    }

    protected abstract void createNegotiationStart();

    public void negotiationResponse(int n, int n2, boolean bl) {
        this.post.send(new GameMessage(28, this.id, this.connectedServer, 3, new NegotiationStartResponse(n, n2, bl)));
        this.status = 17;
    }

    protected void storeActionStart(GameMessage gameMessage) {
        StoreActionRequest storeActionRequest = (StoreActionRequest)gameMessage.getPayload();
        this.getGameTemp().setSelectedObjectId(storeActionRequest.getStoreId());
        this.status = 44;
    }

    protected abstract void createStoreAction();

    public void storeActionResponse(StoreAction storeAction) {
        ArrayList<StoreAction> arrayList = new ArrayList<StoreAction>();
        arrayList.add(storeAction);
        this.storeActionResponse(arrayList);
    }

    public void storeActionResponse(List<StoreAction> list) {
        this.post.send(new GameMessage(26, this.id, this.connectedServer, 3, new StoreActionResponse(list)));
        this.status = 17;
    }

    protected void negotiationActionStart(GameMessage gameMessage) {
        NegotiationActionRequest negotiationActionRequest = (NegotiationActionRequest)gameMessage.getPayload();
        this.getGameTemp().setNegotiationAction(negotiationActionRequest.getNegotiationAction());
        this.getGameTemp().setNegotiationDaimyoId(negotiationActionRequest.getNegotiationAction().getTargetEntry().getDaimyoId());
        this.status = 10;
    }

    protected abstract void createNegotiationAction();

    public void negotiationActionResponse(NegotiationAction negotiationAction) {
        negotiationAction.validate();
        this.post.send(new GameMessage(30, this.id, this.connectedServer, 3, new NegotiationActionResponse(negotiationAction)));
        this.status = 9;
    }

    protected void negotiationResultStart(GameMessage gameMessage) {
        NegotiationResultRequest negotiationResultRequest = (NegotiationResultRequest)gameMessage.getPayload();
        if (negotiationResultRequest.isAgreement()) {
            AIUseObject aIUseObject = this.getPlayer().getAIUseObject();
            aIUseObject.getNotNegotiates().remove(negotiationResultRequest.getTargetDaimyoId());
        } else {
            AIUseObject aIUseObject = this.getPlayer().getAIUseObject();
            aIUseObject.getNotNegotiates().put(negotiationResultRequest.getTargetDaimyoId(), 5);
        }
        this.status = 11;
    }

    protected abstract void createNegotiationResult();

    public void negotiationResultResponse() {
        this.post.send(new GameMessage(32, this.id, this.connectedServer, 3, new NegotiationResultResponse()));
        this.status = 17;
    }

    protected void tacticsStartRequestReceive(GameMessage gameMessage) {
        this.getGameTemp().setForceShift(true);
        this.status = 12;
    }

    protected abstract void createTacticsStart();

    public void tacticsStartResponse() {
        this.post.send(new GameMessage(34, this.id, this.connectedServer, 3, new TacticsPhaseResponse()));
        this.status = 13;
    }

    protected void tacticsActionStart(GameMessage gameMessage) {
        TacticsAction tacticsAction = new TacticsAction(this.getPlayer().getDaimyoId());
        GameTacticsUtil.initTacticsAction(this.getGameDataV(), this.getPlayer().getDaimyoId(), tacticsAction);
        this.getGameTemp().setTacticsAction(tacticsAction);
        this.status = 14;
    }

    protected abstract void createTacticsAction();

    public void tacticsActionResponse(TacticsAction tacticsAction) {
        this.post.send(new GameMessage(36, this.id, this.connectedServer, 3, new TacticsActionResponse(tacticsAction)));
        this.status = 15;
    }

    protected void tacticsResultStart(GameMessage gameMessage) {
        TacticsResultRequest tacticsResultRequest = (TacticsResultRequest)gameMessage.getPayload();
        if (GameTacticsUtil.isResultReflect(this.gameDataV, this.player.getDaimyo(), tacticsResultRequest.getTacticsResult())) {
            this.getGameTemp().setTacticsResult(tacticsResultRequest.getTacticsResult());
            this.getGameTemp().setForceReLoad(true);
        } else {
            this.getGameTemp().setTacticsResult(null);
        }
        this.status = 16;
    }

    protected abstract void createTacticsResult();

    public void tacticsResultResponse() {
        this.post.send(new GameMessage(38, this.id, this.connectedServer, 3, null));
        this.status = 15;
    }

    protected void tacticsEndRequestReceive(GameMessage gameMessage) {
        this.status = 52;
    }

    protected abstract void createTacticsEnd();

    public void tacticsEndResponse() {
        this.post.send(new GameMessage(40, this.id, this.connectedServer, 3, null));
        this.getGameTemp().setTacticsAction(null);
        this.status = 15;
    }

    protected void intervalActionRequestReceive(GameMessage gameMessage) {
        this.status = 38;
    }

    protected abstract void createIntervalAction();

    public void intervalActionResponse() {
        this.post.send(new GameMessage(50, this.id, this.connectedServer, 3, null));
        this.status = 39;
    }

    protected void gameFinalRequestReceive(GameMessage gameMessage) {
        GameFinalRequest gameFinalRequest = (GameFinalRequest)gameMessage.getPayload();
        this.gameTemp.setConquerDaimyoId(gameFinalRequest.getDaimyoId());
        this.status = 42;
    }

    protected abstract void createGameFinal();

    public void gameFinalResponse() {
        this.post.send(new GameMessage(52, this.id, this.connectedServer, 3, new GameFinalResponse()));
        this.status = 43;
    }

    protected void receiveMessage(GameMessage gameMessage) {
        MessageNotice messageNotice = (MessageNotice)gameMessage.getPayload();
        if (messageNotice.getNotice().getType() == 2 || messageNotice.getNotice().getType() == 3) {
            this.gameTemp.getNotices().add(messageNotice.getNotice());
        }
        if (messageNotice.getNotice().getType() == 1 || messageNotice.getNotice().getType() == 3) {
            GameHistory gameHistory = GameCommandUtil.createHistory(this.gameDataV, messageNotice.getNotice());
            this.player.getBackLogs().add(gameHistory);
        } else if (messageNotice.getNotice().getType() == 4) {
            GameHistory gameHistory = GameCommandUtil.createHistory(this.gameDataV, messageNotice.getNotice());
            this.player.getHistories().add(gameHistory);
        }
        this.messageResponse(gameMessage.getPairingKey());
    }

    public void messageResponse(int n) {
        GameMessage gameMessage = new GameMessage(99, this.id, this.connectedServer, 3, new MessageResponse());
        gameMessage.setPairingKey(n);
        this.post.send(gameMessage);
    }

    public void gameEnd() {
        this.status = 30;
    }

    public List<Scenario> getScenarios() {
        return this.scenarios;
    }

    public List<SaveDataInterface> getSaveDatas() {
        return this.saveDatas;
    }

    public GameData getGameData() {
        return this.gameData;
    }

    public GameDataV getGameDataV() {
        return this.gameDataV;
    }

    public GameAIData getGameAiData() {
        return this.gameAiData;
    }

    public DaimyoV getDaimyoV() {
        return this.gameDataV == null ? null : (DaimyoV)this.gameDataV.getDaimyos().get(this.player.getDaimyoId());
    }

    public GameTemp getGameTemp() {
        return this.gameTemp;
    }
}

