/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.main;

import game.base.common.GameConfigure;
import game.base.graphic.BatchGraphicContext;
import game.base.main.GameMain;
import game.sengoku.common.GameUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.common.Scene;
import game.sengoku.data.SystemData;
import game.sengoku.game.WorldMapSpriteSet;
import game.sengoku.main.FlowControler;
import game.sengoku.main.SceneSelector;
import game.sengoku.word.Words;

public class KessenMain
extends GameMain {
    private Scene scene;
    private static KessenMain instance = null;
    private FlowControler flow = null;
    private SceneSelector sceneSelector = null;
    private SystemData systemData = null;
    private Words words = null;

    public SystemData getSystemData() {
        return this.systemData;
    }

    public Words getWords() {
        return this.words;
    }

    private KessenMain() {
    }

    public static KessenMain getInstance() {
        if (instance == null) {
            instance = new KessenMain();
        }
        return instance;
    }

    @Override
    public void initialize(GameConfigure gameConfigure) {
        super.initialize(gameConfigure);
    }

    @Override
    public void load() {
        super.load();
        this.systemData = GameUtil.loadSystemData();
        this.words = GameUtil.loadWords();
        FlowControler.nullifyInstance();
        WorldMapSpriteSet.nullifyInstance();
        this.flow = FlowControler.getInstance();
        this.sceneSelector = new SceneSelector();
    }

    @Override
    public void beginRun() {
        super.beginRun();
        MouseSymbolLayerManager.LAYER_NORMAL.setActive(true);
        this.flow.refresh();
        this.flow.createPlayer();
    }

    @Override
    public void update() {
        super.update();
        this.flow.update();
        this.sceneSelector.update();
        this.scene = this.sceneSelector.getScene();
        if (this.scene == null) {
            this.exit();
            return;
        }
        this.scene.update();
    }

    @Override
    public void draw() {
        super.draw();
        BatchGraphicContext batchGraphicContext = this.getGraphicContext();
        batchGraphicContext.clear(0);
        if (this.scene != null) {
            this.scene.draw(batchGraphicContext);
        }
        batchGraphicContext.commit();
    }

    @Override
    public void endRun() {
        super.endRun();
    }

    @Override
    public void unload() {
        super.unload();
    }

    public void restart() {
        this.endRun();
        this.unload();
        this.load();
        this.beginRun();
    }
}

