/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.tactics;

import game.base.common.Pair;
import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.DataTableHeaderItem;
import game.sengoku.common.DataTableRecord;
import game.sengoku.common.DataTableRecordItem;
import game.sengoku.common.GameFontUtil;
import game.sengoku.data.CountryV;
import game.sengoku.data.Technique;
import game.sengoku.data.UnitType;
import game.sengoku.game.GameTacticsUtil;
import game.sengoku.game.SceneTableCommon;
import game.sengoku.main.KessenMain;
import game.sengoku.window.WindowMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SceneTacticsGoOutUnitSelect
extends SceneTableCommon {
    protected static final int ITEM_NAME = 1;
    protected static final int ITEM_SPEED = 2;
    protected static final int ITEM_ATTACK = 3;
    protected static final int ITEM_DEFENSE = 4;
    protected static final int ITEM_TECHNIQUE1 = 5;
    protected static final int ITEM_TECHNIQUE2 = 6;
    protected WindowMessage info;
    protected List<UnitType> units;
    protected Map<Integer, List<Pair<String, String>>> effects;

    public SceneTacticsGoOutUnitSelect() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        this.effects = new HashMap<Integer, List<Pair<String, String>>>();
        this.info = new WindowMessage(20, 10, 100, 700, 30, 877223628, GameFontUtil.FONT16, -269422081, this.getDefaultMessage());
    }

    protected String getDefaultMessage() {
        return "\u51fa\u6483\u3059\u308b\u30e6\u30cb\u30c3\u30c8\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044";
    }

    @Override
    public void load() {
        super.load();
        this.getGameTemp().setSelectedUnitId(0);
    }

    protected int[] getUnitsItems() {
        return new int[]{1, 2, 3, 4, 5, 6};
    }

    protected void loadData() {
        int n = this.getGameTemp().getCandidateCountryId();
        CountryV countryV = (CountryV)this.getGameDataV().getCountries().get(n);
        this.units = GameTacticsUtil.getGoOutUnits(this.getGameDataV(), this.getDaimyo(), countryV, this.getGameTemp().getTacticsAction());
    }

    @Override
    protected int getTopY() {
        return 50;
    }

    @Override
    protected int getRowMax() {
        return 10;
    }

    @Override
    protected int getColumnMax() {
        return 8;
    }

    @Override
    protected void createTable() {
        this.loadData();
        this.createTableUnits();
        this.dataTable.setFixItem(1);
    }

    protected void createTableUnits() {
        List<DataTableHeaderItem> list = this.dataTable.getHeader().getItems();
        list.clear();
        List<DataTableRecord> list2 = this.dataTable.getRecords();
        list2.clear();
        Object object = this.units.iterator();
        while (object.hasNext()) {
            UnitType object2 = object.next();
            list2.add(new DataTableRecord(object2.getId()));
        }
        block9: for (Object object3 : object = (Object)this.getUnitsItems()) {
            switch (object3) {
                case 1: {
                    list.add(new DataTableHeaderItem(120, "\u540d\u524d", dataTableHeaderItem -> this.setWeights(1, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        UnitType unitType = (UnitType)this.getGameData().getUnitTypes().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(120, unitType.getName(), dataTableRecord.getId(), dataTable -> this.clickedUnit(unitType)));
                    });
                    continue block9;
                }
                case 2: {
                    list.add(new DataTableHeaderItem(75, "\u884c\u52d5\u529b", dataTableHeaderItem -> this.setWeights(2, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        UnitType unitType = (UnitType)this.getGameData().getUnitTypes().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, "" + unitType.getSpeedRate(), unitType.getSpeedRate()));
                    });
                    continue block9;
                }
                case 3: {
                    list.add(new DataTableHeaderItem(75, "\u653b\u6483\u529b", dataTableHeaderItem -> this.setWeights(3, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        UnitType unitType = (UnitType)this.getGameData().getUnitTypes().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, "" + unitType.getAttackRate(), unitType.getAttackRate()));
                    });
                    continue block9;
                }
                case 4: {
                    list.add(new DataTableHeaderItem(75, "\u9632\u5fa1\u529b", dataTableHeaderItem -> this.setWeights(4, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        UnitType unitType = (UnitType)this.getGameData().getUnitTypes().get(dataTableRecord.getId());
                        dataTableRecord.getItems().add(new DataTableRecordItem(75, "" + unitType.getDefenseRate(), unitType.getDefenseRate()));
                    });
                    continue block9;
                }
                case 5: {
                    list.add(new DataTableHeaderItem(95, "\u7279\u6280", dataTableHeaderItem -> this.setWeights(5, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        UnitType unitType = (UnitType)this.getGameData().getUnitTypes().get(dataTableRecord.getId());
                        List list = unitType.getUniqTechniqueIds();
                        String string = "-";
                        int n = 0;
                        if (0 < list.size()) {
                            n = (Integer)list.get(0);
                            Technique technique = (Technique)this.getGameData().getTechniques().get(n);
                            if (technique != null) {
                                string = technique.getName();
                            }
                        }
                        dataTableRecord.getItems().add(new DataTableRecordItem(95, string, n));
                    });
                    continue block9;
                }
                case 6: {
                    list.add(new DataTableHeaderItem(95, "\u7279\u6280", dataTableHeaderItem -> this.setWeights(6, dataTableHeaderItem.clickSort())));
                    list2.forEach(dataTableRecord -> {
                        UnitType unitType = (UnitType)this.getGameData().getUnitTypes().get(dataTableRecord.getId());
                        List list = unitType.getUniqTechniqueIds();
                        String string = "-";
                        int n = 0;
                        if (1 < list.size()) {
                            n = (Integer)list.get(1);
                            Technique technique = (Technique)this.getGameData().getTechniques().get(n);
                            if (technique != null) {
                                string = technique.getName();
                            }
                        }
                        dataTableRecord.getItems().add(new DataTableRecordItem(95, string, n));
                    });
                }
            }
        }
    }

    @Override
    protected void resetTable() {
        for (DataTableRecord dataTableRecord : this.dataTable.getRecords()) {
            dataTableRecord.setSelected(false);
            dataTableRecord.setDisabled(false);
        }
    }

    protected void clickedUnit(UnitType unitType) {
        if (unitType != null) {
            this.selectedUnit(unitType.getId());
        }
    }

    protected void selectedUnit(int n) {
        this.getGameTemp().setSelectedUnitId(n);
        this.getGameTemp().setSubSceneId(5);
    }

    @Override
    protected int getItemIndex(int n) {
        int n2 = -1;
        int[] nArray = this.getUnitsItems();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    @Override
    public void unLoad() {
    }

    @Override
    public void update() {
        super.update();
        this.info.update();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.info.draw(this.bcontext);
    }

    @Override
    protected void exit() {
        this.getGameTemp().setSubSceneId(3);
    }
}

