/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.tactics;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.common.SceneCommon;
import game.sengoku.data.CountryV;
import game.sengoku.game.GameTacticsUtil;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.WindowUnitPower;
import java.util.List;

public class SceneTacticsGoOutPowerSelect
extends SceneCommon {
    private WindowUnitPower input;
    private ButtonSprite rollback;
    private ButtonSprite commit;

    public SceneTacticsGoOutPowerSelect() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        this.input = new WindowUnitPower(50, 10, 10, 650, 400, this.getDaimyo().getId(), this.getGameDataV());
        this.commit = new ButtonSprite(410, 550, 100, 75, 25, -235801635, 1768520959, GameFontUtil.FONT20, "\u6c7a\u5b9a", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.commit.setPrimaryClicked(windowClickable -> this.forward());
        this.rollback = new ButtonSprite(310, 550, 100, 75, 25, -235801635, 1768520959, GameFontUtil.FONT20, "\u623b\u308b", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.rollback.setPrimaryClicked(windowClickable -> this.exit());
    }

    @Override
    public void load() {
        super.load();
        this.input.reset(this.getDaimyo().getId(), this.getGameTemp().getCandidateCountryId(), this.getGameTemp().getSelectedUnitId(), this.getGameTemp().getTacticsAction());
    }

    @Override
    public void update() {
        super.update();
        this.input.update();
        this.commit.update();
        this.rollback.update();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        this.input.draw(this.bcontext);
        this.commit.draw(this.bcontext);
        this.rollback.draw(this.bcontext);
    }

    @Override
    protected void exit() {
        int n = this.getGameTemp().getCandidateCountryId();
        CountryV countryV = (CountryV)this.getGameDataV().getCountries().get(n);
        this.getGameTemp().setCenterSpotId(countryV.getCapitalSpot().getId());
        this.getGameTemp().setSubSceneId(4);
    }

    protected void forward() {
        if (this.input.getPower() <= 0) {
            return;
        }
        this.getGameTemp().setSelectedPower(this.input.getPower());
        this.getGameTemp().setSelectedGun(this.input.getGun());
        this.getGameTemp().setSelectedHorse(this.input.getHorse());
        this.getGameTemp().setPlunder(this.input.isPlunder());
        this.getGameTemp().getCandidateSpotIds().clear();
        List<Integer> list = GameTacticsUtil.getGoOutSpotIds(this.getGameDataV(), this.getDaimyo().getId(), this.getGameTemp().getCandidateCountryId());
        this.getGameTemp().getCandidateSpotIds().addAll(list);
        this.getGameTemp().setSubSceneId(6);
    }
}

