/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.domestic;

import game.sengoku.common.AudioUtil;
import game.sengoku.data.BorderConflictV;
import game.sengoku.data.CountryV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.WorldDataV;
import game.sengoku.game.SceneMapCommon;
import game.sengoku.game.domestic.DomesticEvent;
import game.sengoku.game.domestic.DomesticEventResult;
import game.sengoku.game.log.LogCountryData;
import game.sengoku.game.log.LogDaimyoData;
import game.sengoku.window.PhaseStartButton;
import game.sengoku.window.WindowDomesticReport;
import java.util.HashMap;
import java.util.Map;

public class SceneDomesticStart
extends SceneMapCommon {
    WindowDomesticReport windowDomesticReport = new WindowDomesticReport(200, 20, 100, 400, 500);
    private boolean report = false;

    public SceneDomesticStart() {
        this.windowDomesticReport.setVisible(false);
    }

    @Override
    public void load() {
        super.load();
        this.report = false;
        switch (this.getPlayerClient().getStatus()) {
            case 3: {
                this.loadSeasonSe();
                this.windowDomesticReport.setVisible(false);
                this.setReceiveNotice(false);
                PhaseStartButton phaseStartButton = new PhaseStartButton("\u5185\u653f\u30d5\u30a7\u30fc\u30ba", this.getYMD());
                phaseStartButton.setFontColor(-319753729);
                phaseStartButton.setPrimaryClicked(windowClickable -> {
                    this.setMiddleWindow(null);
                    this.setReceiveNotice(true);
                });
                this.setMiddleWindow(phaseStartButton);
                break;
            }
            case 4: {
                break;
            }
            case 41: {
                this.setReceiveNotice(true);
                this.startEvent();
                break;
            }
            case 36: {
                this.setReceiveNotice(true);
            }
        }
        this.year.setVisible(false);
        this.info.setVisible(false);
        this.unitInfo.setVisible(false);
    }

    @Override
    public void update() {
        super.update();
        switch (this.getPlayerClient().getStatus()) {
            case 3: {
                if (this.report) {
                    if (this.windowDomesticReport.isVisible()) break;
                    this.setMiddleWindow(null);
                    this.getPlayerClient().domesticStartResponse();
                    break;
                }
                if (this.isMessageExists()) break;
                this.report = true;
                this.initWindowDomesticReport();
                break;
            }
            case 4: {
                if (!this.isReceiveNotice()) break;
                this.setReceiveNotice(false);
                break;
            }
            case 36: {
                if (!this.isReceiveNotice()) {
                    this.setReceiveNotice(true);
                }
                if (this.isMessageExists()) break;
                this.getPlayerClient().domesticResultResponse();
            }
        }
    }

    private void initWindowDomesticReport() {
        Map<Integer, LogCountryData> map = this.getGameTemp().getLogCountryDatas();
        LogDaimyoData logDaimyoData = this.getGameTemp().getLogDaimyoData();
        LogDaimyoData logDaimyoData2 = new LogDaimyoData(this.getDaimyo());
        HashMap<Integer, LogCountryData> hashMap = new HashMap<Integer, LogCountryData>();
        for (CountryV countryV : this.getDaimyo().getCountries()) {
            hashMap.put(countryV.getId(), new LogCountryData(countryV));
        }
        this.getGameTemp().setLogDaimyoData(logDaimyoData2);
        this.getGameTemp().setLogCountryDatas(hashMap);
        if (map != null && logDaimyoData != null) {
            this.windowDomesticReport.reset(logDaimyoData, map, logDaimyoData2, hashMap, this.getDaimyo());
            this.windowDomesticReport.setVisible(true);
            this.setMiddleWindow(this.windowDomesticReport);
        }
    }

    @Override
    protected void exit() {
    }

    private void startEvent() {
        DomesticEvent domesticEvent = this.getGameTemp().getDomesticEvent();
        if (domesticEvent == null) {
            this.getPlayerClient().domesticEventResponse(null);
            return;
        }
        this.shiftToSpot(domesticEvent.getSpotId());
        switch (domesticEvent.getEventId()) {
            case 1: {
                BorderConflictV borderConflictV2 = this.getGameDataV().getBorderConflicts().stream().filter(borderConflictV -> borderConflictV.getId() == domesticEvent.getArgs().get(0).intValue()).findFirst().orElse(null);
                if (borderConflictV2 == null) {
                    this.getPlayerClient().domesticEventResponse(null);
                    return;
                }
                DaimyoV daimyoV = null;
                CountryV countryV = null;
                CountryV countryV2 = null;
                if (borderConflictV2.getDaimyoId1() == this.getDaimyo().getId()) {
                    daimyoV = borderConflictV2.getDaimyo2();
                    countryV = borderConflictV2.getCountry1();
                    countryV2 = borderConflictV2.getCountry2();
                } else {
                    daimyoV = borderConflictV2.getDaimyo1();
                    countryV = borderConflictV2.getCountry2();
                    countryV2 = borderConflictV2.getCountry1();
                }
                CountryV countryV3 = countryV;
                CountryV countryV4 = countryV2;
                this.alert(1, () -> this.alert(1, () -> {
                    DomesticEventResult domesticEventResult = new DomesticEventResult(domesticEvent.getEventId(), this.getDaimyo().getId());
                    domesticEventResult.getArgs().addAll(domesticEvent.getArgs());
                    this.getPlayerClient().domesticEventResponse(domesticEventResult);
                }, () -> this.getPlayerClient().domesticEventResponse(null), countryV3.getName() + "\u56fd\u306e\u8fb2\u6c11", "\u300c" + countryV4.getName() + "\u56fd\u306e\u8fb2\u6c11\u306e\u632f\u308b\u821e\u3044\u306f\u76ee\u306b\u4f59\u308b\u3082\u306e\u304c\u3042\u308a\u307e\u3059\u3002\u61f2\u3089\u3057\u3081\u3066\u9802\u3051\u306a\u3044\u3067\u3057\u3087\u3046\u304b\uff1f\u300d", "\u662f\uff1a\u627f\u8a8d\u3059\u308b\u3000\u975e\uff1a\u65ad\u308b"), () -> this.getPlayerClient().domesticEventResponse(null), countryV3.getName() + "\u56fd\u306e\u8fb2\u6c11\u304c\u5606\u9858\u306b\u6765\u3066\u3044\u307e\u3059\u3002\u4f1a\u3044\u307e\u3059\u304b\uff1f");
                break;
            }
            case 2: {
                DaimyoV daimyoV;
                DaimyoV daimyoV2 = daimyoV = (DaimyoV)this.getGameDataV().getDaimyos().get(domesticEvent.getArgs().get(0));
                this.alert(1, () -> this.alert(1, () -> {
                    DomesticEventResult domesticEventResult = new DomesticEventResult(domesticEvent.getEventId(), this.getDaimyo().getId());
                    domesticEventResult.getArgs().addAll(domesticEvent.getArgs());
                    this.getPlayerClient().domesticEventResponse(domesticEventResult);
                }, () -> this.getPlayerClient().domesticEventResponse(null), "\u5207\u652f\u4e39", "\u300c" + daimyoV2.getName() + "\u306f\u9818\u5185\u306e\u5207\u652f\u4e39\u306b\u5bfe\u3057\u3066\u53b3\u3057\u3044\u5f3e\u5727\u3092\u884c\u3063\u3066\u3044\u307e\u3059\u3002\u6551\u6e08\u306b\u6765\u3066\u9802\u3051\u306a\u3044\u3067\u3057\u3087\u3046\u304b\uff1f\u300d", "\u662f\uff1a\u627f\u8a8d\u3059\u308b\u3000\u975e\uff1a\u65ad\u308b"), () -> this.getPlayerClient().domesticEventResponse(null), daimyoV2.getName() + "\u9818\u5185\u306e\u5207\u652f\u4e39\u304c\u5606\u9858\u306b\u6765\u3066\u3044\u307e\u3059\u3002\u4f1a\u3044\u307e\u3059\u304b\uff1f");
                break;
            }
            case 3: {
                DaimyoV daimyoV;
                DaimyoV daimyoV3 = daimyoV = (DaimyoV)this.getGameDataV().getDaimyos().get(domesticEvent.getArgs().get(0));
                this.alert(1, () -> this.alert(1, () -> {
                    DomesticEventResult domesticEventResult = new DomesticEventResult(domesticEvent.getEventId(), this.getDaimyo().getId());
                    domesticEventResult.getArgs().addAll(domesticEvent.getArgs());
                    this.getPlayerClient().domesticEventResponse(domesticEventResult);
                }, () -> this.getPlayerClient().domesticEventResponse(null), "\u8fb2\u6c11", "\u300c" + daimyoV3.getName() + "\u9818\u5185\u306e\u8fb2\u6c11\u306f" + daimyoV3.getKnight().getFullName() + "\u306e\u60aa\u653f\u306b\u82e6\u3057\u3093\u3067\u3044\u307e\u3059\u3002\u6551\u6e08\u306b\u6765\u3066\u9802\u3051\u306a\u3044\u3067\u3057\u3087\u3046\u304b\uff1f\u300d", "\u662f\uff1a\u627f\u8a8d\u3059\u308b\u3000\u975e\uff1a\u65ad\u308b"), () -> this.getPlayerClient().domesticEventResponse(null), daimyoV3.getName() + "\u9818\u5185\u306e\u8fb2\u6c11\u304c\u5606\u9858\u306b\u6765\u3066\u3044\u307e\u3059\u3002\u4f1a\u3044\u307e\u3059\u304b\uff1f");
                break;
            }
            case 4: {
                this.alert3("\u5968\u52b1\u3059\u308b", "\u5f3e\u5727\u3059\u308b", "\u4eca\u306f\u307e\u3060\u614b\u5ea6\u3092\u6c7a\u3081\u308b\u3068\u304d\u3067\u306f\u306a\u3044", () -> {
                    DomesticEventResult domesticEventResult = new DomesticEventResult(domesticEvent.getEventId(), this.getDaimyo().getId());
                    domesticEventResult.getArgs().add(1);
                    this.getPlayerClient().domesticEventResponse(domesticEventResult);
                    this.setMiddleWindow(null);
                }, () -> {
                    DomesticEventResult domesticEventResult = new DomesticEventResult(domesticEvent.getEventId(), this.getDaimyo().getId());
                    domesticEventResult.getArgs().add(-1);
                    this.getPlayerClient().domesticEventResponse(domesticEventResult);
                    this.setMiddleWindow(null);
                }, () -> {
                    this.getPlayerClient().domesticEventResponse(null);
                    this.setMiddleWindow(null);
                }, "\u6700\u8fd1\u3001\u57fa\u7763\u6559\u3068\u3044\u3046\u5357\u86ee\u306e\u5b97\u6559\u3092\u4fe1\u3058\u308b\u8005\u9054\u304c\u3044\u308b\u3088\u3046\u3067\u3059\u3002\u3053\u308c\u3089\u306b\u5bfe\u3059\u308b\u5f53\u5bb6\u306e\u614b\u5ea6\u3092\u6c7a\u5b9a\u3057\u3066\u304a\u3044\u305f\u307b\u3046\u304c\u826f\u3044\u306e\u3067\u306f\u306a\u3044\u3067\u3057\u3087\u3046\u304b\uff1f");
                break;
            }
            case 5: {
                this.alert(1, () -> {
                    DomesticEventResult domesticEventResult = new DomesticEventResult(domesticEvent.getEventId(), this.getDaimyo().getId());
                    this.getPlayerClient().domesticEventResponse(domesticEventResult);
                }, () -> this.getPlayerClient().domesticEventResponse(null), "\u5f53\u5bb6\u306e\u9818\u5185\u3067\u5207\u652f\u4e39\u304c\u5897\u3048\u3066\u3044\u308b\u3088\u3046\u3067\u3059\u3002", this.getDaimyo().getKnight().getFullName() + "\u69d8\u3082\u6d17\u793c\u3092\u53d7\u3051\u3066\u307f\u3066\u306f\u3044\u304b\u304c\u3067\u3057\u3087\u3046\u304b\uff1f");
                break;
            }
            case 6: {
                this.alert(1, () -> {
                    DomesticEventResult domesticEventResult = new DomesticEventResult(domesticEvent.getEventId(), this.getDaimyo().getId());
                    domesticEventResult.getArgs().addAll(domesticEvent.getArgs());
                    this.getPlayerClient().domesticEventResponse(domesticEventResult);
                }, () -> this.getPlayerClient().domesticEventResponse(null), "\u5f53\u5bb6\u306b\u5f81\u5937\u5927\u5c06\u8ecd\u3078\u306e\u5c31\u4efb\u8981\u8acb\u304c\u6765\u3066\u3044\u307e\u3059\u3002", "\u662f\uff1a\u627f\u8a8d\u3059\u308b\u3000\u975e\uff1a\u65ad\u308b");
                break;
            }
            default: {
                this.getPlayerClient().domesticEventResponse(null);
            }
        }
    }

    protected void loadSeasonSe() {
        WorldDataV worldDataV = this.getWorld();
        if (worldDataV.getMonth() == 3 && !worldDataV.isIntercalary()) {
            AudioUtil.sePlay(26);
        } else if (worldDataV.getMonth() == 6 && !worldDataV.isIntercalary()) {
            AudioUtil.sePlay(27);
        } else if (worldDataV.getMonth() == 7 && !worldDataV.isIntercalary()) {
            AudioUtil.sePlay(28);
        } else if (worldDataV.getMonth() == 10 && !worldDataV.isIntercalary()) {
            AudioUtil.sePlay(29);
        } else if (worldDataV.getMonth() == 12 && !worldDataV.isIntercalary()) {
            AudioUtil.sePlay(30);
        }
    }
}

