/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.domestic;

import game.base.common.Pair;
import game.base.font.Font;
import game.base.font.FontPool;
import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.AIDomesticUtil;
import game.sengoku.common.GameCommandCreator;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.GameUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.data.KnightV;
import game.sengoku.game.GameCommandUtil;
import game.sengoku.game.SceneMapCommon;
import game.sengoku.game.domestic.DomesticAction;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.ImageButtonSprite;
import game.sengoku.window.WindowDomestic;
import game.sengoku.window.WindowMessage;
import java.util.ArrayList;
import java.util.List;

public class SceneDomesticMenu
extends SceneMapCommon {
    public static final int MENU_BUILD = 1;
    public static final int MENU_HR = 4;
    public static final int MENU_INFO = 5;
    public static final int MENU_CHARGE = 7;
    private static final int MENU_X = 40;
    private static final int MENU_Y = 10;
    private static final int MENU_X_INTERVAL = 90;
    private static final int SUBMENU_X_INTERVAL = 70;
    private ButtonSprite menuBuild;
    private ButtonSprite subMenuBuild;
    private ButtonSprite subMenuTechnology;
    private ButtonSprite subMenuGiant;
    private ButtonSprite subMenuPropagate;
    private ButtonSprite subMenuAgitate;
    private ButtonSprite menuHR;
    private ButtonSprite subMenuEmploy;
    private ButtonSprite subMenuTreasure;
    private ButtonSprite subMenuAbsort;
    private ButtonSprite subMenuRelease;
    private ButtonSprite subMenuRetire;
    private ButtonSprite menuInfo;
    private ButtonSprite subMenuMap;
    private ButtonSprite subMenuDetail;
    private ButtonSprite subMenuRanking;
    private ButtonSprite subMenuHistory;
    private ButtonSprite subMenuWords;
    private ButtonSprite menuSoubuji;
    private ButtonSprite menuCharge;
    private ButtonSprite subMenuChargeSetting;
    private ButtonSprite subMenuChargeExecute;
    private ButtonSprite commit;
    private int selectMenu = 0;
    private WindowDomestic windowDomestic;
    private boolean soubuji;
    protected WindowMessage explain;
    private ImageButtonSprite talk;
    private List<Pair<KnightV, String>> talkMessages;

    public SceneDomesticMenu() {
        KessenMain kessenMain = KessenMain.getInstance();
        FontPool fontPool = kessenMain.getFontPool();
        Font font = GameFontUtil.FONT22;
        Font font2 = GameFontUtil.FONT20;
        Font font3 = GameFontUtil.FONT16;
        int n = 0;
        this.menuBuild = new ButtonSprite(40 + 90 * n, 10, 300, 85, 30, -235801635, 1768520959, font2, "\u5185\u653f", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.menuBuild.setPrimaryClicked(windowClickable -> this.selectMenu(1));
        this.menuBuild.setMouseEnter(windowClickable -> this.resetMessage("\u65bd\u8a2d\u306e\u5efa\u8a2d\u3084\u7269\u8cc7\u306e\u8cfc\u5165\u3092\u884c\u3044\u307e\u3059\u3002"));
        this.menuBuild.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuBuild = new ButtonSprite(40, 60, 300, 65, 25, -235801635, 1768520959, font3, "\u5efa\u8a2d", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.subMenuBuild.setPrimaryClicked(windowClickable -> {
            this.getGameTemp().setSubSceneId(1);
            this.getGameTemp().getCandidateCountryIds().clear();
            this.getPlayerClient().getDaimyoV().getCountries().forEach(countryV -> this.getGameTemp().getCandidateCountryIds().add(countryV.getId()));
        });
        this.subMenuBuild.setMouseEnter(windowClickable -> this.resetMessage("\u65bd\u8a2d\u306e\u5efa\u8a2d\u3092\u884c\u3044\u307e\u3059\u3002"));
        this.subMenuBuild.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuBuild.setVisible(false);
        this.subMenuTechnology = new ButtonSprite(110, 60, 300, 65, 25, -235801635, 1768520959, font3, "\u6280\u8853", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.subMenuTechnology.setPrimaryClicked(windowClickable -> this.getGameTemp().setSubSceneId(16));
        this.subMenuTechnology.setMouseEnter(windowClickable -> this.resetMessage("\u6280\u8853\u958b\u767a\u306e\u9032\u6357\u3092\u78ba\u8a8d\u3057\u307e\u3059\u3002"));
        this.subMenuTechnology.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuTechnology.setVisible(false);
        this.subMenuGiant = new ButtonSprite(180, 60, 300, 65, 25, -235801635, 1768520959, font3, "\u6587\u5316\u4eba", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.subMenuGiant.setPrimaryClicked(windowClickable -> this.getGameTemp().setSubSceneId(17));
        this.subMenuGiant.setMouseEnter(windowClickable -> this.resetMessage("\u6587\u5316\u4eba\u306e\u7814\u7a76\u72b6\u6cc1\u3092\u78ba\u8a8d\u3057\u307e\u3059\u3002"));
        this.subMenuGiant.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuGiant.setVisible(false);
        this.subMenuPropagate = new ButtonSprite(250, 60, 300, 65, 25, -235801635, 1768520959, font3, "\u5e03\u6559", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.subMenuPropagate.setPrimaryClicked(windowClickable -> this.getGameTemp().setSubSceneId(9));
        this.subMenuPropagate.setMouseEnter(windowClickable -> this.resetMessage("\u5e03\u6559\u6d3b\u52d5\u3092\u884c\u3063\u3066\u4fe1\u8005\u3092\u5897\u3084\u3057\u307e\u3059\u3002"));
        this.subMenuPropagate.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuPropagate.setVisible(false);
        this.subMenuAgitate = new ButtonSprite(320, 60, 300, 65, 25, -235801635, 1768520959, font3, "\u6a84\u6587", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.subMenuAgitate.setPrimaryClicked(windowClickable -> this.getGameTemp().setSubSceneId(10));
        this.subMenuAgitate.setMouseEnter(windowClickable -> this.resetMessage("\u4fe1\u8005\u306b\u6a84\u6587\u3092\u9001\u3063\u3066\u4e00\u63c6\u3092\u4fc3\u3057\u307e\u3059\u3002"));
        this.subMenuAgitate.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuAgitate.setVisible(false);
        this.menuHR = new ButtonSprite(40 + 90 * ++n, 10, 300, 85, 30, -235801635, 1768520959, font2, "\u4eba\u4e8b", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.menuHR.setPrimaryClicked(windowClickable -> this.selectMenu(4));
        this.menuHR.setMouseEnter(windowClickable -> this.resetMessage("\u6b66\u5c06\u306e\u96c7\u7528\u3084\u5f79\u8077\u3078\u306e\u4efb\u547d\u3092\u884c\u3044\u307e\u3059\u3002"));
        this.menuHR.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuEmploy = new ButtonSprite(40, 60, 300, 65, 25, -235801635, 1768520959, font3, "\u96c7\u7528", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.subMenuEmploy.setPrimaryClicked(windowClickable -> this.getGameTemp().setSubSceneId(5));
        this.subMenuEmploy.setMouseEnter(windowClickable -> this.resetMessage("\u6d6a\u4eba\u3084\u6587\u5316\u4eba\u306e\u96c7\u7528\u3092\u884c\u3044\u307e\u3059\u3002"));
        this.subMenuEmploy.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuAbsort = new ButtonSprite(180, 60, 300, 65, 25, -235801635, 1768520959, font3, "\u53d6\u8fbc", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.subMenuAbsort.setPrimaryClicked(windowClickable -> this.getGameTemp().setSubSceneId(12));
        this.subMenuAbsort.setMouseEnter(windowClickable -> this.resetMessage("\u56fd\u4eba\u3092\u5bb6\u81e3\u306b\u53d6\u308a\u7acb\u3066\u307e\u3059\u3002"));
        this.subMenuAbsort.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuAbsort.setVisible(false);
        this.subMenuRelease = new ButtonSprite(250, 60, 300, 65, 25, -235801635, 1768520959, font3, "\u89e3\u96c7", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.subMenuRelease.setPrimaryClicked(windowClickable -> this.getGameTemp().setSubSceneId(11));
        this.subMenuRelease.setMouseEnter(windowClickable -> this.resetMessage("\u5bb6\u81e3\u3084\u6587\u5316\u4eba\u3092\u89e3\u96c7\u3057\u307e\u3059\u3002"));
        this.subMenuRelease.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuRelease.setVisible(false);
        this.subMenuRetire = new ButtonSprite(320, 60, 300, 65, 25, -235801635, 1768520959, font3, "\u5f15\u9000", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.subMenuRetire.setPrimaryClicked(windowClickable -> this.getGameTemp().setSubSceneId(19));
        this.subMenuRetire.setMouseEnter(windowClickable -> this.resetMessage("\u5bb6\u81e3\u306b\u5bb6\u7763\u3092\u8b72\u3063\u3066\u5f15\u9000\u3057\u307e\u3059\u3002"));
        this.subMenuRetire.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuRetire.setVisible(false);
        this.subMenuTreasure = new ButtonSprite(110, 60, 300, 65, 25, -235801635, 1768520959, font3, "\u5bb6\u5b9d", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.subMenuTreasure.setPrimaryClicked(windowClickable -> this.getGameTemp().setSubSceneId(22));
        this.subMenuTreasure.setMouseEnter(windowClickable -> this.resetMessage("\u5bb6\u81e3\u306b\u5bb6\u5b9d\u3092\u4e0e\u3048\u307e\u3059\u3002"));
        this.subMenuTreasure.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuTreasure.setVisible(false);
        this.menuInfo = new ButtonSprite(40 + 90 * ++n, 10, 300, 85, 30, -235801635, 1768520959, font2, "\u60c5\u5831", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.menuInfo.setPrimaryClicked(windowClickable -> this.selectMenu(5));
        this.menuInfo.setMouseEnter(windowClickable -> this.resetMessage("\u5404\u7a2e\u60c5\u5831\u3092\u53c2\u7167\u3057\u307e\u3059\u3002"));
        this.menuInfo.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuMap = new ButtonSprite(40, 60, 300, 65, 25, -235801635, 1768520959, font3, "\u5730\u56f3", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.subMenuMap.setPrimaryClicked(windowClickable -> this.getGameTemp().setSubSceneId(13));
        this.subMenuMap.setMouseEnter(windowClickable -> this.resetMessage("\u5730\u56f3\u4e0a\u306e\u60c5\u5831\u3092\u78ba\u8a8d\u3057\u307e\u3059\u3002"));
        this.subMenuMap.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuMap.setVisible(false);
        this.subMenuDetail = new ButtonSprite(110, 60, 300, 65, 25, -235801635, 1768520959, font3, "\u8a73\u7d30", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.subMenuDetail.setPrimaryClicked(windowClickable -> this.getGameTemp().setSubSceneId(14));
        this.subMenuDetail.setMouseEnter(windowClickable -> this.resetMessage("\u5927\u540d\u3084\u56fd\u306e\u60c5\u5831\u3092\u78ba\u8a8d\u3057\u307e\u3059\u3002"));
        this.subMenuDetail.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuDetail.setVisible(false);
        this.subMenuRanking = new ButtonSprite(180, 60, 300, 65, 25, -235801635, 1768520959, font3, "\u5927\u540d", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.subMenuRanking.setPrimaryClicked(windowClickable -> this.getGameTemp().setSubSceneId(15));
        this.subMenuRanking.setMouseEnter(windowClickable -> this.resetMessage("\u5927\u540d\u306e\u60c5\u5831\u3092\u78ba\u8a8d\u3057\u307e\u3059\u3002"));
        this.subMenuRanking.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuRanking.setVisible(false);
        this.subMenuHistory = new ButtonSprite(250, 60, 300, 65, 25, -235801635, 1768520959, font3, "\u5c65\u6b74", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.subMenuHistory.setPrimaryClicked(windowClickable -> this.getGameTemp().setSubSceneId(18));
        this.subMenuHistory.setMouseEnter(windowClickable -> this.resetMessage("\u4e8b\u8c61\u5c65\u6b74\u3092\u78ba\u8a8d\u3057\u307e\u3059\u3002"));
        this.subMenuHistory.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuHistory.setVisible(false);
        this.subMenuWords = new ButtonSprite(320, 60, 300, 65, 25, -235801635, 1768520959, font3, "\u7528\u8a9e\u96c6", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.subMenuWords.setPrimaryClicked(windowClickable -> this.getGameTemp().setSubSceneId(27));
        this.subMenuWords.setMouseEnter(windowClickable -> this.resetMessage("\u30b2\u30fc\u30e0\u5185\u3067\u4f7f\u7528\u3059\u308b\u7528\u8a9e\u96c6\u3067\u3059\u3002"));
        this.subMenuWords.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuWords.setVisible(false);
        this.menuCharge = new ButtonSprite(40 + 90 * ++n, 10, 300, 85, 30, -235801635, 1768520959, font2, "\u59d4\u4efb", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.menuCharge.setPrimaryClicked(windowClickable -> this.selectMenu(7));
        this.menuCharge.setMouseEnter(windowClickable -> this.resetMessage("\u5185\u653f\u3092AI\u306b\u59d4\u4efb\u3057\u307e\u3059\u3002"));
        this.menuCharge.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuChargeSetting = new ButtonSprite(40, 60, 300, 65, 25, -235801635, 1768520959, font3, "\u8a2d\u5b9a", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.subMenuChargeSetting.setPrimaryClicked(windowClickable -> this.getGameTemp().setSubSceneId(26));
        this.subMenuChargeSetting.setMouseEnter(windowClickable -> this.resetMessage("\u59d4\u4efb\u3059\u308b\u5185\u5bb9\u306e\u8a2d\u5b9a\u3092\u884c\u3044\u307e\u3059\u3002"));
        this.subMenuChargeSetting.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuChargeSetting.setVisible(false);
        this.subMenuChargeExecute = new ButtonSprite(110, 60, 300, 65, 25, -235801635, 1768520959, font3, "\u5b9f\u884c", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.subMenuChargeExecute.setPrimaryClicked(windowClickable -> this.executeDomesticAI());
        this.subMenuChargeExecute.setMouseEnter(windowClickable -> this.resetMessage("\u8a2d\u5b9a\u3057\u305f\u5185\u5bb9\u3067\u5185\u653f\u3092\u5b9f\u884c\u3057\u307e\u3059\u3002"));
        this.subMenuChargeExecute.setMouseExit(windowClickable -> this.resetMessage(null));
        this.subMenuChargeExecute.setVisible(false);
        this.menuSoubuji = new ButtonSprite(40 + 90 * ++n, 10, 300, 85, 30, -235801635, 1768520959, font2, "\u60e3\u7121\u4e8b\u4ee4", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.menuSoubuji.setPrimaryClicked(windowClickable -> {
            this.soubuji = !this.soubuji;
        });
        this.menuSoubuji.setMouseEnter(windowClickable -> this.resetMessage("\u60e3\u7121\u4e8b\u4ee4\u3092\u767a\u3057\u3066\u30b2\u30fc\u30e0\u3092\u7d42\u4e86\u3057\u307e\u3059\u3002"));
        this.menuSoubuji.setMouseExit(windowClickable -> this.resetMessage(null));
        this.commit = new ButtonSprite(40 + 90 * ++n, 10, 300, 95, 40, -235801635, 1768520959, font, "\u5b8c\u4e86", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.commit.setPrimaryClicked(windowClickable -> {
            DomesticAction domesticAction = new DomesticAction(this.getPlayer().getDaimyoId());
            domesticAction.getCommandList().addAll(this.getPlayer().getCommands());
            if (this.isSoubuji()) {
                domesticAction.getCommandList().add(GameCommandCreator.commandSoubuji(0, this.getDaimyo().getId()));
            }
            this.getPlayerClient().domesticActionResponse(domesticAction);
        });
        this.commit.setMouseEnter(windowClickable -> this.resetMessage("\u4eca\u6708\u306e\u5185\u653f\u30b3\u30de\u30f3\u30c9\u3092\u5b8c\u4e86\u3057\u307e\u3059\u3002"));
        this.commit.setMouseExit(windowClickable -> this.resetMessage(null));
        this.commit.setSoundId(4);
        this.windowDomestic = new WindowDomestic(590, 100, 1000, 200, 450, this.getGameDataV());
        this.explain = new WindowMessage(20, 550, 100, 560, 30, 877223628, GameFontUtil.FONT16, -269422081, "");
        this.resetMessage(null);
        this.enableDrag = false;
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        Texture texture = (Texture)graphicPool.getResource("talk01.png");
        Texture texture2 = (Texture)graphicPool.getResource("talk02.png");
        this.talk = new ImageButtonSprite(5, 125, 2000, 25, 25, texture, texture2);
        this.talk.setPrimaryClicked(windowClickable -> this.talk());
        this.talkMessages = new ArrayList<Pair<KnightV, String>>();
    }

    @Override
    public void load() {
        super.load();
        this.shiftCapital();
        this.getGameTemp().setBuildSelectedCountryId(0);
        this.getGameTemp().setAssignSelectedCountryId(0);
        this.getGameTemp().setReturnSubSceneId(0);
        this.createConflicts();
        this.createUnits();
        this.selectMenu(0);
        this.soubuji = false;
        this.optionUse = true;
        this.menuSoubuji.setVisible(false);
        if (GameCommandUtil.canSoubuji(this.getGameDataV(), this.getDaimyo().getId())) {
            this.menuSoubuji.setVisible(true);
        }
        this.info.setVisible(false);
        this.unitInfo.setVisible(false);
        this.windowDomestic.needUpdate();
        GameCommandUtil.createDomesticMessage(this.getGameDataV(), this.getDaimyo(), this.getPlayer(), this.talkMessages);
        this.setReceiveNotice(true);
    }

    private void selectMenu(int n) {
        this.selectMenu = n;
        this.subMenuBuild.setVisible(false);
        this.subMenuTechnology.setVisible(false);
        this.subMenuGiant.setVisible(false);
        this.subMenuPropagate.setVisible(false);
        this.subMenuAgitate.setVisible(false);
        this.subMenuAbsort.setVisible(false);
        this.subMenuRelease.setVisible(false);
        this.subMenuRetire.setVisible(false);
        this.subMenuEmploy.setVisible(false);
        this.subMenuTreasure.setVisible(false);
        this.subMenuMap.setVisible(false);
        this.subMenuDetail.setVisible(false);
        this.subMenuRanking.setVisible(false);
        this.subMenuHistory.setVisible(false);
        this.subMenuWords.setVisible(false);
        this.subMenuChargeSetting.setVisible(false);
        this.subMenuChargeExecute.setVisible(false);
        switch (this.selectMenu) {
            case 1: {
                this.subMenuBuild.setVisible(true);
                this.subMenuTechnology.setVisible(true);
                this.subMenuGiant.setVisible(true);
                this.subMenuPropagate.setVisible(this.getDaimyo().isCanHongan());
                this.subMenuAgitate.setVisible(this.getDaimyo().isCanHongan());
                break;
            }
            case 4: {
                this.subMenuAbsort.setVisible(true);
                this.subMenuRelease.setVisible(true);
                this.subMenuEmploy.setVisible(true);
                this.subMenuTreasure.setVisible(true);
                this.subMenuRetire.setVisible(true);
                break;
            }
            case 5: {
                this.subMenuMap.setVisible(true);
                this.subMenuDetail.setVisible(true);
                this.subMenuRanking.setVisible(true);
                this.subMenuHistory.setVisible(true);
                this.subMenuWords.setVisible(true);
                break;
            }
            case 7: {
                this.subMenuChargeSetting.setVisible(true);
                this.subMenuChargeExecute.setVisible(true);
                break;
            }
        }
    }

    @Override
    public void update() {
        super.update();
        this.menuBuild.update();
        this.subMenuEmploy.update();
        this.subMenuTreasure.update();
        this.menuHR.update();
        this.menuInfo.update();
        this.subMenuBuild.update();
        this.subMenuTechnology.update();
        this.subMenuGiant.update();
        this.subMenuPropagate.update();
        this.subMenuAgitate.update();
        this.subMenuAbsort.update();
        this.subMenuRelease.update();
        this.subMenuRetire.update();
        this.subMenuMap.update();
        this.subMenuDetail.update();
        this.subMenuRanking.update();
        this.subMenuHistory.update();
        this.subMenuWords.update();
        this.menuCharge.update();
        this.subMenuChargeSetting.update();
        this.subMenuChargeExecute.update();
        if (this.soubuji) {
            this.menuSoubuji.setNormalColor(1097458124);
        } else {
            this.menuSoubuji.setNormalColor(-235801635);
        }
        this.menuSoubuji.update();
        this.commit.update();
        this.explain.update();
        this.talk.update();
        this.windowDomestic.setUsableMoney(this.getUsableMoney());
        this.windowDomestic.setDaimyo(this.getDaimyo());
        this.windowDomestic.update();
        this.unitInfo.setVisible(false);
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.menuBuild.draw(this.bcontext);
        this.subMenuEmploy.draw(this.bcontext);
        this.subMenuTreasure.draw(this.bcontext);
        this.menuHR.draw(this.bcontext);
        this.menuInfo.draw(this.bcontext);
        this.subMenuBuild.draw(this.bcontext);
        this.subMenuTechnology.draw(this.bcontext);
        this.subMenuGiant.draw(this.bcontext);
        this.subMenuPropagate.draw(this.bcontext);
        this.subMenuAgitate.draw(this.bcontext);
        this.subMenuAbsort.draw(this.bcontext);
        this.subMenuRelease.draw(this.bcontext);
        this.subMenuRetire.draw(this.bcontext);
        this.subMenuMap.draw(this.bcontext);
        this.subMenuDetail.draw(this.bcontext);
        this.subMenuRanking.draw(this.bcontext);
        this.subMenuHistory.draw(this.bcontext);
        this.subMenuWords.draw(this.bcontext);
        this.menuSoubuji.draw(this.bcontext);
        this.menuCharge.draw(this.bcontext);
        this.subMenuChargeSetting.draw(this.bcontext);
        this.subMenuChargeExecute.draw(this.bcontext);
        this.commit.draw(this.bcontext);
        this.explain.draw(this.bcontext);
        this.talk.draw(this.bcontext);
        this.windowDomestic.draw(this.bcontext);
    }

    @Override
    protected void exit() {
        this.selectMenu(0);
    }

    private boolean isSoubuji() {
        return this.soubuji;
    }

    protected void talk() {
        if (!this.talkMessages.isEmpty()) {
            Pair<KnightV, String> pair = GameUtil.getRandom(this.talkMessages);
            this.alert(pair.getFirst(), pair.getSecond());
        }
    }

    protected void executeDomesticAI() {
        AIDomesticUtil.createDomesticAction(this.getGameDataV(), this.getDaimyo(), this.getPlayer(), this.getGameTemp(), this.getUsableMoney());
        this.updateSumCost();
        this.alert("\u5185\u653f\u884c\u52d5\u306e\u8a2d\u5b9a\u3092\u5b9f\u884c\u3057\u307e\u3057\u305f\u3002");
        this.selectMenu(0);
    }

    private void resetMessage(String string) {
        if (string == null) {
            string = "\u4eca\u6708\u306e\u5185\u653f\u30b3\u30de\u30f3\u30c9\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044\u3002";
        }
        this.explain.setMessages(string);
    }
}

