/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.domestic;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.GameCommandCreator;
import game.sengoku.common.SceneCommon;
import game.sengoku.data.CommandV;
import game.sengoku.data.CountryV;
import game.sengoku.data.GameData;
import game.sengoku.main.KessenMain;
import game.sengoku.window.CountrySelectButton;
import game.sengoku.window.WindowPropagateInfo;
import java.util.ArrayList;
import java.util.List;

public class SceneDomesticAgitate
extends SceneCommon {
    private Texture minimap;
    private List<CountrySelectButton> countryInfoButtons;
    private WindowPropagateInfo countryInfoWindow;

    public SceneDomesticAgitate() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        GameData gameData = this.getGameData();
        this.minimap = (Texture)graphicPool.getResource(gameData.getMap().getImageMini());
        this.countryInfoButtons = new ArrayList<CountrySelectButton>();
        this.countryInfoWindow = new WindowPropagateInfo(50, 450, 10, 700, 140, 0, "\u6a84\u6587\u3092\u9001\u308b\u56fd\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044\u3002", this.getGameDataV());
    }

    @Override
    public void load() {
        super.load();
        this.countryInfoWindow.setDaimyoId(-1);
        this.setReceiveNotice(true);
        this.setMiddleWindow(null);
        this.createCountryInfo();
        this.updateVisible();
    }

    private void updateVisible() {
        this.countryInfoButtons.forEach(countrySelectButton -> countrySelectButton.setVisible(true));
        this.countryInfoWindow.setVisible(true);
        this.countryInfoWindow.setDaimyoId(this.getPlayer().getDaimyoId());
    }

    private int getColor(CountryV countryV) {
        return countryV.getDaimyo().getColor();
    }

    private void createCountryInfo() {
        this.countryInfoButtons.clear();
        for (CountryV countryV : this.getGameDataV().getCountries().values()) {
            int n = this.getColor(countryV);
            CountrySelectButton countrySelectButton = new CountrySelectButton(countryV.getCountry(), this.getGameDataV(), n, n);
            countrySelectButton.setMouseEnter(windowClickable -> {
                CountryV countryV = ((CountrySelectButton)windowClickable).getCountryV();
                this.countryInfoWindow.setTargetCountryId(countryV.getId());
            });
            countrySelectButton.setMouseExit(windowClickable -> this.countryInfoWindow.setTargetCountryId(-1));
            countrySelectButton.setPrimaryClicked(windowClickable -> {
                CountryV countryV = ((CountrySelectButton)windowClickable).getCountryV();
                if (countryV != null) {
                    this.countryClicked(countryV);
                }
            });
            this.countryInfoButtons.add(countrySelectButton);
        }
    }

    private void countryClicked(CountryV countryV) {
        boolean bl = this.getPlayer().getCommands().stream().filter(commandV -> commandV.getKind() == 19).anyMatch(commandV -> ((Integer)commandV.getArgs().get(0)).intValue() == countryV.getId());
        if (bl) {
            this.alert(1, () -> this.cancelPropagate(countryV), null, countryV.getName() + "\u56fd\u306b\u6a84\u6587\u3092\u9001\u308b\u306e\u3092\u4e2d\u6b62\u3057\u307e\u3059\u304b\uff1f");
            return;
        }
        if (100 <= countryV.getMissionary()) {
            this.alert(1, () -> {
                CommandV commandV = GameCommandCreator.commandAgitate(0, countryV.getId());
                this.getPlayer().getCommands().add(commandV);
            }, null, countryV.getName() + "\u56fd\u306b\u6a84\u6587\u3092\u9001\u308a\u307e\u3059\u304b\uff1f");
        } else {
            this.alert("\u3053\u306e\u56fd\u306b\u306f\u5341\u5206\u306a\u6570\u306e\u4fe1\u8005\u304c\u5c45\u307e\u305b\u3093\u3002");
        }
    }

    private void cancelPropagate(CountryV countryV) {
        this.getPlayer().getCommands().removeIf(commandV -> commandV.getKind() == 19 && ((Integer)commandV.getArgs().get(0)).intValue() == countryV.getId());
    }

    @Override
    protected void exit() {
        this.getGameTemp().setSubSceneId(0);
    }

    @Override
    public void unLoad() {
        super.unLoad();
        this.countryInfoButtons.clear();
    }

    @Override
    public void update() {
        super.update();
        this.countryInfoButtons.forEach(countrySelectButton -> countrySelectButton.update());
        this.countryInfoWindow.update();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        this.bcontext.drawImage(this.minimap, 150, 10, 10);
        this.countryInfoButtons.forEach(countrySelectButton -> countrySelectButton.draw(this.bcontext));
        this.countryInfoWindow.draw(this.bcontext);
    }
}

