/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.domestic;

import game.sengoku.common.GameCommandCreator;
import game.sengoku.data.CommandV;
import game.sengoku.data.KnightV;
import game.sengoku.data.PlayerV;
import game.sengoku.game.GameCommandUtil;
import game.sengoku.game.domestic.SceneEmployBase;
import java.util.ArrayList;

public class SceneAbsorbSelect
extends SceneEmployBase {
    public SceneAbsorbSelect() {
        this.commandKindKnight = 10;
        this.commandKindGiant = 10;
    }

    @Override
    protected String getDefaultMessage() {
        return "\u53d6\u308a\u8fbc\u3080\u6b66\u5c06\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044";
    }

    @Override
    protected String getCancelMessage() {
        return "\u306e\u53d6\u8fbc\u3092\u30ad\u30e3\u30f3\u30bb\u30eb\u3057\u307e\u3059\u304b\uff1f";
    }

    @Override
    protected String getDecideMessage() {
        return "\u3092\u53d6\u308a\u8fbc\u307f\u307e\u3059\u304b\uff1f";
    }

    @Override
    protected void loadData() {
        this.knights = GameCommandUtil.getKnightAbsorb(this.getGameDataV(), this.getPlayer().getDaimyoId());
        this.giants = new ArrayList();
    }

    @Override
    protected void selectedKnight(int n) {
        PlayerV playerV = this.getPlayer();
        CommandV commandV = GameCommandCreator.commandAbsorp(this.costOfKnight(n), n);
        playerV.getCommands().add(commandV);
        this.forceReLoad();
    }

    @Override
    protected void selectedGiant(int n) {
    }

    @Override
    public void update() {
        super.update();
        this.kindKnight.setVisible(false);
        this.kindGiant.setVisible(false);
    }

    @Override
    protected int costOfKnight(int n) {
        KnightV knightV = (KnightV)this.getGameDataV().getKnights().get(n);
        return knightV.getHeadPay();
    }

    @Override
    protected int costOfGiant(int n) {
        return 0;
    }

    @Override
    protected int[] getKnightsItems() {
        return new int[]{1, 13, 12, 11, 6, 7, 8};
    }

    @Override
    protected int[] getGiantsItems() {
        return new int[0];
    }
}

