/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.domestic;

import game.sengoku.data.GameDataV;
import game.sengoku.data.PlayerV;
import game.sengoku.data.TreasureV;
import game.sengoku.game.GameCommandUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DomesticTreasureV {
    private PlayerV player;
    private GameDataV datav;
    private Map<Integer, Integer> ownerIds = null;
    private Map<Integer, TreasureV> treasures = null;

    public DomesticTreasureV(GameDataV gameDataV, PlayerV playerV) {
        this.player = playerV;
        this.datav = gameDataV;
        this.ownerIds = new HashMap<Integer, Integer>();
        this.treasures = new HashMap<Integer, TreasureV>();
    }

    public void update() {
        this.ownerIds.clear();
        this.treasures.clear();
        List<TreasureV> list = GameCommandUtil.getTreasures(this.datav, this.player.getDaimyoId());
        list.forEach(treasureV -> this.treasures.put(treasureV.getId(), (TreasureV)treasureV));
        this.player.getCommands().stream().filter(commandV -> commandV.getKind() == 16).forEach(commandV -> {
            int n = (Integer)commandV.getArgs().get(0);
            int n2 = (Integer)commandV.getArgs().get(1);
            this.ownerIds.put(n2, n);
        });
    }

    public void set(int n, int n2) {
        TreasureV treasureV = this.treasures.get(n);
        if (treasureV != null && treasureV.getKnightId() == n2) {
            this.ownerIds.remove(n);
        } else {
            this.ownerIds.put(n, n2);
        }
    }

    public int getKnightId(int n) {
        if (this.ownerIds.containsKey(n)) {
            return this.ownerIds.get(n);
        }
        TreasureV treasureV = this.treasures.get(n);
        if (treasureV != null) {
            return treasureV.getKnightId();
        }
        return 0;
    }

    public Map<Integer, TreasureV> getTreasures() {
        return this.treasures;
    }
}

