/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.domestic;

import game.sengoku.common.GameCommandCreator;
import game.sengoku.data.CommandV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.PlayerV;
import game.sengoku.data.Research;
import game.sengoku.data.TechnologyV;

public class DomesticResearchUtil {
    public static final int STATUS_DISABLE = 5;
    public static final int STATUS_CANRESEACH = 3;
    public static final int STATUS_STOP = 2;
    public static final int STATUS_FORCE_STOP = 4;
    public static final int STATUS_RESEACH = 1;
    public static final int STATUS_COMPLETE = 6;

    public static String getStatusName(int n) {
        switch (n) {
            case 1: {
                return "\u7814\u7a76\u4e2d";
            }
            case 2: 
            case 4: {
                return "\u4e2d\u65ad";
            }
            case 3: {
                return "\u7814\u7a76\u53ef\u80fd";
            }
            case 5: {
                return "\u7814\u7a76\u4e0d\u53ef\u80fd";
            }
            case 6: {
                return "\u7fd2\u5f97\u6e08\u307f";
            }
        }
        return "";
    }

    public static String getStatusName(int n, PlayerV playerV) {
        return DomesticResearchUtil.getStatusName(DomesticResearchUtil.getStatus(n, playerV));
    }

    public static int getStatus(int n, PlayerV playerV) {
        if (playerV.getDaimyo().getTechnologyIds().contains(n)) {
            return 6;
        }
        CommandV commandV2 = playerV.getCommands().stream().filter(commandV -> commandV.getKind() == 17).filter(commandV -> (Integer)commandV.getArgs().get(0) == n).findFirst().orElse(null);
        if (commandV2 != null) {
            int n2 = (Integer)commandV2.getArgs().get(1);
            if (n2 == 0) {
                return 2;
            }
            return 1;
        }
        Research research = (Research)playerV.getDaimyo().getResearches().get(n);
        if (research != null) {
            if (research.getKnightId() != 0) {
                return 1;
            }
            if (research.getProgress() == 0) {
                return 3;
            }
            GameDataV gameDataV = playerV.getGameDataV();
            int n3 = gameDataV.getWorld().getYear();
            TechnologyV technologyV = (TechnologyV)gameDataV.getTechnologies().get(n);
            if (!technologyV.getTechnology().getCondition().judgeForTechnology(n3, playerV.getDaimyo())) {
                return 4;
            }
            return 2;
        }
        return 5;
    }

    public static int getProgress(int n, PlayerV playerV) {
        return DomesticResearchUtil.getProgress(n, playerV.getDaimyo());
    }

    public static int getProgress(int n, DaimyoV daimyoV) {
        Research research = (Research)daimyoV.getResearches().get(n);
        if (research != null) {
            return research.getProgress();
        }
        return 0;
    }

    public static void start(int n, int n2, PlayerV playerV) {
        DomesticResearchUtil.remove(n, playerV);
        CommandV commandV = GameCommandCreator.commandTechnology(0, n, n2);
        playerV.getCommands().add(commandV);
    }

    public static void stop(int n, PlayerV playerV) {
        DomesticResearchUtil.remove(n, playerV);
        CommandV commandV = GameCommandCreator.commandTechnology(0, n, 0);
        playerV.getCommands().add(commandV);
    }

    public static void remove(int n, PlayerV playerV) {
        playerV.getCommands().removeIf(commandV -> commandV.getKind() == 17 && (Integer)commandV.getArgs().get(0) == n);
    }
}

