/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game.diplomacy;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.GameUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.common.Scene;
import game.sengoku.game.diplomacy.semiscene.SemiScene;
import game.sengoku.game.diplomacy.semiscene.SemiSceneAlliance;
import game.sengoku.game.diplomacy.semiscene.SemiSceneCulture;
import game.sengoku.game.diplomacy.semiscene.SemiSceneResource;
import game.sengoku.game.diplomacy.semiscene.SemiSceneRole;
import game.sengoku.game.diplomacy.semiscene.SemiSceneTechnology;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.WindowNegotiationEntry;

public class SceneNegotiationItemSelect
extends Scene {
    private static final int TYPE_CULTURE = 0;
    private static final int TYPE_TECHNOLOGY = 1;
    private static final int TYPE_TREASURE = 2;
    private static final int TYPE_RESOURCE = 3;
    private static final int TYPE_ALLIANCE = 4;
    private static final int TYPE_BAKUHU = 5;
    private Texture backGraund = null;
    private ButtonSprite kindCulture;
    private ButtonSprite kindTechnology;
    private ButtonSprite kindResource;
    private ButtonSprite kindAlliance;
    private ButtonSprite kindBakuhu;
    private ButtonSprite exit;
    private WindowNegotiationEntry info;
    private int kind = 0;
    private SemiScene semiSceneTechnology;
    private SemiScene semiSceneCulture;
    private SemiScene semiSceneResource;
    private SemiScene semiSceneAlliance;
    private SemiScene semiSceneRole;
    private SemiScene scene;

    public SceneNegotiationItemSelect() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        int n = 1;
        this.kindCulture = new ButtonSprite(800 * n / 7 - 40, 420, 100, 80, 25, 1097458124, 1768520959, GameFontUtil.FONT20, "\u6587\u5316", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.kindCulture.setPrimaryClicked(windowClickable -> this.setKind(0));
        this.kindCulture.setFontColor(-319753729);
        this.kindTechnology = new ButtonSprite(800 * ++n / 7 - 40, 420, 100, 80, 25, 1097458124, 1768520959, GameFontUtil.FONT20, "\u6280\u8853", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.kindTechnology.setPrimaryClicked(windowClickable -> this.setKind(1));
        this.kindTechnology.setFontColor(-319753729);
        this.kindResource = new ButtonSprite(800 * ++n / 7 - 40, 420, 100, 80, 25, 1097458124, 1768520959, GameFontUtil.FONT20, "\u8cc7\u6e90", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.kindResource.setPrimaryClicked(windowClickable -> this.setKind(3));
        this.kindResource.setFontColor(-319753729);
        this.kindAlliance = new ButtonSprite(800 * ++n / 7 - 40, 420, 100, 80, 25, 1097458124, 1768520959, GameFontUtil.FONT20, "\u8ecd\u4e8b", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.kindAlliance.setPrimaryClicked(windowClickable -> this.setKind(4));
        this.kindAlliance.setFontColor(-319753729);
        this.kindBakuhu = new ButtonSprite(800 * ++n / 7 - 40, 420, 100, 80, 25, 1097458124, 1768520959, GameFontUtil.FONT20, "\u5e55\u5e9c", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.kindBakuhu.setPrimaryClicked(windowClickable -> this.setKind(5));
        this.kindBakuhu.setFontColor(-319753729);
        ++n;
        this.exit = new ButtonSprite(660, 520, 100, 80, 25, 1097458124, 1768520959, GameFontUtil.FONT20, "\u7de8\u96c6\u7d42\u4e86", true, MouseSymbolLayerManager.LAYER_NORMAL);
        this.exit.setPrimaryClicked(windowClickable -> this.exit());
        this.exit.setFontColor(-319753729);
        this.info = new WindowNegotiationEntry(600, 10, 10, 190, 400, this.getGameTemp().getNegotiationEditDaimyoId(), this.getGameDataV());
    }

    @Override
    public void load() {
        super.load();
        this.loadBg();
        this.kind = -1;
        this.setKind(1);
        this.info.setDaimyoId(this.getGameTemp().getNegotiationEditDaimyoId());
        this.info.setNegotiationAction(this.getGameTemp().getNegotiationAction());
        this.info.forceUpdate();
    }

    @Override
    public void unLoad() {
        if (this.scene != null) {
            this.scene.unLoad();
        }
        this.scene = null;
    }

    protected void loadBg() {
        this.backGraund = GameUtil.selectTexture(this.getGameDataV().getWorld());
    }

    private void setKind(int n) {
        if (this.kind == n) {
            return;
        }
        this.kind = n;
        this.kindCulture.setNormalColor(1097458124);
        this.kindTechnology.setNormalColor(1097458124);
        this.kindResource.setNormalColor(1097458124);
        this.kindAlliance.setNormalColor(1097458124);
        this.kindBakuhu.setNormalColor(1097458124);
        if (this.scene != null) {
            this.scene.unLoad();
        }
        switch (n) {
            case 0: {
                this.kindCulture.setNormalColor(1768520959);
                if (this.semiSceneCulture == null) {
                    this.semiSceneCulture = new SemiSceneCulture();
                }
                this.scene = this.semiSceneCulture;
                break;
            }
            case 1: {
                this.kindTechnology.setNormalColor(1768520959);
                if (this.semiSceneTechnology == null) {
                    this.semiSceneTechnology = new SemiSceneTechnology();
                }
                this.scene = this.semiSceneTechnology;
                break;
            }
            case 2: {
                this.scene = null;
                break;
            }
            case 3: {
                this.kindResource.setNormalColor(1768520959);
                if (this.semiSceneResource == null) {
                    this.semiSceneResource = new SemiSceneResource();
                }
                this.scene = this.semiSceneResource;
                break;
            }
            case 4: {
                this.kindAlliance.setNormalColor(1768520959);
                if (this.semiSceneAlliance == null) {
                    this.semiSceneAlliance = new SemiSceneAlliance();
                }
                this.scene = this.semiSceneAlliance;
                break;
            }
            case 5: {
                this.kindBakuhu.setNormalColor(1768520959);
                if (this.semiSceneRole == null) {
                    this.semiSceneRole = new SemiSceneRole();
                }
                this.scene = this.semiSceneRole;
            }
        }
        if (this.scene != null) {
            this.scene.load();
        }
        this.info.forceUpdate();
    }

    @Override
    public void update() {
        super.update();
        this.kindCulture.update();
        this.kindTechnology.update();
        this.kindResource.update();
        this.kindAlliance.update();
        this.kindBakuhu.update();
        this.exit.update();
        this.info.update();
        if (this.info.isChangeEntry()) {
            this.info.forceUpdate();
        }
        if (this.scene != null) {
            this.scene.update();
            if (this.scene.isEntryChange()) {
                this.info.forceUpdate();
                this.scene.setEntryChange(false);
            }
        }
    }

    @Override
    protected void updateContent() {
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        this.kindCulture.draw(this.bcontext);
        this.kindTechnology.draw(this.bcontext);
        this.kindResource.draw(this.bcontext);
        this.kindAlliance.draw(this.bcontext);
        this.kindBakuhu.draw(this.bcontext);
        this.exit.draw(this.bcontext);
        this.info.draw(this.bcontext);
        if (this.scene != null) {
            this.scene.draw(this.bcontext);
        }
    }

    protected void exit() {
        this.getGameTemp().setSubSceneId(1);
    }

    @Override
    public boolean withHolding() {
        if (this.scene != null) {
            return this.scene.withHolding();
        }
        return false;
    }
}

