/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game;

import game.base.graphic.Drawable;
import game.base.graphic.DrawableTexture;
import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.base.graphic.TextureFactory;
import game.sengoku.data.Build;
import game.sengoku.data.GameData;
import game.sengoku.data.GameDataV;
import game.sengoku.data.MapPosition;
import game.sengoku.data.SpotV;
import game.sengoku.game.GameCommandUtil;
import game.sengoku.main.KessenMain;
import java.util.List;

public class WorldMapSpriteSet {
    public static final int WIDTH = 4000;
    public static final int HEIGHT = 3000;
    private Texture backgroundLayer;
    private Texture borderLayer;
    private DrawableTexture spotLayer;
    private DrawableTexture buildsLayer;
    private DrawableTexture castleLayer;
    private Texture spot_sea;
    private Texture spot_seaside;
    private Texture spot_mount;
    private Texture spot_plane;
    private Texture path;
    private static WorldMapSpriteSet instance = null;

    public static WorldMapSpriteSet getInstance(GameData gameData, GameDataV gameDataV) {
        if (instance == null) {
            instance = new WorldMapSpriteSet(gameData, gameDataV);
        }
        return instance;
    }

    public static void nullifyInstance() {
        instance = null;
    }

    private WorldMapSpriteSet(GameData gameData, GameDataV gameDataV) {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backgroundLayer = (Texture)graphicPool.getResource(gameData.getMap().getImage());
        this.borderLayer = (Texture)graphicPool.getResource("border05.png");
        this.spotLayer = new TextureFactory().create(4000, 3000);
        this.buildsLayer = new TextureFactory().create(4000, 3000);
        this.castleLayer = new TextureFactory().create(4000, 3000);
        this.spot_sea = (Texture)graphicPool.getResource("spot_sea.png");
        this.spot_seaside = (Texture)graphicPool.getResource("spot_seaside.png");
        this.spot_mount = (Texture)graphicPool.getResource("spot_mount.png");
        this.spot_plane = (Texture)graphicPool.getResource("spot_plane.png");
        this.path = (Texture)graphicPool.getResource("path.png");
        this.refresh(gameData, gameDataV);
    }

    public Texture getBorderLayer() {
        return this.borderLayer;
    }

    public Texture getBackgroundLayer() {
        return this.backgroundLayer;
    }

    public Texture getBoarderLayer() {
        return this.borderLayer;
    }

    public Texture getSpotLayer() {
        return this.spotLayer;
    }

    public Texture getBuildsLayer() {
        return this.buildsLayer;
    }

    public DrawableTexture getCastleLayer() {
        return this.castleLayer;
    }

    public void refresh(GameData gameData, GameDataV gameDataV) {
        this.refreshSpotLayer(gameData, gameDataV);
        this.refreshBuildsLayer(gameData, gameDataV);
    }

    public void refreshBuildsLayer(GameData gameData, GameDataV gameDataV) {
        this.buildsLayer.clear(-256);
        gameDataV.getSpots().forEach((n, spotV) -> {
            MapPosition mapPosition = (MapPosition)gameData.getMap().getPositions().get(n);
            this.createBuilds(mapPosition, (SpotV)spotV, this.buildsLayer);
        });
        this.buildsLayer.commit();
        this.castleLayer.clear(-256);
        gameDataV.getSpots().forEach((n, spotV) -> {
            MapPosition mapPosition = (MapPosition)gameData.getMap().getPositions().get(n);
            this.createCastles(mapPosition, (SpotV)spotV, this.castleLayer);
        });
        this.castleLayer.commit();
    }

    private void createBuilds(MapPosition mapPosition, SpotV spotV, Drawable drawable) {
        int n = 0;
        List<Build> list = GameCommandUtil.getVisibleBuilds(spotV);
        for (Build build : list) {
            this.createBuild(mapPosition.getX(), mapPosition.getY(), build, n, spotV, drawable);
            ++n;
        }
    }

    private void createCastles(MapPosition mapPosition, SpotV spotV, Drawable drawable) {
        int n = 0;
        List<Build> list = GameCommandUtil.getCastles(spotV);
        for (Build build : list) {
            this.createBuild(mapPosition.getX(), mapPosition.getY(), build, n, spotV, drawable);
            ++n;
        }
    }

    public int[] createBuildRect(int n, int n2, int n3, Build build) {
        int[] nArray = new int[4];
        int n4 = 0;
        int n5 = 0;
        int n6 = build.getKind() == 7 ? 35 : 25;
        switch (n3) {
            case 0: {
                n4 = 25;
                n5 = 0;
                break;
            }
            case 1: {
                n4 = -25;
                n5 = 0;
                break;
            }
            case 2: {
                n4 = 0;
                n5 = 25;
                break;
            }
            case 3: {
                n4 = 0;
                n5 = -25;
                break;
            }
            case 4: {
                n4 = 25;
                n5 = 25;
                break;
            }
            case 5: {
                n4 = -25;
                n5 = 25;
                break;
            }
            case 6: {
                n4 = 25;
                n5 = -25;
                break;
            }
            case 7: {
                n4 = -25;
                n5 = -25;
            }
        }
        nArray[0] = n - 12 + n4;
        nArray[1] = n2 - 12 + n5;
        nArray[2] = n6;
        nArray[3] = n6;
        return nArray;
    }

    private void createBuild(int n, int n2, Build build, int n3, SpotV spotV, Drawable drawable) {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        Texture texture = (Texture)graphicPool.getResource(this.getIconFileName(build, spotV));
        int[] nArray = this.createBuildRect(n, n2, n3, build);
        drawable.drawImage(texture, 0, 0, texture.getWidth(), texture.getHeight(), nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    private String getIconFileName(Build build, SpotV spotV) {
        if (build.getKind() == 7) {
            for (Build build2 : spotV.getBuilds()) {
                if (build2.getKind() != 8 || build2.getIconFileName() == null || "".equals(build2.getIconFileName())) continue;
                return build2.getIconFileName();
            }
        }
        return build.getIconFileName();
    }

    private void refreshSpotLayer(GameData gameData, GameDataV gameDataV) {
        this.spotLayer.clear(-256);
        gameData.getMap().getPositions().forEach((n, mapPosition) -> this.createSpot((int)n, mapPosition.getX(), mapPosition.getY(), gameDataV));
        gameData.getJapan().getNearbys().forEach(nearby -> this.createPath(nearby.getSpot1(), nearby.getSpot2(), gameData));
        this.spotLayer.commit();
    }

    private void createSpot(int n, int n2, int n3, GameDataV gameDataV) {
        SpotV spotV = (SpotV)gameDataV.getSpots().get(n);
        Texture texture = null;
        switch (spotV.getType()) {
            case 1: {
                texture = this.spot_plane;
                break;
            }
            case 2: {
                texture = this.spot_mount;
                break;
            }
            case 4: {
                texture = this.spot_sea;
                break;
            }
            case 3: {
                texture = this.spot_seaside;
            }
        }
        this.spotLayer.drawImage(texture, 0, 0, 250, 250, n2 - 15, n3 - 15, 30, 30);
    }

    private void createPath(int n, int n2, GameData gameData) {
        MapPosition mapPosition = (MapPosition)gameData.getMap().getPositions().get(n);
        MapPosition mapPosition2 = (MapPosition)gameData.getMap().getPositions().get(n2);
        this.createPath(mapPosition.getX(), mapPosition.getY(), mapPosition2.getX(), mapPosition2.getY());
    }

    private void createPath(int n, int n2, int n3, int n4) {
        int n5 = Math.max(Math.abs(n - n3) / 2, Math.abs(n2 - n4)) / 15;
        for (int i = 1; i < n5; ++i) {
            int n6 = n + (n3 - n) / n5 * i;
            int n7 = n2 + (n4 - n2) / n5 * i;
            this.spotLayer.drawImage(this.path, 0, 0, 250, 250, n6 - 12, n7 - 12, 25, 25);
        }
    }
}

