/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.SceneCommon;
import game.sengoku.data.CountryV;
import game.sengoku.data.GameData;
import game.sengoku.main.KessenMain;
import game.sengoku.window.CountrySelectButton;
import game.sengoku.window.WindowCountryInfo;
import java.util.ArrayList;
import java.util.List;

public abstract class SceneCountriesSelect
extends SceneCommon {
    private Texture minimap;
    private List<CountrySelectButton> buttons;
    protected List<CountryV> countries;
    private CountryV country;
    private WindowCountryInfo info;

    public SceneCountriesSelect() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.backGraund = (Texture)graphicPool.getResource("title00.jpg");
        GameData gameData = this.getGameData();
        this.minimap = (Texture)graphicPool.getResource(gameData.getMap().getImageMini());
        this.buttons = new ArrayList<CountrySelectButton>();
        this.countries = new ArrayList<CountryV>();
        this.country = null;
        this.info = new WindowCountryInfo(50, 450, 10, 600, 140, 0, "\u56fd\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044", this.getGameDataV(), this.getPlayer());
    }

    @Override
    public void load() {
        super.load();
        this.country = null;
        this.info.setCountryId(-1);
        this.countries.clear();
        this.loadCountries();
        this.loadData();
    }

    public abstract void loadCountries();

    private void loadData() {
        for (CountryV countryV : this.countries) {
            int n = this.getColor(countryV);
            CountrySelectButton countrySelectButton = new CountrySelectButton(countryV.getCountry(), this.getGameDataV(), n, n);
            countrySelectButton.setMouseEnter(windowClickable -> {
                this.country = ((CountrySelectButton)windowClickable).getCountryV();
                this.info.setCountryId(this.country.getId());
            });
            countrySelectButton.setMouseExit(windowClickable -> {
                this.country = null;
                this.info.setCountryId(-1);
            });
            countrySelectButton.setPrimaryClicked(windowClickable -> {
                this.country = ((CountrySelectButton)windowClickable).getCountryV();
                if (this.country != null) {
                    this.countryClicked(this.country);
                }
            });
            this.buttons.add(countrySelectButton);
        }
    }

    protected abstract void countryClicked(CountryV var1);

    public CountryV getCountry() {
        return this.country;
    }

    protected int getColor(CountryV countryV) {
        return countryV.getDaimyo().getColor();
    }

    protected abstract void countrySelected(int var1);

    @Override
    public void unLoad() {
        this.countries.clear();
        this.buttons.clear();
    }

    @Override
    public void update() {
        super.update();
        this.buttons.forEach(countrySelectButton -> countrySelectButton.update());
        this.info.update();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        this.bcontext.drawImage(this.backGraund, 0, 0, -100);
        this.bcontext.drawImage(this.minimap, 150, 10, 10);
        this.info.draw(this.bcontext);
        this.buttons.forEach(countrySelectButton -> countrySelectButton.draw(this.bcontext));
    }
}

