/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.game;

import game.base.common.Pair;
import game.base.common.Tuple;
import game.sengoku.common.GameHistoryCreator;
import game.sengoku.common.GameNoticeCreator;
import game.sengoku.common.GameUtil;
import game.sengoku.data.AIType;
import game.sengoku.data.Baptism;
import game.sengoku.data.BorderConflictV;
import game.sengoku.data.Build;
import game.sengoku.data.BuildPlan;
import game.sengoku.data.CommandV;
import game.sengoku.data.CountryV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameData;
import game.sengoku.data.GameDataV;
import game.sengoku.data.GameHistory;
import game.sengoku.data.GiantV;
import game.sengoku.data.KnightV;
import game.sengoku.data.Nearby;
import game.sengoku.data.PlayerV;
import game.sengoku.data.Present;
import game.sengoku.data.Rank;
import game.sengoku.data.Research;
import game.sengoku.data.RoleV;
import game.sengoku.data.SpotV;
import game.sengoku.data.Store;
import game.sengoku.data.StoreV;
import game.sengoku.data.Technology;
import game.sengoku.data.TechnologyV;
import game.sengoku.data.TreasureV;
import game.sengoku.data.UnitV;
import game.sengoku.data.UnmodifiableReration;
import game.sengoku.data.WorldDataV;
import game.sengoku.game.GameCostUtil;
import game.sengoku.game.GameDiplomacyUtil;
import game.sengoku.game.GameTacticsUtil;
import game.sengoku.game.Notice;
import game.sengoku.game.diplomacy.NegotiationAction;
import game.sengoku.game.diplomacy.NegotiationActionEntry;
import game.sengoku.game.diplomacy.StoreAction;
import game.sengoku.game.domestic.DomesticResearchUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class GameCommandUtil {
    private GameCommandUtil() {
    }

    public static void updateNewGame(GameDataV gameDataV) {
        gameDataV.update();
        WorldDataV worldDataV = gameDataV.getWorld();
        int n = worldDataV.getYear();
        worldDataV.setYear(n - 1);
        worldDataV.setMonth(12);
        gameDataV.getDaimyos().values().forEach(daimyoV -> {
            daimyoV.setFame(daimyoV.getMaxFame() / 2);
            daimyoV.getKnight().setEmployee(true);
            if (daimyoV.isCanHongan()) {
                daimyoV.setChristTreat(-1);
            }
        });
        gameDataV.getCountries().values().forEach(countryV -> countryV.setUsableArmy((int)((double)countryV.getMaxArmy() * 0.5)));
    }

    public static void initAiType(GameData gameData, AIType aIType) {
        boolean bl;
        do {
            Object object;
            bl = false;
            Object object2 = aIType.getPriorBuilds().iterator();
            while (object2.hasNext()) {
                int n = (Integer)object2.next();
                Build build = (Build)gameData.getBuilds().get(n);
                object = build.getCondition().getTechnologies().iterator();
                while (object.hasNext()) {
                    int n2 = (Integer)object.next();
                    if (aIType.getPriorTechnologies().contains(n2)) continue;
                    aIType.getPriorTechnologies().add(n2);
                    bl = true;
                }
            }
            object2 = new ArrayList();
            Iterator<Object> iterator = aIType.getPriorTechnologies().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                object = (Technology)gameData.getTechnologies().get(n);
                Iterator iterator2 = object.getCondition().getTechnologies().iterator();
                while (iterator2.hasNext()) {
                    int n3 = (Integer)iterator2.next();
                    if (aIType.getPriorTechnologies().contains(n3)) continue;
                    object2.add(n3);
                    bl = true;
                }
            }
            aIType.getPriorTechnologies().addAll(object2);
            for (Store store : gameData.getStores().values()) {
                if (aIType.getPriorStores().contains(store.getId())) continue;
                for (Present present : store.getPresents()) {
                    if (!aIType.getPriorTechnologies().contains(present.getTechnologyId())) continue;
                    aIType.getPriorStores().add(store.getId());
                    bl = true;
                }
            }
            for (Build build : gameData.getBuilds().values()) {
                if (build.getStoreId() == 0 || aIType.getPriorBuilds().contains(build.getId()) || !aIType.getPriorStores().contains(build.getStoreId())) continue;
                aIType.getPriorBuilds().add(build.getId());
                bl = true;
            }
        } while (bl);
    }

    public static void updateWorld(GameDataV gameDataV) {
        WorldDataV worldDataV = gameDataV.getWorld();
        worldDataV.stepMonth();
    }

    public static void updateByMonth(GameDataV gameDataV, List<Pair<Integer, Notice>> list) {
        int n2;
        Set set;
        KnightV knightV2;
        GameCommandUtil.updateWorld(gameDataV);
        WorldDataV worldDataV = gameDataV.getWorld();
        if (worldDataV.getMonth() == 1 && !worldDataV.isIntercalary()) {
            GameCommandUtil.updateByYear(gameDataV, list);
        }
        Notice notice = null;
        if (worldDataV.getGengoYear() <= 1) {
            notice = GameNoticeCreator.newGengo(worldDataV.getGengo());
            list.add(new Pair<Integer, Notice>(99, notice));
        }
        int n3 = worldDataV.getYear();
        GameCommandUtil.disaster(gameDataV, list);
        GameCommandUtil.ikkou(gameDataV, list);
        int n4 = gameDataV.getParameters().getMoveRate();
        for (KnightV knightV2 : gameDataV.getKnights().values()) {
            if (!knightV2.isAppear() || knightV2.isDisappear()) continue;
            if (!knightV2.isEmployee() && !knightV2.getKnight().isKokujin() && knightV2.getSpotId() != 0 && GameUtil.getRandom(n4)) {
                set = gameDataV.nearbySpotIds(knightV2.getSpotId());
                set.remove(knightV2.getSpotId());
                n2 = (Integer)GameUtil.getRandom(set);
                knightV2.setSpotId(n2);
            }
            if (knightV2.isEmployee() && knightV2.getDaimyo().getKnight().isBaptism() && GameUtil.getRandom(5)) {
                GameCommandUtil.updateBaptism(gameDataV, knightV2, list);
            }
            knightV2.setUnmoveMonth(0);
        }
        for (KnightV knightV2 : gameDataV.getGiants().values()) {
            if (!knightV2.isAppear() || knightV2.isDisappear() || knightV2.getDaimyoId() != 0 || knightV2.getSpotId() == 0 || !GameUtil.getRandom(n4)) continue;
            set = gameDataV.nearbySpotIds(knightV2.getSpotId());
            n2 = (Integer)GameUtil.getRandom(set);
            knightV2.setSpotId(n2);
        }
        for (KnightV knightV2 : gameDataV.getDaimyos().values()) {
            GameCommandUtil.updateDaimyoImcome(gameDataV, n3, (DaimyoV)knightV2, list);
        }
        for (KnightV knightV2 : gameDataV.getCountries().values()) {
            set = knightV2.getDaimyo();
            knightV2.updateByMonth();
            if (!knightV2.getBuildPlans().isEmpty()) {
                BuildPlan buildPlan = (BuildPlan)knightV2.getBuildPlans().get(0);
                if (buildPlan.getKnight() != null) {
                    if (buildPlan.getKnight().getRentalDaimyoId() == 0 && buildPlan.getKnight().getDaimyoId() == set.getId() || buildPlan.getKnight().getRentalDaimyoId() == set.getId()) {
                        if (!buildPlan.getKnight().isAppear() || buildPlan.getKnight().isDisappear()) {
                            buildPlan.setKnightId(0);
                        }
                    } else {
                        buildPlan.setKnightId(0);
                    }
                }
                if (buildPlan.getCost() <= set.getMoney()) {
                    set.setMoneyChange(11, -1 * buildPlan.getCost());
                    int n5 = knightV2.getPower();
                    if (buildPlan.getKnight() != null) {
                        n5 += n5 * buildPlan.getKnight().getDomestic() / 10;
                        buildPlan.getKnight().setDomesticExp(buildPlan.getKnight().getDomesticExp() + 5);
                    }
                    buildPlan.setAmountPower(buildPlan.getAmountPower() + n5);
                    if (buildPlan.isComplete()) {
                        SpotV spotV = buildPlan.getSpot();
                        spotV.getBuildIds().add(buildPlan.getBuild().getId());
                        knightV2.getBuildPlans().remove(0);
                        notice = GameNoticeCreator.completeBuild((CountryV)knightV2, buildPlan.getBuild());
                        list.add(new Pair<Integer, Notice>(set.getId(), notice));
                        spotV.updateBuilds();
                    }
                } else {
                    notice = GameNoticeCreator.stopBuild((CountryV)knightV2, buildPlan.getBuild());
                    list.add(new Pair<Integer, Notice>(set.getId(), notice));
                }
            }
            if (knightV2.getChrist() < 50) continue;
            GameCommandUtil.brokenShrine(gameDataV, (CountryV)knightV2, list);
        }
        GameCommandUtil.flowPopulation(gameDataV, list);
        GameCommandUtil.flowChirist(gameDataV, list);
        for (KnightV knightV2 : gameDataV.getDaimyos().values()) {
            knightV2.update();
            knightV2.getGiants().forEach(arg_0 -> GameCommandUtil.lambda$updateByMonth$113((DaimyoV)knightV2, list, arg_0));
            knightV2.getKnights().forEach(arg_0 -> GameCommandUtil.lambda$updateByMonth$114((DaimyoV)knightV2, gameDataV, list, arg_0));
            gameDataV.getTechnologies().values().stream().filter(arg_0 -> GameCommandUtil.lambda$updateByMonth$115((DaimyoV)knightV2, arg_0)).filter(arg_0 -> GameCommandUtil.lambda$updateByMonth$116((DaimyoV)knightV2, arg_0)).filter(technologyV -> technologyV.getTechnology().isCanStudy()).filter(arg_0 -> GameCommandUtil.lambda$updateByMonth$118(n3, (DaimyoV)knightV2, arg_0)).forEach(arg_0 -> GameCommandUtil.lambda$updateByMonth$119((DaimyoV)knightV2, list, arg_0));
            knightV2.getResearches().values().stream().filter(research -> !research.isComplete()).filter(research -> !research.isStop()).filter(arg_0 -> GameCommandUtil.lambda$updateByMonth$122((DaimyoV)knightV2, arg_0)).forEach(arg_0 -> GameCommandUtil.lambda$updateByMonth$123(gameDataV, n3, (DaimyoV)knightV2, list, arg_0));
            GameCommandUtil.updateRank(gameDataV, (DaimyoV)knightV2, list);
        }
        GameCommandUtil.updateArmyLevel(gameDataV, list);
        gameDataV.getStores().forEach((n, storeV) -> storeV.updateByMonth());
        GameCommandUtil.appearPirate(gameDataV, list);
        int n6 = gameDataV.getParameters().getConflictRate();
        if (GameUtil.getRandom(n6) && (knightV2 = GameCommandUtil.selectNear(gameDataV)) != null) {
            int n7 = gameDataV.getBorderConflicts().stream().mapToInt(borderConflictV -> borderConflictV.getId()).max().orElse(0) + 1;
            BorderConflictV borderConflictV2 = new BorderConflictV(n7, knightV2.getSpot1(), knightV2.getSpot2(), 0);
            borderConflictV2.setGameDataV(gameDataV);
            borderConflictV2.setGameData(gameDataV.getGameData());
            gameDataV.getBorderConflicts().add(borderConflictV2);
            Notice notice2 = GameNoticeCreator.borderConflict(knightV2.getSpot1(), borderConflictV2.getDaimyo1());
            list.add(new Pair<Integer, Notice>(borderConflictV2.getDaimyoId2(), notice2));
            notice2 = GameNoticeCreator.borderConflict(knightV2.getSpot1(), borderConflictV2.getDaimyo2());
            list.add(new Pair<Integer, Notice>(borderConflictV2.getDaimyoId1(), notice2));
        }
        gameDataV.getRelations().forEach(relationV -> relationV.updateByMonth());
        gameDataV.getBorderConflicts().forEach(borderConflictV -> borderConflictV.updateByMonth());
    }

    public static Nearby selectNear(GameDataV gameDataV) {
        ArrayList<Nearby> arrayList = new ArrayList<Nearby>();
        for (Nearby nearby : gameDataV.getGameData().getJapan().getNearbys()) {
            SpotV spotV = (SpotV)gameDataV.getSpots().get(nearby.getSpot1());
            SpotV spotV2 = (SpotV)gameDataV.getSpots().get(nearby.getSpot2());
            if (spotV.getDaimyoId() == 0 || spotV2.getDaimyoId() == 0 || spotV.getDaimyoId() == spotV2.getDaimyoId() || gameDataV.getBorderConflicts().stream().anyMatch(borderConflictV -> borderConflictV.getSpotId1() == nearby.getSpot1() && borderConflictV.getSpotId2() == nearby.getSpot2() || borderConflictV.getSpotId1() == nearby.getSpot2() && borderConflictV.getSpotId2() == nearby.getSpot1())) continue;
            arrayList.add(nearby);
        }
        Nearby nearby = (Nearby)GameUtil.getRandom(arrayList);
        return nearby;
    }

    public static void updateBaptism(GameDataV gameDataV, KnightV knightV, List<Pair<Integer, Notice>> list) {
        String string = GameCommandUtil.getBaptismName(gameDataV);
        Notice notice = GameNoticeCreator.baptism(knightV, string);
        list.add(new Pair<Integer, Notice>(99, notice));
        knightV.setBaptism(true);
        knightV.setName(string);
    }

    private static String getBaptismName(GameDataV gameDataV) {
        Baptism baptism = (Baptism)GameUtil.getRandom(gameDataV.getGameData().getBaptisms().values());
        return baptism.getName();
    }

    private static void updateDaimyoImcome(GameDataV gameDataV, int n, DaimyoV daimyoV, List<Pair<Integer, Notice>> list) {
        Notice notice;
        WorldDataV worldDataV = gameDataV.getWorld();
        daimyoV.update();
        daimyoV.updateByMonth();
        daimyoV.setIron(daimyoV.getIron() + daimyoV.getIronPlus());
        daimyoV.setSaltpeter(daimyoV.getSaltpeter() + daimyoV.getSaltpeterPlus());
        daimyoV.setHorse(daimyoV.getHorse() + daimyoV.getHorsePlus());
        int n2 = daimyoV.getGunPlus();
        if (daimyoV.getIron() < n2) {
            n2 = daimyoV.getIron();
            Notice notice2 = GameNoticeCreator.stopGun();
            list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice2));
        }
        daimyoV.setGun(daimyoV.getGun() + n2);
        daimyoV.setIron(daimyoV.getIron() - n2);
        int n3 = daimyoV.getGunpowderPlus();
        if (daimyoV.getSaltpeter() < n3) {
            n3 = daimyoV.getSaltpeter();
            Notice notice3 = GameNoticeCreator.stopGunpowder();
            list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice3));
        }
        daimyoV.setGunpowder(daimyoV.getGunpowder() + n3);
        daimyoV.setSaltpeter(daimyoV.getSaltpeter() - n3);
        daimyoV.setHorse(daimyoV.getHorse() + daimyoV.getHorsePlus());
        if (worldDataV.getMonth() == 9 && !worldDataV.isIntercalary()) {
            int n4 = daimyoV.getTaxYearPlus();
            daimyoV.setMoneyChange(2, n4);
            notice = GameNoticeCreator.incomeYear(n4);
            list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
        }
        if (daimyoV.isCanHongan() && worldDataV.getMonth() == 4 && !worldDataV.isIntercalary()) {
            int n5 = gameDataV.getCountries().values().stream().mapToInt(countryV -> countryV.getMissionary()).sum() / 10;
            daimyoV.setMoneyChange(7, n5);
            notice = GameNoticeCreator.incomeMission(n5);
            list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
        }
    }

    private static void updateResearch(GameDataV gameDataV, Research research, int n, DaimyoV daimyoV, List<Pair<Integer, Notice>> list) {
        KnightV knightV;
        TechnologyV technologyV = (TechnologyV)gameDataV.getTechnologies().get(research.getTechnologyId());
        if (!technologyV.getTechnology().getCondition().judgeForTechnology(n, daimyoV)) {
            research.setKnightId(0);
        }
        if ((knightV = (KnightV)gameDataV.getKnights().get(research.getKnightId())) != null) {
            if (knightV.getRentalDaimyoId() == 0 && knightV.getDaimyoId() == daimyoV.getId() || knightV.getRentalDaimyoId() == daimyoV.getId()) {
                if (!knightV.isAppear() || knightV.isDisappear()) {
                    research.setKnightId(0);
                }
            } else {
                research.setKnightId(0);
            }
        }
        if (research.getKnightId() != 0) {
            research.setProgress(research.getProgress() + knightV.getCulture());
            knightV.setCultureExp(knightV.getCultureExp() + 5);
            if (research.isComplete()) {
                technologyV = (TechnologyV)gameDataV.getTechnologies().get(research.getTechnologyId());
                daimyoV.getTechnologyIds().add(technologyV.getId());
                research.setKnightId(0);
                Notice notice = GameNoticeCreator.getTechnology(technologyV);
                list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
            }
        }
    }

    private static void appearPirate(GameDataV gameDataV, List<Pair<Integer, Notice>> list) {
        SpotV spotV;
        int n2;
        int n3 = gameDataV.getParameters().getPirateId();
        int n4 = GameUtil.getRandom(1, 5);
        int n5 = gameDataV.getUnits().keySet().stream().mapToInt(n -> n).max().orElse(0) + 1;
        int n6 = 60;
        int n7 = GameUtil.getRandomSpotIdSea(gameDataV);
        boolean bl = true;
        UnitV unitV = new UnitV(n5, 0, 0, 0, n7, 0, n3, n4, n4 * 100, n6, 0, bl, false, false);
        unitV.setGameDataV(gameDataV);
        unitV.setGameData(gameDataV.getGameData());
        gameDataV.getUnits().put(n5, unitV);
        Set set = gameDataV.nearbySpotIds(n7);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            n2 = (Integer)iterator.next();
            spotV = (SpotV)gameDataV.getSpots().get(n2);
            hashSet.add(spotV.getDaimyoId());
        }
        hashSet.remove(0);
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            n2 = (Integer)iterator.next();
            spotV = (SpotV)gameDataV.getSpots().get(n7);
            Notice notice = GameNoticeCreator.appearPirate(spotV);
            list.add(new Pair<Integer, Notice>(n2, notice));
        }
    }

    private static void appearIkkou(GameDataV gameDataV, CountryV countryV, List<Pair<Integer, Notice>> list) {
        int n2 = gameDataV.getParameters().getIkkouId();
        int n3 = GameUtil.getBinomial(1, countryV.getMissionary() / 100);
        if (countryV.getMissionary() < n3 * 100) {
            return;
        }
        int n4 = gameDataV.getUnits().keySet().stream().mapToInt(n -> n).max().orElse(0) + 1;
        int n5 = 60;
        int n6 = (Integer)GameUtil.getRandom(countryV.getSpotIds());
        boolean bl = false;
        UnitV unitV = new UnitV(n4, 0, 0, 0, n6, 0, n2, n3, n3 * 100, n5, 0, bl, false, false);
        unitV.setGameDataV(gameDataV);
        unitV.setGameData(gameDataV.getGameData());
        gameDataV.getUnits().put(n4, unitV);
        Notice notice = GameNoticeCreator.appearIkkou(countryV);
        list.add(new Pair<Integer, Notice>(99, notice));
        countryV.setMissionary(countryV.getMissionary() - n3 * 100);
    }

    private static void disaster(GameDataV gameDataV, List<Pair<Integer, Notice>> list) {
        CountryV countryV;
        int n = gameDataV.getParameters().getDisasterRate();
        if (GameUtil.getRandom(n) && (countryV = (CountryV)GameUtil.getRandom(gameDataV.getCountries().values())).getRuinMonth() == 0) {
            int n2 = GameUtil.getRandom(0, 100);
            int n3 = (int)((double)GameUtil.getRandom(10, 100) * gameDataV.getWorld().getInflationRate());
            n3 = Math.min(countryV.getDaimyo().getMoney(), n3);
            countryV.getDaimyo().setMoneyChange(15, -1 * n3);
            Notice notice = GameNoticeCreator.disaster(countryV, n2, n3);
            list.add(new Pair<Integer, Notice>(99, notice));
            SpotV spotV = (SpotV)GameUtil.getRandom(countryV.getSpots());
            GameCommandUtil.brokenBuild(gameDataV, spotV, list);
        }
    }

    private static void ikkou(GameDataV gameDataV, List<Pair<Integer, Notice>> list) {
        int n = gameDataV.getParameters().getIkkouId();
        for (CountryV countryV : gameDataV.getCountries().values()) {
            if (countryV.getDaimyo().isCanHongan()) continue;
            int n2 = 0;
            for (SpotV spotV : countryV.getSpots()) {
                for (UnitV unitV : spotV.getUnits()) {
                    if (unitV.getUnit().getId() != n) continue;
                    int n3 = (int)((double)GameUtil.getRandom(10, 100) * gameDataV.getWorld().getInflationRate());
                    n2 += n3;
                }
            }
            if (false >= n2) continue;
            n2 = Math.min(countryV.getDaimyo().getMoney(), n2);
            countryV.getDaimyo().setMoneyChange(15, -1 * n2);
            Notice notice = GameNoticeCreator.ikkou(countryV, n2);
            list.add(new Pair<Integer, Object>(countryV.getDaimyoId(), notice));
        }
    }

    public static void brokenShrine(GameDataV gameDataV, CountryV countryV, List<Pair<Integer, Notice>> list) {
        for (SpotV spotV : countryV.getSpots()) {
            for (Build build : spotV.getBuilds()) {
                if (build.getSpotId() != 0 || build.getBreakRate() <= 0 || build.getKind() != 4 && build.getKind() != 5 || !GameUtil.getRandom(build.getBreakRate())) continue;
                spotV.getBuildIds().remove((Object)build.getId());
                Notice notice = GameNoticeCreator.brokenShrine(spotV.getCountry());
                list.add(new Pair<Integer, Notice>(spotV.getCountry().getDaimyoId(), notice));
                break;
            }
            spotV.updateBuilds();
        }
    }

    public static void brokenBuild(GameDataV gameDataV, SpotV spotV, List<Pair<Integer, Notice>> list) {
        if (spotV.getCountry() == null) {
            return;
        }
        for (Build build : spotV.getBuilds()) {
            if (build.getKind() == 10 || build.getKind() == 9 || build.getSpotId() != 0 || build.getBreakRate() <= 0 || !GameUtil.getRandom(build.getBreakRate())) continue;
            spotV.getBuildIds().remove((Object)build.getId());
            Notice notice = GameNoticeCreator.brokenBuild(spotV.getCountry(), build);
            list.add(new Pair<Integer, Notice>(spotV.getCountry().getDaimyoId(), notice));
            break;
        }
        spotV.updateBuilds();
    }

    private static void flowPopulation(GameDataV gameDataV, List<Pair<Integer, Notice>> list) {
        for (CountryV countryV : gameDataV.getCountries().values()) {
            for (CountryV countryV2 : gameDataV.getCountries().values()) {
                if (countryV.getId() == countryV2.getId() || countryV.getDaimyoId() == countryV2.getDaimyoId() || gameDataV.distanceCountry(countryV.getId(), countryV2.getId()) != 1 || countryV.getTamichu() * 3 >= countryV2.getTamichu()) continue;
                int n = GameUtil.getRandom(1, 10);
                countryV.setPopulation(countryV.getPopulation() - n);
                countryV2.setPopulation(countryV2.getPopulation() + n);
                Notice notice = GameNoticeCreator.flowPopulation(countryV, countryV2);
                list.add(new Pair<Integer, Notice>(countryV.getDaimyoId(), notice));
            }
        }
    }

    private static void flowChirist(GameDataV gameDataV, List<Pair<Integer, Notice>> list) {
        for (CountryV countryV : gameDataV.getCountries().values()) {
            for (CountryV countryV2 : gameDataV.getCountries().values()) {
                if (countryV.getId() == countryV2.getId() || countryV.getDaimyoId() == countryV2.getDaimyoId() || gameDataV.distanceCountry(countryV.getId(), countryV2.getId()) != 1 || countryV.getChrist() * 2 >= countryV2.getChrist() || countryV.getChrist() >= 20) continue;
                countryV.setChrist(countryV.getChrist() + 1);
            }
        }
    }

    private static void updateRank(GameDataV gameDataV, DaimyoV daimyoV, List<Pair<Integer, Notice>> list) {
        int n = daimyoV.getRankId() == 0 ? 0 : daimyoV.getRank().getMinCulture();
        int n2 = gameDataV.getGameData().getRanks().values().stream().filter(rank -> rank.getMinCulture() <= daimyoV.getCultureArv()).filter(rank -> rank.getMinCulture() > n).sorted((rank, rank2) -> rank2.getMinCulture() - rank.getMinCulture()).mapToInt(rank -> rank.getMinCulture()).findFirst().orElse(-1);
        List list2 = gameDataV.getGameData().getRanks().values().stream().filter(rank -> rank.getMinCulture() == n2).collect(Collectors.toList());
        if (!list2.isEmpty()) {
            Rank rank3 = (Rank)GameUtil.getRandom(list2);
            daimyoV.setRankId(rank3.getId());
            Notice notice = GameNoticeCreator.rankUp(rank3);
            list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
            notice = GameHistoryCreator.rankUp(rank3);
            list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
        }
    }

    public static void updateArmyLevel(GameDataV gameDataV, List<Pair<Integer, Notice>> list) {
        for (CountryV countryV : gameDataV.getCountries().values()) {
            int n = countryV.getArmyLevel();
            while (true) {
                int n2 = GameCommandUtil.getForNextLevel(gameDataV, countryV.getCulture(), n);
                if (countryV.getArmyExp() < n2) break;
                ++n;
            }
            if (countryV.getArmyLevel() == n) continue;
            countryV.setArmyLevel(n);
            Notice notice = GameNoticeCreator.updateLevel(countryV, n);
            list.add(new Pair<Integer, Notice>(countryV.getDaimyo().getId(), notice));
        }
    }

    public static int getForNextLevel(GameDataV gameDataV, int n, int n2) {
        int n3 = gameDataV.getParameters().getArmyExpBase();
        int n4 = gameDataV.getParameters().getArmyExpDiv();
        int n5 = (n3 + n / n4) * (n2 + 1);
        return n5;
    }

    public static void updateByYear(GameDataV gameDataV, List<Pair<Integer, Notice>> list) {
        WorldDataV worldDataV = gameDataV.getWorld();
        int n = worldDataV.getYear();
        gameDataV.getKnights().values().stream().filter(knightV -> knightV.isAppear() && !knightV.isDisappear()).filter(knightV -> knightV.getKnight().getDie() <= n).forEach(knightV -> GameCommandUtil.disappearKnight(gameDataV, knightV, list));
        gameDataV.getKnights().values().stream().filter(knightV -> !knightV.isAppear() && !knightV.isDisappear()).filter(knightV -> knightV.getKnight().getBorn() + knightV.getKnight().getEstate() <= n).forEach(knightV -> GameCommandUtil.appearKnight(gameDataV, knightV, list));
        gameDataV.getGiants().values().stream().filter(giantV -> !giantV.isAppear() && !giantV.isDisappear()).filter(giantV -> n <= giantV.getGiant().getAppear()).forEach(giantV -> GameCommandUtil.appearGiant(gameDataV, giantV));
        gameDataV.getTreasures().values().stream().filter(treasureV -> !treasureV.isAppear() && !treasureV.isDisappear()).filter(treasureV -> n <= treasureV.getTreasure().getFrom()).forEach(treasureV -> GameCommandUtil.appearTreasure(gameDataV, treasureV, list));
        double d = worldDataV.getInflationRate();
        gameDataV.getKnights().values().stream().filter(knightV -> knightV.isAppear() && !knightV.isDisappear()).forEach(knightV -> {
            int n = GameCommandUtil.getSalary(gameDataV, knightV);
            knightV.setPay((int)Math.ceil((double)n * d));
        });
        gameDataV.getGiants().values().stream().filter(giantV -> giantV.isAppear() && !giantV.isDisappear()).forEach(giantV -> giantV.setPay((int)Math.ceil((double)giantV.getGiant().getPay() * d)));
        Notice notice = GameNoticeCreator.updateSalary();
        list.add(new Pair<Integer, Notice>(99, notice));
    }

    public static void appearKnight(GameDataV gameDataV, KnightV knightV3, List<Pair<Integer, Notice>> list) {
        Object object;
        knightV3.setAppear(true);
        int n = GameCommandUtil.getSalary(gameDataV, knightV3);
        double d = gameDataV.getWorld().getInflationRate();
        knightV3.setPay((int)Math.ceil((double)n * d));
        boolean bl = false;
        if (knightV3.getKnight().getFather() != 0 && (object = (KnightV)gameDataV.getKnights().get(knightV3.getKnight().getFather())).isAppear() && !object.isDisappear()) {
            knightV3.setDaimyoId(object.getDaimyoId());
            knightV3.setEmployee(object.isEmployee());
            knightV3.setSpotId(object.getSpotId());
            if (object.isDaimyo()) {
                knightV3.setEmployee(true);
            }
            bl = true;
        }
        if (!bl && knightV3.getKnight().getFamilyId() != 0 && (object = (KnightV)gameDataV.getKnights().values().stream().filter(knightV -> knightV.isDaimyo()).filter(knightV2 -> knightV2.getKnight().getFamilyId() == knightV3.getKnight().getFamilyId()).findFirst().orElse(null)) != null && object.isAppear() && !object.isDisappear()) {
            knightV3.setDaimyoId(object.getDaimyoId());
            knightV3.setEmployee(true);
            knightV3.setSpotId(object.getSpotId());
            bl = true;
        }
        if (!bl) {
            GameCommandUtil.releaseKnight(gameDataV, knightV3);
        }
        if (knightV3.getDaimyoId() != 0 && knightV3.isEmployee()) {
            object = GameNoticeCreator.newFaceKnight(knightV3);
            list.add(new Pair<Integer, KnightV>(knightV3.getDaimyoId(), (KnightV)object));
        }
    }

    private static void growUpKnight(GameDataV gameDataV, KnightV knightV, List<Pair<Integer, Notice>> list) {
        Notice notice;
        if (knightV.getDomesticPlus() < 5 && knightV.getDomesticExp() >= knightV.getGrowUpExpDomestic()) {
            knightV.setDomesticPlus(knightV.getDomesticPlus() + 1);
            knightV.setDomesticExp(0);
            notice = GameNoticeCreator.growUpDomestic(knightV);
            list.add(new Pair<Integer, Notice>(knightV.getDaimyoId(), notice));
        }
        if (knightV.getTacticsPlus() < 5 && knightV.getTacticsExp() >= knightV.getGrowUpExpTactics()) {
            knightV.setTacticsPlus(knightV.getTacticsPlus() + 1);
            knightV.setTacticsExp(0);
            notice = GameNoticeCreator.growUpTactics(knightV);
            list.add(new Pair<Integer, Notice>(knightV.getDaimyoId(), notice));
        }
        if (knightV.getCulturePlus() < 5 && knightV.getCultureExp() >= knightV.getGrowUpExpCulture()) {
            knightV.setCulturePlus(knightV.getCulturePlus() + 1);
            knightV.setCultureExp(0);
            notice = GameNoticeCreator.growUpCulture(knightV);
            list.add(new Pair<Integer, Notice>(knightV.getDaimyoId(), notice));
        }
    }

    public static void appearGiant(GameDataV gameDataV, GiantV giantV) {
        giantV.setAppear(true);
        if (giantV.getGiant().getSpotId() == 0) {
            int n = GameUtil.getRandomSpotId(gameDataV);
            giantV.setSpotId(n);
        } else {
            giantV.setSpotId(giantV.getGiant().getSpotId());
        }
    }

    public static void appearTreasure(GameDataV gameDataV, TreasureV treasureV, List<Pair<Integer, Notice>> list) {
        if (!treasureV.getTreasure().getStoreIds().isEmpty()) {
            treasureV.setAppear(true);
            int n = (Integer)GameUtil.getRandom(treasureV.getTreasure().getStoreIds());
            treasureV.setStoreId(n);
            treasureV.setKnightId(0);
        }
    }

    public static void disappearKnight(GameDataV gameDataV, KnightV knightV, List<Pair<Integer, Notice>> list) {
        int n = gameDataV.getParameters().getDieRate();
        if (knightV.isDaimyo()) {
            return;
        }
        if (GameUtil.getRandom(n)) {
            Notice notice = GameNoticeCreator.disappearKnight(knightV);
            list.add(new Pair<Integer, Notice>(99, notice));
            knightV.setDisappear(true);
            knightV.setDaimyoId(0);
            knightV.setSpotId(0);
            knightV.setEmployee(false);
        }
    }

    public static void retireKnight(GameDataV gameDataV, DaimyoV daimyoV, KnightV knightV, List<Pair<Integer, Notice>> list) {
        if (knightV.getDaimyoId() != daimyoV.getId()) {
            return;
        }
        Notice notice = GameNoticeCreator.retire(daimyoV.getKnight(), knightV);
        list.add(new Pair<Integer, Notice>(99, notice));
        daimyoV.getKnight().setDaimyoId(0);
        daimyoV.getKnight().setDisappear(true);
        daimyoV.setKnightId(knightV.getId());
    }

    public static void releaseKnight(GameDataV gameDataV, KnightV knightV) {
        if (knightV.getKnight().isKokujin()) {
            knightV.setSpotId(knightV.getKnight().getSpotId());
            knightV.setDaimyoId(knightV.getSpot().getDaimyoId());
            knightV.setEmployee(false);
        } else {
            knightV.setDaimyoId(0);
            knightV.setEmployee(false);
            if (knightV.getKnight().getSpotId() == 0) {
                int n = GameUtil.getRandomSpotId(gameDataV);
                knightV.setSpotId(n);
            } else {
                knightV.setSpotId(knightV.getKnight().getSpotId());
            }
        }
    }

    public static boolean reflectActions(GameDataV gameDataV, int n, List<CommandV> list, List<Pair<Integer, Notice>> list2) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        list.sort((commandV, commandV2) -> commandV.getKind() - commandV2.getKind());
        for (CommandV commandV3 : list) {
            if (!GameCommandUtil.reflectAction(gameDataV, commandV3, daimyoV, list2)) continue;
            return true;
        }
        return false;
    }

    public static boolean reflectAction(GameDataV gameDataV, CommandV commandV, DaimyoV daimyoV, List<Pair<Integer, Notice>> list) {
        int n = commandV.getKind();
        int n2 = commandV.getCost();
        int n3 = daimyoV.getId();
        int n4 = daimyoV.getMoney();
        if (n4 < n2) {
            Notice notice = GameNoticeCreator.lostMoney();
            list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
            return false;
        }
        List list2 = commandV.getArgs();
        switch (n) {
            case 2: {
                Build build;
                int n5 = (Integer)list2.get(0);
                int n6 = (Integer)list2.get(1);
                int n7 = (Integer)list2.get(2);
                int n8 = (Integer)list2.get(3);
                CountryV countryV = (CountryV)gameDataV.getCountries().get(n5);
                List list3 = countryV.getBuildPlans();
                if (!list3.isEmpty() || !GameCommandUtil.canBuild(daimyoV, build = (Build)gameDataV.getGameData().getBuilds().get(n6), (SpotV)gameDataV.getSpots().get(n7), gameDataV.getWorld().getYear())) break;
                daimyoV.setMoneyChange(11, -1 * n2);
                double d = gameDataV.getWorld().getInflationRate();
                double d2 = (double)(100 - daimyoV.getDiscount()) / 100.0;
                BuildPlan buildPlan = new BuildPlan(n6, n7, n2, (int)Math.ceil(d * d2 * (double)build.getCost()), 0, n8);
                buildPlan.setGameDataV(gameDataV);
                list3.add(buildPlan);
                countryV.setBuildPlans(list3);
                break;
            }
            case 1: {
                daimyoV.setMoneyChange(11, -1 * n2);
                int n9 = (Integer)list2.get(0);
                CountryV countryV = (CountryV)gameDataV.getCountries().get(n9);
                List list4 = countryV.getBuildPlans();
                if (list4.isEmpty()) break;
                list4.remove(0);
                countryV.setBuildPlans(list4);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                int n10 = (Integer)list2.get(0);
                int n11 = (Integer)list2.get(1);
                CountryV countryV = (CountryV)gameDataV.getCountries().get(n11);
                KnightV knightV = (KnightV)gameDataV.getKnights().get(n10);
                if (knightV.getDaimyoId() != 0 || countryV.getDaimyoId() != n3) break;
                knightV.setDaimyoId(n3);
                knightV.setSpotId(0);
                knightV.setRentalDaimyoId(0);
                knightV.setUnmoveMonth(0);
                if (!knightV.getKnight().isKokujin()) {
                    knightV.setEmployee(true);
                }
                daimyoV.setMoneyChange(12, -1 * n2);
                Notice notice = GameNoticeCreator.assignKnight(countryV, knightV);
                list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
                break;
            }
            case 7: {
                int n12 = (Integer)list2.get(0);
                int n13 = (Integer)list2.get(1);
                CountryV countryV = (CountryV)gameDataV.getCountries().get(n13);
                GiantV giantV = (GiantV)gameDataV.getGiants().get(n12);
                if (giantV.getDaimyoId() != 0 || countryV.getDaimyoId() != n3) break;
                if (daimyoV.getCultureArv() < giantV.getGiant().getMinCulture()) {
                    Notice notice = GameNoticeCreator.assignGiantNg(daimyoV, giantV);
                    list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
                    break;
                }
                daimyoV.setMoneyChange(12, -1 * n2);
                giantV.setDaimyoId(n3);
                giantV.setSpotId(0);
                giantV.setMonth(0);
                Notice notice = GameNoticeCreator.assignGiant(countryV, giantV);
                list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
                break;
            }
            case 8: {
                int n14 = (Integer)list2.get(0);
                KnightV knightV = (KnightV)gameDataV.getKnights().get(n14);
                if (knightV.getDaimyoId() != n3) break;
                GameCommandUtil.releaseKnight(gameDataV, knightV);
                Notice notice = GameNoticeCreator.releaseKnight(knightV);
                list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
                break;
            }
            case 9: {
                int n15 = (Integer)list2.get(0);
                GiantV giantV = (GiantV)gameDataV.getGiants().get(n15);
                if (giantV.getDaimyoId() != n3) break;
                giantV.setSpotId(((CountryV)giantV.getDaimyo().getCountries().get(0)).getCapitalSpot().getId());
                giantV.setDaimyoId(0);
                giantV.setMonth(0);
                break;
            }
            case 10: {
                int n16 = (Integer)list2.get(0);
                KnightV knightV = (KnightV)gameDataV.getKnights().get(n16);
                if (knightV.getDaimyoId() != n3) break;
                daimyoV.setMoneyChange(12, -1 * n2);
                knightV.setEmployee(true);
                Notice notice = GameNoticeCreator.absorpKnight(knightV);
                list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
                break;
            }
            case 11: {
                int n17 = (Integer)list2.get(0);
                KnightV knightV = (KnightV)gameDataV.getKnights().get(n17);
                GameCommandUtil.retireKnight(gameDataV, daimyoV, knightV, list);
                break;
            }
            case 16: {
                int n18 = (Integer)list2.get(0);
                KnightV knightV = (KnightV)gameDataV.getKnights().get(n18);
                int n19 = (Integer)list2.get(1);
                TreasureV treasureV = (TreasureV)gameDataV.getTreasures().get(n19);
                if (treasureV == null || knightV == null || treasureV.getDaimyoId() != daimyoV.getId() || !GameCommandUtil.isKnightTreasures(gameDataV, daimyoV.getId(), knightV)) break;
                treasureV.setKnightId(n18);
                treasureV.setStoreId(0);
                break;
            }
            case 17: {
                int n20 = (Integer)list2.get(0);
                int n21 = (Integer)list2.get(1);
                Research research = (Research)daimyoV.getResearches().get(n20);
                if (research == null || research.isComplete()) break;
                research.setKnightId(n21);
                break;
            }
            case 18: {
                int n22 = (Integer)list2.get(0);
                CountryV countryV = (CountryV)gameDataV.getCountries().get(n22);
                int[] nArray = GameCommandUtil.calcMission(countryV);
                int n23 = nArray[2];
                n2 = nArray[4];
                if (n2 > daimyoV.getMoney()) break;
                countryV.setMissionary(n23);
                break;
            }
            case 19: {
                int n24 = (Integer)list2.get(0);
                CountryV countryV = (CountryV)gameDataV.getCountries().get(n24);
                if (countryV.getDaimyo().isCanHongan()) break;
                GameCommandUtil.appearIkkou(gameDataV, countryV, list);
                break;
            }
            case 15: {
                int n25 = (Integer)list2.get(0);
                if (!GameCommandUtil.canSoubuji(gameDataV, n25)) break;
                return true;
            }
        }
        return false;
    }

    public static void reflectActions(GameDataV gameDataV, StoreAction storeAction, int n, List<Pair<Integer, Notice>> list) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        int n2 = storeAction.getStoreId();
        int n3 = storeAction.getGun();
        int n4 = storeAction.getHorse();
        int n5 = storeAction.getIron();
        int n6 = storeAction.getGunpauder();
        int n7 = storeAction.getSaltpater();
        List<Integer> list2 = storeAction.getTreasures();
        List<Present> list3 = storeAction.getPresents();
        int n8 = GameCostUtil.price(gameDataV, n, n2, n3, n4, n5, n6, n7, list2);
        if (daimyoV.getMoney() < n8) {
            return;
        }
        StoreV storeV = (StoreV)gameDataV.getStores().get(n2);
        if (!storeV.getFriendship().containsKey(n)) {
            storeV.getFriendship().put(n, 0);
        }
        int n9 = GameCostUtil.storeFriendShip(gameDataV, n2, n8);
        storeV.getFriendship().put(n, (Integer)storeV.getFriendship().get(n) + n9);
        daimyoV.setMoneyChange(15, -1 * n8);
        daimyoV.setGun(daimyoV.getGun() + n3);
        daimyoV.setHorse(daimyoV.getHorse() + n4);
        daimyoV.setIron(daimyoV.getIron() + n5);
        daimyoV.setGunpowder(daimyoV.getGunpowder() + n6);
        daimyoV.setSaltpeter(daimyoV.getSaltpeter() + n7);
        for (int n10 : list2) {
            TreasureV treasureV = (TreasureV)gameDataV.getTreasures().get(n10);
            if (treasureV == null || treasureV.getStoreId() != n2) continue;
            treasureV.setStoreId(0);
            treasureV.setKnightId(daimyoV.getKnightId());
        }
        for (Present present : list3) {
            int n11 = present.getFriendship();
            int n12 = present.getTechnologyId();
            TechnologyV technologyV = (TechnologyV)gameDataV.getTechnologies().get(n12);
            if (technologyV == null || daimyoV.getTechnologyIds().contains(n12) || n11 > (Integer)storeV.getFriendship().get(n)) continue;
            storeV.getFriendship().put(n, (Integer)storeV.getFriendship().get(n) - n11);
            daimyoV.getTechnologyIds().add(n12);
            Notice notice = GameNoticeCreator.getTechnology(storeV, technologyV);
            list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
        }
        storeV.updateTreatTreasures();
    }

    public static void reflectActions(GameDataV gameDataV, NegotiationAction negotiationAction, List<Pair<Integer, Notice>> list) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(negotiationAction.getSelfEntry().getDaimyoId());
        DaimyoV daimyoV2 = (DaimyoV)gameDataV.getDaimyos().get(negotiationAction.getTargetEntry().getDaimyoId());
        NegotiationActionEntry negotiationActionEntry = negotiationAction.getSelfEntry();
        NegotiationActionEntry negotiationActionEntry2 = negotiationAction.getTargetEntry();
        GameCommandUtil.reflectActions(gameDataV, negotiationActionEntry, daimyoV, daimyoV2, list);
        GameCommandUtil.reflectActions(gameDataV, negotiationActionEntry2, daimyoV2, daimyoV, list);
    }

    public static void reflectActions(GameDataV gameDataV, NegotiationActionEntry negotiationActionEntry, DaimyoV daimyoV, DaimyoV daimyoV2, List<Pair<Integer, Notice>> list) {
        RoleV roleV;
        for (int n : negotiationActionEntry.getTechnologyIds()) {
            if (!daimyoV.getTechnologyIds().contains(n) || daimyoV2.getTechnologyIds().contains(n)) continue;
            daimyoV2.getTechnologyIds().add(n);
        }
        for (int n : negotiationActionEntry.getCultureIds()) {
            if (!daimyoV.getCultureIds().contains(n) || daimyoV2.getCultureIds().contains(n)) continue;
            daimyoV2.getCultureIds().add(n);
        }
        for (int n : negotiationActionEntry.getRoleIds()) {
            if (gameDataV.getWorld().getKingFamilyId() != daimyoV.getId() || (roleV = (RoleV)gameDataV.getRoles().get(n)) == null) continue;
            roleV.setDaimyoId(daimyoV2.getId());
            Notice notice = GameNoticeCreator.role(daimyoV2, roleV);
            list.add(new Pair<Integer, Notice>(99, notice));
            notice = GameHistoryCreator.role(roleV);
            list.add(new Pair<Integer, Notice>(daimyoV2.getId(), notice));
        }
        daimyoV.setMoneyChange(13, -1 * negotiationActionEntry.getMoney());
        daimyoV2.setMoneyChange(5, negotiationActionEntry.getMoney());
        daimyoV.setGun(daimyoV.getGun() - negotiationActionEntry.getGun());
        daimyoV2.setGun(daimyoV2.getGun() + negotiationActionEntry.getGun());
        daimyoV.setHorse(daimyoV.getHorse() - negotiationActionEntry.getHorse());
        daimyoV2.setHorse(daimyoV2.getHorse() + negotiationActionEntry.getHorse());
        daimyoV.setIron(daimyoV.getIron() - negotiationActionEntry.getIron());
        daimyoV2.setIron(daimyoV2.getIron() + negotiationActionEntry.getIron());
        daimyoV.setGunpowder(daimyoV.getGunpowder() - negotiationActionEntry.getGunpowder());
        daimyoV2.setGunpowder(daimyoV2.getGunpowder() + negotiationActionEntry.getGunpowder());
        daimyoV.setSaltpeter(daimyoV.getSaltpeter() - negotiationActionEntry.getSaltpeter());
        daimyoV2.setSaltpeter(daimyoV2.getSaltpeter() + negotiationActionEntry.getSaltpeter());
        if (negotiationActionEntry.isAlliance()) {
            GameCommandUtil.alliance(gameDataV, daimyoV, daimyoV2, list);
        }
        if (negotiationActionEntry.isNonAggression()) {
            GameCommandUtil.nonAggression(gameDataV, daimyoV, daimyoV2, list);
        }
        if (negotiationActionEntry.isBorder()) {
            GameCommandUtil.borderResolve(gameDataV, daimyoV, daimyoV2, list);
        }
        if (negotiationActionEntry.isDetente()) {
            GameCommandUtil.detente(gameDataV, daimyoV, daimyoV2, list);
        }
        if (negotiationActionEntry.isBreakWith()) {
            GameCommandUtil.breakWith(gameDataV, daimyoV, daimyoV2, false, list);
        }
        if (negotiationActionEntry.isSurrender()) {
            GameCommandUtil.surrender(gameDataV, daimyoV, daimyoV2, list);
        }
        for (int n : negotiationActionEntry.getBreakIds()) {
            roleV = (DaimyoV)gameDataV.getDaimyos().get(n);
            if (roleV == null) continue;
            GameCommandUtil.breakWith(gameDataV, daimyoV, (DaimyoV)roleV, false, list);
        }
        for (int n : negotiationActionEntry.getEnemyToIds()) {
            roleV = (DaimyoV)gameDataV.getDaimyos().get(n);
            GameCommandUtil.enemy(gameDataV, daimyoV, (DaimyoV)roleV, list);
        }
        for (int n : negotiationActionEntry.getToubatsuToIds()) {
            roleV = (DaimyoV)gameDataV.getDaimyos().get(n);
            GameCommandUtil.toubatsu(gameDataV, (DaimyoV)roleV, list);
        }
        for (int n : negotiationActionEntry.getToubatsuRemoveIds()) {
            roleV = (DaimyoV)gameDataV.getDaimyos().get(n);
            GameCommandUtil.toubatsuRemove(gameDataV, (DaimyoV)roleV, list);
        }
        for (int n : negotiationActionEntry.getRentalKnightIds()) {
            roleV = (KnightV)gameDataV.getKnights().get(n);
            if (roleV.getDaimyoId() != daimyoV.getId()) continue;
            roleV.setRentalDaimyoId(daimyoV2.getId());
        }
        for (int n : negotiationActionEntry.getRentalReturnKnightIds()) {
            roleV = (KnightV)gameDataV.getKnights().get(n);
            if (roleV.getRentalDaimyoId() != daimyoV.getId() || roleV.getDaimyoId() != daimyoV2.getId()) continue;
            roleV.setRentalDaimyoId(0);
        }
    }

    private static void alliance(GameDataV gameDataV, DaimyoV daimyoV, DaimyoV daimyoV2, List<Pair<Integer, Notice>> list) {
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(daimyoV.getId(), daimyoV2.getId());
        if (unmodifiableReration.getStatus() == 1 || unmodifiableReration.getStatus() == 7 || unmodifiableReration.getStatus() == 6) {
            return;
        }
        Notice notice = GameNoticeCreator.alliance(daimyoV, daimyoV2);
        list.add(new Pair<Integer, Notice>(99, notice));
        notice = GameNoticeCreator.allianceTo(daimyoV2);
        list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
        notice = GameNoticeCreator.allianceTo(daimyoV);
        list.add(new Pair<Integer, Notice>(daimyoV2.getId(), notice));
        gameDataV.alliance(daimyoV.getId(), daimyoV2.getId());
        daimyoV.updateColoniesAndOwner();
        daimyoV2.updateColoniesAndOwner();
    }

    private static void nonAggression(GameDataV gameDataV, DaimyoV daimyoV, DaimyoV daimyoV2, List<Pair<Integer, Notice>> list) {
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(daimyoV.getId(), daimyoV2.getId());
        if (unmodifiableReration.getStatus() == 1 || unmodifiableReration.getStatus() == 7 || unmodifiableReration.getStatus() == 6 || unmodifiableReration.getStatus() == 2 || unmodifiableReration.getNonAggression() > 0) {
            return;
        }
        Notice notice = GameNoticeCreator.nonAggression(daimyoV, daimyoV2);
        list.add(new Pair<Integer, Notice>(99, notice));
        notice = GameNoticeCreator.nonAggressionTo(daimyoV2);
        list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
        notice = GameNoticeCreator.nonAggressionTo(daimyoV);
        list.add(new Pair<Integer, Notice>(daimyoV2.getId(), notice));
        gameDataV.stopWar(daimyoV.getId(), daimyoV2.getId());
        if (0 < GameTacticsUtil.releaseUnitOn(gameDataV, daimyoV, daimyoV2)) {
            notice = GameNoticeCreator.releaseUnitOn(daimyoV2);
            list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
        }
        if (0 < GameTacticsUtil.releaseUnitOn(gameDataV, daimyoV2, daimyoV)) {
            notice = GameNoticeCreator.releaseUnitOn(daimyoV);
            list.add(new Pair<Integer, Notice>(daimyoV2.getId(), notice));
        }
    }

    private static void surrender(GameDataV gameDataV, DaimyoV daimyoV, DaimyoV daimyoV2, List<Pair<Integer, Notice>> list) {
        if (!daimyoV2.isIndependent()) {
            return;
        }
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(daimyoV2.getId(), daimyoV.getId());
        if (unmodifiableReration.getStatus() == 6) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(daimyoV.getColonies());
        for (DaimyoV daimyoV3 : arrayList) {
            GameCommandUtil.breakWith(gameDataV, daimyoV, daimyoV3, true, list);
            GameCommandUtil.surrender(gameDataV, daimyoV2, daimyoV3, list);
        }
        arrayList.clear();
        arrayList.addAll(daimyoV.getAlliances());
        for (DaimyoV daimyoV3 : arrayList) {
            GameCommandUtil.breakWith(gameDataV, daimyoV, daimyoV3, true, list);
        }
        arrayList.clear();
        arrayList.addAll(daimyoV.getNonAggressions());
        for (DaimyoV daimyoV3 : arrayList) {
            GameCommandUtil.breakWithNonAggression(gameDataV, daimyoV, daimyoV3, list);
        }
        if (daimyoV.getOwner() != null) {
            GameCommandUtil.breakWith(gameDataV, daimyoV, daimyoV.getOwner(), true, list);
        }
        Notice notice = GameNoticeCreator.surrender(daimyoV2, daimyoV);
        list.add(new Pair<Integer, Object>(99, notice));
        gameDataV.surrender(daimyoV2.getId(), daimyoV.getId());
        daimyoV2.updateColoniesAndOwner();
        daimyoV.updateColoniesAndOwner();
    }

    public static void breakWith(GameDataV gameDataV, int n, int n2, boolean bl, List<Pair<Integer, Notice>> list) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        DaimyoV daimyoV2 = (DaimyoV)gameDataV.getDaimyos().get(n2);
        GameCommandUtil.breakWith(gameDataV, daimyoV, daimyoV2, bl, list);
    }

    private static void breakWithNonAggression(GameDataV gameDataV, DaimyoV daimyoV, DaimyoV daimyoV2, List<Pair<Integer, Notice>> list) {
        if (gameDataV.isNonAggression(daimyoV.getId(), daimyoV2.getId())) {
            gameDataV.none(daimyoV.getId(), daimyoV2.getId());
            daimyoV.updateColoniesAndOwner();
            daimyoV2.updateColoniesAndOwner();
        }
    }

    private static void breakWith(GameDataV gameDataV, DaimyoV daimyoV, DaimyoV daimyoV2, boolean bl, List<Pair<Integer, Notice>> list) {
        if (gameDataV.isAllianceLike(daimyoV.getId(), daimyoV2.getId())) {
            gameDataV.none(daimyoV.getId(), daimyoV2.getId());
            if (!bl) {
                int n = gameDataV.getParameters().getHatePeriod();
                gameDataV.setHate(daimyoV2.getId(), daimyoV.getId(), n);
                Notice notice = GameNoticeCreator.breakWith(daimyoV, daimyoV2);
                list.add(new Pair<Integer, Notice>(99, notice));
                notice = GameNoticeCreator.breakWith1(daimyoV2);
                list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
                notice = GameNoticeCreator.breakWith2(daimyoV);
                list.add(new Pair<Integer, Notice>(daimyoV2.getId(), notice));
            }
            if (0 < GameTacticsUtil.releaseUnitOn(gameDataV, daimyoV, daimyoV2)) {
                Notice notice = GameNoticeCreator.releaseUnitOn(daimyoV2);
                list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
            }
            if (0 < GameTacticsUtil.releaseUnitOn(gameDataV, daimyoV2, daimyoV)) {
                Notice notice = GameNoticeCreator.releaseUnitOn(daimyoV);
                list.add(new Pair<Integer, Notice>(daimyoV2.getId(), notice));
            }
            daimyoV.updateColoniesAndOwner();
            daimyoV2.updateColoniesAndOwner();
        }
    }

    public static void enemy(GameDataV gameDataV, int n, int n2, List<Pair<Integer, Notice>> list) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        DaimyoV daimyoV2 = (DaimyoV)gameDataV.getDaimyos().get(n2);
        GameCommandUtil.enemy(gameDataV, daimyoV, daimyoV2, list);
    }

    private static void enemy(GameDataV gameDataV, DaimyoV daimyoV, DaimyoV daimyoV2, List<Pair<Integer, Notice>> list) {
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(daimyoV.getId(), daimyoV2.getId());
        if (unmodifiableReration.getStatus() != 4) {
            Notice notice = GameNoticeCreator.declarationOfEnemy(gameDataV, daimyoV, daimyoV2);
            if (notice != null) {
                list.add(new Pair<Integer, Notice>(daimyoV2.getId(), notice));
            }
            notice = GameNoticeCreator.enemy(daimyoV, daimyoV2);
            list.add(new Pair<Integer, Notice>(99, notice));
            notice = GameNoticeCreator.enemyTo(daimyoV2);
            list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
            notice = GameNoticeCreator.enemyTo(daimyoV);
            list.add(new Pair<Integer, Notice>(daimyoV2.getId(), notice));
            gameDataV.enemy(daimyoV.getId(), daimyoV2.getId());
            daimyoV.updateColoniesAndOwner();
            daimyoV2.updateColoniesAndOwner();
        }
    }

    public static void toubatsu(GameDataV gameDataV, int n, List<Pair<Integer, Notice>> list) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        GameCommandUtil.toubatsu(gameDataV, daimyoV, list);
    }

    private static void toubatsu(GameDataV gameDataV, DaimyoV daimyoV, List<Pair<Integer, Notice>> list) {
        int n = gameDataV.getParameters().getToubatsuPeriod();
        daimyoV.setToubatsuLeave(n);
        Notice notice = GameNoticeCreator.toubatsu(daimyoV);
        list.add(new Pair<Integer, Notice>(99, notice));
        notice = GameHistoryCreator.toubatsu();
        list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
    }

    private static void toubatsuRemove(GameDataV gameDataV, DaimyoV daimyoV, List<Pair<Integer, Notice>> list) {
        daimyoV.setToubatsuLeave(0);
        Notice notice = GameNoticeCreator.toubatsuRemove(daimyoV);
        list.add(new Pair<Integer, Notice>(99, notice));
        notice = GameHistoryCreator.toubatsuRemove();
        list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
    }

    private static void borderResolve(GameDataV gameDataV, DaimyoV daimyoV, DaimyoV daimyoV2, List<Pair<Integer, Notice>> list) {
        gameDataV.getBorderConflicts().removeIf(borderConflictV -> borderConflictV.getDaimyoId1() == daimyoV.getId() && borderConflictV.getDaimyoId2() == daimyoV2.getId() || borderConflictV.getDaimyoId2() == daimyoV.getId() && borderConflictV.getDaimyoId1() == daimyoV2.getId());
    }

    private static void detente(GameDataV gameDataV, DaimyoV daimyoV, DaimyoV daimyoV2, List<Pair<Integer, Notice>> list) {
        UnmodifiableReration unmodifiableReration = gameDataV.getRelation(daimyoV.getId(), daimyoV2.getId());
        if (unmodifiableReration.getStatus() == 4) {
            gameDataV.none(daimyoV.getId(), daimyoV2.getId());
            Notice notice = GameNoticeCreator.detente(daimyoV, daimyoV2);
            list.add(new Pair<Integer, Notice>(99, notice));
            notice = GameNoticeCreator.detenteTo(daimyoV2);
            list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
            notice = GameNoticeCreator.detenteTo(daimyoV);
            list.add(new Pair<Integer, Notice>(daimyoV2.getId(), notice));
            daimyoV.updateColoniesAndOwner();
            daimyoV2.updateColoniesAndOwner();
        }
    }

    public static boolean canBuild(DaimyoV daimyoV, Build build2, SpotV spotV2, int n) {
        if (build2.isUnbuild()) {
            return false;
        }
        if (build2.getSpotId() == 0 || build2.getSpotId() == spotV2.getId()) {
            CountryV countryV = spotV2.getCountry();
            if (build2.getResources() != 0 && !countryV.getCountry().getResources().contains(build2.getResources())) {
                return false;
            }
            if (build2.isUnique()) {
                if (countryV.getSpots().stream().anyMatch(spotV -> spotV.getBuildIds().contains(build2.getId()))) {
                    return false;
                }
                if (countryV.getBuildPlans().stream().anyMatch(buildPlan -> buildPlan.getBuild().getId() == build2.getId())) {
                    return false;
                }
            }
            if (!build2.getCondition().judge(n, countryV)) {
                return false;
            }
            if (spotV2.getBuildIds().contains(build2.getId())) {
                return false;
            }
            if (countryV.getBuildPlans().stream().anyMatch(buildPlan -> buildPlan.getBuild().getId() == build2.getId() && buildPlan.getSpotId() == spotV2.getId())) {
                return false;
            }
            switch (spotV2.getType()) {
                case 1: {
                    if (build2.isPlain()) break;
                    return false;
                }
                case 2: {
                    if (build2.isMount()) break;
                    return false;
                }
                case 3: {
                    if (build2.isSeaSide()) break;
                    return false;
                }
                case 4: {
                    return false;
                }
            }
            return build2.getKind() != 8 || !spotV2.getBuilds().stream().allMatch(build -> build.getKind() != 7);
        }
        return false;
    }

    public static Map<Integer, List<Integer>> getMakableBuilds(GameDataV gameDataV, int n) {
        HashMap<Integer, List<Integer>> hashMap = new HashMap<Integer, List<Integer>>();
        CountryV countryV = (CountryV)gameDataV.getCountries().get(n);
        for (Build build : gameDataV.getGameData().getBuilds().values()) {
            if (build.isUnbuild() || build.getSpotId() != 0 && !countryV.getSpotIds().contains(build.getSpotId())) continue;
            List list = null;
            int n2 = gameDataV.getWorld().getYear();
            list = countryV.getSpots().stream().filter(spotV -> GameCommandUtil.canBuild(countryV.getDaimyo(), build, spotV, n2)).mapToInt(spotV -> spotV.getId()).boxed().collect(Collectors.toList());
            hashMap.put(build.getId(), list);
        }
        return hashMap;
    }

    public static List<KnightV> getKnightEmploies(GameDataV gameDataV, int n) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        List<KnightV> list = daimyoV.getCountries().parallelStream().flatMap(countryV -> countryV.getSpots().stream()).flatMap(spotV -> spotV.getKnights().stream()).filter(knightV -> !knightV.getKnight().isKokujin()).collect(Collectors.toList());
        return list;
    }

    public static List<KnightV> getKnightEmploies(GameDataV gameDataV, int n, int n2) {
        CountryV countryV = (CountryV)gameDataV.getCountries().get(n2);
        List<KnightV> list = countryV.getSpots().parallelStream().flatMap(spotV -> spotV.getKnights().stream()).filter(knightV -> knightV.getDaimyoId() == n).filter(knightV -> !knightV.getKnight().isKokujin()).collect(Collectors.toList());
        return list;
    }

    public static List<GiantV> getGiantEmploies(GameDataV gameDataV, int n) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        List<GiantV> list = daimyoV.getCountries().parallelStream().flatMap(countryV -> countryV.getSpots().stream()).flatMap(spotV -> spotV.getGiants().stream()).filter(giantV -> !daimyoV.getTechnologyIds().contains(giantV.getGiant().getTechnologyId()) && !daimyoV.getCultureIds().contains(giantV.getGiant().getCultureId())).collect(Collectors.toList());
        return list;
    }

    public static List<KnightV> getKnightResearchs(GameDataV gameDataV, int n, PlayerV playerV) {
        return GameCommandUtil.getKnightBuilds(gameDataV, n, playerV);
    }

    public static List<KnightV> getKnightBuilds(GameDataV gameDataV, int n, PlayerV playerV) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        ArrayList<KnightV> arrayList = new ArrayList<KnightV>();
        arrayList.addAll(daimyoV.getBeingKnights());
        arrayList.add(0, daimyoV.getKnight());
        arrayList.removeIf(knightV -> {
            if (!knightV.isEmployee()) {
                return true;
            }
            for (CountryV countryV : daimyoV.getCountries()) {
                for (BuildPlan buildPlan : countryV.getBuildPlans()) {
                    if (knightV.getId() != buildPlan.getKnightId()) continue;
                    return true;
                }
            }
            for (CountryV countryV : daimyoV.getResearches().values()) {
                if (knightV.getId() != countryV.getKnightId()) continue;
                return true;
            }
            for (CountryV countryV : playerV.getCommands()) {
                if (countryV.getKind() == 2 && knightV.getId() == ((Integer)countryV.getArgs().get(3)).intValue()) {
                    return true;
                }
                if (countryV.getKind() != 17 || knightV.getId() != ((Integer)countryV.getArgs().get(1)).intValue()) continue;
                return true;
            }
            return false;
        });
        return arrayList;
    }

    public static List<KnightV> getKnightAppoints(GameDataV gameDataV, int n, PlayerV playerV) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        List<KnightV> list = daimyoV.getKnights().parallelStream().filter(knightV -> !knightV.isGoOut() && knightV.isEmployee()).collect(Collectors.toList());
        playerV.getCommands().stream().filter(commandV -> commandV.getKind() == 12).forEach(commandV -> list.removeIf(knightV -> knightV.getId() == ((Integer)commandV.getArgs().get(0)).intValue()));
        return list;
    }

    public static List<KnightV> getKnightAssigns(GameDataV gameDataV, int n, int n2) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        List<KnightV> list = daimyoV.getKnights().parallelStream().filter(knightV -> !knightV.isGoOut() && knightV.isEmployee()).collect(Collectors.toList());
        return list;
    }

    public static List<GiantV> getGiantAssigns(GameDataV gameDataV, int n, int n2) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        List<GiantV> list = daimyoV.getGiants().parallelStream().collect(Collectors.toList());
        return list;
    }

    public static List<KnightV> getKnightRelease(GameDataV gameDataV, int n) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        List<KnightV> list = daimyoV.getKnights().parallelStream().filter(knightV -> knightV.isEmployee()).filter(knightV -> !knightV.isGoOut()).collect(Collectors.toList());
        return list;
    }

    public static List<GiantV> getGiantRelease(GameDataV gameDataV, int n) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        List list = daimyoV.getGiants();
        return list;
    }

    public static List<KnightV> getKnightAbsorb(GameDataV gameDataV, int n) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        List<KnightV> list = daimyoV.getKnights().parallelStream().filter(knightV -> knightV.getKnight().isKokujin() && !knightV.isEmployee()).collect(Collectors.toList());
        return list;
    }

    public static List<KnightV> getKnightRetire(GameDataV gameDataV, int n) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        List<KnightV> list = daimyoV.getKnights().parallelStream().filter(knightV -> knightV.isEmployee()).filter(knightV -> !knightV.isGoOut()).collect(Collectors.toList());
        return list;
    }

    public static List<TreasureV> getTreasures(GameDataV gameDataV, int n) {
        List<TreasureV> list = gameDataV.getTreasures().values().stream().filter(treasureV -> treasureV.getKnightId() != 0).filter(treasureV -> treasureV.getKnight().getDaimyoId() == n).filter(treasureV -> treasureV.getKnight().isEmployee()).collect(Collectors.toList());
        return list;
    }

    public static List<KnightV> getKnightTreasures(GameDataV gameDataV, int n) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        List<KnightV> list = daimyoV.getKnightsWithTop().parallelStream().filter(knightV -> GameCommandUtil.isKnightTreasures(gameDataV, n, knightV)).collect(Collectors.toList());
        return list;
    }

    public static boolean isKnightTreasures(GameDataV gameDataV, int n, KnightV knightV) {
        return knightV.isEmployee() && knightV.getDaimyoId() == n && knightV.getRentalDaimyoId() == 0;
    }

    public static List<TechnologyV> getProgressTechnology(GameDataV gameDataV, int n) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        List<TechnologyV> list = gameDataV.getTechnologies().values().stream().filter(technologyV -> technologyV.getTechnology().isCanStudy()).filter(technologyV -> !daimyoV.getTechnologyIds().contains(technologyV.getId())).collect(Collectors.toList());
        list.addAll(daimyoV.getTechnologies());
        return list;
    }

    public static int getForNextRank(GameDataV gameDataV, DaimyoV daimyoV) {
        int n = gameDataV.getGameData().getRanks().values().stream().filter(rank -> rank.getMinCulture() > daimyoV.getCultureArv()).sorted((rank, rank2) -> rank.getMinCulture() - rank2.getMinCulture()).mapToInt(rank -> rank.getMinCulture()).findFirst().orElse(-1);
        int n2 = n - daimyoV.getCultureArv();
        return n2;
    }

    public static boolean isBuildPlaned(PlayerV playerV, CountryV countryV) {
        boolean bl = playerV.getCommands().stream().filter(commandV -> commandV.getKind() == 2).anyMatch(commandV -> countryV.getId() == ((Integer)commandV.getArgs().get(0)).intValue());
        return bl;
    }

    public static boolean isBuildCanceled(PlayerV playerV, CountryV countryV) {
        boolean bl = playerV.getCommands().stream().filter(commandV -> commandV.getKind() == 1).anyMatch(commandV -> countryV.getId() == ((Integer)commandV.getArgs().get(0)).intValue());
        return bl;
    }

    public static boolean isBuildPlanExist(PlayerV playerV, CountryV countryV) {
        boolean bl = GameCommandUtil.isBuildPlaned(playerV, countryV);
        boolean bl2 = GameCommandUtil.isBuildCanceled(playerV, countryV);
        if (bl) {
            return true;
        }
        if (bl2) {
            return false;
        }
        return !countryV.getBuildPlans().isEmpty();
    }

    public static boolean canDomestic(GameDataV gameDataV, int n) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        return !daimyoV.isFall();
    }

    public static boolean canDiplomacy(GameDataV gameDataV, int n) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        return !daimyoV.isFall();
    }

    public static boolean canSoubuji(GameDataV gameDataV, int n) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        int n2 = gameDataV.getParameters().getSoubujiImpact();
        if (n2 <= daimyoV.getImpact()) {
            return true;
        }
        return daimyoV.getRank() != null && daimyoV.getRank().isTop();
    }

    public static void createNegotiationTarget(GameDataV gameDataV, int n, Set<Integer> set, Set<Integer> set2) {
        set.clear();
        set2.clear();
        for (DaimyoV daimyoV : gameDataV.getDaimyos().values()) {
            if (!GameCommandUtil.canNegotiationTarget(gameDataV, n, daimyoV.getId())) continue;
            set.add(daimyoV.getId());
        }
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        set2.addAll(daimyoV.getStoreIds());
    }

    public static void filterNegotiationTarget(GameDataV gameDataV, int n, Set<Integer> set) {
        set.removeIf(n2 -> !GameCommandUtil.canNegotiationTarget(gameDataV, n, n2));
    }

    public static boolean canNegotiationTarget(GameDataV gameDataV, int n, int n2) {
        if (n == n2) {
            return false;
        }
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        DaimyoV daimyoV2 = (DaimyoV)gameDataV.getDaimyos().get(n2);
        if (daimyoV == null || daimyoV2 == null) {
            return false;
        }
        if (daimyoV.isFall() || daimyoV2.isFall()) {
            return false;
        }
        if (!daimyoV.isIndependent() && daimyoV.getOwnerId() != daimyoV2.getId()) {
            return false;
        }
        return daimyoV2.isIndependent() || daimyoV2.getOwnerId() == daimyoV.getId();
    }

    public static boolean canTactics(GameDataV gameDataV, int n) {
        DaimyoV daimyoV = (DaimyoV)gameDataV.getDaimyos().get(n);
        if (daimyoV.isFall()) {
            return false;
        }
        return daimyoV.getOwner() == null;
    }

    public static GameHistory createHistory(GameDataV gameDataV, Notice notice) {
        WorldDataV worldDataV = gameDataV.getWorld();
        GameHistory gameHistory = new GameHistory();
        gameHistory.setTurn(worldDataV.getTurn());
        gameHistory.setYear(worldDataV.getYear());
        gameHistory.setMonth(worldDataV.getMonth());
        gameHistory.setDay(worldDataV.getDay());
        gameHistory.setGengo(worldDataV.getGengo());
        gameHistory.setGengoYear(worldDataV.getGengoYear());
        gameHistory.setIntercalary(worldDataV.isIntercalary());
        gameHistory.getMessages().addAll(notice.getMessages());
        return gameHistory;
    }

    public static int[] calcMission(CountryV countryV) {
        int n = countryV.getMissionary();
        int n2 = n / countryV.getPopulation();
        int n3 = Math.max(1, countryV.getPopulation() / 100) * 100;
        int n4 = n + n3;
        int n5 = n4 / countryV.getPopulation();
        int n6 = Math.max(1, n3 / 10);
        int[] nArray = new int[]{n, n2, n4, n5, n6};
        return nArray;
    }

    public static List<Build> getVisibleBuilds(SpotV spotV) {
        List<Build> list = spotV.getBuilds().stream().filter(build -> build.getIconFileName() != null).filter(build -> build.getKind() != 8).filter(build -> !"".equals(build.getIconFileName())).sorted((build, build2) -> GameCommandUtil.getViewPriority(build2) - GameCommandUtil.getViewPriority(build)).limit(8L).collect(Collectors.toList());
        return list;
    }

    public static List<Build> getCastles(SpotV spotV) {
        List<Build> list = spotV.getBuilds().stream().filter(build -> build.getIconFileName() != null).filter(build -> build.getKind() == 7).filter(build -> !"".equals(build.getIconFileName())).sorted((build, build2) -> GameCommandUtil.getViewPriority(build2) - GameCommandUtil.getViewPriority(build)).limit(8L).collect(Collectors.toList());
        return list;
    }

    private static int getViewPriority(Build build) {
        if (build.getKind() == 7) {
            return 99999;
        }
        if (build.getKind() == 11) {
            return 99998;
        }
        if (build.getKind() == 9) {
            return 99997;
        }
        if (build.getKind() == 10) {
            return 99996;
        }
        if (build.isUnbuild()) {
            return 99995;
        }
        if (build.getSpotId() != 0) {
            return 10000 + build.getCost();
        }
        return build.getCost();
    }

    private static int getSalary(GameDataV gameDataV, KnightV knightV) {
        int n = gameDataV.getParameters().getKnightPay();
        double d = knightV.getKnight().getDomestic() + knightV.getDomesticPlus() + knightV.getKnight().getTactics() + knightV.getTacticsPlus() + knightV.getKnight().getCulture() + knightV.getCulturePlus();
        int n2 = (int)Math.ceil((double)n * d / 10.0) + 1;
        return n2;
    }

    public static void createDomesticMessage(GameDataV gameDataV, DaimyoV daimyoV, PlayerV playerV, List<Pair<KnightV, String>> list) {
        CountryV countryV2;
        Object object;
        KnightV knightV2;
        list.clear();
        if (daimyoV.getEmployeeKnights().isEmpty()) {
            list.add(new Pair<KnightV, String>(daimyoV.getKnight(), "\u5f53\u5bb6\u306b\u306f\u307e\u3060\u5bb6\u81e3\u304c\u5c45\u306a\u3044\u3002\u307e\u305a\u306f\u4eba\u4e8b\u30b3\u30de\u30f3\u30c9\u306e\u96c7\u7528\u304b\u53d6\u8fbc\u3092\u5b9f\u884c\u3057\u3066\u3001\u65b0\u3057\u304f\u5bb6\u81e3\u3092\u63a1\u7528\u3059\u308b\u306e\u304c\u826f\u3044\u3060\u308d\u3046\u3002"));
            return;
        }
        if (daimyoV.getFame() < 0 && !daimyoV.isDark()) {
            knightV2 = (KnightV)GameUtil.getRandom(daimyoV.getEmployeeKnights());
            list.add(new Pair<KnightV, String>(knightV2, "\u5f53\u5bb6\u306b\u5bfe\u3057\u3066\u60aa\u540d\u304c\u7acb\u3063\u3066\u3044\u308b\u3088\u3046\u3067\u3059\u3002\u60aa\u540d\u304c\u7acb\u3064\u3068\u3001\u5916\u4ea4\u95a2\u4fc2\u306b\u60aa\u5f71\u97ff\u304c\u51fa\u307e\u3059\u3002\u307e\u305f\u3001\u60aa\u540d\u72b6\u614b\u306e\u9593\u3001\u6240\u5c5e\u3059\u308b\u56fd\u3067\u6587\u5316\u306e\u5897\u52a0\u304c\u505c\u6b62\u3057\u3001\u6c11\u5fe0\u304c\u6bce\u6708\u4f4e\u4e0b\u3057\u307e\u3059\u3002"));
        }
        if (!(knightV2 = GameCommandUtil.getGiantEmploies(gameDataV, daimyoV.getId())).isEmpty()) {
            object = (KnightV)GameUtil.getRandom(daimyoV.getEmployeeKnights());
            list.add(new Pair<KnightV, String>((KnightV)object, "\u5f53\u5bb6\u306e\u9818\u5185\u3092\u3001\u6587\u5316\u4eba\u304c\u8a2a\u308c\u3066\u3044\u308b\u3088\u3046\u3067\u3059\u3002\u6587\u5316\u4eba\u306f\u4eba\u4e8b\u306e\u96c7\u7528\u30b3\u30de\u30f3\u30c9\u304b\u3089\u96c7\u7528\u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u3059\u3002\u6587\u5316\u4eba\u3092\u96c7\u7528\u3059\u308b\u3068\u3001\u7279\u6b8a\u306a\u6587\u5316\u3084\u6280\u8853\u306e\u7814\u7a76\u304c\u51fa\u6765\u307e\u3059\u3002\u5f53\u5bb6\u306e\u6587\u5316\u5ea6\u304c\u4f4e\u3044\u3068\u96c7\u7528\u3067\u304d\u306a\u3044\u3053\u3068\u3082\u3042\u308a\u307e\u3059\u3002"));
        }
        if (daimyoV.getIron() + daimyoV.getIronPlus() < daimyoV.getGunPlus()) {
            object = (KnightV)GameUtil.getRandom(daimyoV.getEmployeeKnights());
            list.add(new Pair<KnightV, String>((KnightV)object, "\u9244\u304c\u4e0d\u8db3\u3057\u3066\u3044\u308b\u305f\u3081\u3001\u9244\u7832\u306e\u7523\u51fa\u304c\u4f4e\u4e0b\u3057\u3066\u3044\u307e\u3059\u3002\u9244\u7832\u306e\u7523\u51fa\u306b\u306f\u3001\u7523\u51fa\u3059\u308b\u9244\u7832\u3068\u540c\u6570\u306e\u9244\u304c\u5fc5\u8981\u3067\u3059\u3002"));
        }
        if (daimyoV.getSaltpeter() + daimyoV.getSaltpeterPlus() < daimyoV.getGunpowderPlus()) {
            object = (KnightV)GameUtil.getRandom(daimyoV.getEmployeeKnights());
            list.add(new Pair<Object, String>(object, "\u785d\u77f3\u304c\u4e0d\u8db3\u3057\u3066\u3044\u308b\u305f\u3081\u3001\u706b\u85ac\u306e\u7523\u51fa\u304c\u4f4e\u4e0b\u3057\u3066\u3044\u307e\u3059\u3002\u706b\u85ac\u306e\u7523\u51fa\u306b\u306f\u3001\u7523\u51fa\u3059\u308b\u706b\u85ac\u3068\u540c\u6570\u306e\u785d\u77f3\u304c\u5fc5\u8981\u3067\u3059\u3002"));
        }
        for (CountryV countryV2 : daimyoV.getCountries()) {
            if (GameCommandUtil.isBuildPlanExist(playerV, countryV2)) continue;
            KnightV knightV3 = (KnightV)GameUtil.getRandom(daimyoV.getEmployeeKnights());
            list.add(new Pair<KnightV, String>(knightV3, countryV2.getName() + "\u56fd\u306f\u5efa\u7bc9\u547d\u4ee4\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u5185\u653f\u30b3\u30de\u30f3\u30c9\u306e\u5efa\u7bc9\u304b\u3089\u3001\u5efa\u7bc9\u547d\u4ee4\u3092\u51fa\u3059\u3053\u3068\u304c\u51fa\u6765\u307e\u3059\u3002"));
        }
        for (CountryV countryV2 : daimyoV.getResearches().values()) {
            TechnologyV technologyV;
            int n = DomesticResearchUtil.getStatus(countryV2.getTechnologyId(), playerV);
            if (n != 2 && n != 3 || (technologyV = (TechnologyV)gameDataV.getTechnologies().get(countryV2.getTechnologyId())) == null) continue;
            KnightV knightV4 = (KnightV)GameUtil.getRandom(daimyoV.getEmployeeKnights());
            list.add(new Pair<KnightV, String>(knightV4, technologyV.getName() + "\u306e\u6280\u8853\u3092\u7814\u7a76\u3059\u308b\u3053\u3068\u304c\u53ef\u80fd\u3067\u3059\u3002\u5185\u653f\u30b3\u30de\u30f3\u30c9\u306e\u6280\u8853\u304b\u3089\u6280\u8853\u306e\u7814\u7a76\u3092\u958b\u59cb\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002\u6559\u990a\u306e\u9ad8\u3044\u6b66\u5c06\u307b\u3069\u3001\u65e9\u304f\u7814\u7a76\u3092\u5b8c\u4e86\u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u3059\u3002"));
        }
        int n = daimyoV.getEmployeeKnights().stream().mapToInt(knightV -> knightV.getTreasures().size()).max().orElse(0);
        if (2 <= n) {
            countryV2 = (KnightV)GameUtil.getRandom(daimyoV.getEmployeeKnights());
            list.add(new Pair<CountryV, String>(countryV2, "\u8907\u6570\u306e\u5bb6\u5b9d\u3092\u6240\u6709\u3057\u3066\u3044\u308b\u5834\u5408\u3001\u9805\u76ee\u3054\u3068\u306b\u6700\u3082\u52b9\u679c\u304c\u9ad8\u3044\u5bb6\u5b9d\u306e\u88dc\u6b63\u5024\u304c\u63a1\u7528\u3055\u308c\u307e\u3059\u3002\u4f8b\u3048\u3070\u3001\u6559\u990a+2\u3068\u6559\u990a+1\u3068\u5185\u653f+1\u306e\u5bb6\u5b9d\u3092\u6240\u6301\u3057\u3066\u3044\u308b\u5834\u5408\u3001\u88dc\u6b63\u5024\u306f\u6559\u990a+2\u3001\u5185\u653f+1\u3068\u306a\u308a\u307e\u3059\u3002"));
        }
        if (list.isEmpty()) {
            countryV2 = (KnightV)GameUtil.getRandom(daimyoV.getEmployeeKnights());
            list.add(new Pair<CountryV, String>(countryV2, "\u300c\u5b8c\u4e86\u300d\u3092\u9078\u629e\u3059\u308b\u3068\u3001\u5185\u653f\u30b3\u30de\u30f3\u30c9\u3092\u5b9f\u884c\u3057\u3066\u6b21\u306e\u30d5\u30a7\u30fc\u30ba\u306b\u79fb\u884c\u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u3059\u3002"));
        }
    }

    public static void createTacticsMessage(GameDataV gameDataV, DaimyoV daimyoV, PlayerV playerV, List<Tuple<KnightV, SpotV, String>> list) {
        list.clear();
        ArrayList<KnightV> arrayList = new ArrayList<KnightV>();
        arrayList.add(daimyoV.getKnight());
        arrayList.addAll(daimyoV.getEmployeeKnights());
        Set<Integer> set = GameTacticsUtil.getVisibleSpotIds(gameDataV, daimyoV.getId());
        KnightV knightV = set.iterator();
        while (knightV.hasNext()) {
            int n = knightV.next();
            SpotV spotV = (SpotV)gameDataV.getSpots().get(n);
            if (spotV == null) continue;
            for (UnitV unitV : spotV.getUnits()) {
                KnightV knightV2;
                if (unitV.getDaimyoId() == daimyoV.getId()) {
                    if (unitV.isBattle()) {
                        knightV2 = unitV.getKnight();
                        list.add(new Tuple<KnightV, SpotV, String>(knightV2, spotV, "\u6211\u8ecd\u306f\u73fe\u5728\u4ea4\u6226\u4e2d\u3067\u3059\u3002\u4ea4\u6226\u4e2d\u306e\u30e6\u30cb\u30c3\u30c8\u306b\u306f\u3001\u4e00\u90e8\u306e\u7279\u6280\u3092\u9664\u304d\u547d\u4ee4\u304c\u51fa\u6765\u306a\u304f\u306a\u308a\u307e\u3059\u3002"));
                        continue;
                    }
                    if (unitV.getMorale() > 10) continue;
                    knightV2 = unitV.getKnight();
                    list.add(new Tuple<KnightV, SpotV, String>(knightV2, spotV, "\u30e6\u30cb\u30c3\u30c8\u306e\u58eb\u6c17\u304c\u4f4e\u4e0b\u3057\u3066\u3044\u307e\u3059\u3002\u30e6\u30cb\u30c3\u30c8\u306f\u51fa\u9663\u3057\u305f\u56fd\u304b\u3089\u5916\u306b\u51fa\u308b\u3068\u3001\u6bce\u30bf\u30fc\u30f3\u58eb\u6c17\u304c\u4f4e\u4e0b\u3057\u30010\u306b\u306a\u308b\u3068\u5d29\u58ca\u3057\u307e\u3059\u3002\u30e6\u30cb\u30c3\u30c8\u306e\u58eb\u6c17\u304c\u4f4e\u4e0b\u3059\u308b\u3068\u3001\u6575\u306b\u4e0e\u3048\u308b\u30c0\u30e1\u30fc\u30b8\u304c\u4f4e\u4e0b\u3057\u305f\u308a\u6575\u304b\u3089\u53d7\u3051\u308b\u30c0\u30e1\u30fc\u30b8\u304c\u4e0a\u6607\u3057\u305f\u308a\u3057\u307e\u3059\u3002"));
                    continue;
                }
                if (unitV.getDaimyoId() != 0) {
                    if (unitV.getSpot().getDaimyoId() != daimyoV.getId() || !gameDataV.isBattleTerget(daimyoV.getId(), unitV.getDaimyoId())) continue;
                    knightV2 = (KnightV)GameUtil.getRandom(arrayList);
                    list.add(new Tuple<KnightV, SpotV, String>(knightV2, spotV, "\u9818\u5185\u306b" + unitV.getName() + "\u968a\u304c\u4fb5\u5165\u3057\u3066\u3044\u307e\u3059\u3002"));
                    continue;
                }
                if (unitV.getUnitId() != gameDataV.getParameters().getPirateId()) continue;
                knightV2 = (KnightV)GameUtil.getRandom(arrayList);
                list.add(new Tuple<KnightV, SpotV, String>(knightV2, spotV, spotV.getName() + "\u306b\u6d77\u8cca\u304c\u51fa\u73fe\u3057\u3066\u3044\u307e\u3059\u3002\u6d77\u8cca\u304c\u9818\u5185\u306b\u4fb5\u5165\u3059\u308b\u3068\u7565\u596a\u306b\u3088\u308b\u88ab\u5bb3\u304c\u767a\u751f\u3057\u307e\u3059\u3002" + "\u6d77\u8cca\u3092\u5012\u3059\u3068\u3001\u540d\u58f0\u304c\u4e0a\u6607\u3057\u3001\u91d1\u92ad\u304c\u624b\u306b\u5165\u308a\u307e\u3059\u3002"));
            }
        }
        if (list.isEmpty()) {
            knightV = (KnightV)GameUtil.getRandom(arrayList);
            list.add(new Tuple<KnightV, Object, String>(knightV, null, daimyoV.getKnight().getFullName() + "\u69d8\u3002\u547d\u4ee4\u3092\u304a\u9858\u3044\u3044\u305f\u3057\u307e\u3059\u3002"));
        }
    }

    private static /* synthetic */ void lambda$updateByMonth$123(GameDataV gameDataV, int n, DaimyoV daimyoV, List list, Research research) {
        GameCommandUtil.updateResearch(gameDataV, research, n, daimyoV, list);
    }

    private static /* synthetic */ boolean lambda$updateByMonth$122(DaimyoV daimyoV, Research research) {
        return !daimyoV.getTechnologyIds().contains(research.getTechnologyId());
    }

    private static /* synthetic */ void lambda$updateByMonth$119(DaimyoV daimyoV, List list, TechnologyV technologyV) {
        daimyoV.getResearches().put(technologyV.getId(), new Research(technologyV.getId()));
        Notice notice = GameNoticeCreator.canResearchTechnology(technologyV);
        list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
    }

    private static /* synthetic */ boolean lambda$updateByMonth$118(int n, DaimyoV daimyoV, TechnologyV technologyV) {
        return technologyV.getTechnology().getCondition().judgeForTechnology(n, daimyoV);
    }

    private static /* synthetic */ boolean lambda$updateByMonth$116(DaimyoV daimyoV, TechnologyV technologyV) {
        return !daimyoV.getResearches().containsKey(technologyV.getId());
    }

    private static /* synthetic */ boolean lambda$updateByMonth$115(DaimyoV daimyoV, TechnologyV technologyV) {
        return !daimyoV.getTechnologyIds().contains(technologyV.getId());
    }

    private static /* synthetic */ void lambda$updateByMonth$114(DaimyoV daimyoV, GameDataV gameDataV, List list, KnightV knightV) {
        Notice notice;
        if (knightV.isEmployee() && knightV.getRentalDaimyoId() == 0) {
            if (knightV.getPay() <= daimyoV.getMoney()) {
                daimyoV.setMoneyChange(12, -1 * knightV.getPay());
                GameCommandUtil.growUpKnight(gameDataV, knightV, list);
            } else {
                GameCommandUtil.releaseKnight(gameDataV, knightV);
                notice = GameNoticeCreator.stopKnight(knightV);
                list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
            }
        }
        if (knightV.getRentalDaimyoId() != 0) {
            knightV.setCultureExp(0);
            knightV.setDomesticExp(0);
            knightV.setTacticsExp(0);
            if (!GameDiplomacyUtil.canRental(gameDataV, knightV.getRentalDaimyoId(), knightV.getDaimyoId())) {
                notice = GameNoticeCreator.escapeKnight(knightV);
                list.add(new Pair<Integer, Notice>(knightV.getRentalDaimyoId(), notice));
                knightV.setRentalDaimyoId(0);
            }
        }
    }

    private static /* synthetic */ void lambda$updateByMonth$113(DaimyoV daimyoV, List list, GiantV giantV) {
        if (giantV.getPay() <= daimyoV.getMoney()) {
            daimyoV.setMoneyChange(12, -1 * giantV.getPay());
            if (daimyoV.getSpecial() == 4) {
                giantV.setMonth(giantV.getMonth() + 2);
            } else {
                giantV.setMonth(giantV.getMonth() + 1);
            }
            if (giantV.isComplete()) {
                Notice notice;
                if (giantV.getGiant().getCultureId() != 0 && !daimyoV.getCultureIds().contains(giantV.getGiant().getCultureId())) {
                    daimyoV.getCultureIds().add(giantV.getGiant().getCultureId());
                    notice = GameNoticeCreator.getCulture(giantV, giantV.getCulture());
                    list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
                }
                if (giantV.getGiant().getTechnologyId() != 0 && !daimyoV.getTechnologyIds().contains(giantV.getGiant().getTechnologyId())) {
                    daimyoV.getTechnologyIds().add(giantV.getGiant().getTechnologyId());
                    notice = GameNoticeCreator.getTechnology(giantV, giantV.getTechnology());
                    list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
                }
                if (giantV.getGiant().getTreasureId() != 0) {
                    giantV.getTreasure().setKnightId(daimyoV.getKnightId());
                    giantV.getTreasure().setStoreId(0);
                    giantV.getTreasure().setAppear(true);
                    notice = GameNoticeCreator.getTreasure(giantV, giantV.getTreasure());
                    list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
                }
                giantV.setDisappear(true);
                giantV.setDaimyoId(0);
                giantV.setSpotId(0);
            }
        } else {
            giantV.setSpotId(((CountryV)giantV.getDaimyo().getCountries().get(0)).getCapitalSpot().getId());
            giantV.setDaimyoId(0);
            giantV.setMonth(0);
            Notice notice = GameNoticeCreator.stopGiant(giantV);
            list.add(new Pair<Integer, Notice>(daimyoV.getId(), notice));
        }
    }
}

