/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.common;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.base.input.InputInterface;
import game.sengoku.common.AudioUtil;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.GameUtil;
import game.sengoku.common.LazyExecutor;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.common.Scene;
import game.sengoku.data.KnightV;
import game.sengoku.data.WorldDataV;
import game.sengoku.game.Notice;
import game.sengoku.main.KessenMain;
import game.sengoku.server.GameClient;
import game.sengoku.window.ImageButtonSprite;
import game.sengoku.window.SoundOptionWindow;
import game.sengoku.window.WindowBase;
import game.sengoku.window.WindowMessageEx;
import game.sengoku.window.WindowMessageEx3;
import java.util.ArrayList;
import java.util.List;

public abstract class SceneCommon
extends Scene {
    protected WindowMessageEx messageWindow = new WindowMessageEx(0, 0, 3000, 600, 124, -858993440, GameFontUtil.FONT16);
    private WindowBase middleWindow;
    private List<String> messagesStrings;
    private List<LazyExecutor> lazyExecutors;
    protected Runnable yesSelected;
    protected Runnable noSelected;
    private boolean receiveNotice = false;
    protected int sumCost = 0;
    private ImageButtonSprite soundOption;
    private ImageButtonSprite powerOff;
    protected boolean optionUse = false;
    protected Texture backGraund = null;

    public SceneCommon() {
        this.messageWindow.setVisible(false);
        this.messagesStrings = new ArrayList<String>();
        this.lazyExecutors = new ArrayList<LazyExecutor>();
        this.middleWindow = null;
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        Texture texture = (Texture)graphicPool.getResource("onpu.png");
        Texture texture2 = (Texture)graphicPool.getResource("onpu2.png");
        this.soundOption = new ImageButtonSprite(5, 35, 2000, 25, 25, texture, texture2);
        this.soundOption.setPrimaryClicked(windowClickable -> {
            SoundOptionWindow soundOptionWindow2 = new SoundOptionWindow(250, 150, 1000, 350, 160, MouseSymbolLayerManager.LAYER_MIDDLE);
            soundOptionWindow2.setCommitClicked(soundOptionWindow -> {
                this.setMiddleWindow(null);
                this.loadMusic();
            });
            this.setMiddleWindow(soundOptionWindow2);
        });
        Texture texture3 = (Texture)graphicPool.getResource("poweroff.png");
        Texture texture4 = (Texture)graphicPool.getResource("poweroff2.png");
        this.powerOff = new ImageButtonSprite(5, 5, 2000, 25, 25, texture3, texture4);
        this.powerOff.setPrimaryClicked(windowClickable -> this.alert(1, () -> this.getPlayerClient().gameEnd(), null, "\u30b2\u30fc\u30e0\u3092\u7d42\u4e86\u3057\u307e\u3059\u304b\uff1f"));
    }

    @Override
    public void load() {
        super.load();
        this.loadBg();
        this.loadMusic();
    }

    public WindowBase getMiddleWindow() {
        return this.middleWindow;
    }

    public void setMiddleWindow(WindowBase windowBase) {
        if (windowBase != null) {
            windowBase.setZ(2000);
        }
        this.middleWindow = windowBase;
    }

    public void lazy(Runnable runnable, int n) {
        this.lazyExecutors.add(new LazyExecutor(runnable, n));
    }

    public boolean isReceiveNotice() {
        return this.receiveNotice;
    }

    public void setReceiveNotice(boolean bl) {
        this.receiveNotice = bl;
    }

    @Override
    public void update() {
        super.update();
        this.updateActive();
        if (this.messageWindow.isVisible()) {
            this.messageWindow.update();
        } else {
            Notice notice;
            InputInterface inputInterface = KessenMain.getInstance().getInput();
            if (inputInterface.isMouseSecondaryClicked()) {
                this.exit();
            }
            this.messagesStrings = this.getGameTemp().getMessages();
            if (!this.messagesStrings.isEmpty()) {
                this.messageWindow.refresh();
                this.messageWindow.setKnight(this.getGameTemp().getMessageKnight());
                this.messageWindow.setMessages(this.messagesStrings);
                this.messageWindow.setVisible(true);
                this.messageWindow.centering();
                this.messageWindow.setType(this.getGameTemp().getMessageWindowType());
                this.messageWindow.setYesSelected(this.yesSelected);
                this.messageWindow.setNoSelected(this.noSelected);
                this.yesSelected = null;
                this.noSelected = null;
                this.messagesStrings.clear();
                this.getGameTemp().setMessageKnight(null);
            } else if (this.isReceiveNotice() && (notice = this.getGameTemp().getNotice()) != null) {
                AudioUtil.sePlay(notice.getSoundId());
                this.shiftToSpot(notice.getSpotId());
                this.alert(notice.getKnight(), notice.getMessages().toArray(new String[0]));
            }
            this.messageWindow.update();
        }
        if (this.middleWindow != null) {
            this.middleWindow.update();
        }
        this.lazyExecutors.removeIf(lazyExecutor -> lazyExecutor.execute());
        this.soundOption.setVisible(this.optionUse);
        this.soundOption.update();
        this.powerOff.setVisible(this.optionUse);
        this.powerOff.update();
    }

    protected abstract void exit();

    @Override
    protected void updateContent() {
        this.messageWindow.draw(this.bcontext);
        if (this.middleWindow != null) {
            this.middleWindow.draw(this.bcontext);
        }
        this.soundOption.draw(this.bcontext);
        this.powerOff.draw(this.bcontext);
    }

    protected void alert(int n, KnightV knightV, Runnable runnable, Runnable runnable2, String ... stringArray) {
        this.yesSelected = runnable;
        this.noSelected = runnable2;
        this.getGameTemp().setMessageWindowType(n);
        this.getGameTemp().setMessageKnight(knightV);
        List<String> list = this.getGameTemp().getMessages();
        list.clear();
        for (String string : stringArray) {
            list.add(string);
        }
    }

    protected void alert(int n, Runnable runnable, Runnable runnable2, String ... stringArray) {
        this.alert(n, null, runnable, runnable2, stringArray);
    }

    protected void alert(KnightV knightV, String ... stringArray) {
        this.alert(0, knightV, stringArray);
    }

    protected void alert(String ... stringArray) {
        this.alert(0, stringArray);
    }

    protected void alert(int n, KnightV knightV, String ... stringArray) {
        this.alert(n, knightV, (Runnable)null, (Runnable)null, stringArray);
    }

    protected void alert(int n, String ... stringArray) {
        this.alert(n, (Runnable)null, (Runnable)null, stringArray);
    }

    protected void alert3(String string, String string2, String string3, Runnable runnable, Runnable runnable2, Runnable runnable3, String ... stringArray) {
        WindowMessageEx3 windowMessageEx3 = new WindowMessageEx3(0, 0, 3000, 600, 176, -858993440, GameFontUtil.FONT16, string, string2, string3);
        String[] stringArray2 = GameUtil.splitMessages(30, stringArray);
        windowMessageEx3.setMessages(stringArray2);
        windowMessageEx3.setVisible(true);
        windowMessageEx3.centering();
        windowMessageEx3.setSelected1(runnable);
        windowMessageEx3.setSelected2(runnable2);
        windowMessageEx3.setSelected3(runnable3);
        this.setMiddleWindow(windowMessageEx3);
    }

    protected void updateSumCost() {
        this.sumCost = this.getPlayer().getCommands().stream().mapToInt(commandV -> commandV.getCost()).sum();
        if (this.getGameTemp().getTacticsAction() != null) {
            this.sumCost += this.getGameTemp().getTacticsAction().getCommandNewMap().values().stream().mapToInt(tacticsActionEntry -> tacticsActionEntry.getMoney()).sum();
        }
    }

    protected int getSumCost() {
        return this.sumCost;
    }

    protected int getUsableMoney() {
        return this.getPlayer().getDaimyo().getMoney() - this.sumCost;
    }

    protected String getYMD() {
        WorldDataV worldDataV = this.getWorld();
        String string = worldDataV.getGengo() + worldDataV.getGengoYear() + "\u5e74 ";
        string = string + (worldDataV.isIntercalary() ? "\u958f" : "") + worldDataV.getMonth() + "\u6708";
        string = string + worldDataV.getDay() + "\u65e5";
        return string;
    }

    protected void updateActive() {
        InputInterface inputInterface = KessenMain.getInstance().getInput();
        if (this.messageWindow.isVisible()) {
            MouseSymbolLayerManager.LAYER_NORMAL.setActive(false);
            MouseSymbolLayerManager.LAYER_MESSAGE.setActive(true);
            MouseSymbolLayerManager.LAYER_MIDDLE.setActive(false);
            inputInterface.setActive(true);
            return;
        }
        if (this.middleWindow != null && this.middleWindow.isVisible()) {
            MouseSymbolLayerManager.LAYER_NORMAL.setActive(false);
            MouseSymbolLayerManager.LAYER_MESSAGE.setActive(false);
            MouseSymbolLayerManager.LAYER_MIDDLE.setActive(true);
            inputInterface.setActive(true);
            return;
        }
        GameClient gameClient = this.getPlayerClient();
        switch (gameClient.getStatus()) {
            case 0: 
            case 5: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 34: 
            case 36: 
            case 38: 
            case 44: 
            case 52: {
                MouseSymbolLayerManager.LAYER_NORMAL.setActive(true);
                MouseSymbolLayerManager.LAYER_MESSAGE.setActive(false);
                MouseSymbolLayerManager.LAYER_MIDDLE.setActive(false);
                inputInterface.setActive(true);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 24: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 43: {
                MouseSymbolLayerManager.LAYER_NORMAL.setActive(false);
                MouseSymbolLayerManager.LAYER_MESSAGE.setActive(false);
                MouseSymbolLayerManager.LAYER_MIDDLE.setActive(false);
                inputInterface.setActive(false);
                break;
            }
            default: {
                throw new RuntimeException("invalid status = " + gameClient.getStatus());
            }
        }
    }

    protected void loadMusic() {
        GameClient gameClient = this.getPlayerClient();
        switch (gameClient.getStatus()) {
            case 17: 
            case 18: 
            case 37: {
                AudioUtil.musicPlay(3);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 44: {
                AudioUtil.musicPlay(3);
                break;
            }
            case 4: 
            case 5: 
            case 36: 
            case 41: {
                AudioUtil.musicPlay(2);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 52: {
                if (this.getDaimyo().getWars().isEmpty()) {
                    AudioUtil.musicPlay(5);
                    break;
                }
                AudioUtil.musicPlay(6);
                break;
            }
            case 30: 
            case 42: 
            case 43: {
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 21: {
                AudioUtil.musicPlay(1);
                break;
            }
            case 38: 
            case 39: {
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                break;
            }
            case 3: {
                AudioUtil.musicPlay(0);
                break;
            }
            default: {
                throw new RuntimeException("invalid status = " + gameClient.getStatus());
            }
        }
    }

    protected void loadBg() {
        if (this.getGameDataV() != null) {
            this.backGraund = GameUtil.selectTexture(this.getGameDataV().getWorld());
        }
    }

    protected boolean isMessageExists() {
        if (this.messageWindow.isVisible() || !this.getGameTemp().getMessages().isEmpty() || this.getMiddleWindow() != null) {
            return true;
        }
        return this.isReceiveNotice() && !this.getGameTemp().getNotices().isEmpty();
    }

    protected void shiftToSpot(int n) {
    }

    @Override
    public boolean withHolding() {
        return this.isMessageExists();
    }
}

