/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.common;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.data.DataUtil;
import game.sengoku.data.GameAIData;
import game.sengoku.data.GameData;
import game.sengoku.data.GameDataV;
import game.sengoku.data.GameServerSetting;
import game.sengoku.data.PlayerV;
import game.sengoku.data.SaveData;
import game.sengoku.data.SaveDataHeader;
import game.sengoku.data.SaveDataInterface;
import game.sengoku.data.Scenario;
import game.sengoku.data.SpotV;
import game.sengoku.data.SystemData;
import game.sengoku.data.WorldDataV;
import game.sengoku.main.KessenMain;
import game.sengoku.word.Words;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.simpleframework.xml.Serializer;

public class GameUtil {
    private static List<Integer> spotIds = null;

    public static int getMaxKey(Map<Integer, Integer> map) {
        int n = map.entrySet().stream().sorted((entry, entry2) -> (Integer)entry2.getValue() - (Integer)entry.getValue()).findFirst().map(entry -> (Integer)entry.getKey()).orElse(Integer.MIN_VALUE);
        return n;
    }

    public static int getBinomial(int n, int n2) {
        int n3 = n;
        for (int i = 0; i < n2 - n; ++i) {
            n3 += GameUtil.getRandom(0, 100) % 2;
        }
        return n3;
    }

    public static boolean getRandom(int n) {
        return GameUtil.getRandom(0, 100) < n;
    }

    public static int getRandom(int n, int n2) {
        int n3 = (int)Math.floor(Math.random() * (double)(n2 - n + 1)) + n;
        return n3;
    }

    public static <T> T getRandom(T[] TArray) {
        return TArray[GameUtil.getRandom(0, TArray.length - 1)];
    }

    public static <T> T getRandom(Collection<T> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        return (T)arrayList.get(GameUtil.getRandom(0, arrayList.size() - 1));
    }

    public static List<SpotV> getSpots(GameDataV gameDataV, Collection<Integer> collection) {
        ArrayList<SpotV> arrayList = new ArrayList<SpotV>();
        for (int n : collection) {
            SpotV spotV = (SpotV)gameDataV.getSpots().get(n);
            if (spotV == null) continue;
            arrayList.add(spotV);
        }
        return arrayList;
    }

    public static int getRandomSpotId(GameDataV gameDataV) {
        if (spotIds == null) {
            Set set = gameDataV.getSpots().keySet();
            spotIds = new ArrayList<Integer>();
            spotIds.addAll(set);
        }
        int n = GameUtil.getRandom(0, spotIds.size() - 1);
        return spotIds.get(n);
    }

    public static int getRandomSpotIdSea(GameDataV gameDataV) {
        Set set = gameDataV.getSpots().values().stream().filter(spotV -> spotV.getSpot().isSea()).mapToInt(spotV -> spotV.getId()).boxed().collect(Collectors.toSet());
        int n = (Integer)GameUtil.getRandom(set);
        return n;
    }

    public static boolean cornerRectInner(int n, int n2, int n3, int n4, int n5) {
        int n6 = Math.min(n3, n4) / n5;
        if (n < n6 && n2 < n6) {
            return GameUtil.distance2(n, n2, n6, n6) <= n6 * n6;
        }
        if (n < n6 && n2 > n4 - n6) {
            return GameUtil.distance2(n, n2, n6, n4 - n6) <= n6 * n6;
        }
        if (n > n3 - n6 && n2 < n6) {
            return GameUtil.distance2(n, n2, n3 - n6, n6) <= n6 * n6;
        }
        if (n > n3 - n6 && n2 > n4 - n6) {
            return GameUtil.distance2(n, n2, n3 - n6, n4 - n6) <= n6 * n6;
        }
        return true;
    }

    private static int distance2(int n, int n2, int n3, int n4) {
        return (n - n3) * (n - n3) + (n2 - n4) * (n2 - n4);
    }

    public static <T, U> void zip(List<T> list, List<U> list2, BiConsumer<T, U> biConsumer) {
        int n = Math.min(list.size(), list2.size());
        for (int i = 0; i < n; ++i) {
            biConsumer.accept(list.get(i), list2.get(i));
        }
    }

    public static <T, U> void product(List<T> list, List<U> list2, BiConsumer<T, U> biConsumer) {
        for (T t : list) {
            for (U u : list2) {
                biConsumer.accept(t, u);
            }
        }
    }

    public static <T> void eachWithIndex(List<T> list, BiConsumer<Integer, T> biConsumer) {
        int n = 0;
        for (T t : list) {
            biConsumer.accept(n, (Integer)t);
            ++n;
        }
    }

    public static String[] splitMessages(int n, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            for (int i = 0; i < string.length(); i += n) {
                String string2 = string.substring(i, Math.min(i + n, string.length()));
                arrayList.add(string2);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public static String[] splitMessages(int n, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            for (int i = 0; i < string.length(); i += n) {
                String string2 = string.substring(i, Math.min(i + n, string.length()));
                arrayList.add(string2);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public static Words loadWords() {
        File file = new File("word.xml");
        if (file.canRead()) {
            Serializer serializer = DataUtil.getSerializer();
            try {
                Words words = (Words)serializer.read(Words.class, file);
                return words;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        System.exit(0);
        return null;
    }

    public static SystemData loadSystemData() {
        File file = new File("system.xml");
        if (file.canRead()) {
            Serializer serializer = DataUtil.getSerializer();
            try {
                SystemData systemData = (SystemData)serializer.read(SystemData.class, file);
                return systemData;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        System.exit(0);
        return null;
    }

    public static void saveSystemData(SystemData systemData) {
        File file = new File("system.xml");
        Serializer serializer = DataUtil.getSerializer();
        try {
            serializer.write((Object)systemData, (Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static GameData loadData() {
        File file = new File("data.xml");
        if (file.canRead()) {
            Serializer serializer = DataUtil.getSerializer();
            try {
                GameData gameData = (GameData)serializer.read(GameData.class, file);
                gameData.setReference();
                return gameData;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        System.exit(0);
        return null;
    }

    public static GameAIData loadAIData() {
        File file = new File("aiparams.xml");
        if (file.canRead()) {
            Serializer serializer = DataUtil.getSerializer();
            try {
                GameAIData gameAIData = (GameAIData)serializer.read(GameAIData.class, file);
                return gameAIData;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        System.exit(0);
        return null;
    }

    public static void loadScenarios(List<Scenario> list) {
        File[] fileArray;
        String string = ".";
        File file = new File(string);
        for (File file2 : fileArray = file.listFiles()) {
            if (!file2.canRead() || !file2.getName().startsWith("scenario")) continue;
            Scenario scenario = GameUtil.loadScenario(file2);
            list.add(scenario);
        }
    }

    public static Scenario loadScenario(File file) {
        if (file.canRead()) {
            Serializer serializer = DataUtil.getSerializer();
            try {
                Scenario scenario = (Scenario)serializer.read(Scenario.class, file);
                return scenario;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        System.exit(0);
        return null;
    }

    public static String getNewSaveName() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return "save" + simpleDateFormat.format(date) + ".dat";
    }

    public static void saveGameData(String string, Scenario scenario, GameDataV gameDataV, List<PlayerV> list, GameServerSetting gameServerSetting, Map<Integer, Integer> map) {
        File file = new File(string);
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        int n = (int)System.currentTimeMillis();
        WorldDataV worldDataV = gameDataV.getWorld();
        String string2 = "" + worldDataV.getYear() + "\u5e74 " + (worldDataV.isIntercalary() ? "\u958f" : "") + worldDataV.getMonth() + "\u6708";
        Serializer serializer = DataUtil.getSerializer();
        SaveData saveData = new SaveData(scenario.getName(), simpleDateFormat.format(date), (long)n, string2, scenario.getExplain(), gameDataV, gameServerSetting);
        saveData.setPlayers(list);
        try {
            serializer.write((Object)saveData, (Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void loadSaves(List<SaveDataInterface> list) {
        SaveDataHeader saveDataHeader;
        String string = ".";
        File file = new File(string);
        for (File file2 : saveDataHeader = file.listFiles()) {
            if (!file2.canRead() || !file2.getName().startsWith("save")) continue;
            SaveDataHeader saveDataHeader2 = GameUtil.loadSaveHeader(file2);
            saveDataHeader2.setFileName(file2.getName());
            list.add((SaveDataInterface)saveDataHeader2);
        }
        list.sort((saveDataInterface, saveDataInterface2) -> (int)(saveDataInterface2.getTotalsec() - saveDataInterface.getTotalsec()));
        if (!list.isEmpty()) {
            SaveDataHeader saveDataHeader3 = (SaveDataHeader)list.get(0);
            saveDataHeader3.setLatest(true);
        }
    }

    public static SaveDataHeader loadSaveHeader(File file) {
        if (file.canRead()) {
            Serializer serializer = DataUtil.getSerializer();
            try {
                SaveDataHeader saveDataHeader = (SaveDataHeader)serializer.read(SaveDataHeader.class, file);
                return saveDataHeader;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        System.exit(0);
        return null;
    }

    public static SaveData loadSave(File file) {
        if (file.canRead()) {
            Serializer serializer = DataUtil.getSerializer();
            try {
                SaveData saveData = (SaveData)serializer.read(SaveData.class, file);
                return saveData;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        System.exit(0);
        return null;
    }

    public static double sigmoid(double d) {
        double d2 = Math.max(1.0E-5, d);
        double d3 = Math.log(d2);
        double d4 = 0.0;
        if (d3 < 0.0) {
            d4 = 1.0 / (1.0 + Math.exp(-d3));
            return d4 + 0.5;
        }
        d4 = 1.0 / (1.0 + Math.exp(d3));
        return 1.0 / (d4 + 0.5);
    }

    public static void uniqList(List<Integer> list) {
        LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>();
        linkedHashSet.addAll(list);
        list.clear();
        list.addAll(linkedHashSet);
    }

    public static String getTypeName(int n) {
        switch (n) {
            case 2: {
                return "\u5c71\u5730";
            }
            case 3: {
                return "\u6cbf\u5cb8";
            }
            case 4: {
                return "\u6d77\u4e0a";
            }
            case 1: {
                return "\u5e73\u5730";
            }
        }
        return "";
    }

    public static int getSpotColor(int n) {
        switch (n) {
            case 1: {
                return 665739519;
            }
            case 2: {
                return -749469441;
            }
            case 4: {
                return 696302079;
            }
            case 3: {
                return 882433023;
            }
        }
        return 665739519;
    }

    public static String getResourceName(int n) {
        switch (n) {
            case 1: {
                return "\u9244";
            }
            case 2: {
                return "\u99ac";
            }
        }
        return "";
    }

    public static int getResourceColor(int n) {
        switch (n) {
            case 1: {
                return 0x696969FF;
            }
            case 2: {
                return -749469441;
            }
        }
        return 665739519;
    }

    public static Texture selectTexture(WorldDataV worldDataV) {
        if (worldDataV == null) {
            return null;
        }
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        Texture texture = null;
        texture = worldDataV.getMonth() <= 2 ? (Texture)graphicPool.getResource("bgwinter.jpg") : (worldDataV.getMonth() <= 5 ? (Texture)graphicPool.getResource("bgspring.jpg") : (worldDataV.getMonth() <= 6 ? (Texture)graphicPool.getResource("bgrain.jpg") : (worldDataV.getMonth() <= 9 ? (Texture)graphicPool.getResource("bgsummer.jpg") : (worldDataV.getMonth() <= 11 ? (Texture)graphicPool.getResource("bgautumn.jpg") : (Texture)graphicPool.getResource("bgwinter.jpg")))));
        return texture;
    }

    public static String[] getDaimyoSpecialLabel(int n) {
        switch (n) {
            case 3: {
                return new String[]{"\u6bd8\u6c99\u9580\u5929\u306e\u5316\u8eab", "\u540d\u58f0\u304c\u4f4e\u4e0b\u3057\u306a\u3044"};
            }
            case 2: {
                return new String[]{"\u4e71\u4e16\u306e\u689f\u96c4", "\u60aa\u540d\u6642\u306b\u30e6\u30cb\u30c3\u30c8\u306e\u653b\u6483\u529b\u4e0a\u6607"};
            }
            case 1: {
                return new String[]{"\u672c\u9858\u5bfa\u6cd5\u4e3b", "\u5e03\u6559\u3001\u6a84\u6587\u306e\u30b3\u30de\u30f3\u30c9\u304c\u4f7f\u7528\u53ef\u80fd"};
            }
            case 5: {
                return new String[]{"\u80fd\u529b\u4e3b\u7fa9", "\u9ad8\u80fd\u529b\u306e\u6b66\u5c06\u306e\u6210\u9577\u901f\u5ea6\u304c\u4e0a\u6607"};
            }
            case 4: {
                return new String[]{"\u672b\u4e16\u306e\u9053\u8005", "\u6587\u5316\u4eba\u306e\u7814\u7a76\u901f\u5ea6\u304c\u4e0a\u6607"};
            }
        }
        return null;
    }
}

