/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.data;

import game.sengoku.data.DataUtil;
import game.sengoku.data.GameDataObject;
import game.sengoku.data.ValidErrorMessage;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;

public class UnitType
extends GameDataObject {
    public static final int ID_NONE = 0;
    public static final int ID_MIN = 0;
    public static final int ID_MAX = 99;
    public static final int SPEED_RATE_MIN = 0;
    public static final int SPEED_RATE_MAX = 1000;
    public static final int ATTACK_RATE_MIN = 0;
    public static final int ATTACK_RATE_MAX = 1000;
    public static final int DEFENSE_RATE_MIN = 0;
    public static final int DEFENSE_RATE_MAX = 1000;
    public static final int GUN_MIN = 0;
    public static final int GUN_MAX = 100;
    public static final int HORSE_MIN = 0;
    public static final int HORSE_MAX = 100;
    public static final int VISION_MIN = 0;
    public static final int VISION_MAX = 3;
    @Attribute(required=true, name="id")
    private int id = 0;
    @Element(required=true, name="name")
    private String name = "";
    @Element(required=true, name="icon_file_name")
    private String iconFileName = "";
    @Element(required=true, name="speed_rate")
    private int speedRate = 0;
    @Element(required=true, name="attack_rate")
    private int attackRate = 0;
    @Element(required=true, name="defense_rate")
    private int defenseRate = 0;
    @Element(required=true, name="gun")
    private int gun = 0;
    @Element(required=true, name="horse")
    private int horse = 0;
    @Element(required=true, name="technology_id")
    private int technologyId = 0;
    @Element(required=true, name="uniq_country_id")
    private int uniqCountryId = 0;
    @ElementList(required=true, name="uniq_technique_ids")
    private List<Integer> uniqTechniqueIds = null;
    @Element(required=true, name="vision")
    private int vision = 0;
    @Element(required=true, name="special")
    private boolean special = false;
    @Element(required=false, name="explain")
    private String explain = "";

    public UnitType() {
    }

    public UnitType(@Attribute(name="id") int n, @Element(name="name") String string, @Element(name="icon_file_name") String string2, @Element(name="speed_rate") int n2, @Element(name="attack_rate") int n3, @Element(name="defense_rate") int n4, @Element(name="gun") int n5, @Element(name="horse") int n6, @Element(name="technology_id") int n7, @Element(name="uniq_country_id") int n8, @Element(name="vision") int n9, @Element(name="special") boolean bl, @Element(name="explain") String string3) {
        this.id = n;
        DataUtil.assertInteger(n, 0, 99);
        this.name = string;
        this.iconFileName = string2;
        this.speedRate = n2;
        this.speedRate = DataUtil.checkInteger(n2, 0, 1000);
        this.attackRate = n3;
        this.attackRate = DataUtil.checkInteger(n3, 0, 1000);
        this.defenseRate = n4;
        this.defenseRate = DataUtil.checkInteger(n4, 0, 1000);
        this.gun = n5;
        this.gun = DataUtil.checkInteger(n5, 0, 100);
        this.horse = n6;
        this.horse = DataUtil.checkInteger(n6, 0, 100);
        this.technologyId = n7;
        this.uniqCountryId = n8;
        this.uniqTechniqueIds = new ArrayList<Integer>();
        this.vision = n9;
        this.vision = DataUtil.checkInteger(n9, 0, 3);
        this.special = bl;
        this.explain = string3;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getIconFileName() {
        return this.iconFileName;
    }

    public void setIconFileName(String string) {
        this.iconFileName = string;
    }

    public int getSpeedRate() {
        return this.speedRate;
    }

    public void setSpeedRate(int n) {
        this.speedRate = DataUtil.checkInteger(n, 0, 1000);
    }

    public int getAttackRate() {
        return this.attackRate;
    }

    public void setAttackRate(int n) {
        this.attackRate = DataUtil.checkInteger(n, 0, 1000);
    }

    public int getDefenseRate() {
        return this.defenseRate;
    }

    public void setDefenseRate(int n) {
        this.defenseRate = DataUtil.checkInteger(n, 0, 1000);
    }

    public int getGun() {
        return this.gun;
    }

    public void setGun(int n) {
        this.gun = DataUtil.checkInteger(n, 0, 100);
    }

    public int getHorse() {
        return this.horse;
    }

    public void setHorse(int n) {
        this.horse = DataUtil.checkInteger(n, 0, 100);
    }

    public int getTechnologyId() {
        return this.technologyId;
    }

    public void setTechnologyId(int n) {
        this.technologyId = n;
    }

    public int getUniqCountryId() {
        return this.uniqCountryId;
    }

    public void setUniqCountryId(int n) {
        this.uniqCountryId = n;
    }

    public List<Integer> getUniqTechniqueIds() {
        return this.uniqTechniqueIds;
    }

    public void setUniqTechniqueIds(List<Integer> list) {
        this.uniqTechniqueIds = list;
    }

    public int getVision() {
        return this.vision;
    }

    public void setVision(int n) {
        this.vision = DataUtil.checkInteger(n, 0, 3);
    }

    public boolean isSpecial() {
        return this.special;
    }

    public void setSpecial(boolean bl) {
        this.special = bl;
    }

    public String getExplain() {
        return this.explain;
    }

    public void setExplain(String string) {
        this.explain = string;
    }

    @Override
    public boolean checkValid(List<ValidErrorMessage> list) {
        int n = 0;
        if (!super.checkValid(list)) {
            ++n;
        }
        if (this.uniqCountryId != 0 && !this.getGameData().getJapan().getCountries().containsKey(this.uniqCountryId)) {
            this.uniqCountryId = 0;
        }
        if (this.technologyId != 0 && !this.getGameData().getTechnologies().containsKey(this.technologyId)) {
            this.technologyId = 0;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int n2 : this.uniqTechniqueIds) {
            if (n2 == 0 || this.getGameData().getTechniques().containsKey(n2)) continue;
            arrayList.add(n2);
        }
        this.uniqTechniqueIds.removeAll(arrayList);
        arrayList.clear();
        return n == 0;
    }
}

