/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.data;

import game.sengoku.data.Build;
import game.sengoku.data.DataUtil;
import game.sengoku.data.GameDataObjectV;
import game.sengoku.data.Technology;
import game.sengoku.data.UnitType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.simpleframework.xml.Attribute;

public class TechnologyV
extends GameDataObjectV {
    public static final int ID_MIN = 0;
    public static final int ID_MAX = 999;
    public static final int LEARNED_MIN = 0;
    public static final int LEARNED_MAX = 99;
    @Attribute(required=true, name="id")
    private int id = 0;
    private List<UnitType> uniqUnits = null;
    private List<Build> uniqBuilds = null;
    private List<TechnologyV> uniqTechnologies = null;
    private int learned = 0;

    public TechnologyV() {
        this.uniqUnits = new ArrayList<UnitType>();
        this.uniqBuilds = new ArrayList<Build>();
        this.uniqTechnologies = new ArrayList<TechnologyV>();
    }

    public TechnologyV(@Attribute(name="id") int n) {
        this.id = n;
        this.id = DataUtil.checkInteger(n, 0, 999);
        this.uniqUnits = new ArrayList<UnitType>();
        this.uniqBuilds = new ArrayList<Build>();
        this.uniqTechnologies = new ArrayList<TechnologyV>();
        this.learned = 0;
        this.learned = DataUtil.checkInteger(this.learned, 0, 99);
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = DataUtil.checkInteger(n, 0, 999);
    }

    public Technology getTechnology() {
        return this.getGameData().getTechnologies().get(this.id);
    }

    public List<UnitType> getUniqUnits() {
        return this.uniqUnits;
    }

    public void updateUniqUnits() {
        if (this.uniqUnits.isEmpty()) {
            this.uniqUnits = this.getGameData().getUnitTypes().values().parallelStream().filter(unitType -> unitType.getTechnologyId() == this.id).collect(Collectors.toList());
        }
    }

    public List<Build> getUniqBuilds() {
        return this.uniqBuilds;
    }

    public void updateUniqBuilds() {
        if (this.uniqBuilds.isEmpty()) {
            this.uniqBuilds = this.getGameData().getBuilds().values().parallelStream().filter(build -> build.getCondition().getTechnologies().contains(this.id)).collect(Collectors.toList());
        }
    }

    public List<TechnologyV> getUniqTechnologies() {
        return this.uniqTechnologies;
    }

    public void updateUniqTechnologies() {
        if (this.uniqTechnologies.isEmpty()) {
            this.uniqTechnologies = this.getGameDataV().getTechnologies().values().parallelStream().filter(technologyV -> technologyV.getTechnology().getCondition().getTechnologies().contains(this.id)).collect(Collectors.toList());
        }
    }

    public int getLearned() {
        return this.learned;
    }

    public void updateLearned() {
        this.learned = (int)this.getGameDataV().getDaimyos().values().parallelStream().filter(daimyoV -> daimyoV.getTechnologyIds().contains(this.id)).count();
    }

    public void update() {
        this.updateUniqUnits();
        this.updateUniqBuilds();
        this.updateUniqTechnologies();
        this.updateLearned();
    }

    @Override
    public String getName() {
        return this.getTechnology().getName();
    }
}

