/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.data;

import game.sengoku.data.Build;
import game.sengoku.data.CountryV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.DataUtil;
import game.sengoku.data.Effect;
import game.sengoku.data.GameDataObjectV;
import game.sengoku.data.GiantV;
import game.sengoku.data.KnightV;
import game.sengoku.data.MapPosition;
import game.sengoku.data.Spot;
import game.sengoku.data.UnitV;
import game.sengoku.data.ValidErrorMessage;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;

public class SpotV
extends GameDataObjectV {
    public static final int ID_MIN = 0;
    public static final int ID_MAX = 9999;
    public static final int DEFENSE_MIN = 0;
    public static final int DEFENSE_MAX = 9999;
    public static final int INCOME_MONTH_MIN = 0;
    public static final int INCOME_MONTH_MAX = 999999;
    public static final int SPOT_PLAIN = 1;
    public static final int SPOT_MOUNTAIN = 2;
    public static final int SPOT_SEASIDE = 3;
    public static final int SPOT_SEA = 4;
    @Attribute(required=true, name="id")
    private int id = 0;
    @ElementList(required=true, name="build_ids")
    private List<Integer> buildIds = null;
    @Element(required=true, name="battle")
    private int battle = 0;
    private List<Build> builds = null;
    private int defense = 0;
    private int incomeMonth = 0;
    private Effect amountEffect = null;
    private List<KnightV> knights = null;
    private List<GiantV> giants = null;
    private List<UnitV> units = null;

    public SpotV() {
        this.buildIds = new ArrayList<Integer>();
        this.builds = new ArrayList<Build>();
        this.knights = new ArrayList<KnightV>();
        this.giants = new ArrayList<GiantV>();
        this.units = new ArrayList<UnitV>();
    }

    public SpotV(@Attribute(name="id") int n, @Element(name="battle") int n2) {
        this.id = n;
        this.id = DataUtil.checkInteger(n, 0, 9999);
        this.buildIds = new ArrayList<Integer>();
        this.builds = new ArrayList<Build>();
        this.knights = new ArrayList<KnightV>();
        this.giants = new ArrayList<GiantV>();
        this.units = new ArrayList<UnitV>();
        this.battle = n2;
        this.defense = 0;
        this.defense = DataUtil.checkInteger(this.defense, 0, 9999);
        this.incomeMonth = 0;
        this.incomeMonth = DataUtil.checkInteger(this.incomeMonth, 0, 999999);
        this.amountEffect = new Effect();
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = DataUtil.checkInteger(n, 0, 9999);
    }

    public Spot getSpot() {
        return this.getGameData().getJapan().getSpots().get(this.id);
    }

    public int getCountryId() {
        return this.getSpot().getCountryId();
    }

    public CountryV getCountry() {
        return this.getGameDataV().getCountries().get(this.getCountryId());
    }

    public List<Integer> getBuildIds() {
        return this.buildIds;
    }

    public void setBuildIds(List<Integer> list) {
        this.buildIds = list;
    }

    public List<Build> getBuilds() {
        return this.builds;
    }

    public void setBuilds(List<Build> list) {
        this.builds = list;
    }

    public void updateBuilds() {
        this.builds.clear();
        for (int n : this.buildIds) {
            Build build = this.getGameData().getBuilds().get(n);
            if (build == null) continue;
            this.builds.add(build);
        }
    }

    public int getBattle() {
        return this.battle;
    }

    public void setBattle(int n) {
        this.battle = n;
    }

    public int getDefense() {
        return this.defense;
    }

    public void updateDefense() {
        this.defense = this.amountEffect.getDefensePlus();
    }

    public int getIncomeMonth() {
        return this.incomeMonth;
    }

    public void updateIncomeMonth() {
        this.incomeMonth = this.amountEffect.getMoneyPlus();
    }

    public Effect getAmountEffect() {
        return this.amountEffect;
    }

    public void updateAmountEffect() {
        this.amountEffect.init();
        int[] nArray = this.amountEffect.getValues();
        for (Build build : this.builds) {
            int[] nArray2 = build.getEffect().getValues();
            DataUtil.addArray(nArray, nArray2);
        }
        this.amountEffect.setValues(nArray);
    }

    public MapPosition getPosition() {
        return this.getGameData().getMap().getPositions().get(this.id);
    }

    public void update() {
        this.updateBuilds();
        this.updateDefense();
        this.updateIncomeMonth();
        this.updateAmountEffect();
        this.updateUnits();
        this.updateKnights();
        this.updateGiants();
    }

    @Override
    public String getName() {
        return this.getSpot().getName();
    }

    public int getType() {
        if (this.getSpot().isMount()) {
            return 2;
        }
        if (this.getSpot().isSeaSize()) {
            return 3;
        }
        if (this.getSpot().isSea()) {
            return 4;
        }
        return 1;
    }

    public String getTypeName() {
        switch (this.getType()) {
            case 2: {
                return "\u5c71\u5730";
            }
            case 3: {
                return "\u6cbf\u5cb8";
            }
            case 4: {
                return "\u6d77\u4e0a";
            }
            case 1: {
                return "\u5e73\u5730";
            }
        }
        return "";
    }

    public void updateKnights() {
        this.knights.clear();
        this.gameDataV.getKnights().forEach((n, knightV) -> {
            if (knightV.getDaimyoId() == 0 && knightV.getSpotId() == this.id) {
                this.knights.add((KnightV)knightV);
            }
        });
    }

    public void updateGiants() {
        this.giants.clear();
        this.gameDataV.getGiants().forEach((n, giantV) -> {
            if (giantV.getDaimyoId() == 0 && giantV.getSpotId() == this.id) {
                this.giants.add((GiantV)giantV);
            }
        });
    }

    public List<KnightV> getKnights() {
        return this.knights;
    }

    public List<GiantV> getGiants() {
        return this.giants;
    }

    public List<UnitV> getUnits() {
        return this.units;
    }

    public void updateUnits() {
        this.units.clear();
        int n = 0;
        for (UnitV unitV : this.getGameDataV().getUnits().values()) {
            if (unitV.getSpotId() != this.id) continue;
            unitV.setIndexOnSpot(n);
            this.units.add(unitV);
            ++n;
        }
    }

    public DaimyoV getDaimyo() {
        return this.getCountry() == null ? null : this.getCountry().getDaimyo();
    }

    public int getDaimyoId() {
        return this.getDaimyo() == null ? 0 : this.getDaimyo().getId();
    }

    @Override
    public boolean checkValid(List<ValidErrorMessage> list) {
        int n = 0;
        if (!super.checkValid(list)) {
            ++n;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int n2 : this.buildIds) {
            if (this.getGameData().getBuilds().containsKey(n2)) continue;
            arrayList.add(n2);
        }
        this.buildIds.removeAll(arrayList);
        return n == 0;
    }
}

