/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.data;

import game.base.common.Pair;
import game.base.common.PairKeyMap;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RankingUtil {
    public static final int RANK_FOOD = 1;
    public static final int RANK_COMMERCE = 2;
    public static final int RANK_POPULATION = 3;
    public static final int RANK_CULTURE = 4;
    public static final int RANK_FAME = 5;
    public static final int RANK_IMPACT = 6;
    public static final int RANK_ARMY = 7;
    public static final int RANK_CHRIST = 9;

    public static PairKeyMap<Integer, Integer, Integer> getRankPairKeyMap(GameDataV gameDataV) {
        int[] nArray;
        PairKeyMap pairKeyMap = new PairKeyMap();
        for (int n : nArray = new int[]{1, 2, 3, 4, 5, 6, 7, 9}) {
            Map<Integer, Integer> map = RankingUtil.getRankMap(gameDataV, n);
            for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
                pairKeyMap.put((Object)n, (Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        return pairKeyMap;
    }

    public static Map<Integer, Integer> getRankMap(GameDataV gameDataV, int n) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        List<Pair<Integer, Integer>> list = RankingUtil.getRank(gameDataV, n);
        for (Pair<Integer, Integer> pair : list) {
            hashMap.put((Integer)pair.getSecond(), (Integer)pair.getFirst());
        }
        return hashMap;
    }

    public static List<Pair<Integer, Integer>> getRank(GameDataV gameDataV, int n) {
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        for (DaimyoV daimyoV : gameDataV.getDaimyos().values()) {
            if (daimyoV.isFall()) continue;
            switch (n) {
                case 1: {
                    arrayList.add(new Pair((Object)daimyoV, (Object)daimyoV.getFoodAmount()));
                    break;
                }
                case 2: {
                    arrayList.add(new Pair((Object)daimyoV, (Object)daimyoV.getCommerce()));
                    break;
                }
                case 3: {
                    arrayList.add(new Pair((Object)daimyoV, (Object)daimyoV.getPopulationAmount()));
                    break;
                }
                case 4: {
                    arrayList.add(new Pair((Object)daimyoV, (Object)daimyoV.getCultureArv()));
                    break;
                }
                case 5: {
                    arrayList.add(new Pair((Object)daimyoV, (Object)daimyoV.getFame()));
                    break;
                }
                case 6: {
                    arrayList.add(new Pair((Object)daimyoV, (Object)daimyoV.getImpact()));
                    break;
                }
                case 7: {
                    arrayList.add(new Pair((Object)daimyoV, (Object)daimyoV.getArmyAmount()));
                    break;
                }
                case 9: {
                    arrayList.add(new Pair((Object)daimyoV, (Object)daimyoV.getChrist()));
                    break;
                }
            }
        }
        arrayList.sort((pair, pair2) -> (Integer)pair2.getSecond() - (Integer)pair.getSecond());
        ArrayList arrayList2 = new ArrayList();
        int n2 = 1;
        int n3 = 0;
        int n4 = -1;
        for (Pair pair3 : arrayList) {
            if (n4 != (Integer)pair3.getSecond()) {
                n3 = n2;
            }
            arrayList2.add(new Pair((Object)n3, (Object)((DaimyoV)pair3.getFirst()).getId()));
            ++n2;
            n4 = (Integer)pair3.getSecond();
        }
        return arrayList2;
    }
}

