/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.data;

import game.sengoku.data.DaimyoV;
import game.sengoku.data.DataUtil;
import game.sengoku.data.Family;
import game.sengoku.data.GameDataObjectV;
import game.sengoku.data.Knight;
import game.sengoku.data.SpotV;
import game.sengoku.data.TreasureV;
import game.sengoku.data.UnitV;
import game.sengoku.data.ValidErrorMessage;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;

public class KnightV
extends GameDataObjectV {
    public static final int ID_MIN = 0;
    public static final int ID_MAX = 9999;
    public static final int COUNTRY_ID_MIN = 0;
    public static final int COUNTRY_ID_MAX = 99;
    public static final int DAIMYO_ID_MIN = 0;
    public static final int DAIMYO_ID_MAX = 99;
    public static final int RENTAL_DAIMYO_ID_MIN = 0;
    public static final int RENTAL_DAIMYO_ID_MAX = 99;
    public static final int UNMOVE_MONTH_MIN = 0;
    public static final int UNMOVE_MONTH_MAX = 999;
    public static final int PAY_MIN = 0;
    public static final int PAY_MAX = 99999;
    public static final int DOMESTIC_EXP_MIN = 0;
    public static final int DOMESTIC_EXP_MAX = 1000;
    public static final int TACTICS_EXP_MIN = 0;
    public static final int TACTICS_EXP_MAX = 1000;
    public static final int CULTURE_EXP_MIN = 0;
    public static final int CULTURE_EXP_MAX = 1000;
    public static final int DOMESTIC_PLUS_MIN = 0;
    public static final int DOMESTIC_PLUS_MAX = 5;
    public static final int TACTICS_PLUS_MIN = 0;
    public static final int TACTICS_PLUS_MAX = 5;
    public static final int CULTURE_PLUS_MIN = 0;
    public static final int CULTURE_PLUS_MAX = 5;
    @Attribute(required=true, name="id")
    private int id = 0;
    @Element(required=true, name="daimyo_id")
    private int daimyoId = 0;
    @Element(required=true, name="rental_daimyo_id")
    private int rentalDaimyoId = 0;
    @Element(required=false, name="family")
    private String family = "";
    @Element(required=false, name="name")
    private String name = "";
    @Element(required=true, name="unmove_month")
    private int unmoveMonth = 0;
    @Element(required=true, name="spot_id")
    private int spotId = 0;
    @Element(required=true, name="appear")
    private boolean appear = false;
    @Element(required=true, name="disappear")
    private boolean disappear = false;
    @Element(required=true, name="employee")
    private boolean employee = false;
    @Element(required=true, name="pay")
    private int pay = 0;
    @Element(required=true, name="baptism")
    private boolean baptism = false;
    @Element(required=true, name="domestic_exp")
    private int domesticExp = 0;
    @Element(required=true, name="tactics_exp")
    private int tacticsExp = 0;
    @Element(required=true, name="culture_exp")
    private int cultureExp = 0;
    @Element(required=true, name="domestic_plus")
    private int domesticPlus = 0;
    @Element(required=true, name="tactics_plus")
    private int tacticsPlus = 0;
    @Element(required=true, name="culture_plus")
    private int culturePlus = 0;
    private boolean goOut = false;
    private List<TreasureV> treasures = null;

    public KnightV(int n) {
        this.id = n;
        this.treasures = new ArrayList<TreasureV>();
    }

    public KnightV(@Attribute(name="id") int n, @Element(name="daimyo_id") int n2, @Element(name="rental_daimyo_id") int n3, @Element(name="family") String string, @Element(name="name") String string2, @Element(name="unmove_month") int n4, @Element(name="spot_id") int n5, @Element(name="appear") boolean bl, @Element(name="disappear") boolean bl2, @Element(name="employee") boolean bl3, @Element(name="pay") int n6, @Element(name="baptism") boolean bl4, @Element(name="domestic_exp") int n7, @Element(name="tactics_exp") int n8, @Element(name="culture_exp") int n9, @Element(name="domestic_plus") int n10, @Element(name="tactics_plus") int n11, @Element(name="culture_plus") int n12) {
        this.id = n;
        this.id = DataUtil.checkInteger(n, 0, 9999);
        this.daimyoId = n2;
        this.daimyoId = DataUtil.checkInteger(n2, 0, 99);
        this.rentalDaimyoId = n3;
        this.rentalDaimyoId = DataUtil.checkInteger(n3, 0, 99);
        this.family = string;
        this.name = string2;
        this.unmoveMonth = n4;
        this.unmoveMonth = DataUtil.checkInteger(n4, 0, 999);
        this.spotId = n5;
        this.appear = bl;
        this.disappear = bl2;
        this.domesticExp = n7;
        this.domesticExp = DataUtil.checkInteger(n7, 0, 1000);
        this.tacticsExp = n8;
        this.tacticsExp = DataUtil.checkInteger(n8, 0, 1000);
        this.cultureExp = n9;
        this.cultureExp = DataUtil.checkInteger(n9, 0, 1000);
        this.domesticPlus = n10;
        this.domesticPlus = DataUtil.checkInteger(n10, 0, 5);
        this.tacticsPlus = n11;
        this.tacticsPlus = DataUtil.checkInteger(n11, 0, 5);
        this.culturePlus = n12;
        this.culturePlus = DataUtil.checkInteger(n12, 0, 5);
        this.employee = bl3;
        this.pay = n6;
        this.pay = DataUtil.checkInteger(n6, 0, 99999);
        this.baptism = bl4;
        this.treasures = new ArrayList<TreasureV>();
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = DataUtil.checkInteger(n, 0, 9999);
    }

    public Knight getKnight() {
        return this.getGameData().getKnights().get(this.id);
    }

    public int getDaimyoId() {
        return this.daimyoId;
    }

    public void setDaimyoId(int n) {
        this.daimyoId = DataUtil.checkInteger(n, 0, 99);
    }

    public DaimyoV getDaimyo() {
        return this.getGameDataV().getDaimyos().get(this.daimyoId);
    }

    public int getRentalDaimyoId() {
        return this.rentalDaimyoId;
    }

    public void setRentalDaimyoId(int n) {
        this.rentalDaimyoId = DataUtil.checkInteger(n, 0, 99);
    }

    public DaimyoV getRentalDaimyo() {
        return this.getGameDataV().getDaimyos().get(this.rentalDaimyoId);
    }

    public int getAge() {
        int n = this.getGameDataV().getWorld().getYear() - this.getKnight().getBorn();
        n = n < 0 ? 0 : n;
        return n;
    }

    public List<TreasureV> getTreasures() {
        return this.treasures;
    }

    public void updateTreasures() {
        this.treasures.clear();
        for (TreasureV treasureV : this.getGameDataV().getTreasures().values()) {
            if (!treasureV.isAppear() || treasureV.isDisappear() || treasureV.getKnightId() != this.id) continue;
            this.treasures.add(treasureV);
        }
    }

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String string) {
        this.family = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Knight getFatherKnight() {
        return this.getGameData().getKnights().get(this.getKnight().getFather());
    }

    public int getUnmoveMonth() {
        return this.unmoveMonth;
    }

    public void setUnmoveMonth(int n) {
        this.unmoveMonth = DataUtil.checkInteger(n, 0, 999);
    }

    public int getSpotId() {
        return this.spotId;
    }

    public void setSpotId(int n) {
        this.spotId = n;
    }

    public SpotV getSpot() {
        return this.getGameDataV().getSpots().get(this.spotId);
    }

    public boolean isAppear() {
        return this.appear;
    }

    public void setAppear(boolean bl) {
        this.appear = bl;
    }

    public boolean isDisappear() {
        return this.disappear;
    }

    public void setDisappear(boolean bl) {
        this.disappear = bl;
    }

    public boolean isEmployee() {
        return this.employee;
    }

    public void setEmployee(boolean bl) {
        this.employee = bl;
    }

    public boolean isBaptism() {
        return this.baptism;
    }

    public void setBaptism(boolean bl) {
        this.baptism = bl;
    }

    public boolean isGoOut() {
        return this.goOut;
    }

    public void updateGoOut() {
        this.goOut = false;
        for (UnitV unitV : this.getGameDataV().getUnits().values()) {
            if (unitV.getKnightId() != this.id) continue;
            this.goOut = true;
            break;
        }
    }

    public boolean isDaimyo() {
        if (this.getDaimyo() == null) {
            return false;
        }
        return this.getDaimyo().getKnight().getId() == this.id;
    }

    public int getDomestic() {
        int n = this.getKnight().getDomestic();
        n += this.getDomesticPlus();
        return n += this.treasures.parallelStream().mapToInt(treasureV -> treasureV.getTreasure().getDomesticPlus()).max().orElse(0);
    }

    public int getTactics() {
        int n = this.getKnight().getTactics();
        n += this.getTacticsPlus();
        return n += this.treasures.parallelStream().mapToInt(treasureV -> treasureV.getTreasure().getTacticsPlus()).max().orElse(0);
    }

    public int getCulture() {
        int n = this.getKnight().getCulture();
        n += this.getCulturePlus();
        return n += this.treasures.parallelStream().mapToInt(treasureV -> treasureV.getTreasure().getCulturePlus()).max().orElse(0);
    }

    public Family getFamilyData() {
        return this.getGameData().getFamilies().get(this.getKnight().getFamilyId());
    }

    public int getHeadPay() {
        double d = this.gameDataV.getWorld().getInflationRate();
        int n = this.getParameters().getKnightEmployCost();
        return (int)Math.ceil((double)n * d);
    }

    public int getGoOutPay() {
        if (this.isEmployee()) {
            return 0;
        }
        return (int)Math.ceil((double)(this.getHeadPay() * this.getTactics()) / 2.5);
    }

    public int getPay() {
        return this.pay;
    }

    public void setPay(int n) {
        this.pay = DataUtil.checkInteger(n, 0, 99999);
    }

    public int getDomesticExp() {
        return this.domesticExp;
    }

    public void setDomesticExp(int n) {
        this.domesticExp = DataUtil.checkInteger(n, 0, 1000);
    }

    public int getTacticsExp() {
        return this.tacticsExp;
    }

    public void setTacticsExp(int n) {
        this.tacticsExp = DataUtil.checkInteger(n, 0, 1000);
    }

    public int getCultureExp() {
        return this.cultureExp;
    }

    public void setCultureExp(int n) {
        this.cultureExp = DataUtil.checkInteger(n, 0, 1000);
    }

    public int getDomesticPlus() {
        return this.domesticPlus;
    }

    public void setDomesticPlus(int n) {
        this.domesticPlus = DataUtil.checkInteger(n, 0, 5);
    }

    public int getTacticsPlus() {
        return this.tacticsPlus;
    }

    public void setTacticsPlus(int n) {
        this.tacticsPlus = DataUtil.checkInteger(n, 0, 5);
    }

    public int getCulturePlus() {
        return this.culturePlus;
    }

    public void setCulturePlus(int n) {
        this.culturePlus = DataUtil.checkInteger(n, 0, 5);
    }

    public int getGrowUpExpDomestic() {
        if (this.getDaimyo() == null) {
            return 100;
        }
        if (this.getDaimyo().getSpecial() == 5) {
            return 125 - 10 * this.getKnight().getDomestic();
        }
        return 100;
    }

    public int getGrowUpExpTactics() {
        if (this.getDaimyo() == null) {
            return 100;
        }
        if (this.getDaimyo().getSpecial() == 5) {
            return 125 - 10 * this.getKnight().getTactics();
        }
        return 100;
    }

    public int getGrowUpExpCulture() {
        if (this.getDaimyo() == null) {
            return 100;
        }
        if (this.getDaimyo().getSpecial() == 5) {
            return 125 - 10 * this.getKnight().getCulture();
        }
        return 100;
    }

    public String getStatus() {
        return this.isDaimyo() ? "\u5927\u540d" : (this.getRentalDaimyoId() == 0 ? (this.isEmployee() ? "\u5bb6\u81e3" : (this.getKnight().isKokujin() ? "\u56fd\u4eba" : "\u6d6a\u4eba")) : "\u4eba\u8cea");
    }

    public void updateDaimyoId() {
        if (this.isAppear() && !this.isDisappear()) {
            DaimyoV daimyoV2 = this.gameDataV.getDaimyos().values().stream().filter(daimyoV -> daimyoV.getKnightId() == this.getId()).findFirst().orElse(null);
            if (daimyoV2 != null) {
                this.daimyoId = daimyoV2.getId();
            } else if (this.isEmployee()) {
                if (this.getDaimyo().isFall()) {
                    this.setEmployee(false);
                    this.rentalDaimyoId = 0;
                    this.unmoveMonth = 0;
                    if (this.getKnight().isKokujin()) {
                        this.spotId = this.getKnight().getSpotId();
                        this.daimyoId = this.getSpot().getCountry().getDaimyoId();
                    } else {
                        this.spotId = this.getKnight().getSpotId();
                        this.daimyoId = 0;
                    }
                }
            } else if (this.getKnight().isKokujin()) {
                this.spotId = this.getKnight().getSpotId();
                this.daimyoId = this.getSpot().getCountry().getDaimyoId();
            }
            if (this.rentalDaimyoId != 0 && this.getRentalDaimyo().isFall()) {
                this.rentalDaimyoId = 0;
            }
        }
    }

    public void update() {
        this.updateTreasures();
        this.updateGoOut();
        this.updateDaimyoId();
        if (!this.isEmployee()) {
            this.setDomesticExp(0);
            this.setTacticsExp(0);
            this.setCultureExp(0);
        }
    }

    @Override
    public String getLabel() {
        return this.getKnight().getLabel();
    }

    public String getFullName() {
        String string;
        Knight knight = this.getKnight();
        String string2 = this.getFamily();
        if (string2 == null || "".equals(string2)) {
            string2 = knight.getFamily();
        }
        if ((string = this.getName()) == null || "".equals(string)) {
            string = knight.getName();
        }
        return string2 + string;
    }

    @Override
    public boolean checkValid(List<ValidErrorMessage> list) {
        int n = 0;
        if (!super.checkValid(list)) {
            ++n;
        }
        if (this.daimyoId != 0 && !this.getGameDataV().getDaimyos().containsKey(this.daimyoId)) {
            this.daimyoId = 0;
        }
        if (this.rentalDaimyoId != 0 && !this.getGameDataV().getDaimyos().containsKey(this.rentalDaimyoId)) {
            this.rentalDaimyoId = 0;
        }
        if (this.spotId != 0 && !this.getGameData().getJapan().getSpots().containsKey(this.spotId)) {
            this.spotId = 0;
        }
        return n == 0;
    }
}

