/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.data;

import game.sengoku.data.DataUtil;
import game.sengoku.data.GameDataObject;
import game.sengoku.data.ValidErrorMessage;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;

public class Knight
extends GameDataObject {
    public static final int ID_NONE = 0;
    public static final int ID_MIN = 0;
    public static final int ID_MAX = 9999;
    public static final int BORN_MIN = 1500;
    public static final int BORN_MAX = 1600;
    public static final int DIE_MIN = 1500;
    public static final int DIE_MAX = 1600;
    public static final int ESTATE_MIN = 0;
    public static final int ESTATE_MAX = 100;
    public static final int DOMESTIC_MIN = 0;
    public static final int DOMESTIC_MAX = 10;
    public static final int TACTICS_MIN = 0;
    public static final int TACTICS_MAX = 10;
    public static final int CULTURE_MIN = 0;
    public static final int CULTURE_MAX = 10;
    @Attribute(required=true, name="id")
    private int id = 0;
    @Element(required=true, name="family")
    private String family = "";
    @Element(required=true, name="name")
    private String name = "";
    @Element(required=true, name="born")
    private int born = 1500;
    @Element(required=true, name="die")
    private int die = 1500;
    @Element(required=false, name="estate")
    private int estate = 15;
    @Element(required=false, name="father")
    private int father = 0;
    @Element(required=false, name="spot_id")
    private int spotId = 0;
    @Element(required=true, name="kokujin")
    private boolean kokujin = false;
    @Element(required=true, name="family_id")
    private int familyId = 0;
    @Element(required=true, name="domestic")
    private int domestic = 0;
    @Element(required=true, name="tactics")
    private int tactics = 0;
    @Element(required=true, name="culture")
    private int culture = 0;
    @Element(required=true, name="technique")
    private int technique = 0;
    @Element(required=true, name="ai_type_id")
    private int aiTypeId = 0;
    @Element(required=false, name="face_icon")
    private String faceIcon = "";
    @Element(required=false, name="explain")
    private String explain = "";

    public Knight() {
    }

    public Knight(@Attribute(name="id") int n, @Element(name="family") String string, @Element(name="name") String string2, @Element(name="born") int n2, @Element(name="die") int n3, @Element(name="estate") int n4, @Element(name="father") int n5, @Element(name="spot_id") int n6, @Element(name="kokujin") boolean bl, @Element(name="family_id") int n7, @Element(name="domestic") int n8, @Element(name="tactics") int n9, @Element(name="culture") int n10, @Element(name="technique") int n11, @Element(name="ai_type_id") int n12, @Element(name="face_icon") String string3, @Element(name="explain") String string4) {
        this.id = n;
        DataUtil.assertInteger(n, 0, 9999);
        this.family = string;
        this.name = string2;
        this.born = n2;
        this.born = DataUtil.checkInteger(n2, 1500, 1600);
        this.die = n3;
        this.die = DataUtil.checkInteger(n3, 1500, 1600);
        this.estate = n4;
        this.estate = DataUtil.checkInteger(n4, 0, 100);
        this.father = n5;
        this.spotId = n6;
        this.kokujin = bl;
        this.familyId = n7;
        this.domestic = n8;
        this.domestic = DataUtil.checkInteger(n8, 0, 10);
        this.tactics = n9;
        this.tactics = DataUtil.checkInteger(n9, 0, 10);
        this.culture = n10;
        this.culture = DataUtil.checkInteger(n10, 0, 10);
        this.technique = n11;
        this.aiTypeId = n12;
        this.faceIcon = string3;
        this.explain = string4;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String string) {
        this.family = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getBorn() {
        return this.born;
    }

    public void setBorn(int n) {
        this.born = DataUtil.checkInteger(n, 1500, 1600);
    }

    public int getDie() {
        return this.die;
    }

    public void setDie(int n) {
        this.die = DataUtil.checkInteger(n, 1500, 1600);
    }

    public int getEstate() {
        return this.estate;
    }

    public void setEstate(int n) {
        this.estate = DataUtil.checkInteger(n, 0, 100);
    }

    public int getFather() {
        return this.father;
    }

    public void setFather(int n) {
        this.father = n;
    }

    public int getSpotId() {
        return this.spotId;
    }

    public void setSpotId(int n) {
        this.spotId = n;
    }

    public boolean isKokujin() {
        return this.kokujin;
    }

    public void setKokujin(boolean bl) {
        this.kokujin = bl;
    }

    public int getFamilyId() {
        return this.familyId;
    }

    public void setFamilyId(int n) {
        this.familyId = n;
    }

    public int getDomestic() {
        return this.domestic;
    }

    public void setDomestic(int n) {
        this.domestic = DataUtil.checkInteger(n, 0, 10);
    }

    public int getTactics() {
        return this.tactics;
    }

    public void setTactics(int n) {
        this.tactics = DataUtil.checkInteger(n, 0, 10);
    }

    public int getCulture() {
        return this.culture;
    }

    public void setCulture(int n) {
        this.culture = DataUtil.checkInteger(n, 0, 10);
    }

    public int getTechnique() {
        return this.technique;
    }

    public void setTechnique(int n) {
        this.technique = n;
    }

    public int getAiTypeId() {
        return this.aiTypeId;
    }

    public void setAiTypeId(int n) {
        this.aiTypeId = n;
    }

    public String getFaceIcon() {
        return this.faceIcon;
    }

    public void setFaceIcon(String string) {
        this.faceIcon = string;
    }

    public String getExplain() {
        return this.explain;
    }

    public void setExplain(String string) {
        this.explain = string;
    }

    @Override
    public String getLabel() {
        return this.getId() + " " + this.family + this.name;
    }

    @Override
    public boolean checkValid(List<ValidErrorMessage> list) {
        int n = 0;
        if (!super.checkValid(list)) {
            ++n;
        }
        if (!DataUtil.valid(this, this.getFamily(), "\u82d7\u5b57", list)) {
            ++n;
        }
        if (this.father != 0 && !this.getGameData().getKnights().containsKey(this.father)) {
            this.father = 0;
        }
        if (this.spotId != 0 && !this.getGameData().getJapan().getSpots().containsKey(this.spotId)) {
            this.spotId = 0;
        }
        return n == 0;
    }
}

