/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.data;

import game.sengoku.data.Build;
import game.sengoku.data.DataUtil;
import game.sengoku.data.GameDataObjectV;
import game.sengoku.data.KnightV;
import game.sengoku.data.SpotV;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;

public class BuildPlan
extends GameDataObjectV {
    public static final int ID_MIN = 0;
    public static final int ID_MAX = 9999;
    public static final int AMOUNT_POWER_MIN = 0;
    public static final int AMOUNT_POWER_MAX = 9999;
    @Attribute(required=true, name="id")
    private int id = 0;
    @Element(required=true, name="spot_id")
    private int spotId = 0;
    @Element(required=true, name="head_cost")
    private int headCost = 0;
    @Element(required=true, name="cost")
    private int cost = 0;
    @Element(required=true, name="amount_power")
    private int amountPower = 0;
    @Element(required=true, name="knight_id")
    private int knightId = 0;

    public BuildPlan() {
    }

    public BuildPlan(@Attribute(name="id") int n, @Element(name="spot_id") int n2, @Element(name="head_cost") int n3, @Element(name="cost") int n4, @Element(name="amount_power") int n5, @Element(name="knight_id") int n6) {
        this.id = n;
        this.id = DataUtil.checkInteger(n, 0, 9999);
        this.spotId = n2;
        this.headCost = n3;
        this.cost = n4;
        this.amountPower = n5;
        this.amountPower = DataUtil.checkInteger(n5, 0, 9999);
        this.knightId = n6;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = DataUtil.checkInteger(n, 0, 9999);
    }

    public Build getBuild() {
        return this.getGameData().getBuilds().get(this.id);
    }

    public int getSpotId() {
        return this.spotId;
    }

    public void setSpotId(int n) {
        this.spotId = n;
    }

    public SpotV getSpot() {
        return this.getGameDataV().getSpots().get(this.spotId);
    }

    public int getHeadCost() {
        return this.headCost;
    }

    public void setHeadCost(int n) {
        this.headCost = n;
    }

    public int getCost() {
        return this.cost;
    }

    public void setCost(int n) {
        this.cost = n;
    }

    public int getAmountPower() {
        return this.amountPower;
    }

    public void setAmountPower(int n) {
        this.amountPower = DataUtil.checkInteger(n, 0, 9999);
    }

    public int getKnightId() {
        return this.knightId;
    }

    public void setKnightId(int n) {
        this.knightId = n;
    }

    public KnightV getKnight() {
        return this.getGameDataV().getKnights().get(this.knightId);
    }

    public boolean isComplete() {
        return this.getBuild() != null && this.getBuild().getPower() <= this.amountPower;
    }

    public void update() {
    }

    @Override
    public String getName() {
        return null;
    }
}

