/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.sengoku.common.GameFontUtil;
import game.sengoku.data.GameDataV;
import game.sengoku.data.TreasureV;
import game.sengoku.window.WindowBase;

public class WindowTreasure
extends WindowBase {
    private static final int INTERVAL = 18;
    private Font font = GameFontUtil.FONT16;
    private int fontColor = -84214785;
    private int daimyoId = 0;
    private int treasureId = 0;
    private String defaultMessage;
    private GameDataV datav;

    public WindowTreasure(int n, int n2, int n3, int n4, int n5, String string, GameDataV gameDataV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.defaultMessage = string;
        this.datav = gameDataV;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public void setDefaultMessage(String string) {
        this.defaultMessage = string;
        this.needUpdate();
    }

    public int getDaimyoId() {
        return this.daimyoId;
    }

    public void setDaimyoId(int n) {
        if (this.daimyoId != n) {
            this.daimyoId = n;
            this.needUpdate();
        }
    }

    public int getTreasureId() {
        return this.treasureId;
    }

    public void setTreasureId(int n) {
        if (this.treasureId != n) {
            this.treasureId = n;
            this.needUpdate();
        }
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        TreasureV treasureV = (TreasureV)this.datav.getTreasures().get(this.treasureId);
        if (treasureV == null) {
            int n = 1;
            this.content.drawText(this.defaultMessage, this.font, this.fontColor, 6, 6 + 18 * n);
            return;
        }
        int n = 1;
        this.content.drawText(treasureV.getName() + "  " + treasureV.getTreasure().getKind(), this.font, this.fontColor, 6, 6 + 18 * n);
        this.content.drawText("\u4fa1\u683c\u3000\u3000\u3000 " + treasureV.getPrice(), this.font, this.fontColor, 6, 6 + 18 * ++n);
        this.content.drawText("\u5185\u653f\u52b9\u679c\u3000 +" + treasureV.getTreasure().getDomesticPlus(), this.font, this.fontColor, 6, 6 + 18 * ++n);
        this.content.drawText("\u6226\u8853\u52b9\u679c\u3000 +" + treasureV.getTreasure().getTacticsPlus(), this.font, this.fontColor, 6, 6 + 18 * ++n);
        this.content.drawText("\u6559\u990a\u52b9\u679c\u3000 +" + treasureV.getTreasure().getCulturePlus(), this.font, this.fontColor, 6, 6 + 18 * ++n);
    }
}

