/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.common.Tuple4;
import game.base.font.Font;
import game.sengoku.common.GameEffectUtil;
import game.sengoku.common.GameFontUtil;
import game.sengoku.data.BattleReport;
import game.sengoku.data.Build;
import game.sengoku.data.Condition;
import game.sengoku.data.CultureV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.KnightV;
import game.sengoku.data.Research;
import game.sengoku.data.TechnologyV;
import game.sengoku.data.UnitType;
import game.sengoku.window.WindowBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;

public class WindowTechnology
extends WindowBase {
    protected static final int INTERVAL = 18;
    public static final int NORMAL = 0;
    public static final int PROGRESS = 1;
    protected Font font = GameFontUtil.FONT16;
    protected int fontColor = -84214785;
    protected TechnologyV technology;
    protected int daimyoId = 0;
    protected String defaultMessage;
    protected GameDataV datav;
    protected int mode = 0;

    public WindowTechnology(int n, int n2, int n3, int n4, int n5, String string, GameDataV gameDataV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.technology = null;
        this.defaultMessage = string;
        this.datav = gameDataV;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        if (this.mode != n) {
            this.mode = n;
            this.needUpdate();
        }
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public void setDefaultMessage(String string) {
        this.defaultMessage = string;
        this.needUpdate();
    }

    public TechnologyV getTechnology() {
        return this.technology;
    }

    public void setTechnology(TechnologyV technologyV) {
        if (this.technology != technologyV) {
            this.technology = technologyV;
            this.needUpdate();
        }
    }

    public int getDaimyoId() {
        return this.daimyoId;
    }

    public void setDaimyoId(int n) {
        if (this.daimyoId != n) {
            this.daimyoId = n;
            this.needUpdate();
        }
    }

    protected void updateContentNormal() {
        String string;
        int n = 2;
        this.content.drawText("\u52b9\u679c", this.font, this.fontColor, 6, 6 + 18 * n);
        ++n;
        Map<Integer, Integer> map = GameEffectUtil.getEffectValues(this.technology.getTechnology().getEffect());
        for (Map.Entry<Integer, Integer> object2 : map.entrySet()) {
            int object3 = object2.getKey();
            int iterator = object2.getValue();
            string = GameEffectUtil.getEffectName(object3);
            String string2 = GameEffectUtil.getEffecUnit(object3);
            this.content.drawText(string + " " + (0 < iterator ? "+" : "") + iterator + string2, this.font, this.fontColor, 6, 6 + 18 * n);
            ++n;
        }
        n = 2;
        if (!this.technology.getUniqTechnologies().isEmpty()) {
            this.content.drawText("\u6d3e\u751f\u6280\u8853", this.font, this.fontColor, 6 + this.width / 4, 6 + 18 * n);
        }
        ++n;
        List list = this.technology.getUniqTechnologies();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TechnologyV technologyV = (TechnologyV)iterator.next();
            this.content.drawText(technologyV.getName(), this.font, this.fontColor, 6 + this.width / 4, 6 + 18 * n);
            ++n;
        }
        n = 2;
        if (!this.technology.getUniqBuilds().isEmpty()) {
            this.content.drawText("\u56fa\u6709\u65bd\u8a2d", this.font, this.fontColor, 6 + this.width / 4 * 2, 6 + 18 * n);
        }
        ++n;
        List list2 = this.technology.getUniqBuilds();
        for (Build build : list2) {
            this.content.drawText(build.getName(), this.font, this.fontColor, 6 + this.width / 4 * 2, 6 + 18 * n);
            ++n;
        }
        n = 2;
        if (!this.technology.getUniqUnits().isEmpty()) {
            this.content.drawText("\u56fa\u6709\u30e6\u30cb\u30c3\u30c8", this.font, this.fontColor, 6 + this.width / 4 * 3, 6 + 18 * n);
        }
        ++n;
        List list3 = this.technology.getUniqUnits();
        Iterator iterator2 = list3.iterator();
        while (iterator2.hasNext()) {
            string = (UnitType)iterator2.next();
            this.content.drawText(string.getName(), this.font, this.fontColor, 6 + this.width / 4 * 3, 6 + 18 * n);
            ++n;
        }
    }

    protected void updateContentProgress() {
        DaimyoV daimyoV = (DaimyoV)this.datav.getDaimyos().get(this.daimyoId);
        int n = 2;
        this.content.drawText("\u7814\u7a76\u53ef\u80fd\u6761\u4ef6", this.font, this.fontColor, 6, 6 + 18 * n);
        ++n;
        if (daimyoV != null) {
            TechnologyV technologyV;
            int n2;
            int n3;
            BattleReport battleReport;
            Condition condition;
            if (daimyoV.getTechnologyIds().contains(this.technology.getId())) {
                int n4 = -69579521;
                this.content.drawText("\u53d6\u5f97\u6e08\u307f", this.font, n4, 6, 6 + 18 * n);
                return;
            }
            if (daimyoV.getResearches().containsKey(this.technology.getId()) && (condition = (Research)daimyoV.getResearches().get(this.technology.getId())) != null && condition.getKnightId() != 0 && (battleReport = (KnightV)this.datav.getKnights().get(condition.getKnightId())) != null) {
                int n5 = (100 - condition.getProgress()) / battleReport.getCulture();
                this.content.drawText(battleReport.getFullName() + "\u304c\u7814\u7a76\u4e2d\u3000\u3000\u6b8b\u308a" + (n5 + 1) + "\u30f6\u6708", this.font, -69579521, 6, 6 + 18 * n);
                return;
            }
            condition = this.technology.getTechnology().getCondition();
            battleReport = daimyoV.getReport();
            ArrayList<Tuple4<IntSupplier, IntSupplier, String, String>> arrayList = new ArrayList<Tuple4<IntSupplier, IntSupplier, String, String>>();
            arrayList.add(new Tuple4<IntSupplier, IntSupplier, String, String>(() -> ((Condition)condition).getMinImpact(), () -> ((DaimyoV)daimyoV).getImpact(), "\u5fc5\u8981\u6700\u4f4e\u6b66\u5a01", ""));
            arrayList.add(new Tuple4<IntSupplier, IntSupplier, String, String>(() -> ((Condition)condition).getMinFood(), () -> ((DaimyoV)daimyoV).getFoodAmount(), "\u5fc5\u8981\u6700\u4f4e\u77f3\u9ad8", ""));
            arrayList.add(new Tuple4<IntSupplier, IntSupplier, String, String>(() -> ((Condition)condition).getMinFoodRate(), () -> ((DaimyoV)daimyoV).getFoodRate(), "\u5fc5\u8981\u6700\u4f4e\u77f3\u9ad8\u958b\u767a\u7387", ""));
            arrayList.add(new Tuple4<IntSupplier, IntSupplier, String, String>(() -> ((Condition)condition).getMinCulture(), () -> ((DaimyoV)daimyoV).getCultureArv(), "\u5fc5\u8981\u6700\u4f4e\u6587\u5316", ""));
            arrayList.add(new Tuple4<IntSupplier, IntSupplier, String, String>(() -> ((Condition)condition).getMinCommerce(), () -> ((DaimyoV)daimyoV).getCommerce(), "\u5fc5\u8981\u6700\u4f4e\u5546\u696d", ""));
            arrayList.add(new Tuple4<IntSupplier, IntSupplier, String, String>(() -> ((Condition)condition).getMinPopulation(), () -> ((DaimyoV)daimyoV).getPopulationAmount(), "\u5fc5\u8981\u6700\u4f4e\u4eba\u53e3", ""));
            arrayList.add(new Tuple4<IntSupplier, IntSupplier, String, String>(() -> ((Condition)condition).getMinChrist(), () -> ((DaimyoV)daimyoV).getChrist(), "\u5fc5\u8981\u6700\u4f4e\u57fa\u7763\u6559\u666e\u53ca\u7387", ""));
            arrayList.add(new Tuple4<IntSupplier, IntSupplier, String, String>(() -> ((Condition)condition).getWin(), () -> ((BattleReport)battleReport).getWin(), "\u5fc5\u8981\u6700\u4f4e\u6483\u7834\u6570", ""));
            arrayList.add(new Tuple4<IntSupplier, IntSupplier, String, String>(() -> ((Condition)condition).getWinPlane(), () -> ((BattleReport)battleReport).getWinPlane(), "\u5fc5\u8981\u6700\u4f4e\u91ce\u6226\u6483\u7834\u6570", ""));
            arrayList.add(new Tuple4<IntSupplier, IntSupplier, String, String>(() -> ((Condition)condition).getWinMountain(), () -> ((BattleReport)battleReport).getWinMountain(), "\u5fc5\u8981\u6700\u4f4e\u5c71\u5cb3\u6483\u7834\u6570", ""));
            arrayList.add(new Tuple4<IntSupplier, IntSupplier, String, String>(() -> ((Condition)condition).getWinSea(), () -> ((BattleReport)battleReport).getWinSea(), "\u5fc5\u8981\u6700\u4f4e\u6d77\u6226\u6483\u7834\u6570", ""));
            arrayList.add(new Tuple4<IntSupplier, IntSupplier, String, String>(() -> ((Condition)condition).getWinGun(), () -> ((BattleReport)battleReport).getWinGun(), "\u5fc5\u8981\u6700\u4f4e\u9244\u7832\u6483\u7834\u6570", ""));
            arrayList.add(new Tuple4<IntSupplier, IntSupplier, String, String>(() -> ((Condition)condition).getWinHorse(), () -> ((BattleReport)battleReport).getWinHorse(), "\u5fc5\u8981\u6700\u4f4e\u9a0e\u99ac\u6483\u7834\u6570", ""));
            arrayList.add(new Tuple4<IntSupplier, IntSupplier, String, String>(() -> ((Condition)condition).getWinCastle(), () -> ((BattleReport)battleReport).getWinCastle(), "\u5fc5\u8981\u6700\u4f4e\u653b\u57ce\u6226\u6483\u7834\u6570", ""));
            arrayList.add(new Tuple4<IntSupplier, IntSupplier, String, String>(() -> ((Condition)condition).getWinDefense(), () -> ((BattleReport)battleReport).getWinDefense(), "\u5fc5\u8981\u6700\u4f4e\u9632\u885b\u6226\u6483\u7834\u6570", ""));
            arrayList.add(new Tuple4<IntSupplier, IntSupplier, String, String>(() -> ((Condition)condition).getMinMoney(), () -> ((DaimyoV)daimyoV).getMoney(), "\u5fc5\u8981\u6700\u4f4e\u91d1", ""));
            arrayList.add(new Tuple4<IntSupplier, IntSupplier, String, String>(() -> ((Condition)condition).getMinGun(), () -> ((DaimyoV)daimyoV).getGun(), "\u5fc5\u8981\u6700\u4f4e\u9244\u7832", ""));
            arrayList.add(new Tuple4<IntSupplier, IntSupplier, String, String>(() -> ((Condition)condition).getMinHorse(), () -> ((DaimyoV)daimyoV).getHorse(), "\u5fc5\u8981\u6700\u4f4e\u99ac", ""));
            arrayList.add(new Tuple4<IntSupplier, IntSupplier, String, String>(() -> ((Condition)condition).getMinIron(), () -> ((DaimyoV)daimyoV).getIron(), "\u5fc5\u8981\u6700\u4f4e\u9244", ""));
            arrayList.add(new Tuple4<IntSupplier, IntSupplier, String, String>(() -> ((Condition)condition).getMinGunpowder(), () -> ((DaimyoV)daimyoV).getGunpowder(), "\u5fc5\u8981\u6700\u4f4e\u706b\u85ac", ""));
            arrayList.add(new Tuple4<IntSupplier, IntSupplier, String, String>(() -> ((Condition)condition).getMinSaltpeter(), () -> ((DaimyoV)daimyoV).getSaltpeter(), "\u5fc5\u8981\u6700\u4f4e\u785d\u77f3", ""));
            for (Tuple4 object2 : arrayList) {
                if (((IntSupplier)object2.getFirst()).getAsInt() == 0) continue;
                if (((IntSupplier)object2.getFirst()).getAsInt() <= ((IntSupplier)object2.getSecond()).getAsInt()) {
                    n3 = -69579521;
                    this.content.drawText((String)object2.getThird(), this.font, n3, 6, 6 + 18 * n);
                    this.content.drawText("" + ((IntSupplier)object2.getFirst()).getAsInt(), this.font, n3, 156, 6 + 18 * n);
                } else {
                    n3 = -84214785;
                    n2 = ((IntSupplier)object2.getSecond()).getAsInt() * 100 / ((IntSupplier)object2.getFirst()).getAsInt();
                    this.content.drawText((String)object2.getThird(), this.font, n3, 6, 6 + 18 * n);
                    this.content.drawText("" + ((IntSupplier)object2.getFirst()).getAsInt() + "  \u73fe\u5728:" + ((IntSupplier)object2.getSecond()).getAsInt(), this.font, n3, 181, 6 + 18 * n);
                }
                ++n;
            }
            if (!condition.getTechnologies().isEmpty()) {
                this.content.drawText("\u5fc5\u8981\u6280\u8853", this.font, -84214785, 6, 6 + 18 * n);
                int n6 = 1;
                Iterator iterator = condition.getTechnologies().iterator();
                while (iterator.hasNext()) {
                    n3 = (Integer)iterator.next();
                    n2 = daimyoV.getTechnologyIds().contains(n3) ? -69579521 : -84214785;
                    technologyV = (TechnologyV)this.datav.getTechnologies().get(n3);
                    this.content.drawText(technologyV.getName(), this.font, n2, 26 + 80 * n6, 6 + 18 * n);
                    ++n6;
                }
                ++n;
            }
            if (!condition.getCultures().isEmpty()) {
                this.content.drawText("\u5fc5\u8981\u6587\u5316", this.font, -84214785, 6, 6 + 18 * n);
                int n7 = 1;
                Iterator iterator = condition.getCultures().iterator();
                while (iterator.hasNext()) {
                    n3 = (Integer)iterator.next();
                    n2 = daimyoV.getCultureIds().contains(n3) ? -69579521 : -84214785;
                    technologyV = (CultureV)this.datav.getCultures().get(n3);
                    this.content.drawText(technologyV.getName(), this.font, n2, 26 + 80 * n7, 6 + 18 * n);
                    ++n7;
                }
                ++n;
            }
        }
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        if (this.technology == null) {
            int n = 1;
            this.content.drawText(this.defaultMessage, this.font, this.fontColor, 6, 6 + 18 * n);
            return;
        }
        int n = 1;
        this.content.drawText(this.technology.getName(), this.font, this.fontColor, 6, 6 + 18 * n);
        switch (this.mode) {
            case 0: {
                this.updateContentNormal();
                break;
            }
            case 1: {
                this.updateContentProgress();
            }
        }
    }
}

