/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.base.graphic.Texture;
import game.sengoku.common.GameFontUtil;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.Technique;
import game.sengoku.data.UnitV;
import game.sengoku.game.GameUnitUtil;
import game.sengoku.game.tactics.TacticsResult;
import game.sengoku.window.WindowBase;

public class WindowTacticsResult
extends WindowBase {
    private static final int INTERVAL = 20;
    private Font font = GameFontUtil.FONT16;
    private int fontColor = -319753729;
    private int daimyoId = 0;
    private TacticsResult tacticsResult;
    private GameDataV datav;

    public WindowTacticsResult(int n, int n2, int n3, int n4, int n5, int n6, GameDataV gameDataV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.daimyoId = n6;
        this.datav = gameDataV;
    }

    public int getDaimyoId() {
        return this.daimyoId;
    }

    public void setDaimyoId(int n) {
        if (this.daimyoId != n) {
            this.daimyoId = n;
            this.needUpdate();
        }
    }

    public void setTacticsResult(TacticsResult tacticsResult) {
        this.tacticsResult = tacticsResult;
        this.needUpdate();
    }

    @Override
    public void update() {
        super.update();
        DaimyoV daimyoV = (DaimyoV)this.datav.getDaimyos().get(this.daimyoId);
        if (daimyoV == null || this.tacticsResult == null) {
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
        this.needUpdate();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        DaimyoV daimyoV = (DaimyoV)this.datav.getDaimyos().get(this.daimyoId);
        int n = this.tacticsResult.getUnitId();
        UnitV unitV = (UnitV)this.datav.getUnits().get(n);
        if (unitV != null) {
            Texture texture = GameUnitUtil.selectTexture(daimyoV, unitV);
            int n2 = GameUnitUtil.calcEdge(unitV);
            this.content.drawImage(texture, 0, 0, texture.getWidth(), texture.getHeight(), 6, 11, n2, n2);
            this.content.drawText(unitV.getName(), this.font, this.fontColor, 36, 26);
            Technique technique = (Technique)this.datav.getGameData().getTechniques().get(this.tacticsResult.getTechniqueId());
            if (technique != null) {
                this.content.drawText("" + technique.getName(), this.font, this.fontColor, 136, 26);
            }
        }
    }
}

