/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.sengoku.common.GameFontUtil;
import game.sengoku.data.CountryV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.RoleV;
import game.sengoku.window.WindowBase;
import java.util.Iterator;

public class WindowRoleInfo
extends WindowBase {
    private static final int INTERVAL = 22;
    private Font font = GameFontUtil.FONT16;
    private int fontColor = -319753729;
    private int roleId;
    private String defaultMessage;
    private GameDataV datav;

    public WindowRoleInfo(int n, int n2, int n3, int n4, int n5, String string, GameDataV gameDataV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.roleId = 0;
        this.defaultMessage = string;
        this.datav = gameDataV;
    }

    public int getRoleId() {
        return this.roleId;
    }

    public void setRoleId(int n) {
        if (this.roleId != n) {
            this.roleId = n;
            this.needUpdate();
        }
    }

    public void setId(int n) {
        this.setRoleId(n);
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public void setDefaultMessage(String string) {
        this.defaultMessage = string;
        this.needUpdate();
    }

    private String[] getLabels(RoleV roleV) {
        String string;
        String[] stringArray = new String[2];
        String string2 = string = roleV.getRole().isAroundJapan() ? "\u5168\u56fd\u3067" : "\u4ee5\u4e0b\u306e\u56fd\u3067";
        if (0 < roleV.getRole().getAttackPlusRate()) {
            string = string + "\u3001\u653b\u6483\u529b +" + roleV.getRole().getAttackPlusRate() + "\uff05";
        }
        if (0 < roleV.getRole().getDefensePlusRate()) {
            string = string + "\u3001\u9632\u5fa1\u529b +" + roleV.getRole().getDefensePlusRate() + "\uff05";
        }
        stringArray[0] = string;
        string = "";
        Iterator iterator = roleV.getRole().getCountries().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            CountryV countryV = (CountryV)this.datav.getCountries().get(n);
            string = string + countryV.getName() + " ";
        }
        stringArray[1] = string;
        return stringArray;
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        RoleV roleV = (RoleV)this.datav.getRoles().get(this.roleId);
        if (roleV != null) {
            int n = 1;
            this.content.drawText(roleV.getName(), this.font, this.fontColor, 6, 6 + 22 * n);
            this.content.drawText("\u6700\u5927\u540d\u58f0\u3000+" + roleV.getRole().getFamePlus(), this.font, this.fontColor, 6, 6 + 22 * ++n);
            String[] stringArray = this.getLabels(roleV);
            this.content.drawText(stringArray[0], this.font, this.fontColor, 6, 6 + 22 * ++n);
            this.content.drawText(stringArray[1], this.font, this.fontColor, 6, 6 + 22 * ++n);
        } else {
            int n = 1;
            this.content.drawText(this.defaultMessage, this.font, this.fontColor, 6, 6 + 22 * n);
        }
    }
}

