/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.common.RelationUtil;
import game.sengoku.data.CountryV;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.UnmodifiableReration;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.WindowBase;

public class WindowPropagateInfo
extends WindowBase {
    private static final int INTERVAL = 20;
    private Font font = GameFontUtil.FONT16;
    private int fontColor = -319753729;
    private int daimyoId;
    private int targetCountryId;
    private String defaultMessage;
    private GameDataV datav;
    private ButtonSprite relationLabel;
    private ButtonSprite friendshipLabel;
    private ButtonSprite toubatsu;
    private ButtonSprite border;

    public WindowPropagateInfo(int n, int n2, int n3, int n4, int n5, int n6, String string, GameDataV gameDataV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.daimyoId = n6;
        this.defaultMessage = string;
        this.datav = gameDataV;
        this.relationLabel = new ButtonSprite(n4 - 275, 6, 100, 50, 20, 388883421, 388883421, GameFontUtil.FONT16, "", true, MouseSymbolLayerManager.LAYER_MESSAGE);
        this.relationLabel.setFontColor(-319753729);
        this.friendshipLabel = new ButtonSprite(n4 - 330, 6, 100, 50, 20, 388883421, 388883421, GameFontUtil.FONT16, "", true, MouseSymbolLayerManager.LAYER_MESSAGE);
        this.friendshipLabel.setFontColor(-319753729);
        this.toubatsu = new ButtonSprite(n4 - 220, 6, 100, 50, 20, -1069995009, -1069995009, GameFontUtil.FONT16, "\u8a0e\u4f10", true, MouseSymbolLayerManager.LAYER_MESSAGE);
        this.toubatsu.setFontColor(-319753729);
        this.border = new ButtonSprite(n4 - 165, 6, 100, 75, 20, -414434049, -414434049, GameFontUtil.FONT16, "\u56fd\u5883\u7d1b\u4e89", true, MouseSymbolLayerManager.LAYER_MESSAGE);
        this.border.setFontColor(-319753729);
    }

    public int getDaimyoId() {
        return this.daimyoId;
    }

    public void setDaimyoId(int n) {
        if (this.daimyoId != n) {
            this.daimyoId = n;
            this.needUpdate();
        }
    }

    public int getTargetCountryId() {
        return this.targetCountryId;
    }

    public void setTargetCountryId(int n) {
        if (this.targetCountryId != n) {
            this.targetCountryId = n;
            this.needUpdate();
        }
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public void setDefaultMessage(String string) {
        this.defaultMessage = string;
        this.needUpdate();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        DaimyoV daimyoV = (DaimyoV)this.datav.getDaimyos().get(this.daimyoId);
        CountryV countryV = (CountryV)this.datav.getCountries().get(this.targetCountryId);
        if (daimyoV == null || countryV == null) {
            int n = 1;
            this.content.drawText(this.defaultMessage, this.font, this.fontColor, 6, 6 + 20 * n);
            return;
        }
        DaimyoV daimyoV2 = countryV.getDaimyo();
        UnmodifiableReration unmodifiableReration = this.datav.getRelation(daimyoV2.getId(), this.daimyoId);
        int n = 1;
        this.content.drawText(countryV.getName(), this.font, this.fontColor, 6, 6 + 20 * n);
        this.content.drawText(daimyoV2.getName(), this.font, this.fontColor, 106, 6 + 20 * n);
        if (unmodifiableReration != null) {
            this.content.drawText("\u53cb\u597d\u5ea6  " + unmodifiableReration.getFriendShip(), this.font, this.fontColor, 306, 6 + 20 * n);
            this.friendshipLabel.setText(RelationUtil.friendShipName(unmodifiableReration));
            this.friendshipLabel.setBgColor(RelationUtil.friendShipColor(unmodifiableReration));
            this.friendshipLabel.draw(this.content);
            if (unmodifiableReration.getStatus() != 0) {
                this.relationLabel.setText(RelationUtil.relationName(unmodifiableReration));
                this.relationLabel.setBgColor(RelationUtil.relationColor(unmodifiableReration));
                this.relationLabel.draw(this.content);
            }
            if (0 < daimyoV2.getToubatsuLeave()) {
                this.toubatsu.draw(this.content);
            }
            if (0 < unmodifiableReration.getBorder()) {
                this.border.draw(this.content);
            }
        }
        int n2 = countryV.getMissionary();
        this.content.drawText("\u5e03\u6559\u7387  " + n2 / countryV.getPopulation() + "\uff05", this.font, this.fontColor, 6, 46);
        this.content.drawText("\u4fe1\u5f92\u6570  " + n2, this.font, this.fontColor, 206, 46);
    }
}

