/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.base.graphic.Texture;
import game.sengoku.common.GameFontUtil;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.UnitV;
import game.sengoku.game.GameUnitUtil;
import game.sengoku.window.WindowBase;

public class WindowMapUnitInfo
extends WindowBase {
    private static final int INTERVAL = 20;
    private Font font = GameFontUtil.FONT16;
    private int fontColor = -319753729;
    private int unitId;
    private GameDataV datav;
    private DaimyoV daimyo;

    public WindowMapUnitInfo(int n, int n2, int n3, int n4, int n5, GameDataV gameDataV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.unitId = 0;
        this.datav = gameDataV;
    }

    public DaimyoV getDaimyo() {
        return this.daimyo;
    }

    public void setDaimyo(DaimyoV daimyoV) {
        if (daimyoV == null || this.daimyo == null || this.daimyo.getId() != daimyoV.getId()) {
            this.daimyo = daimyoV;
            this.needUpdate();
        }
    }

    public int getUnitId() {
        return this.unitId;
    }

    public void setUnitId(int n) {
        if (this.unitId != n) {
            this.unitId = n;
            this.needUpdate();
        }
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        if (this.daimyo == null) {
            return;
        }
        UnitV unitV = (UnitV)this.datav.getUnits().get(this.unitId);
        if (unitV != null) {
            int n = 1;
            unitV.getSpot().updateUnits();
            for (UnitV unitV2 : unitV.getSpot().getUnits()) {
                Texture texture = GameUnitUtil.selectTexture(this.daimyo, unitV2);
                int n2 = GameUnitUtil.calcEdge(unitV2);
                this.content.drawImage(texture, 0, 0, texture.getWidth(), texture.getHeight(), 6, 12 + 20 * (n - 1), n2, n2);
                this.content.drawText(unitV2.getUnit().getName(), this.font, this.fontColor, 36, 6 + 20 * n);
                this.content.drawText("" + unitV2.getLeave(), this.font, this.fontColor, 136, 6 + 20 * n);
                ++n;
                if (unitV2.getDaimyo() == null) continue;
                this.content.drawText(unitV2.getName() + "(" + unitV2.getDaimyo().getName() + ")", this.font, this.fontColor, 36, 6 + 20 * n);
                ++n;
            }
        }
    }
}

