/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.sengoku.common.GameEffectUtil;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.GameUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.data.BorderConflictV;
import game.sengoku.data.Build;
import game.sengoku.data.GameDataV;
import game.sengoku.data.SpotV;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.WindowBase;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class WindowMapInfo
extends WindowBase {
    private static final int INTERVAL = 20;
    private Font font = GameFontUtil.FONT16;
    private int fontColor = -319753729;
    private int spotId;
    private int buildId;
    private BorderConflictV borderConflict;
    private GameDataV datav;
    private ButtonSprite spotTypeLabel;

    public WindowMapInfo(int n, int n2, int n3, int n4, int n5, GameDataV gameDataV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.spotId = 0;
        this.buildId = 0;
        this.datav = gameDataV;
        this.spotTypeLabel = new ButtonSprite(n4 - 55, 6, 100, 50, 20, 388883421, 388883421, GameFontUtil.FONT16, "", true, MouseSymbolLayerManager.LAYER_MESSAGE);
        this.spotTypeLabel.setFontColor(-319753729);
    }

    public int getSpotId() {
        return this.spotId;
    }

    public void setSpotId(int n) {
        if (this.spotId != n) {
            this.spotId = n;
            this.needUpdate();
        }
    }

    public int getBuildId() {
        return this.buildId;
    }

    public void setBuildId(int n) {
        if (this.buildId != n) {
            this.buildId = n;
            this.needUpdate();
        }
    }

    public void setId(int n, int n2) {
        this.setSpotId(n);
        this.setBuildId(n2);
    }

    public BorderConflictV getBorderConflict() {
        return this.borderConflict;
    }

    public void setBorderConflict(BorderConflictV borderConflictV) {
        this.borderConflict = borderConflictV;
        this.needUpdate();
    }

    public int getSpotColor(SpotV spotV) {
        return GameUtil.getSpotColor(spotV.getType());
    }

    @Override
    protected void updateContent() {
        block8: {
            SpotV spotV;
            block7: {
                super.updateContent();
                if (this.borderConflict != null) {
                    int n = 1;
                    this.content.drawText("\u56fd\u5883\u7d1b\u4e89", this.font, this.fontColor, 6, 6 + 20 * n);
                    this.content.drawText(this.borderConflict.getSpot1().getName() + "\u3068" + this.borderConflict.getSpot2().getName() + "\u306e\u8fb2\u6c11\u304c\u6c34\u5834\u3092", this.font, this.fontColor, 6, 6 + 20 * ++n);
                    this.content.drawText("\u3081\u3050\u3063\u3066\u4e89\u3063\u3066\u3044\u307e\u3059\u3002", this.font, this.fontColor, 6, 6 + 20 * ++n);
                    return;
                }
                spotV = (SpotV)this.datav.getSpots().get(this.spotId);
                Build build3 = (Build)this.datav.getGameData().getBuilds().get(this.buildId);
                if (build3 == null) break block7;
                int n = 1;
                this.content.drawText(build3.getName(), this.font, this.fontColor, 6, 6 + 20 * n);
                n = 2;
                Map<Integer, Integer> map = GameEffectUtil.getEffectValues(build3.getEffect());
                for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
                    int n2 = entry.getKey();
                    int n3 = entry.getValue();
                    String string = GameEffectUtil.getEffectName(n2);
                    String string2 = GameEffectUtil.getEffecUnit(n2);
                    if (n2 == 14 || n2 == 15) {
                        double d = this.datav.getWorld().getInflationRate();
                        n3 = (int)Math.ceil((double)n3 * d);
                    }
                    this.content.drawText(string + " " + (0 < n3 ? "+" : "") + n3 + string2, this.font, this.fontColor, 6, 6 + 20 * n);
                    ++n;
                }
                break block8;
            }
            if (spotV == null) break block8;
            int n = 1;
            if (spotV.getCountry() == null) {
                this.content.drawText("\u516c\u6d77 " + spotV.getName(), this.font, this.fontColor, 6, 6 + 20 * n);
            } else {
                this.content.drawText(spotV.getCountry().getName() + "\u56fd " + spotV.getName(), this.font, this.fontColor, 6, 6 + 20 * n);
            }
            this.spotTypeLabel.setText(spotV.getTypeName());
            this.spotTypeLabel.setBgColor(this.getSpotColor(spotV));
            this.spotTypeLabel.draw(this.content);
            ++n;
            if (spotV.getDaimyo() != null) {
                this.content.drawText(spotV.getDaimyo().getName(), this.font, this.fontColor, 6, 6 + 20 * n);
                ++n;
            }
            this.content.drawText("\u6226\u95d8\u52b9\u679c " + spotV.getDefense(), this.font, this.fontColor, 6, 6 + 20 * n);
            ++n;
            List list = spotV.getBuilds().stream().sorted((build, build2) -> build2.getCost() - build.getCost()).limit(5L).collect(Collectors.toList());
            for (Build build4 : list) {
                this.content.drawText(build4.getName(), this.font, this.fontColor, 6, 6 + 20 * n);
                ++n;
            }
        }
    }
}

