/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.sengoku.common.GameEffectUtil;
import game.sengoku.common.GameFontUtil;
import game.sengoku.data.GameDataV;
import game.sengoku.data.GiantV;
import game.sengoku.data.KnightV;
import game.sengoku.window.WindowBase;
import java.util.Map;

public class WindowEmployInfo
extends WindowBase {
    private static final int INTERVAL = 22;
    private Font font = GameFontUtil.FONT20;
    private int fontColor = -319753729;
    private int knightId;
    private int giantId;
    private String defaultMessage;
    private GameDataV datav;

    public WindowEmployInfo(int n, int n2, int n3, int n4, int n5, String string, GameDataV gameDataV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.knightId = 0;
        this.giantId = 0;
        this.defaultMessage = string;
        this.datav = gameDataV;
    }

    public int getKnightId() {
        return this.knightId;
    }

    public void setKnightId(int n) {
        if (this.knightId != n) {
            this.knightId = n;
            this.needUpdate();
        }
    }

    public int getGiantId() {
        return this.giantId;
    }

    public void setGiantId(int n) {
        if (this.giantId != n) {
            this.giantId = n;
            this.needUpdate();
        }
    }

    public void setId(int n, int n2, int n3) {
        this.setKnightId(n);
        this.setGiantId(n2);
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public void setDefaultMessage(String string) {
        this.defaultMessage = string;
        this.needUpdate();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        KnightV knightV = (KnightV)this.datav.getKnights().get(this.knightId);
        GiantV giantV = (GiantV)this.datav.getGiants().get(this.giantId);
        if (knightV != null) {
            int n = 1;
            this.content.drawText(knightV.getFullName(), this.font, this.fontColor, 6, 6 + 22 * n);
            if (knightV.getDaimyoId() == 0) {
                if (knightV.getKnight().isKokujin()) {
                    this.content.drawText("\u56fd\u4eba", this.font, this.fontColor, 156, 6 + 22 * n);
                } else {
                    this.content.drawText("\u6d6a\u4eba", this.font, this.fontColor, 156, 6 + 22 * n);
                }
            } else if (!knightV.isEmployee()) {
                this.content.drawText("\u56fd\u4eba", this.font, this.fontColor, 156, 6 + 22 * n);
            } else {
                this.content.drawText("\u5bb6\u81e3", this.font, this.fontColor, 156, 6 + 22 * n);
            }
            ++n;
            if (knightV.getDaimyoId() == 0) {
                this.content.drawText("\u96c7\u7528\u30b3\u30b9\u30c8 " + knightV.getHeadPay(), this.font, this.fontColor, 6, 6 + 22 * n);
                this.content.drawText("\u7d66\u6599\u3000\u3000\u3000 " + knightV.getPay(), this.font, this.fontColor, 6, 6 + 22 * ++n);
                ++n;
            } else {
                this.content.drawText("\u5e74\u9f62 " + knightV.getAge(), this.font, this.fontColor, 6, 6 + 22 * n);
                ++n;
            }
        } else if (giantV != null) {
            int n = 1;
            this.content.drawText(giantV.getGiant().getType() + "\u3000" + giantV.getFullName(), this.font, this.fontColor, 6, 6 + 22 * n);
            ++n;
            if (giantV.getDaimyoId() == 0) {
                this.content.drawText("\u96c7\u7528\u30b3\u30b9\u30c8 " + giantV.getHeadPay(), this.font, this.fontColor, 6, 6 + 22 * n);
                this.content.drawText("\u7d66\u6599\u3000\u3000\u3000 " + giantV.getPay(), this.font, this.fontColor, 6, 6 + 22 * ++n);
                ++n;
            } else {
                this.content.drawText("\u7d66\u6599\u3000\u3000\u3000\u3000 " + giantV.getPay(), this.font, this.fontColor, 6, 6 + 22 * n);
                this.content.drawText("\u7814\u7a76\u5b8c\u4e86\u307e\u3067 " + (giantV.getGiant().getCultureMonths() - giantV.getMonth()) + "\u30f6\u6708", this.font, this.fontColor, 6, 6 + 22 * ++n);
                ++n;
            }
            n = 2;
            Map<Integer, Integer> map = GameEffectUtil.getEffectValues(giantV.getGiant().getEffect());
            for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
                int n2 = entry.getKey();
                int n3 = entry.getValue();
                String string = GameEffectUtil.getEffectName(n2);
                String string2 = GameEffectUtil.getEffecUnit(n2);
                this.content.drawText(string + " " + (0 < n3 ? "+" : "") + n3 + string2, this.font, this.fontColor, 206, 6 + 22 * n);
                ++n;
            }
        } else {
            int n = 1;
            this.content.drawText(this.defaultMessage, this.font, this.fontColor, 6, 6 + 22 * n);
        }
    }
}

