/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.common.Pair;
import game.base.font.Font;
import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.data.DaimyoV;
import game.sengoku.game.log.LogCountryData;
import game.sengoku.game.log.LogDaimyoData;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.WindowBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class WindowDomesticReport
extends WindowBase {
    private static final int BUTTON_WIDTH = 32;
    private static final int BUTTON_HEIGHT = 20;
    private static final int VALUE_X = 160;
    private static final int ARRAW_X = 220;
    private static final int INTERVAL_X = 260;
    private static final int INTERVAL_Y = 22;
    private static final int ICON_X = 320;
    private Font font = GameFontUtil.FONT20;
    private int fontColor = -269422081;
    private int pageIndex = 0;
    protected ButtonSprite nextButton;
    protected ButtonSprite prevButton;
    protected ButtonSprite exitButton;
    private List<Pair<LogCountryData, LogCountryData>> logCountryDataPairs;
    private Pair<LogDaimyoData, LogDaimyoData> logDaimyoDataPair;
    private Map<Integer, Integer> cashFlow;
    private DaimyoV daimyo;
    private Texture texUp;
    private Texture texDown;

    public WindowDomesticReport(int n, int n2, int n3, int n4, int n5) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.logCountryDataPairs = new ArrayList<Pair<LogCountryData, LogCountryData>>();
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.texUp = (Texture)graphicPool.getResource("updelta.png");
        this.texDown = (Texture)graphicPool.getResource("downdelta.png");
    }

    public void reset(LogDaimyoData logDaimyoData, Map<Integer, LogCountryData> map, LogDaimyoData logDaimyoData2, Map<Integer, LogCountryData> map2, DaimyoV daimyoV) {
        this.logDaimyoDataPair = new Pair<LogDaimyoData, LogDaimyoData>(logDaimyoData, logDaimyoData2);
        this.logCountryDataPairs = map2.keySet().stream().sorted().filter(n -> map.containsKey(n)).map(n -> new Pair(map.get(n), map2.get(n))).collect(Collectors.toList());
        this.cashFlow = daimyoV.getCashFlow();
        this.daimyo = daimyoV;
        this.pageIndex = 0;
        this.needUpdate();
    }

    @Override
    protected void init() {
        this.nextButton = new ButtonSprite(this.width / 2 + 5, this.height - 6 - 17, 100, 32, 20, 388883421, -1380583425, this.font, "\u6b21", true, MouseSymbolLayerManager.LAYER_MIDDLE);
        this.nextButton.setPrimaryClicked(windowClickable -> this.onNextClicked());
        this.nextButton.setFontColor(-319753729);
        this.nextButton.setParent(this);
        this.children.add(this.nextButton);
        this.prevButton = new ButtonSprite(this.width / 2 + 5 - 32 - 5, this.height - 6 - 17, 100, 32, 20, 388883421, -1380583425, this.font, "\u623b", true, MouseSymbolLayerManager.LAYER_MIDDLE);
        this.prevButton.setPrimaryClicked(windowClickable -> this.onPrevClicked());
        this.prevButton.setFontColor(-319753729);
        this.prevButton.setParent(this);
        this.children.add(this.prevButton);
        this.exitButton = new ButtonSprite(this.width / 2 + 5 + 32 + 5, this.height - 6 - 17, 100, 32, 20, 388883421, -1380583425, this.font, "\u9589", true, MouseSymbolLayerManager.LAYER_MIDDLE);
        this.exitButton.setPrimaryClicked(windowClickable -> this.onExitClicked());
        this.exitButton.setFontColor(-319753729);
        this.exitButton.setParent(this);
        this.children.add(this.exitButton);
    }

    private void onExitClicked() {
        this.setVisible(false);
        this.needUpdate();
    }

    private void onNextClicked() {
        if (!this.isLast()) {
            ++this.pageIndex;
            this.needUpdate();
        }
    }

    private void onPrevClicked() {
        if (!this.isFirst()) {
            --this.pageIndex;
            this.needUpdate();
        }
    }

    private boolean isFirst() {
        return this.pageIndex == 0;
    }

    private boolean isLast() {
        return this.pageIndex >= this.logCountryDataPairs.size() + 1;
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        if (this.pageIndex == 0) {
            this.updateContentCashFlow();
        } else if (this.pageIndex == 1) {
            this.updateContentDaimyo();
        } else if (this.pageIndex - 2 < this.logCountryDataPairs.size()) {
            this.updateContentCountry(this.pageIndex - 2);
        }
    }

    protected void updateContentCountry(int n) {
        LogCountryData logCountryData = this.logCountryDataPairs.get(n).getFirst();
        LogCountryData logCountryData2 = this.logCountryDataPairs.get(n).getSecond();
        int n2 = 1;
        this.content.drawText(logCountryData.getName() + "\u56fd", this.font, this.fontColor, 6, 6 + 22 * n2);
        ++n2;
        this.content.drawText("\u77f3\u9ad8 ", this.font, this.fontColor, 6, 6 + 22 * ++n2);
        this.content.drawText(" " + logCountryData.getFood(), this.font, this.fontColor, 160, 6 + 22 * n2);
        this.content.drawText("\u2192", this.font, this.fontColor, 220, 6 + 22 * n2);
        this.content.drawText(" " + logCountryData2.getFood(), this.font, this.fontColor, 266, 6 + 22 * n2);
        this.drawDelta(logCountryData.getFood() - logCountryData2.getFood(), 320, 6 + 22 * n2);
        this.content.drawText("\u4eba\u53e3 ", this.font, this.fontColor, 6, 6 + 22 * ++n2);
        this.content.drawText(" " + logCountryData.getPopulation(), this.font, this.fontColor, 160, 6 + 22 * n2);
        this.content.drawText("\u2192", this.font, this.fontColor, 220, 6 + 22 * n2);
        this.content.drawText(" " + logCountryData2.getPopulation(), this.font, this.fontColor, 266, 6 + 22 * n2);
        this.drawDelta(logCountryData.getPopulation() - logCountryData2.getPopulation(), 320, 6 + 22 * n2);
        this.content.drawText("\u5546\u696d ", this.font, this.fontColor, 6, 6 + 22 * ++n2);
        this.content.drawText(" " + logCountryData.getCommerce(), this.font, this.fontColor, 160, 6 + 22 * n2);
        this.content.drawText("\u2192", this.font, this.fontColor, 220, 6 + 22 * n2);
        this.content.drawText(" " + logCountryData2.getCommerce(), this.font, this.fontColor, 266, 6 + 22 * n2);
        this.drawDelta(logCountryData.getCommerce() - logCountryData2.getCommerce(), 320, 6 + 22 * n2);
        this.content.drawText("\u6587\u5316 ", this.font, this.fontColor, 6, 6 + 22 * ++n2);
        this.content.drawText(" " + logCountryData.getCulture(), this.font, this.fontColor, 160, 6 + 22 * n2);
        this.content.drawText("\u2192", this.font, this.fontColor, 220, 6 + 22 * n2);
        this.content.drawText(" " + logCountryData2.getCulture(), this.font, this.fontColor, 266, 6 + 22 * n2);
        this.drawDelta(logCountryData.getCulture() - logCountryData2.getCulture(), 320, 6 + 22 * n2);
        this.content.drawText("\u6c11\u5fe0 ", this.font, this.fontColor, 6, 6 + 22 * ++n2);
        this.content.drawText(" " + logCountryData.getTamichu(), this.font, this.fontColor, 160, 6 + 22 * n2);
        this.content.drawText("\u2192", this.font, this.fontColor, 220, 6 + 22 * n2);
        this.content.drawText(" " + logCountryData2.getTamichu(), this.font, this.fontColor, 266, 6 + 22 * n2);
        this.drawDelta(logCountryData.getTamichu() - logCountryData2.getTamichu(), 320, 6 + 22 * n2);
        this.content.drawText("\u57fa\u7763\u6559\u666e\u53ca\u7387 ", this.font, this.fontColor, 6, 6 + 22 * ++n2);
        this.content.drawText(" " + logCountryData.getChrist(), this.font, this.fontColor, 160, 6 + 22 * n2);
        this.content.drawText("\u2192", this.font, this.fontColor, 220, 6 + 22 * n2);
        this.content.drawText(" " + logCountryData2.getChrist(), this.font, this.fontColor, 266, 6 + 22 * n2);
        this.drawDelta(logCountryData.getChrist() - logCountryData2.getChrist(), 320, 6 + 22 * n2);
        this.content.drawText("\u6700\u5927\u5175\u6570 ", this.font, this.fontColor, 6, 6 + 22 * ++n2);
        this.content.drawText(" " + logCountryData.getMaxArmy(), this.font, this.fontColor, 160, 6 + 22 * n2);
        this.content.drawText("\u2192", this.font, this.fontColor, 220, 6 + 22 * n2);
        this.content.drawText(" " + logCountryData2.getMaxArmy(), this.font, this.fontColor, 266, 6 + 22 * n2);
        this.drawDelta(logCountryData.getMaxArmy() - logCountryData2.getMaxArmy(), 320, 6 + 22 * n2);
        this.content.drawText("\u51fa\u9663\u53ef\u80fd\u5175\u6570 ", this.font, this.fontColor, 6, 6 + 22 * ++n2);
        this.content.drawText(" " + logCountryData.getUsableArmy(), this.font, this.fontColor, 160, 6 + 22 * n2);
        this.content.drawText("\u2192", this.font, this.fontColor, 220, 6 + 22 * n2);
        this.content.drawText(" " + logCountryData2.getUsableArmy(), this.font, this.fontColor, 266, 6 + 22 * n2);
        this.drawDelta(logCountryData.getUsableArmy() - logCountryData2.getUsableArmy(), 320, 6 + 22 * n2);
        this.content.drawText("\u5175\u58eb\u7d4c\u9a13\u5024 ", this.font, this.fontColor, 6, 6 + 22 * ++n2);
        this.content.drawText(" " + logCountryData.getArmyExp(), this.font, this.fontColor, 160, 6 + 22 * n2);
        this.content.drawText("\u2192", this.font, this.fontColor, 220, 6 + 22 * n2);
        this.content.drawText(" " + logCountryData2.getArmyExp(), this.font, this.fontColor, 266, 6 + 22 * n2);
        this.drawDelta(logCountryData.getArmyExp() - logCountryData2.getArmyExp(), 320, 6 + 22 * n2);
        this.content.drawText("\u5175\u58eb\u30ec\u30d9\u30eb ", this.font, this.fontColor, 6, 6 + 22 * ++n2);
        this.content.drawText(" " + logCountryData.getArmyLevel(), this.font, this.fontColor, 160, 6 + 22 * n2);
        this.content.drawText("\u2192", this.font, this.fontColor, 220, 6 + 22 * n2);
        this.content.drawText(" " + logCountryData2.getArmyLevel(), this.font, this.fontColor, 266, 6 + 22 * n2);
        this.drawDelta(logCountryData.getArmyLevel() - logCountryData2.getArmyLevel(), 320, 6 + 22 * n2);
    }

    protected void updateContentDaimyo() {
        if (this.logDaimyoDataPair == null) {
            return;
        }
        LogDaimyoData logDaimyoData = this.logDaimyoDataPair.getFirst();
        LogDaimyoData logDaimyoData2 = this.logDaimyoDataPair.getSecond();
        int n = 1;
        this.content.drawText(logDaimyoData.getName(), this.font, this.fontColor, 6, 6 + 22 * n);
        ++n;
        this.content.drawText("\u540d\u58f0\u3000\u3000 ", this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText(" " + logDaimyoData.getFame(), this.font, this.fontColor, 160, 6 + 22 * n);
        this.content.drawText("\u2192", this.font, this.fontColor, 220, 6 + 22 * n);
        this.content.drawText(" " + logDaimyoData2.getFame(), this.font, this.fontColor, 266, 6 + 22 * n);
        this.drawDelta(logDaimyoData.getFame() - logDaimyoData2.getFame(), 320, 6 + 22 * n);
        this.content.drawText("\u6b66\u5a01\u3000\u3000 ", this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText(" " + logDaimyoData.getImpact(), this.font, this.fontColor, 160, 6 + 22 * n);
        this.content.drawText("\u2192", this.font, this.fontColor, 220, 6 + 22 * n);
        this.content.drawText(" " + logDaimyoData2.getImpact(), this.font, this.fontColor, 266, 6 + 22 * n);
        this.drawDelta(logDaimyoData.getImpact() - logDaimyoData2.getImpact(), 320, 6 + 22 * n);
        this.content.drawText("\u56fd\u6570\u3000\u3000 ", this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText(" " + logDaimyoData.getCountries(), this.font, this.fontColor, 160, 6 + 22 * n);
        this.content.drawText("\u2192", this.font, this.fontColor, 220, 6 + 22 * n);
        this.content.drawText(" " + logDaimyoData2.getCountries(), this.font, this.fontColor, 266, 6 + 22 * n);
        this.drawDelta(logDaimyoData.getCountries() - logDaimyoData2.getCountries(), 320, 6 + 22 * n);
        this.content.drawText("\u7dcf\u4eba\u53e3\u3000 ", this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText(" " + logDaimyoData.getPopulationAmount(), this.font, this.fontColor, 160, 6 + 22 * n);
        this.content.drawText("\u2192", this.font, this.fontColor, 220, 6 + 22 * n);
        this.content.drawText(" " + logDaimyoData2.getPopulationAmount(), this.font, this.fontColor, 266, 6 + 22 * n);
        this.drawDelta(logDaimyoData.getPopulationAmount() - logDaimyoData2.getPopulationAmount(), 320, 6 + 22 * n);
        this.content.drawText("\u7dcf\u77f3\u9ad8\u3000 ", this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText(" " + logDaimyoData.getFoodAmount(), this.font, this.fontColor, 160, 6 + 22 * n);
        this.content.drawText("\u2192", this.font, this.fontColor, 220, 6 + 22 * n);
        this.content.drawText(" " + logDaimyoData2.getFoodAmount(), this.font, this.fontColor, 266, 6 + 22 * n);
        this.drawDelta(logDaimyoData.getFoodAmount() - logDaimyoData2.getFoodAmount(), 320, 6 + 22 * n);
        this.content.drawText("\u91d1\u92ad\u3000\u3000 ", this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText(" " + logDaimyoData.getMoney(), this.font, this.fontColor, 160, 6 + 22 * n);
        this.content.drawText("\u2192", this.font, this.fontColor, 220, 6 + 22 * n);
        this.content.drawText(" " + logDaimyoData2.getMoney(), this.font, this.fontColor, 266, 6 + 22 * n);
        this.drawDelta(logDaimyoData.getMoney() - logDaimyoData2.getMoney(), 320, 6 + 22 * n);
        this.content.drawText("\u6587\u5316\u5e73\u5747 ", this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText(" " + logDaimyoData.getCultureArv(), this.font, this.fontColor, 160, 6 + 22 * n);
        this.content.drawText("\u2192", this.font, this.fontColor, 220, 6 + 22 * n);
        this.content.drawText(" " + logDaimyoData2.getCultureArv(), this.font, this.fontColor, 266, 6 + 22 * n);
        this.drawDelta(logDaimyoData.getCultureArv() - logDaimyoData2.getCultureArv(), 320, 6 + 22 * n);
        this.content.drawText("\u9244\u7832\u3000\u3000 ", this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText(" " + logDaimyoData.getGun(), this.font, this.fontColor, 160, 6 + 22 * n);
        this.content.drawText("\u2192", this.font, this.fontColor, 220, 6 + 22 * n);
        this.content.drawText(" " + logDaimyoData2.getGun(), this.font, this.fontColor, 266, 6 + 22 * n);
        this.drawDelta(logDaimyoData.getGun() - logDaimyoData2.getGun(), 320, 6 + 22 * n);
        this.content.drawText("\u9a0e\u99ac\u3000\u3000 ", this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText(" " + logDaimyoData.getHorse(), this.font, this.fontColor, 160, 6 + 22 * n);
        this.content.drawText("\u2192", this.font, this.fontColor, 220, 6 + 22 * n);
        this.content.drawText(" " + logDaimyoData2.getHorse(), this.font, this.fontColor, 266, 6 + 22 * n);
        this.drawDelta(logDaimyoData.getHorse() - logDaimyoData2.getHorse(), 320, 6 + 22 * n);
        this.content.drawText("\u9244 ", this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText(" " + logDaimyoData.getIron(), this.font, this.fontColor, 160, 6 + 22 * n);
        this.content.drawText("\u2192", this.font, this.fontColor, 220, 6 + 22 * n);
        this.content.drawText(" " + logDaimyoData2.getIron(), this.font, this.fontColor, 266, 6 + 22 * n);
        this.drawDelta(logDaimyoData.getIron() - logDaimyoData2.getIron(), 320, 6 + 22 * n);
        this.content.drawText("\u785d\u77f3 ", this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText(" " + logDaimyoData.getSaltpeter(), this.font, this.fontColor, 160, 6 + 22 * n);
        this.content.drawText("\u2192", this.font, this.fontColor, 220, 6 + 22 * n);
        this.content.drawText(" " + logDaimyoData2.getSaltpeter(), this.font, this.fontColor, 266, 6 + 22 * n);
        this.drawDelta(logDaimyoData.getSaltpeter() - logDaimyoData2.getSaltpeter(), 320, 6 + 22 * n);
        this.content.drawText("\u706b\u85ac ", this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText(" " + logDaimyoData.getGunpowder(), this.font, this.fontColor, 160, 6 + 22 * n);
        this.content.drawText("\u2192", this.font, this.fontColor, 220, 6 + 22 * n);
        this.content.drawText(" " + logDaimyoData2.getGunpowder(), this.font, this.fontColor, 266, 6 + 22 * n);
        this.drawDelta(logDaimyoData.getGunpowder() - logDaimyoData2.getGunpowder(), 320, 6 + 22 * n);
        this.content.drawText("\u6240\u5c5e\u6b66\u5c06 ", this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText(" " + logDaimyoData.getKnights() + " \u4eba", this.font, this.fontColor, 160, 6 + 22 * n);
        this.content.drawText("\u2192", this.font, this.fontColor, 220, 6 + 22 * n);
        this.content.drawText(" " + logDaimyoData2.getKnights() + " \u4eba", this.font, this.fontColor, 266, 6 + 22 * n);
        this.drawDelta(logDaimyoData.getKnights() - logDaimyoData2.getKnights(), 320, 6 + 22 * n);
    }

    protected void updateContentCashFlow() {
        if (this.cashFlow == null) {
            return;
        }
        this.content.drawText("\u53ce\u652f\u5831\u544a", this.font, this.fontColor, 6, 28);
        this.content.drawText("\u6240\u6301\u91d1", this.font, this.fontColor, this.width / 2 - (int)this.font.getFontSize() * 4, 72);
        this.content.drawText("" + this.daimyo.getMoney(), this.font, this.fontColor, this.width / 2 + (int)this.font.getFontSize(), 72);
        int n2 = this.cashFlow.values().stream().filter(n -> 0 < n).mapToInt(n -> n).sum();
        int n3 = this.cashFlow.values().stream().filter(n -> n < 0).mapToInt(n -> n).sum();
        this.content.drawText("\u7dcf\u53ce\u5165", this.font, this.fontColor, 6, 116);
        this.content.drawText("" + n2, this.font, this.fontColor, 6 + this.width / 4, 116);
        this.content.drawText("\u7dcf\u652f\u51fa", this.font, this.fontColor, 6 + this.width / 2, 116);
        this.content.drawText("" + -1 * n3, this.font, this.fontColor, 6 + this.width / 4 + this.width / 2, 116);
        int n4 = 7;
        if (this.cashFlow.containsKey(1)) {
            this.content.drawText("\u5546\u696d\u7a0e", this.font, this.fontColor, 6, 6 + 22 * n4);
            this.content.drawText("" + this.cashFlow.get(1), this.font, this.fontColor, 6 + this.width / 4, 6 + 22 * n4);
            ++n4;
        }
        if (this.cashFlow.containsKey(2)) {
            this.content.drawText("\u5e74\u8ca2\u53ce\u5165", this.font, this.fontColor, 6, 6 + 22 * n4);
            this.content.drawText("" + this.cashFlow.get(2), this.font, this.fontColor, 6 + this.width / 4, 6 + 22 * n4);
            ++n4;
        }
        if (this.cashFlow.containsKey(3)) {
            this.content.drawText("\u65bd\u8a2d\u53ce\u5165", this.font, this.fontColor, 6, 6 + 22 * n4);
            this.content.drawText("" + this.cashFlow.get(3), this.font, this.fontColor, 6 + this.width / 4, 6 + 22 * n4);
            ++n4;
        }
        if (this.cashFlow.containsKey(4)) {
            this.content.drawText("\u91d1\u5c71\u53ce\u5165", this.font, this.fontColor, 6, 6 + 22 * n4);
            this.content.drawText("" + this.cashFlow.get(4), this.font, this.fontColor, 6 + this.width / 4, 6 + 22 * n4);
            ++n4;
        }
        if (this.cashFlow.containsKey(5)) {
            this.content.drawText("\u5916\u4ea4\u53ce\u5165", this.font, this.fontColor, 6, 6 + 22 * n4);
            this.content.drawText("" + this.cashFlow.get(5), this.font, this.fontColor, 6 + this.width / 4, 6 + 22 * n4);
            ++n4;
        }
        if (this.cashFlow.containsKey(6)) {
            this.content.drawText("\u7565\u596a", this.font, this.fontColor, 6, 6 + 22 * n4);
            this.content.drawText("" + this.cashFlow.get(6), this.font, this.fontColor, 6 + this.width / 4, 6 + 22 * n4);
            ++n4;
        }
        if (this.cashFlow.containsKey(7)) {
            this.content.drawText("\u81e8\u6642\u53ce\u5165", this.font, this.fontColor, 6, 6 + 22 * n4);
            this.content.drawText("" + this.cashFlow.get(7), this.font, this.fontColor, 6 + this.width / 4, 6 + 22 * n4);
        }
        n4 = 7;
        if (this.cashFlow.containsKey(12)) {
            this.content.drawText("\u7d66\u6599", this.font, this.fontColor, 6 + this.width / 2, 6 + 22 * n4);
            this.content.drawText("" + -1 * this.cashFlow.get(12), this.font, this.fontColor, 6 + this.width / 4 + this.width / 2, 6 + 22 * n4);
            ++n4;
        }
        if (this.cashFlow.containsKey(11)) {
            this.content.drawText("\u5efa\u8a2d\u8cc7\u91d1", this.font, this.fontColor, 6 + this.width / 2, 6 + 22 * n4);
            this.content.drawText("" + -1 * this.cashFlow.get(11), this.font, this.fontColor, 6 + this.width / 4 + this.width / 2, 6 + 22 * n4);
            ++n4;
        }
        if (this.cashFlow.containsKey(13)) {
            this.content.drawText("\u5916\u4ea4\u652f\u51fa", this.font, this.fontColor, 6 + this.width / 2, 6 + 22 * n4);
            this.content.drawText("" + -1 * this.cashFlow.get(13), this.font, this.fontColor, 6 + this.width / 4 + this.width / 2, 6 + 22 * n4);
            ++n4;
        }
        if (this.cashFlow.containsKey(14)) {
            this.content.drawText("\u7565\u596a", this.font, this.fontColor, 6 + this.width / 2, 6 + 22 * n4);
            this.content.drawText("" + -1 * this.cashFlow.get(14), this.font, this.fontColor, 6 + this.width / 4 + this.width / 2, 6 + 22 * n4);
            ++n4;
        }
        if (this.cashFlow.containsKey(15)) {
            this.content.drawText("\u81e8\u6642\u652f\u51fa", this.font, this.fontColor, 6 + this.width / 2, 6 + 22 * n4);
            this.content.drawText("" + -1 * this.cashFlow.get(15), this.font, this.fontColor, 6 + this.width / 4 + this.width / 2, 6 + 22 * n4);
        }
    }

    private void drawDelta(int n, int n2, int n3) {
        if (n < 0) {
            this.content.drawImage(this.texUp, 0, 0, this.texUp.getWidth(), this.texUp.getHeight(), n2, n3 - 20, 25, 25);
        } else if (n > 0) {
            this.content.drawImage(this.texDown, 0, 0, this.texDown.getWidth(), this.texDown.getHeight(), n2, n3 - 20, 25, 25);
        }
    }
}

