/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.sengoku.common.GameFontUtil;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.RoleV;
import game.sengoku.game.GameCommandUtil;
import game.sengoku.window.WindowBase;

public class WindowDomestic
extends WindowBase {
    private static final int INTERVAL = 22;
    private Font font = GameFontUtil.FONT20;
    private int fontColor = -269422081;
    private int usableMoney = 0;
    private DaimyoV daimyo;
    private GameDataV datav;
    private int forNextRank = 0;

    public WindowDomestic(int n, int n2, int n3, int n4, int n5, GameDataV gameDataV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.datav = gameDataV;
    }

    private void updateForNextRank() {
        this.forNextRank = GameCommandUtil.getForNextRank(this.datav, this.daimyo);
    }

    public DaimyoV getDaimyo() {
        return this.daimyo;
    }

    public void setDaimyo(DaimyoV daimyoV) {
        if (daimyoV == null || this.daimyo == null || this.daimyo.getId() != daimyoV.getId()) {
            this.daimyo = daimyoV;
            this.needUpdate();
        }
    }

    public int getUsableMoney() {
        return this.usableMoney;
    }

    public void setUsableMoney(int n) {
        if (this.usableMoney != n) {
            this.usableMoney = n;
            this.needUpdate();
        }
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        if (this.daimyo == null) {
            return;
        }
        this.updateForNextRank();
        int n = 1;
        this.content.drawText(this.daimyo.getName(), this.font, this.fontColor, 6, 6 + 22 * n);
        this.content.drawText(this.daimyo.getKnight().getFullName(), this.font, this.fontColor, 6, 6 + 22 * ++n);
        ++n;
        if (this.daimyo.getRank() == null) {
            this.content.drawText("\u7121\u4f4d\u7121\u5b98", this.font, this.fontColor, 6, 6 + 22 * n);
        } else {
            this.content.drawText(this.daimyo.getRank().getName() + " " + this.daimyo.getRank().getRoleName(), this.font, this.fontColor, 6, 6 + 22 * n);
        }
        if (!this.daimyo.getRoles().isEmpty()) {
            this.content.drawText(((RoleV)this.daimyo.getRoles().get(0)).getName(), this.font, this.fontColor, 6, 6 + 22 * ++n);
        }
        this.content.drawText("\u540d\u58f0\u3000\u3000 " + this.daimyo.getFame(), this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText("\u6b66\u5a01\u3000\u3000 " + this.daimyo.getImpact(), this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText("\u56fd\u6570\u3000\u3000 " + this.daimyo.getCountries().size(), this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText("\u7dcf\u4eba\u53e3\u3000 " + this.daimyo.getPopulationAmount(), this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText("\u7dcf\u77f3\u9ad8\u3000 " + this.daimyo.getFoodAmount(), this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText("\u7dcf\u5175\u6570\u3000 " + this.daimyo.getArmyAmount(), this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText("\u6587\u5316\u5e73\u5747 " + this.daimyo.getCultureArv(), this.font, this.fontColor, 6, 6 + 22 * ++n);
        if (0 < this.forNextRank) {
            this.content.drawText("\u6b21\u306e\u5b98\u4f4d\u307e\u3067 " + this.forNextRank, this.font, this.fontColor, 6, 6 + 22 * ++n);
        }
        this.content.drawText("\u91d1\u92ad\u3000\u3000 " + this.daimyo.getMoney() + " (" + this.usableMoney + ")", this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText("\u9244\u7832\u3000\u3000 " + this.daimyo.getGun(), this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText("\u9a0e\u99ac\u3000\u3000 " + this.daimyo.getHorse(), this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText("\u706b\u85ac\u3000\u3000 " + this.daimyo.getGunpowder(), this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText("\u9244\u3000\u3000\u3000 " + this.daimyo.getIron(), this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText("\u785d\u77f3\u3000\u3000 " + this.daimyo.getSaltpeter(), this.font, this.fontColor, 6, 6 + 22 * ++n);
        this.content.drawText("\u6240\u5c5e\u6b66\u5c06 " + this.daimyo.getEmployeeKnights().size() + " \u4eba", this.font, this.fontColor, 6, 6 + 22 * ++n);
    }
}

