/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.GameUtil;
import game.sengoku.data.DaimyoV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.TechnologyV;
import game.sengoku.window.WindowBase;

public class WindowDaimyoSelectInfo
extends WindowBase {
    private static final int INTERVAL = 20;
    private Font font = GameFontUtil.FONT16;
    private int fontColor = -319753729;
    private int daimyoId;
    private String defaultMessage;
    private GameDataV datav;

    public WindowDaimyoSelectInfo(int n, int n2, int n3, int n4, int n5, String string, GameDataV gameDataV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.daimyoId = 0;
        this.defaultMessage = string;
        this.datav = gameDataV;
    }

    public int getDaimyoId() {
        return this.daimyoId;
    }

    public void setDaimyoId(int n) {
        if (this.daimyoId != n) {
            this.daimyoId = n;
            this.needUpdate();
        }
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public void setDefaultMessage(String string) {
        this.defaultMessage = string;
        this.needUpdate();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        DaimyoV daimyoV = (DaimyoV)this.datav.getDaimyos().get(this.daimyoId);
        if (daimyoV == null) {
            int n = 1;
            this.content.drawText(this.defaultMessage, this.font, this.fontColor, 6, 6 + 20 * n);
            return;
        }
        int n = 1;
        this.content.drawText(daimyoV.getName(), this.font, this.fontColor, 6, 6 + 20 * n);
        this.content.drawText("\u5927\u540d " + daimyoV.getKnight().getFullName(), this.font, this.fontColor, 6, 6 + 20 * ++n);
        this.content.drawText("\u56fd\u6570 " + daimyoV.getCountries().size(), this.font, this.fontColor, 6, 6 + 20 * ++n);
        String string = "";
        if (daimyoV.getTechnologyIds().isEmpty()) {
            string = "\u306a\u3057";
        } else {
            for (TechnologyV technologyV : daimyoV.getTechnologies()) {
                string = string + technologyV.getName() + " ";
            }
        }
        this.content.drawText("\u6240\u6709\u6280\u8853 " + string, this.font, this.fontColor, 6, 6 + 20 * ++n);
        ++n;
        String[] stringArray = GameUtil.getDaimyoSpecialLabel(daimyoV.getSpecial());
        if (stringArray != null) {
            this.content.drawText("\u5927\u540d\u7279\u6027 " + stringArray[0] + "  " + stringArray[1], this.font, this.fontColor, 6, 6 + 20 * n);
        }
    }
}

