/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.sengoku.common.GameEffectUtil;
import game.sengoku.common.GameFontUtil;
import game.sengoku.data.Culture;
import game.sengoku.data.GameDataV;
import game.sengoku.window.WindowBase;
import java.util.Map;

public class WindowCulture
extends WindowBase {
    private static final int INTERVAL = 22;
    private Font font = GameFontUtil.FONT16;
    private int fontColor = -319753729;
    private Culture culture;
    private String defaultMessage;
    private GameDataV datav;

    public WindowCulture(int n, int n2, int n3, int n4, int n5, String string, GameDataV gameDataV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.culture = null;
        this.defaultMessage = string;
        this.datav = gameDataV;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public void setDefaultMessage(String string) {
        this.defaultMessage = string;
        this.needUpdate();
    }

    public Culture getCulture() {
        return this.culture;
    }

    public void setCulture(Culture culture) {
        if (this.culture != culture) {
            this.culture = culture;
            this.needUpdate();
        }
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        if (this.culture == null) {
            int n = 1;
            this.content.drawText(this.defaultMessage, this.font, this.fontColor, 6, 6 + 22 * n);
            return;
        }
        int n = 1;
        this.content.drawText(this.culture.getName(), this.font, this.fontColor, 36, 6 + 22 * n);
        ++n;
        n = 3;
        Map<Integer, Integer> map = GameEffectUtil.getEffectValues(this.culture.getEffect());
        for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
            int n2 = entry.getKey();
            int n3 = entry.getValue();
            String string = GameEffectUtil.getEffectName(n2);
            String string2 = GameEffectUtil.getEffecUnit(n2);
            this.content.drawText(string + " " + (0 < n3 ? "+" : "") + n3 + string2, this.font, this.fontColor, 6, 6 + 22 * n);
            ++n;
        }
    }
}

