/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.GameUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.data.Build;
import game.sengoku.data.BuildPlan;
import game.sengoku.data.CommandV;
import game.sengoku.data.CountryV;
import game.sengoku.data.GameDataV;
import game.sengoku.data.PlayerV;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.WindowBase;
import java.util.List;

public class WindowCountryInfo
extends WindowBase {
    private static final int INTERVAL = 20;
    private Font font = GameFontUtil.FONT16;
    private int fontColor = -319753729;
    private int countryId;
    private String defaultMessage;
    private GameDataV datav;
    private PlayerV player;
    private ButtonSprite resourceLabel1;
    private ButtonSprite resourceLabel2;

    public WindowCountryInfo(int n, int n2, int n3, int n4, int n5, int n6, String string, GameDataV gameDataV, PlayerV playerV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.countryId = n6;
        this.defaultMessage = string;
        this.datav = gameDataV;
        this.player = playerV;
        this.resourceLabel1 = new ButtonSprite(n4 - 275, 6, 100, 50, 20, 388883421, 388883421, GameFontUtil.FONT16, "", true, MouseSymbolLayerManager.LAYER_MESSAGE);
        this.resourceLabel1.setFontColor(-319753729);
        this.resourceLabel2 = new ButtonSprite(n4 - 330, 6, 100, 50, 20, 388883421, 388883421, GameFontUtil.FONT16, "", true, MouseSymbolLayerManager.LAYER_MESSAGE);
        this.resourceLabel2.setFontColor(-319753729);
    }

    public int getCountryId() {
        return this.countryId;
    }

    public void setCountryId(int n) {
        if (this.countryId != n) {
            this.countryId = n;
            this.needUpdate();
        }
    }

    public PlayerV getPlayer() {
        return this.player;
    }

    public void setPlayer(PlayerV playerV) {
        this.player = playerV;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public void setDefaultMessage(String string) {
        this.defaultMessage = string;
        this.needUpdate();
    }

    @Override
    protected void updateContent() {
        int n;
        int n2;
        List list;
        super.updateContent();
        CountryV countryV = (CountryV)this.datav.getCountries().get(this.countryId);
        if (countryV == null) {
            int n3 = 1;
            this.content.drawText(this.defaultMessage, this.font, this.fontColor, 6, 6 + 20 * n3);
            return;
        }
        int n4 = 1;
        this.content.drawText(countryV.getName() + "\u56fd", this.font, this.fontColor, 6, 6 + 20 * n4);
        this.content.drawText(countryV.getDaimyo().getName(), this.font, this.fontColor, 106, 6 + 20 * n4);
        this.content.drawText("\u77f3\u9ad8 " + countryV.getFood() + "/" + countryV.getMaxFood(), this.font, this.fontColor, 6, 6 + 20 * ++n4);
        this.content.drawText("\u4eba\u53e3 " + countryV.getPopulation() + "/" + countryV.getMaxPopulation(), this.font, this.fontColor, 6, 6 + 20 * ++n4);
        this.content.drawText("\u5546\u696d " + countryV.getCommerce() + "/" + countryV.getMaxCommerce(), this.font, this.fontColor, 6, 6 + 20 * ++n4);
        this.content.drawText("\u6587\u5316 " + countryV.getCulture(), this.font, this.fontColor, 6, 6 + 20 * ++n4);
        n4 = 2;
        this.content.drawText("\u6c11\u5fe0 " + countryV.getTamichu(), this.font, this.fontColor, 206, 6 + 20 * n4);
        ++n4;
        String string = "????";
        if (this.player != null && this.player.getDaimyoId() == countryV.getDaimyoId()) {
            string = "" + countryV.getUsableArmy();
        }
        this.content.drawText("\u5175\u6570 " + string + "/" + countryV.getMaxArmy(), this.font, this.fontColor, 206, 6 + 20 * n4);
        this.content.drawText("\u5175\u58eb\u30ec\u30d9\u30eb " + countryV.getArmyLevel(), this.font, this.fontColor, 206, 6 + 20 * ++n4);
        ++n4;
        if (this.player != null && this.player.getDaimyo().isCanHongan()) {
            this.content.drawText("\u4fe1\u8005\u6570 " + countryV.getMissionary(), this.font, this.fontColor, 206, 6 + 20 * n4);
            ++n4;
        }
        if (this.player != null && this.player.getDaimyoId() == countryV.getDaimyoId()) {
            list = countryV.getBuildPlans();
            CommandV commandV2 = this.getPlayer().getCommands().stream().filter(commandV -> commandV.getKind() == 2).filter(commandV -> this.countryId == (Integer)commandV.getArgs().get(0)).findFirst().orElse(null);
            if (!list.isEmpty()) {
                BuildPlan buildPlan = (BuildPlan)list.get(0);
                n4 = 2;
                this.content.drawText(buildPlan.getBuild().getName() + "\u3092\u5efa\u8a2d\u4e2d", this.font, this.fontColor, 406, 6 + 20 * n4);
                int n5 = (buildPlan.getBuild().getPower() - buildPlan.getAmountPower()) / countryV.getPower() + 1;
                this.content.drawText("\u6b8b\u308a" + n5 + "\u30f6\u6708", this.font, this.fontColor, 406, 6 + 20 * ++n4);
            } else if (commandV2 != null) {
                Build build = (Build)this.datav.getGameData().getBuilds().get(commandV2.getArgs().get(1));
                n4 = 2;
                this.content.drawText(build.getName() + "\u3092\u5efa\u8a2d\u4e2d", this.font, this.fontColor, 406, 6 + 20 * n4);
                int n6 = build.getPower() / countryV.getPower() + 1;
                this.content.drawText("\u6b8b\u308a" + n6 + "\u30f6\u6708", this.font, this.fontColor, 406, 6 + 20 * ++n4);
            }
        }
        if ((list = countryV.getCountry().getResources()).size() > 0 && (n2 = ((Integer)list.get(0)).intValue()) != 0) {
            this.resourceLabel1.setText(GameUtil.getResourceName(n2));
            this.resourceLabel1.setBgColor(GameUtil.getResourceColor(n2));
            this.resourceLabel1.draw(this.content);
        }
        if (list.size() > 1 && (n = ((Integer)list.get(1)).intValue()) != 0) {
            this.resourceLabel2.setText(GameUtil.getResourceName(n));
            this.resourceLabel2.setBgColor(GameUtil.getResourceColor(n));
            this.resourceLabel2.draw(this.content);
        }
    }
}

