/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.GameEffectUtil;
import game.sengoku.common.GameFontUtil;
import game.sengoku.common.GameUtil;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.data.Build;
import game.sengoku.data.CountryV;
import game.sengoku.data.GameDataV;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ButtonSprite;
import game.sengoku.window.WindowBase;
import java.util.Map;

public class WindowBuild
extends WindowBase {
    private static final int INTERVAL = 22;
    private Font font = GameFontUtil.FONT20;
    private int fontColor = -319753729;
    private Build build;
    private int countryId;
    private ButtonSprite field;
    private ButtonSprite mountain;
    private ButtonSprite seaside;
    private ButtonSprite castle;
    private String defaultMessage;
    private GameDataV datav;

    public WindowBuild(int n, int n2, int n3, int n4, int n5, int n6, String string, GameDataV gameDataV) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.setBgColor(877223628);
        this.build = null;
        this.countryId = n6;
        this.defaultMessage = string;
        this.datav = gameDataV;
        this.field = new ButtonSprite(n4 - 165, 6, n3 + 100, 50, 20, GameUtil.getSpotColor(1), GameUtil.getSpotColor(1), GameFontUtil.FONT16, GameUtil.getTypeName(1), true, MouseSymbolLayerManager.LAYER_MESSAGE);
        this.field.setFontColor(-319753729);
        this.field.setParent(this);
        this.children.add(this.field);
        this.mountain = new ButtonSprite(n4 - 110, 6, n3 + 100, 50, 20, GameUtil.getSpotColor(2), GameUtil.getSpotColor(2), GameFontUtil.FONT16, GameUtil.getTypeName(2), true, MouseSymbolLayerManager.LAYER_MESSAGE);
        this.mountain.setFontColor(-319753729);
        this.mountain.setParent(this);
        this.children.add(this.mountain);
        this.seaside = new ButtonSprite(n4 - 55, 6, n3 + 100, 50, 20, GameUtil.getSpotColor(3), GameUtil.getSpotColor(3), GameFontUtil.FONT16, GameUtil.getTypeName(3), true, MouseSymbolLayerManager.LAYER_MESSAGE);
        this.seaside.setFontColor(-319753729);
        this.seaside.setParent(this);
        this.children.add(this.seaside);
        this.castle = new ButtonSprite(n4 - 110, 6, n3 + 100, 50, 20, 0x666666FF, 0x666666FF, GameFontUtil.FONT16, "\u57ce\u90ed", true, MouseSymbolLayerManager.LAYER_MESSAGE);
        this.castle.setFontColor(-319753729);
        this.castle.setParent(this);
        this.children.add(this.castle);
    }

    public Build getBuild() {
        return this.build;
    }

    public void setBuild(Build build) {
        this.build = build;
        this.needUpdate();
    }

    public int getCountryId() {
        return this.countryId;
    }

    public void setCountryId(int n) {
        this.countryId = n;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public void setDefaultMessage(String string) {
        this.defaultMessage = string;
        this.needUpdate();
    }

    public Texture getTexture() {
        if (this.build == null || this.build.getIconFileName() == null || "".equals(this.build.getIconFileName())) {
            return null;
        }
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        Texture texture = (Texture)graphicPool.getResource(this.build.getIconFileName());
        return texture;
    }

    @Override
    public void update() {
        super.update();
        if (this.build != null) {
            if (this.build.getKind() == 8) {
                this.castle.setVisible(true);
                this.field.setVisible(false);
                this.mountain.setVisible(false);
                this.seaside.setVisible(false);
            } else {
                this.castle.setVisible(false);
                this.field.setVisible(this.build.isPlain());
                this.mountain.setVisible(this.build.isMount());
                this.seaside.setVisible(this.build.isSeaSide());
            }
        }
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        CountryV countryV = (CountryV)this.datav.getCountries().get(this.countryId);
        if (this.build == null || countryV == null) {
            int n = 1;
            this.content.drawText(this.defaultMessage, this.font, this.fontColor, 6, 6 + 22 * n);
            return;
        }
        Texture texture = this.getTexture();
        if (texture != null) {
            this.content.drawImage(texture, 0, 0, texture.getWidth(), texture.getHeight(), 6, 6, 25, 25);
        }
        int n = 1;
        this.content.drawText(this.build.getName(), this.font, this.fontColor, 36, 6 + 22 * n);
        this.content.drawText("\u521d\u671f\u30b3\u30b9\u30c8 " + this.getHeadCost(this.build), this.font, this.fontColor, 36, 6 + 22 * ++n);
        this.content.drawText("\u6708\u6bce\u30b3\u30b9\u30c8 " + this.getCost(this.build), this.font, this.fontColor, 36, 6 + 22 * ++n);
        this.content.drawText("\u5fc5\u8981\u52b4\u529b " + this.build.getPower(), this.font, this.fontColor, 36, 6 + 22 * ++n);
        this.content.drawText("\u5b8c\u6210\u307e\u3067 " + (this.build.getPower() / countryV.getPower() + 1) + "\u30f6\u6708", this.font, this.fontColor, 36, 6 + 22 * ++n);
        ++n;
        n = 2;
        Map<Integer, Integer> map = GameEffectUtil.getEffectValues(this.build.getEffect());
        for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
            int n2 = entry.getKey();
            int n3 = entry.getValue();
            String string = GameEffectUtil.getEffectName(n2);
            String string2 = GameEffectUtil.getEffecUnit(n2);
            if (n2 == 14 || n2 == 15) {
                double d = this.datav.getWorld().getInflationRate();
                n3 = (int)Math.ceil((double)n3 * d);
            }
            this.content.drawText(string + " " + (0 < n3 ? "+" : "") + n3 + string2, this.font, this.fontColor, 236, 6 + 22 * n);
            ++n;
        }
    }

    private int getDiscount() {
        CountryV countryV = (CountryV)this.datav.getCountries().get(this.countryId);
        if (countryV != null) {
            return countryV.getDaimyo().getDiscount();
        }
        return 0;
    }

    private int getHeadCost(Build build) {
        double d = this.datav.getWorld().getInflationRate();
        double d2 = (double)(100 - this.getDiscount()) / 100.0;
        return (int)Math.ceil((double)build.getHeadCost() * d * d2);
    }

    private int getCost(Build build) {
        double d = this.datav.getWorld().getInflationRate();
        double d2 = (double)(100 - this.getDiscount()) / 100.0;
        return (int)Math.ceil((double)build.getCost() * d * d2);
    }
}

