/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.common.HasAbsoluteXY;
import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.base.input.InputInterface;
import game.base.symbol.MouseSymbol;
import game.base.symbol.MouseSymbolLayer;
import game.base.symbol.SymbolRect;
import game.sengoku.data.DataUtil;
import game.sengoku.main.KessenMain;
import game.sengoku.window.WindowBase;

public class VSliderSprite
extends WindowBase {
    protected MouseSymbol mouseSymbolMinus;
    protected MouseSymbol mouseSymbolGauge;
    protected MouseSymbol mouseSymbolPlus;
    protected Texture texUp;
    protected Texture texDown;
    protected Texture texUpMono;
    protected Texture texDownMono;
    protected Texture texBoll;
    protected MouseSymbolLayer layer;
    protected int length;
    protected HasAbsoluteXY origine;
    protected int value;
    protected int valueMax;
    protected int valueMin;
    private int counter = 0;
    private Runnable valueChanged = null;

    public VSliderSprite(int n, int n2, int n3, int n4, int n5, MouseSymbolLayer mouseSymbolLayer) {
        super(n4, n5);
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.length = n5 - n4 * 2;
        this.layer = mouseSymbolLayer;
        this.initializeSlider();
    }

    public VSliderSprite(int n, int n2, int n3, int n4, int n5, MouseSymbolLayer mouseSymbolLayer, HasAbsoluteXY hasAbsoluteXY) {
        this(n, n2, n3, n4, n5, mouseSymbolLayer);
        this.origine = hasAbsoluteXY;
        this.initializeSlider();
    }

    protected void initializeSlider() {
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.texUp = (Texture)graphicPool.getResource("iconUp.png");
        this.texDown = (Texture)graphicPool.getResource("iconDown.png");
        this.texUpMono = (Texture)graphicPool.getResource("iconUpMono.png");
        this.texDownMono = (Texture)graphicPool.getResource("iconDownMono.png");
        this.texBoll = (Texture)graphicPool.getResource("boll.png");
        if (this.origine == null) {
            this.origine = this;
        }
        this.mouseSymbolMinus = new MouseSymbol(KessenMain.getInstance(), this.layer);
        this.mouseSymbolMinus.setOrigin(this.origine);
        this.mouseSymbolMinus.setActive(true);
        this.mouseSymbolMinus.getAreas().add(new SymbolRect(0, 0, this.width, this.width));
        this.mouseSymbolGauge = new MouseSymbol(KessenMain.getInstance(), this.layer);
        this.mouseSymbolGauge.setOrigin(this.origine);
        this.mouseSymbolGauge.setActive(true);
        this.mouseSymbolGauge.getAreas().add(new SymbolRect(0, this.width, this.width, this.length));
        this.mouseSymbolPlus = new MouseSymbol(KessenMain.getInstance(), this.layer);
        this.mouseSymbolPlus.setOrigin(this.origine);
        this.mouseSymbolPlus.setActive(true);
        this.mouseSymbolPlus.getAreas().add(new SymbolRect(0, this.width + this.length, this.width, this.width));
    }

    public Runnable getValueChanged() {
        return this.valueChanged;
    }

    public void setValueChanged(Runnable runnable) {
        this.valueChanged = runnable;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        if (this.value != n) {
            this.value = DataUtil.checkInteger((int)n, (int)this.valueMin, (int)this.valueMax);
            if (this.valueChanged != null) {
                this.valueChanged.run();
            }
            this.needUpdate();
        }
    }

    public int getValueMax() {
        return this.valueMax;
    }

    public void setValueMax(int n) {
        if (this.valueMax != n) {
            this.valueMax = n;
            this.needUpdate();
        }
    }

    public int getValueMin() {
        return this.valueMin;
    }

    public void setValueMin(int n) {
        if (this.valueMin != n) {
            this.valueMin = n;
            this.needUpdate();
        }
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        if (this.value == this.valueMin) {
            this.content.drawImage(this.texUpMono, 0, 0, this.texUp.getWidth(), this.texUp.getHeight(), 0, 0, this.width, this.width);
        } else {
            this.content.drawImage(this.texUp, 0, 0, this.texUp.getWidth(), this.texUp.getHeight(), 0, 0, this.width, this.width);
        }
        if (this.value == this.valueMax) {
            this.content.drawImage(this.texDownMono, 0, 0, this.texDown.getWidth(), this.texDown.getHeight(), 0, this.width + this.length, this.width, this.width);
        } else {
            this.content.drawImage(this.texDown, 0, 0, this.texDown.getWidth(), this.texDown.getHeight(), 0, this.width + this.length, this.width, this.width);
        }
        if (this.valueMax == this.valueMin) {
            this.content.drawImage(this.texBoll, 0, 0, this.texBoll.getWidth(), this.texBoll.getHeight(), (this.width - 8) / 2, this.width + this.length / 2, 8, 8);
        } else {
            this.content.drawImage(this.texBoll, 0, 0, this.texBoll.getWidth(), this.texBoll.getHeight(), (this.width - 8) / 2, this.width + this.length * this.value / (this.valueMax - this.valueMin), 8, 8);
        }
    }

    @Override
    public void update() {
        super.update();
        InputInterface inputInterface = KessenMain.getInstance().getInput();
        this.mouseSymbolMinus.setActive(this.isVisible());
        this.mouseSymbolPlus.setActive(this.isVisible());
        this.mouseSymbolGauge.setActive(this.isVisible());
        this.mouseSymbolMinus.update();
        this.mouseSymbolPlus.update();
        this.mouseSymbolGauge.update();
        if (inputInterface.isMousePrimaryPress()) {
            if (this.mouseSymbolMinus.isMousePrimaryClicked()) {
                this.setValue(this.value - 1);
                this.counter = 0;
            } else if (this.mouseSymbolMinus.isMouseOver()) {
                ++this.counter;
                if (this.counter % 5 == 0) {
                    this.setValue(this.value - 1);
                }
            }
            if (this.mouseSymbolPlus.isMousePrimaryClicked()) {
                this.setValue(this.value + 1);
                this.counter = 0;
            } else if (this.mouseSymbolPlus.isMouseOver()) {
                ++this.counter;
                if (this.counter % 5 == 0) {
                    this.setValue(this.value + 1);
                }
            }
        } else {
            this.counter = 0;
        }
        if (this.mouseSymbolGauge.isMousePrimaryClicked()) {
            int n = inputInterface.getMouseY() - this.getAbsoluteY() - this.width;
            this.setValue(this.valueMin + n * (this.valueMax - this.valueMin) / this.length);
        }
    }
}

