/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.font.Font;
import game.base.font.FontPool;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.data.Scenario;
import game.sengoku.main.KessenMain;
import game.sengoku.window.ButtonSprite;

public class ScenarioButton
extends ButtonSprite {
    private Scenario scenario;

    public Scenario getScenario() {
        return this.scenario;
    }

    public void setScenario(Scenario scenario) {
        this.scenario = scenario;
    }

    public ScenarioButton(int n, int n2, Scenario scenario) {
        super(n, n2, 100, 400, 112, -6710887, -6710785, null, null, false, MouseSymbolLayerManager.LAYER_NORMAL);
        this.scenario = scenario;
        KessenMain kessenMain = KessenMain.getInstance();
        FontPool fontPool = kessenMain.getFontPool();
        this.font = (Font)fontPool.getResource("ipam.ttf:16");
        this.needUpdate();
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        if (this.scenario != null) {
            this.content.drawText(this.scenario.getName(), this.font, -1, 6, 22);
            this.content.drawText(this.scenario.getLabel(), this.font, -1, 6, 38);
            String string = this.scenario.getExplain();
            int n = 0;
            for (int i = 0; i < string.length(); i += 24) {
                String string2 = string.substring(i, Math.min(i + 24, string.length()));
                this.content.drawText(string2, this.font, -1, 6, 60 + 16 * n);
                ++n;
            }
        }
    }
}

