/*
 * Decompiled with CFR 0.152.
 */
package game.sengoku.window;

import game.base.graphic.GraphicPool;
import game.base.graphic.Texture;
import game.sengoku.common.MouseSymbolLayerManager;
import game.sengoku.main.KessenMain;
import game.sengoku.window.WindowClickable;
import java.util.ArrayList;
import java.util.Iterator;

public class DamageSprite
extends WindowClickable {
    private int total;
    private int leave;
    private int damage;
    private int count;
    private int color = -1069995009;
    private Texture texNumber;

    public DamageSprite(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(n, n2, n3, n4, n5, -256, -256, MouseSymbolLayerManager.LAYER_NORMAL);
        this.setBgColor(-256);
        this.count = 0;
        this.total = n6;
        this.leave = n7;
        this.damage = n8;
        KessenMain kessenMain = KessenMain.getInstance();
        GraphicPool graphicPool = kessenMain.getGraphicPool();
        this.texNumber = (Texture)graphicPool.getResource("number.png");
    }

    @Override
    protected void updateBackGround() {
    }

    @Override
    protected void updateContent() {
        super.updateContent();
        double d = (double)Math.min(this.damage, this.leave) * 1.0 / 10.0;
        double d2 = (double)this.leave - (double)this.count * d;
        double d3 = d2 / (double)this.total;
        int n = (int)((double)(this.width - 50) * d3);
        this.content.fill(this.color, 0, 3, n, this.height - 6);
        this.drawNumber((int)d2, this.width - 50, 0);
    }

    private void drawNumber(int n, int n2, int n3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 10000; i > 0; i /= 10) {
            if (n < i) continue;
            arrayList.add(n % (i * 10) / i);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n4 = (Integer)iterator.next();
            this.content.drawImage(this.texNumber, n4 % 5 * 15, n4 / 5 * 20, 15, 20, n2, n3, 9, 12);
            n2 += 9;
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.count < 10) {
            ++this.count;
        }
        this.needUpdate();
    }
}

